//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armkusto_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/kusto/armkusto/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersGet.json
func ExampleClustersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClustersClient().Get(ctx, "kustorptest", "kustoCluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Cluster = armkusto.Cluster{
	// 	Name: to.Ptr("kustoCluster"),
	// 	Type: to.Ptr("Microsoft.Kusto/Clusters"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster"),
	// 	Location: to.Ptr("westus"),
	// 	Etag: to.Ptr("abcd123"),
	// 	Identity: &armkusto.Identity{
	// 		Type: to.Ptr(armkusto.IdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("faabad1f-4876-463c-af9d-6ba2d2d2394c"),
	// 		TenantID: to.Ptr("b932977f-6277-4ab7-a2cd-5bd21f07aaf4"),
	// 		UserAssignedIdentities: map[string]*armkusto.ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties{
	// 		},
	// 	},
	// 	Properties: &armkusto.ClusterProperties{
	// 		AllowedFqdnList: []*string{
	// 			to.Ptr("my-stroage.blob.core.windows.net")},
	// 			AllowedIPRangeList: []*string{
	// 			},
	// 			EnableAutoStop: to.Ptr(true),
	// 			EnableDiskEncryption: to.Ptr(false),
	// 			EnablePurge: to.Ptr(false),
	// 			EnableStreamingIngest: to.Ptr(true),
	// 			EngineType: to.Ptr(armkusto.EngineTypeV3),
	// 			KeyVaultProperties: &armkusto.KeyVaultProperties{
	// 				KeyName: to.Ptr("keyName"),
	// 				KeyVaultURI: to.Ptr("https://dummy.keyvault.com"),
	// 				KeyVersion: to.Ptr("keyVersion"),
	// 			},
	// 			MigrationCluster: &armkusto.MigrationClusterProperties{
	// 				DataIngestionURI: to.Ptr("https://ingest-kustocluster2.westus.kusto.windows.net"),
	// 				ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster2"),
	// 				Role: to.Ptr(armkusto.MigrationClusterRoleDestination),
	// 				URI: to.Ptr("https://kustocluster2.westus.kusto.windows.net"),
	// 			},
	// 			PrivateEndpointConnections: []*armkusto.PrivateEndpointConnection{
	// 				{
	// 					Name: to.Ptr("privateEndpointTest"),
	// 					Type: to.Ptr("Microsoft.Kusto/Clusters/PrivateEndpointConnections"),
	// 					ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster/privateEndpointConnections/privateEndpointTest"),
	// 					Properties: &armkusto.PrivateEndpointConnectionProperties{
	// 						GroupID: to.Ptr("cluster"),
	// 						PrivateEndpoint: &armkusto.PrivateEndpointProperty{
	// 							ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/rg1Network/providers/Microsoft.Network/privateEndpoints/privateEndpointName"),
	// 						},
	// 						PrivateLinkServiceConnectionState: &armkusto.PrivateLinkServiceConnectionStateProperty{
	// 							Description: to.Ptr("Auto-approved"),
	// 							ActionsRequired: to.Ptr("None"),
	// 							Status: to.Ptr("Approved"),
	// 						},
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 					},
	// 			}},
	// 			ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
	// 			PublicIPType: to.Ptr(armkusto.PublicIPTypeIPv4),
	// 			PublicNetworkAccess: to.Ptr(armkusto.PublicNetworkAccessEnabled),
	// 			RestrictOutboundNetworkAccess: to.Ptr(armkusto.ClusterNetworkAccessFlagEnabled),
	// 		},
	// 		SKU: &armkusto.AzureSKU{
	// 			Name: to.Ptr(armkusto.AzureSKUNameStandardL16AsV3),
	// 			Capacity: to.Ptr[int32](2),
	// 			Tier: to.Ptr(armkusto.AzureSKUTierStandard),
	// 		},
	// 		SystemData: &armkusto.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-29T15:06:54.275Z"); return t}()),
	// 			CreatedBy: to.Ptr("user@microsoft.com"),
	// 			CreatedByType: to.Ptr(armkusto.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-29T15:06:54.275Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("user@microsoft.com"),
	// 			LastModifiedByType: to.Ptr(armkusto.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersCreateOrUpdate.json
func ExampleClustersClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginCreateOrUpdate(ctx, "kustorptest", "kustoCluster", armkusto.Cluster{
		Location: to.Ptr("westus"),
		Identity: &armkusto.Identity{
			Type: to.Ptr(armkusto.IdentityTypeSystemAssigned),
		},
		Properties: &armkusto.ClusterProperties{
			AllowedIPRangeList: []*string{
				to.Ptr("0.0.0.0/0")},
			EnableAutoStop:         to.Ptr(true),
			EnableDoubleEncryption: to.Ptr(false),
			EnablePurge:            to.Ptr(true),
			EnableStreamingIngest:  to.Ptr(true),
			LanguageExtensions: &armkusto.LanguageExtensionsList{
				Value: []*armkusto.LanguageExtension{
					{
						LanguageExtensionCustomImageName: to.Ptr("customImage8"),
						LanguageExtensionImageName:       to.Ptr(armkusto.LanguageExtensionImageName("Python_Custom_Image")),
						LanguageExtensionName:            to.Ptr(armkusto.LanguageExtensionNamePYTHON),
					},
					{
						LanguageExtensionImageName: to.Ptr(armkusto.LanguageExtensionImageNameR),
						LanguageExtensionName:      to.Ptr(armkusto.LanguageExtensionNameR),
					}},
			},
			PublicIPType:        to.Ptr(armkusto.PublicIPTypeDualStack),
			PublicNetworkAccess: to.Ptr(armkusto.PublicNetworkAccessEnabled),
		},
		SKU: &armkusto.AzureSKU{
			Name:     to.Ptr(armkusto.AzureSKUNameStandardL16AsV3),
			Capacity: to.Ptr[int32](2),
			Tier:     to.Ptr(armkusto.AzureSKUTierStandard),
		},
	}, &armkusto.ClustersClientBeginCreateOrUpdateOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Cluster = armkusto.Cluster{
	// 	Name: to.Ptr("kustoCluster"),
	// 	Type: to.Ptr("Microsoft.Kusto/Clusters"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster"),
	// 	Location: to.Ptr("westus"),
	// 	Etag: to.Ptr("abcd"),
	// 	Identity: &armkusto.Identity{
	// 		Type: to.Ptr(armkusto.IdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("faabad1f-4876-463c-af9d-6ba2d2d2394c"),
	// 		TenantID: to.Ptr("b932977f-6277-4ab7-a2cd-5bd21f07aaf4"),
	// 		UserAssignedIdentities: map[string]*armkusto.ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties{
	// 		},
	// 	},
	// 	Properties: &armkusto.ClusterProperties{
	// 		AllowedIPRangeList: []*string{
	// 			to.Ptr("0.0.0.0/0")},
	// 			EnableAutoStop: to.Ptr(true),
	// 			EnableDiskEncryption: to.Ptr(false),
	// 			EnableDoubleEncryption: to.Ptr(false),
	// 			EnablePurge: to.Ptr(true),
	// 			EnableStreamingIngest: to.Ptr(true),
	// 			EngineType: to.Ptr(armkusto.EngineTypeV3),
	// 			KeyVaultProperties: &armkusto.KeyVaultProperties{
	// 				KeyName: to.Ptr("keyName"),
	// 				KeyVaultURI: to.Ptr("https://dummy.keyvault.com"),
	// 				KeyVersion: to.Ptr("keyVersion"),
	// 			},
	// 			LanguageExtensions: &armkusto.LanguageExtensionsList{
	// 				Value: []*armkusto.LanguageExtension{
	// 					{
	// 						LanguageExtensionCustomImageName: to.Ptr("customImage8"),
	// 						LanguageExtensionImageName: to.Ptr(armkusto.LanguageExtensionImageName("Python_Custom_Image")),
	// 						LanguageExtensionName: to.Ptr(armkusto.LanguageExtensionNamePYTHON),
	// 					},
	// 					{
	// 						LanguageExtensionImageName: to.Ptr(armkusto.LanguageExtensionImageNameR),
	// 						LanguageExtensionName: to.Ptr(armkusto.LanguageExtensionNameR),
	// 				}},
	// 			},
	// 			ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
	// 			PublicIPType: to.Ptr(armkusto.PublicIPTypeDualStack),
	// 			PublicNetworkAccess: to.Ptr(armkusto.PublicNetworkAccessEnabled),
	// 			RestrictOutboundNetworkAccess: to.Ptr(armkusto.ClusterNetworkAccessFlagDisabled),
	// 		},
	// 		SKU: &armkusto.AzureSKU{
	// 			Name: to.Ptr(armkusto.AzureSKUNameStandardL16AsV3),
	// 			Capacity: to.Ptr[int32](2),
	// 			Tier: to.Ptr(armkusto.AzureSKUTierStandard),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersUpdate.json
func ExampleClustersClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginUpdate(ctx, "kustorptest", "kustoCluster2", armkusto.ClusterUpdate{
		Location: to.Ptr("westus"),
	}, &armkusto.ClustersClientBeginUpdateOptions{IfMatch: to.Ptr("*")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Cluster = armkusto.Cluster{
	// 	Name: to.Ptr("kustoCluster2"),
	// 	Type: to.Ptr("Microsoft.Kusto/Clusters"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster2"),
	// 	Location: to.Ptr("westus"),
	// 	Etag: to.Ptr("abcd123"),
	// 	Identity: &armkusto.Identity{
	// 		Type: to.Ptr(armkusto.IdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("faabad1f-4876-463c-af9d-6ba2d2d2394c"),
	// 		TenantID: to.Ptr("b932977f-6277-4ab7-a2cd-5bd21f07aaf4"),
	// 		UserAssignedIdentities: map[string]*armkusto.ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties{
	// 		},
	// 	},
	// 	Properties: &armkusto.ClusterProperties{
	// 		EnableAutoStop: to.Ptr(true),
	// 		EnableDiskEncryption: to.Ptr(false),
	// 		EnablePurge: to.Ptr(true),
	// 		EnableStreamingIngest: to.Ptr(true),
	// 		EngineType: to.Ptr(armkusto.EngineTypeV3),
	// 		KeyVaultProperties: &armkusto.KeyVaultProperties{
	// 			KeyName: to.Ptr("keyName"),
	// 			KeyVaultURI: to.Ptr("https://dummy.keyvault.com"),
	// 			KeyVersion: to.Ptr("keyVersion"),
	// 		},
	// 		ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
	// 		PublicIPType: to.Ptr(armkusto.PublicIPTypeIPv4),
	// 		RestrictOutboundNetworkAccess: to.Ptr(armkusto.ClusterNetworkAccessFlagDisabled),
	// 	},
	// 	SKU: &armkusto.AzureSKU{
	// 		Name: to.Ptr(armkusto.AzureSKUNameStandardL16AsV3),
	// 		Capacity: to.Ptr[int32](2),
	// 		Tier: to.Ptr(armkusto.AzureSKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersDelete.json
func ExampleClustersClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginDelete(ctx, "kustorptest", "kustoCluster2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersStop.json
func ExampleClustersClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginStop(ctx, "kustorptest", "kustoCluster2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersStart.json
func ExampleClustersClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginStart(ctx, "kustorptest", "kustoCluster2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClusterMigrate.json
func ExampleClustersClient_BeginMigrate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginMigrate(ctx, "kustorptest", "kustoCluster1", armkusto.ClusterMigrateRequest{
		ClusterResourceID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/clusters/kustoCluster2"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClusterListFollowerDatabases.json
func ExampleClustersClient_NewListFollowerDatabasesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClustersClient().NewListFollowerDatabasesPager("kustorptest", "kustoCluster", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FollowerDatabaseListResult = armkusto.FollowerDatabaseListResult{
		// 	Value: []*armkusto.FollowerDatabaseDefinition{
		// 		{
		// 			AttachedDatabaseConfigurationName: to.Ptr("attachedDbConfiguration"),
		// 			ClusterResourceID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/clusters/follower1"),
		// 			DatabaseName: to.Ptr("*"),
		// 			DatabaseShareOrigin: to.Ptr(armkusto.DatabaseShareOriginDataShare),
		// 		},
		// 		{
		// 			AttachedDatabaseConfigurationName: to.Ptr("attachedDbConfiguration2"),
		// 			ClusterResourceID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/clusters/follower4"),
		// 			DatabaseName: to.Ptr("db1"),
		// 			DatabaseShareOrigin: to.Ptr(armkusto.DatabaseShareOriginDirect),
		// 			TableLevelSharingProperties: &armkusto.TableLevelSharingProperties{
		// 				ExternalTablesToExclude: []*string{
		// 					to.Ptr("ExternalTable2")},
		// 					ExternalTablesToInclude: []*string{
		// 						to.Ptr("ExternalTable1")},
		// 						MaterializedViewsToExclude: []*string{
		// 							to.Ptr("MaterializedViewTable2")},
		// 							MaterializedViewsToInclude: []*string{
		// 								to.Ptr("MaterializedViewTable1")},
		// 								TablesToExclude: []*string{
		// 									to.Ptr("Table2")},
		// 									TablesToInclude: []*string{
		// 										to.Ptr("Table1")},
		// 									},
		// 							}},
		// 						}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClusterDetachFollowerDatabases.json
func ExampleClustersClient_BeginDetachFollowerDatabases() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginDetachFollowerDatabases(ctx, "kustorptest", "kustoCluster", armkusto.FollowerDatabaseDefinition{
		AttachedDatabaseConfigurationName: to.Ptr("attachedDatabaseConfigurationsTest"),
		ClusterResourceID:                 to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/clusters/kustoCluster2"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersDiagnoseVirtualNetwork.json
func ExampleClustersClient_BeginDiagnoseVirtualNetwork() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginDiagnoseVirtualNetwork(ctx, "kustorptest", "kustoCluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DiagnoseVirtualNetworkResult = armkusto.DiagnoseVirtualNetworkResult{
	// 	Findings: []*string{
	// 		to.Ptr("Outbound dependency 'Storage:443' might not be satisfied (Outbound)")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersListByResourceGroup.json
func ExampleClustersClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClustersClient().NewListByResourceGroupPager("kustorptest", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ClusterListResult = armkusto.ClusterListResult{
		// 	Value: []*armkusto.Cluster{
		// 		{
		// 			Name: to.Ptr("KustoClusterRPTest4"),
		// 			Type: to.Ptr("Microsoft.Kusto/Clusters"),
		// 			ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/KustoClusterRPTest4"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("abcd123"),
		// 			Properties: &armkusto.ClusterProperties{
		// 				AllowedFqdnList: []*string{
		// 					to.Ptr("my-stroage.blob.core.windows.net")},
		// 					AllowedIPRangeList: []*string{
		// 					},
		// 					EnableDiskEncryption: to.Ptr(false),
		// 					EnableStreamingIngest: to.Ptr(true),
		// 					EngineType: to.Ptr(armkusto.EngineTypeV2),
		// 					KeyVaultProperties: &armkusto.KeyVaultProperties{
		// 						KeyName: to.Ptr("keyName"),
		// 						KeyVaultURI: to.Ptr("https://dummy.keyvault.com"),
		// 						KeyVersion: to.Ptr("keyVersion"),
		// 					},
		// 					MigrationCluster: &armkusto.MigrationClusterProperties{
		// 						DataIngestionURI: to.Ptr("https://ingest-kustocluster2.westus.kusto.windows.net"),
		// 						ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster2"),
		// 						Role: to.Ptr(armkusto.MigrationClusterRoleDestination),
		// 						URI: to.Ptr("https://kustocluster2.westus.kusto.windows.net"),
		// 					},
		// 					ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
		// 					PublicNetworkAccess: to.Ptr(armkusto.PublicNetworkAccessEnabled),
		// 					RestrictOutboundNetworkAccess: to.Ptr(armkusto.ClusterNetworkAccessFlagDisabled),
		// 				},
		// 				SKU: &armkusto.AzureSKU{
		// 					Name: to.Ptr(armkusto.AzureSKUNameStandardL16AsV3),
		// 					Capacity: to.Ptr[int32](2),
		// 					Tier: to.Ptr(armkusto.AzureSKUTierStandard),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("KustoClusterRPTest3"),
		// 				Type: to.Ptr("Microsoft.Kusto/Clusters"),
		// 				ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/KustoClusterRPTest3"),
		// 				Location: to.Ptr("westus"),
		// 				Etag: to.Ptr("abcd123"),
		// 				Properties: &armkusto.ClusterProperties{
		// 					AllowedIPRangeList: []*string{
		// 						to.Ptr("0.0.0.0/0")},
		// 						EnableDiskEncryption: to.Ptr(true),
		// 						EnableStreamingIngest: to.Ptr(true),
		// 						EngineType: to.Ptr(armkusto.EngineTypeV3),
		// 						ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
		// 						PublicNetworkAccess: to.Ptr(armkusto.PublicNetworkAccessEnabled),
		// 						RestrictOutboundNetworkAccess: to.Ptr(armkusto.ClusterNetworkAccessFlagDisabled),
		// 					},
		// 					SKU: &armkusto.AzureSKU{
		// 						Name: to.Ptr(armkusto.AzureSKUNameStandardL16AsV3),
		// 						Capacity: to.Ptr[int32](2),
		// 						Tier: to.Ptr(armkusto.AzureSKUTierStandard),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersList.json
func ExampleClustersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClustersClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ClusterListResult = armkusto.ClusterListResult{
		// 	Value: []*armkusto.Cluster{
		// 		{
		// 			Name: to.Ptr("kustoCluster"),
		// 			Type: to.Ptr("Microsoft.Kusto/Clusters"),
		// 			ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("abcd123"),
		// 			Properties: &armkusto.ClusterProperties{
		// 				AllowedFqdnList: []*string{
		// 					to.Ptr("my-stroage.blob.core.windows.net")},
		// 					AllowedIPRangeList: []*string{
		// 					},
		// 					EnableAutoStop: to.Ptr(true),
		// 					EnableDiskEncryption: to.Ptr(false),
		// 					EnableStreamingIngest: to.Ptr(true),
		// 					EngineType: to.Ptr(armkusto.EngineTypeV3),
		// 					KeyVaultProperties: &armkusto.KeyVaultProperties{
		// 						KeyName: to.Ptr("keyName"),
		// 						KeyVaultURI: to.Ptr("https://dummy.keyvault.com"),
		// 						KeyVersion: to.Ptr("keyVersion"),
		// 					},
		// 					MigrationCluster: &armkusto.MigrationClusterProperties{
		// 						DataIngestionURI: to.Ptr("https://ingest-kustocluster2.westus.kusto.windows.net"),
		// 						ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster2"),
		// 						Role: to.Ptr(armkusto.MigrationClusterRoleDestination),
		// 						URI: to.Ptr("https://kustocluster2.westus.kusto.windows.net"),
		// 					},
		// 					PrivateEndpointConnections: []*armkusto.PrivateEndpointConnection{
		// 						{
		// 							Name: to.Ptr("privateEndpointTest"),
		// 							Type: to.Ptr("Microsoft.Kusto/Clusters/PrivateEndpointConnections"),
		// 							ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster/privateEndpointConnections/privateEndpointTest"),
		// 							Properties: &armkusto.PrivateEndpointConnectionProperties{
		// 								GroupID: to.Ptr("cluster"),
		// 								PrivateEndpoint: &armkusto.PrivateEndpointProperty{
		// 									ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/rg1Network/providers/Microsoft.Network/privateEndpoints/privateEndpointName"),
		// 								},
		// 								PrivateLinkServiceConnectionState: &armkusto.PrivateLinkServiceConnectionStateProperty{
		// 									Description: to.Ptr("Auto-approved"),
		// 									ActionsRequired: to.Ptr("None"),
		// 									Status: to.Ptr("Approved"),
		// 								},
		// 								ProvisioningState: to.Ptr("Succeeded"),
		// 							},
		// 					}},
		// 					ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
		// 					PublicIPType: to.Ptr(armkusto.PublicIPTypeDualStack),
		// 					PublicNetworkAccess: to.Ptr(armkusto.PublicNetworkAccessEnabled),
		// 					RestrictOutboundNetworkAccess: to.Ptr(armkusto.ClusterNetworkAccessFlagEnabled),
		// 				},
		// 				SKU: &armkusto.AzureSKU{
		// 					Name: to.Ptr(armkusto.AzureSKUNameStandardL16AsV3),
		// 					Capacity: to.Ptr[int32](2),
		// 					Tier: to.Ptr(armkusto.AzureSKUTierStandard),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("KustoClusterRPTest3"),
		// 				Type: to.Ptr("Microsoft.Kusto/Clusters"),
		// 				ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/KustoClusterRPTest3"),
		// 				Location: to.Ptr("westus"),
		// 				Etag: to.Ptr("abcd123"),
		// 				Properties: &armkusto.ClusterProperties{
		// 					AllowedIPRangeList: []*string{
		// 						to.Ptr("0.0.0.0/0")},
		// 						EnableDiskEncryption: to.Ptr(true),
		// 						EnableStreamingIngest: to.Ptr(true),
		// 						EngineType: to.Ptr(armkusto.EngineTypeV2),
		// 						PrivateEndpointConnections: []*armkusto.PrivateEndpointConnection{
		// 						},
		// 						ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
		// 						PublicIPType: to.Ptr(armkusto.PublicIPTypeIPv4),
		// 						PublicNetworkAccess: to.Ptr(armkusto.PublicNetworkAccessEnabled),
		// 						RestrictOutboundNetworkAccess: to.Ptr(armkusto.ClusterNetworkAccessFlagDisabled),
		// 					},
		// 					SKU: &armkusto.AzureSKU{
		// 						Name: to.Ptr(armkusto.AzureSKUNameStandardL16AsV3),
		// 						Capacity: to.Ptr[int32](2),
		// 						Tier: to.Ptr(armkusto.AzureSKUTierStandard),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersListSkus.json
func ExampleClustersClient_NewListSKUsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClustersClient().NewListSKUsPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SKUDescriptionList = armkusto.SKUDescriptionList{
		// 	Value: []*armkusto.SKUDescription{
		// 		{
		// 			Name: to.Ptr("Standard_L8s_v3"),
		// 			LocationInfo: []*armkusto.SKULocationInfoItem{
		// 				{
		// 					Location: to.Ptr("West US"),
		// 					Zones: []*string{
		// 						to.Ptr("1"),
		// 						to.Ptr("2"),
		// 						to.Ptr("3")},
		// 					},
		// 					{
		// 						Location: to.Ptr("West Europe"),
		// 						Zones: []*string{
		// 						},
		// 				}},
		// 				Locations: []*string{
		// 					to.Ptr("West US"),
		// 					to.Ptr("West Europe")},
		// 					Tier: to.Ptr("Standard"),
		// 				},
		// 				{
		// 					Name: to.Ptr("Standard_L16s_v3"),
		// 					LocationInfo: []*armkusto.SKULocationInfoItem{
		// 						{
		// 							Location: to.Ptr("West US"),
		// 							Zones: []*string{
		// 								to.Ptr("1"),
		// 								to.Ptr("2"),
		// 								to.Ptr("3")},
		// 							},
		// 							{
		// 								Location: to.Ptr("West Europe"),
		// 								Zones: []*string{
		// 								},
		// 						}},
		// 						Locations: []*string{
		// 							to.Ptr("West US"),
		// 							to.Ptr("West Europe")},
		// 							Tier: to.Ptr("Standard"),
		// 						},
		// 						{
		// 							Name: to.Ptr("Standard_L8as_v3"),
		// 							LocationInfo: []*armkusto.SKULocationInfoItem{
		// 								{
		// 									Location: to.Ptr("West US"),
		// 									Zones: []*string{
		// 										to.Ptr("1"),
		// 										to.Ptr("2"),
		// 										to.Ptr("3")},
		// 									},
		// 									{
		// 										Location: to.Ptr("West Europe"),
		// 										Zones: []*string{
		// 										},
		// 								}},
		// 								Locations: []*string{
		// 									to.Ptr("West US"),
		// 									to.Ptr("West Europe")},
		// 									Tier: to.Ptr("Standard"),
		// 								},
		// 								{
		// 									Name: to.Ptr("Standard_L16as_v3"),
		// 									LocationInfo: []*armkusto.SKULocationInfoItem{
		// 										{
		// 											Location: to.Ptr("West US"),
		// 											Zones: []*string{
		// 												to.Ptr("1"),
		// 												to.Ptr("2"),
		// 												to.Ptr("3")},
		// 											},
		// 											{
		// 												Location: to.Ptr("West Europe"),
		// 												Zones: []*string{
		// 												},
		// 										}},
		// 										Locations: []*string{
		// 											to.Ptr("West US"),
		// 											to.Ptr("West Europe")},
		// 											Tier: to.Ptr("Standard"),
		// 									}},
		// 								}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersCheckNameAvailability.json
func ExampleClustersClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClustersClient().CheckNameAvailability(ctx, "westus", armkusto.ClusterCheckNameRequest{
		Name: to.Ptr("kustoCluster"),
		Type: to.Ptr("Microsoft.Kusto/clusters"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameResult = armkusto.CheckNameResult{
	// 	Name: to.Ptr("kuskusprod"),
	// 	Message: to.Ptr("Name 'kuskusprod' is already taken. Please specify a different name"),
	// 	NameAvailable: to.Ptr(false),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClustersListResourceSkus.json
func ExampleClustersClient_NewListSKUsByResourcePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClustersClient().NewListSKUsByResourcePager("kustorptest", "kustoCluster", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListResourceSKUsResult = armkusto.ListResourceSKUsResult{
		// 	Value: []*armkusto.AzureResourceSKU{
		// 		{
		// 			Capacity: &armkusto.AzureCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](100),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr(armkusto.AzureScaleTypeAutomatic),
		// 			},
		// 			ResourceType: to.Ptr("clusters"),
		// 			SKU: &armkusto.AzureSKU{
		// 				Name: to.Ptr(armkusto.AzureSKUNameStandardL8SV3),
		// 				Tier: to.Ptr(armkusto.AzureSKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armkusto.AzureCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](100),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr(armkusto.AzureScaleTypeAutomatic),
		// 			},
		// 			ResourceType: to.Ptr("clusters"),
		// 			SKU: &armkusto.AzureSKU{
		// 				Name: to.Ptr(armkusto.AzureSKUNameStandardL8AsV3),
		// 				Tier: to.Ptr(armkusto.AzureSKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armkusto.AzureCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](100),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr(armkusto.AzureScaleTypeAutomatic),
		// 			},
		// 			ResourceType: to.Ptr("clusters"),
		// 			SKU: &armkusto.AzureSKU{
		// 				Name: to.Ptr(armkusto.AzureSKUNameStandardL16AsV3),
		// 				Tier: to.Ptr(armkusto.AzureSKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armkusto.AzureCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](100),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr(armkusto.AzureScaleTypeAutomatic),
		// 			},
		// 			ResourceType: to.Ptr("clusters"),
		// 			SKU: &armkusto.AzureSKU{
		// 				Name: to.Ptr(armkusto.AzureSKUNameStandardL16SV3),
		// 				Tier: to.Ptr(armkusto.AzureSKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoOutboundNetworkDependenciesList.json
func ExampleClustersClient_NewListOutboundNetworkDependenciesEndpointsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClustersClient().NewListOutboundNetworkDependenciesEndpointsPager("kustorptest", "kustoCluster", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OutboundNetworkDependenciesEndpointListResult = armkusto.OutboundNetworkDependenciesEndpointListResult{
		// 	Value: []*armkusto.OutboundNetworkDependenciesEndpoint{
		// 		{
		// 			Name: to.Ptr("kustoCluster/AzureActiveDirectory"),
		// 			Type: to.Ptr("Microsoft.Kusto/Clusters/OutboundNetworkDependenciesEndpoints"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster/OutboundNetworkDependenciesEndpoints/AzureActiveDirectory"),
		// 			Properties: &armkusto.OutboundNetworkDependenciesEndpointProperties{
		// 				Category: to.Ptr("Azure Active Directory"),
		// 				Endpoints: []*armkusto.EndpointDependency{
		// 					{
		// 						DomainName: to.Ptr("login.microsoftonline.com"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("graph.windows.net"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("graph.microsoft.com"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("graph.microsoft-ppe.com"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 				}},
		// 				ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("kustoCluster/AzureMonitor"),
		// 			Type: to.Ptr("Microsoft.Kusto/Clusters/OutboundNetworkDependenciesEndpoints"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster/OutboundNetworkDependenciesEndpoints/AzureMonitor"),
		// 			Properties: &armkusto.OutboundNetworkDependenciesEndpointProperties{
		// 				Category: to.Ptr("Azure Monitor"),
		// 				Endpoints: []*armkusto.EndpointDependency{
		// 					{
		// 						DomainName: to.Ptr("prod.warmpath.msftcloudes.com"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("gcs.prod.monitoring.core.windows.net"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("production.diagnostics.monitoring.core.windows.net"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("shoebox2.metrics.nsatc.net:443"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 				}},
		// 				ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("kustoCluster/CertificateAuthority"),
		// 			Type: to.Ptr("Microsoft.Kusto/Clusters/OutboundNetworkDependenciesEndpoints"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster/OutboundNetworkDependenciesEndpoints/CertificateAuthority"),
		// 			Properties: &armkusto.OutboundNetworkDependenciesEndpointProperties{
		// 				Category: to.Ptr("Certificate Authority"),
		// 				Endpoints: []*armkusto.EndpointDependency{
		// 					{
		// 						DomainName: to.Ptr("ocsp.msocsp.com"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](80),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("ocsp.digicert.com"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](80),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("crl3.digicert.com"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](80),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("crl.microsoft.com"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](80),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("www.microsoft.com"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](80),
		// 						}},
		// 				}},
		// 				ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("kustoCluster/AzureStorage"),
		// 			Type: to.Ptr("Microsoft.Kusto/Clusters/OutboundNetworkDependenciesEndpoints"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster/OutboundNetworkDependenciesEndpoints/AzureStorage"),
		// 			Properties: &armkusto.OutboundNetworkDependenciesEndpointProperties{
		// 				Category: to.Ptr("Azure Storage"),
		// 				Endpoints: []*armkusto.EndpointDependency{
		// 					{
		// 						DomainName: to.Ptr("clusterinternalsa.blob.core.windows.net"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("clusterinternalsa.queue.core.windows.net"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 					},
		// 					{
		// 						DomainName: to.Ptr("clusterinternalsa.table.core.windows.net"),
		// 						EndpointDetails: []*armkusto.EndpointDetail{
		// 							{
		// 								IPAddress: to.Ptr("1.2.3.4"),
		// 								Port: to.Ptr[int32](443),
		// 						}},
		// 				}},
		// 				ProvisioningState: to.Ptr(armkusto.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClusterListLanguageExtensions.json
func ExampleClustersClient_NewListLanguageExtensionsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClustersClient().NewListLanguageExtensionsPager("kustorptest", "kustoCluster", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LanguageExtensionsList = armkusto.LanguageExtensionsList{
		// 	Value: []*armkusto.LanguageExtension{
		// 		{
		// 			LanguageExtensionName: to.Ptr(armkusto.LanguageExtensionNamePYTHON),
		// 		},
		// 		{
		// 			LanguageExtensionName: to.Ptr(armkusto.LanguageExtensionNameR),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClusterAddLanguageExtensions.json
func ExampleClustersClient_BeginAddLanguageExtensions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginAddLanguageExtensions(ctx, "kustorptest", "kustoCluster", armkusto.LanguageExtensionsList{
		Value: []*armkusto.LanguageExtension{
			{
				LanguageExtensionName: to.Ptr(armkusto.LanguageExtensionNamePYTHON),
			},
			{
				LanguageExtensionName: to.Ptr(armkusto.LanguageExtensionNameR),
			}},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoClusterRemoveLanguageExtensions.json
func ExampleClustersClient_BeginRemoveLanguageExtensions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClustersClient().BeginRemoveLanguageExtensions(ctx, "kustorptest", "kustoCluster", armkusto.LanguageExtensionsList{
		Value: []*armkusto.LanguageExtension{
			{
				LanguageExtensionName: to.Ptr(armkusto.LanguageExtensionNamePYTHON),
			},
			{
				LanguageExtensionName: to.Ptr(armkusto.LanguageExtensionNameR),
			}},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
