//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armkeyvault_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/keyvault/armkeyvault"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/ManagedHsm_listPrivateLinkResources.json
func ExampleMHSMPrivateLinkResourcesClient_ListByMHSMResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMHSMPrivateLinkResourcesClient().ListByMHSMResource(ctx, "sample-group", "sample-mhsm", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MHSMPrivateLinkResourceListResult = armkeyvault.MHSMPrivateLinkResourceListResult{
	// 	Value: []*armkeyvault.MHSMPrivateLinkResource{
	// 		{
	// 			Name: to.Ptr("managedhsm"),
	// 			Type: to.Ptr("Microsoft.KeyVault/managedhsms/privateLinkResources"),
	// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-resource-group/providers/Microsoft.KeyVault/managedhsms/sample-mhsm/privateLinkResources/managedhsm"),
	// 			Properties: &armkeyvault.MHSMPrivateLinkResourceProperties{
	// 				GroupID: to.Ptr("managedhsms"),
	// 				RequiredMembers: []*string{
	// 					to.Ptr("default")},
	// 					RequiredZoneNames: []*string{
	// 						to.Ptr("privatelink.managedhsm.azure.net")},
	// 					},
	// 			}},
	// 		}
}
