//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iothub/armiothub"
	"net/http"
	"net/url"
	"regexp"
)

// ResourceServer is a fake server for instances of the armiothub.ResourceClient type.
type ResourceServer struct {
	// CheckNameAvailability is the fake for method ResourceClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, operationInputs armiothub.OperationInputs, options *armiothub.ResourceClientCheckNameAvailabilityOptions) (resp azfake.Responder[armiothub.ResourceClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// CreateEventHubConsumerGroup is the fake for method ResourceClient.CreateEventHubConsumerGroup
	// HTTP status codes to indicate success: http.StatusOK
	CreateEventHubConsumerGroup func(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string, consumerGroupBody armiothub.EventHubConsumerGroupBodyDescription, options *armiothub.ResourceClientCreateEventHubConsumerGroupOptions) (resp azfake.Responder[armiothub.ResourceClientCreateEventHubConsumerGroupResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method ResourceClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, resourceName string, iotHubDescription armiothub.Description, options *armiothub.ResourceClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armiothub.ResourceClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ResourceClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound
	BeginDelete func(ctx context.Context, resourceGroupName string, resourceName string, options *armiothub.ResourceClientBeginDeleteOptions) (resp azfake.PollerResponder[armiothub.ResourceClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteEventHubConsumerGroup is the fake for method ResourceClient.DeleteEventHubConsumerGroup
	// HTTP status codes to indicate success: http.StatusOK
	DeleteEventHubConsumerGroup func(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string, options *armiothub.ResourceClientDeleteEventHubConsumerGroupOptions) (resp azfake.Responder[armiothub.ResourceClientDeleteEventHubConsumerGroupResponse], errResp azfake.ErrorResponder)

	// ExportDevices is the fake for method ResourceClient.ExportDevices
	// HTTP status codes to indicate success: http.StatusOK
	ExportDevices func(ctx context.Context, resourceGroupName string, resourceName string, exportDevicesParameters armiothub.ExportDevicesRequest, options *armiothub.ResourceClientExportDevicesOptions) (resp azfake.Responder[armiothub.ResourceClientExportDevicesResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ResourceClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceName string, options *armiothub.ResourceClientGetOptions) (resp azfake.Responder[armiothub.ResourceClientGetResponse], errResp azfake.ErrorResponder)

	// NewGetEndpointHealthPager is the fake for method ResourceClient.NewGetEndpointHealthPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetEndpointHealthPager func(resourceGroupName string, iotHubName string, options *armiothub.ResourceClientGetEndpointHealthOptions) (resp azfake.PagerResponder[armiothub.ResourceClientGetEndpointHealthResponse])

	// GetEventHubConsumerGroup is the fake for method ResourceClient.GetEventHubConsumerGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetEventHubConsumerGroup func(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string, options *armiothub.ResourceClientGetEventHubConsumerGroupOptions) (resp azfake.Responder[armiothub.ResourceClientGetEventHubConsumerGroupResponse], errResp azfake.ErrorResponder)

	// GetJob is the fake for method ResourceClient.GetJob
	// HTTP status codes to indicate success: http.StatusOK
	GetJob func(ctx context.Context, resourceGroupName string, resourceName string, jobID string, options *armiothub.ResourceClientGetJobOptions) (resp azfake.Responder[armiothub.ResourceClientGetJobResponse], errResp azfake.ErrorResponder)

	// GetKeysForKeyName is the fake for method ResourceClient.GetKeysForKeyName
	// HTTP status codes to indicate success: http.StatusOK
	GetKeysForKeyName func(ctx context.Context, resourceGroupName string, resourceName string, keyName string, options *armiothub.ResourceClientGetKeysForKeyNameOptions) (resp azfake.Responder[armiothub.ResourceClientGetKeysForKeyNameResponse], errResp azfake.ErrorResponder)

	// NewGetQuotaMetricsPager is the fake for method ResourceClient.NewGetQuotaMetricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetQuotaMetricsPager func(resourceGroupName string, resourceName string, options *armiothub.ResourceClientGetQuotaMetricsOptions) (resp azfake.PagerResponder[armiothub.ResourceClientGetQuotaMetricsResponse])

	// GetStats is the fake for method ResourceClient.GetStats
	// HTTP status codes to indicate success: http.StatusOK
	GetStats func(ctx context.Context, resourceGroupName string, resourceName string, options *armiothub.ResourceClientGetStatsOptions) (resp azfake.Responder[armiothub.ResourceClientGetStatsResponse], errResp azfake.ErrorResponder)

	// NewGetValidSKUsPager is the fake for method ResourceClient.NewGetValidSKUsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetValidSKUsPager func(resourceGroupName string, resourceName string, options *armiothub.ResourceClientGetValidSKUsOptions) (resp azfake.PagerResponder[armiothub.ResourceClientGetValidSKUsResponse])

	// ImportDevices is the fake for method ResourceClient.ImportDevices
	// HTTP status codes to indicate success: http.StatusOK
	ImportDevices func(ctx context.Context, resourceGroupName string, resourceName string, importDevicesParameters armiothub.ImportDevicesRequest, options *armiothub.ResourceClientImportDevicesOptions) (resp azfake.Responder[armiothub.ResourceClientImportDevicesResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method ResourceClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armiothub.ResourceClientListByResourceGroupOptions) (resp azfake.PagerResponder[armiothub.ResourceClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method ResourceClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armiothub.ResourceClientListBySubscriptionOptions) (resp azfake.PagerResponder[armiothub.ResourceClientListBySubscriptionResponse])

	// NewListEventHubConsumerGroupsPager is the fake for method ResourceClient.NewListEventHubConsumerGroupsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListEventHubConsumerGroupsPager func(resourceGroupName string, resourceName string, eventHubEndpointName string, options *armiothub.ResourceClientListEventHubConsumerGroupsOptions) (resp azfake.PagerResponder[armiothub.ResourceClientListEventHubConsumerGroupsResponse])

	// NewListJobsPager is the fake for method ResourceClient.NewListJobsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListJobsPager func(resourceGroupName string, resourceName string, options *armiothub.ResourceClientListJobsOptions) (resp azfake.PagerResponder[armiothub.ResourceClientListJobsResponse])

	// NewListKeysPager is the fake for method ResourceClient.NewListKeysPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListKeysPager func(resourceGroupName string, resourceName string, options *armiothub.ResourceClientListKeysOptions) (resp azfake.PagerResponder[armiothub.ResourceClientListKeysResponse])

	// TestAllRoutes is the fake for method ResourceClient.TestAllRoutes
	// HTTP status codes to indicate success: http.StatusOK
	TestAllRoutes func(ctx context.Context, iotHubName string, resourceGroupName string, input armiothub.TestAllRoutesInput, options *armiothub.ResourceClientTestAllRoutesOptions) (resp azfake.Responder[armiothub.ResourceClientTestAllRoutesResponse], errResp azfake.ErrorResponder)

	// TestRoute is the fake for method ResourceClient.TestRoute
	// HTTP status codes to indicate success: http.StatusOK
	TestRoute func(ctx context.Context, iotHubName string, resourceGroupName string, input armiothub.TestRouteInput, options *armiothub.ResourceClientTestRouteOptions) (resp azfake.Responder[armiothub.ResourceClientTestRouteResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ResourceClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK
	BeginUpdate func(ctx context.Context, resourceGroupName string, resourceName string, iotHubTags armiothub.TagsResource, options *armiothub.ResourceClientBeginUpdateOptions) (resp azfake.PollerResponder[armiothub.ResourceClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewResourceServerTransport creates a new instance of ResourceServerTransport with the provided implementation.
// The returned ResourceServerTransport instance is connected to an instance of armiothub.ResourceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourceServerTransport(srv *ResourceServer) *ResourceServerTransport {
	return &ResourceServerTransport{
		srv:                                srv,
		beginCreateOrUpdate:                newTracker[azfake.PollerResponder[armiothub.ResourceClientCreateOrUpdateResponse]](),
		beginDelete:                        newTracker[azfake.PollerResponder[armiothub.ResourceClientDeleteResponse]](),
		newGetEndpointHealthPager:          newTracker[azfake.PagerResponder[armiothub.ResourceClientGetEndpointHealthResponse]](),
		newGetQuotaMetricsPager:            newTracker[azfake.PagerResponder[armiothub.ResourceClientGetQuotaMetricsResponse]](),
		newGetValidSKUsPager:               newTracker[azfake.PagerResponder[armiothub.ResourceClientGetValidSKUsResponse]](),
		newListByResourceGroupPager:        newTracker[azfake.PagerResponder[armiothub.ResourceClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:         newTracker[azfake.PagerResponder[armiothub.ResourceClientListBySubscriptionResponse]](),
		newListEventHubConsumerGroupsPager: newTracker[azfake.PagerResponder[armiothub.ResourceClientListEventHubConsumerGroupsResponse]](),
		newListJobsPager:                   newTracker[azfake.PagerResponder[armiothub.ResourceClientListJobsResponse]](),
		newListKeysPager:                   newTracker[azfake.PagerResponder[armiothub.ResourceClientListKeysResponse]](),
		beginUpdate:                        newTracker[azfake.PollerResponder[armiothub.ResourceClientUpdateResponse]](),
	}
}

// ResourceServerTransport connects instances of armiothub.ResourceClient to instances of ResourceServer.
// Don't use this type directly, use NewResourceServerTransport instead.
type ResourceServerTransport struct {
	srv                                *ResourceServer
	beginCreateOrUpdate                *tracker[azfake.PollerResponder[armiothub.ResourceClientCreateOrUpdateResponse]]
	beginDelete                        *tracker[azfake.PollerResponder[armiothub.ResourceClientDeleteResponse]]
	newGetEndpointHealthPager          *tracker[azfake.PagerResponder[armiothub.ResourceClientGetEndpointHealthResponse]]
	newGetQuotaMetricsPager            *tracker[azfake.PagerResponder[armiothub.ResourceClientGetQuotaMetricsResponse]]
	newGetValidSKUsPager               *tracker[azfake.PagerResponder[armiothub.ResourceClientGetValidSKUsResponse]]
	newListByResourceGroupPager        *tracker[azfake.PagerResponder[armiothub.ResourceClientListByResourceGroupResponse]]
	newListBySubscriptionPager         *tracker[azfake.PagerResponder[armiothub.ResourceClientListBySubscriptionResponse]]
	newListEventHubConsumerGroupsPager *tracker[azfake.PagerResponder[armiothub.ResourceClientListEventHubConsumerGroupsResponse]]
	newListJobsPager                   *tracker[azfake.PagerResponder[armiothub.ResourceClientListJobsResponse]]
	newListKeysPager                   *tracker[azfake.PagerResponder[armiothub.ResourceClientListKeysResponse]]
	beginUpdate                        *tracker[azfake.PollerResponder[armiothub.ResourceClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ResourceServerTransport.
func (r *ResourceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourceClient.CheckNameAvailability":
		resp, err = r.dispatchCheckNameAvailability(req)
	case "ResourceClient.CreateEventHubConsumerGroup":
		resp, err = r.dispatchCreateEventHubConsumerGroup(req)
	case "ResourceClient.BeginCreateOrUpdate":
		resp, err = r.dispatchBeginCreateOrUpdate(req)
	case "ResourceClient.BeginDelete":
		resp, err = r.dispatchBeginDelete(req)
	case "ResourceClient.DeleteEventHubConsumerGroup":
		resp, err = r.dispatchDeleteEventHubConsumerGroup(req)
	case "ResourceClient.ExportDevices":
		resp, err = r.dispatchExportDevices(req)
	case "ResourceClient.Get":
		resp, err = r.dispatchGet(req)
	case "ResourceClient.NewGetEndpointHealthPager":
		resp, err = r.dispatchNewGetEndpointHealthPager(req)
	case "ResourceClient.GetEventHubConsumerGroup":
		resp, err = r.dispatchGetEventHubConsumerGroup(req)
	case "ResourceClient.GetJob":
		resp, err = r.dispatchGetJob(req)
	case "ResourceClient.GetKeysForKeyName":
		resp, err = r.dispatchGetKeysForKeyName(req)
	case "ResourceClient.NewGetQuotaMetricsPager":
		resp, err = r.dispatchNewGetQuotaMetricsPager(req)
	case "ResourceClient.GetStats":
		resp, err = r.dispatchGetStats(req)
	case "ResourceClient.NewGetValidSKUsPager":
		resp, err = r.dispatchNewGetValidSKUsPager(req)
	case "ResourceClient.ImportDevices":
		resp, err = r.dispatchImportDevices(req)
	case "ResourceClient.NewListByResourceGroupPager":
		resp, err = r.dispatchNewListByResourceGroupPager(req)
	case "ResourceClient.NewListBySubscriptionPager":
		resp, err = r.dispatchNewListBySubscriptionPager(req)
	case "ResourceClient.NewListEventHubConsumerGroupsPager":
		resp, err = r.dispatchNewListEventHubConsumerGroupsPager(req)
	case "ResourceClient.NewListJobsPager":
		resp, err = r.dispatchNewListJobsPager(req)
	case "ResourceClient.NewListKeysPager":
		resp, err = r.dispatchNewListKeysPager(req)
	case "ResourceClient.TestAllRoutes":
		resp, err = r.dispatchTestAllRoutes(req)
	case "ResourceClient.TestRoute":
		resp, err = r.dispatchTestRoute(req)
	case "ResourceClient.BeginUpdate":
		resp, err = r.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourceServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if r.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiothub.OperationInputs](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CheckNameAvailability(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NameAvailabilityInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchCreateEventHubConsumerGroup(req *http.Request) (*http.Response, error) {
	if r.srv.CreateEventHubConsumerGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateEventHubConsumerGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventHubEndpoints/(?P<eventHubEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ConsumerGroups/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiothub.EventHubConsumerGroupBodyDescription](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	eventHubEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventHubEndpointName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CreateEventHubConsumerGroup(req.Context(), resourceGroupNameParam, resourceNameParam, eventHubEndpointNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventHubConsumerGroupInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := r.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armiothub.Description](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armiothub.ResourceClientBeginCreateOrUpdateOptions
		if ifMatchParam != nil {
			options = &armiothub.ResourceClientBeginCreateOrUpdateOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := r.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, resourceNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		r.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		r.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		r.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (r *ResourceServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := r.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginDelete(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		r.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound}, resp.StatusCode) {
		r.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		r.beginDelete.remove(req)
	}

	return resp, nil
}

func (r *ResourceServerTransport) dispatchDeleteEventHubConsumerGroup(req *http.Request) (*http.Response, error) {
	if r.srv.DeleteEventHubConsumerGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteEventHubConsumerGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventHubEndpoints/(?P<eventHubEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ConsumerGroups/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	eventHubEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventHubEndpointName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DeleteEventHubConsumerGroup(req.Context(), resourceGroupNameParam, resourceNameParam, eventHubEndpointNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchExportDevices(req *http.Request) (*http.Response, error) {
	if r.srv.ExportDevices == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExportDevices not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportDevices`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiothub.ExportDevicesRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.ExportDevices(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Description, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchNewGetEndpointHealthPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetEndpointHealthPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetEndpointHealthPager not implemented")}
	}
	newGetEndpointHealthPager := r.newGetEndpointHealthPager.get(req)
	if newGetEndpointHealthPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<iotHubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routingEndpointsHealth`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		iotHubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iotHubName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetEndpointHealthPager(resourceGroupNameParam, iotHubNameParam, nil)
		newGetEndpointHealthPager = &resp
		r.newGetEndpointHealthPager.add(req, newGetEndpointHealthPager)
		server.PagerResponderInjectNextLinks(newGetEndpointHealthPager, req, func(page *armiothub.ResourceClientGetEndpointHealthResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetEndpointHealthPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetEndpointHealthPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetEndpointHealthPager) {
		r.newGetEndpointHealthPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchGetEventHubConsumerGroup(req *http.Request) (*http.Response, error) {
	if r.srv.GetEventHubConsumerGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetEventHubConsumerGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventHubEndpoints/(?P<eventHubEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ConsumerGroups/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	eventHubEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventHubEndpointName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetEventHubConsumerGroup(req.Context(), resourceGroupNameParam, resourceNameParam, eventHubEndpointNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventHubConsumerGroupInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchGetJob(req *http.Request) (*http.Response, error) {
	if r.srv.GetJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	jobIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetJob(req.Context(), resourceGroupNameParam, resourceNameParam, jobIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchGetKeysForKeyName(req *http.Request) (*http.Response, error) {
	if r.srv.GetKeysForKeyName == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetKeysForKeyName not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/IotHubKeys/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listkeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetKeysForKeyName(req.Context(), resourceGroupNameParam, resourceNameParam, keyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SharedAccessSignatureAuthorizationRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchNewGetQuotaMetricsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetQuotaMetricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetQuotaMetricsPager not implemented")}
	}
	newGetQuotaMetricsPager := r.newGetQuotaMetricsPager.get(req)
	if newGetQuotaMetricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/quotaMetrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetQuotaMetricsPager(resourceGroupNameParam, resourceNameParam, nil)
		newGetQuotaMetricsPager = &resp
		r.newGetQuotaMetricsPager.add(req, newGetQuotaMetricsPager)
		server.PagerResponderInjectNextLinks(newGetQuotaMetricsPager, req, func(page *armiothub.ResourceClientGetQuotaMetricsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetQuotaMetricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetQuotaMetricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetQuotaMetricsPager) {
		r.newGetQuotaMetricsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchGetStats(req *http.Request) (*http.Response, error) {
	if r.srv.GetStats == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetStats not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/IotHubStats`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetStats(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegistryStatistics, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchNewGetValidSKUsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetValidSKUsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetValidSKUsPager not implemented")}
	}
	newGetValidSKUsPager := r.newGetValidSKUsPager.get(req)
	if newGetValidSKUsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetValidSKUsPager(resourceGroupNameParam, resourceNameParam, nil)
		newGetValidSKUsPager = &resp
		r.newGetValidSKUsPager.add(req, newGetValidSKUsPager)
		server.PagerResponderInjectNextLinks(newGetValidSKUsPager, req, func(page *armiothub.ResourceClientGetValidSKUsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetValidSKUsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetValidSKUsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetValidSKUsPager) {
		r.newGetValidSKUsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchImportDevices(req *http.Request) (*http.Response, error) {
	if r.srv.ImportDevices == nil {
		return nil, &nonRetriableError{errors.New("fake for method ImportDevices not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/importDevices`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiothub.ImportDevicesRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.ImportDevices(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := r.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		r.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armiothub.ResourceClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		r.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := r.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := r.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		r.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armiothub.ResourceClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		r.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchNewListEventHubConsumerGroupsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListEventHubConsumerGroupsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListEventHubConsumerGroupsPager not implemented")}
	}
	newListEventHubConsumerGroupsPager := r.newListEventHubConsumerGroupsPager.get(req)
	if newListEventHubConsumerGroupsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventHubEndpoints/(?P<eventHubEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ConsumerGroups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		eventHubEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventHubEndpointName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListEventHubConsumerGroupsPager(resourceGroupNameParam, resourceNameParam, eventHubEndpointNameParam, nil)
		newListEventHubConsumerGroupsPager = &resp
		r.newListEventHubConsumerGroupsPager.add(req, newListEventHubConsumerGroupsPager)
		server.PagerResponderInjectNextLinks(newListEventHubConsumerGroupsPager, req, func(page *armiothub.ResourceClientListEventHubConsumerGroupsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListEventHubConsumerGroupsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListEventHubConsumerGroupsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListEventHubConsumerGroupsPager) {
		r.newListEventHubConsumerGroupsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchNewListJobsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListJobsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListJobsPager not implemented")}
	}
	newListJobsPager := r.newListJobsPager.get(req)
	if newListJobsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListJobsPager(resourceGroupNameParam, resourceNameParam, nil)
		newListJobsPager = &resp
		r.newListJobsPager.add(req, newListJobsPager)
		server.PagerResponderInjectNextLinks(newListJobsPager, req, func(page *armiothub.ResourceClientListJobsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListJobsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListJobsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListJobsPager) {
		r.newListJobsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchNewListKeysPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListKeysPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListKeysPager not implemented")}
	}
	newListKeysPager := r.newListKeysPager.get(req)
	if newListKeysPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listkeys`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListKeysPager(resourceGroupNameParam, resourceNameParam, nil)
		newListKeysPager = &resp
		r.newListKeysPager.add(req, newListKeysPager)
		server.PagerResponderInjectNextLinks(newListKeysPager, req, func(page *armiothub.ResourceClientListKeysResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListKeysPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListKeysPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListKeysPager) {
		r.newListKeysPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchTestAllRoutes(req *http.Request) (*http.Response, error) {
	if r.srv.TestAllRoutes == nil {
		return nil, &nonRetriableError{errors.New("fake for method TestAllRoutes not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<iotHubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routing/routes/\$testall`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiothub.TestAllRoutesInput](req)
	if err != nil {
		return nil, err
	}
	iotHubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iotHubName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.TestAllRoutes(req.Context(), iotHubNameParam, resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TestAllRoutesResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchTestRoute(req *http.Request) (*http.Response, error) {
	if r.srv.TestRoute == nil {
		return nil, &nonRetriableError{errors.New("fake for method TestRoute not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<iotHubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routing/routes/\$testnew`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiothub.TestRouteInput](req)
	if err != nil {
		return nil, err
	}
	iotHubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iotHubName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.TestRoute(req.Context(), iotHubNameParam, resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TestRouteResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := r.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/IotHubs/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armiothub.TagsResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdate(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		r.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		r.beginUpdate.remove(req)
	}

	return resp, nil
}
