//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotfirmwaredefense/armiotfirmwaredefense"
	"net/http"
	"net/url"
	"regexp"
)

// FirmwaresServer is a fake server for instances of the armiotfirmwaredefense.FirmwaresClient type.
type FirmwaresServer struct {
	// Create is the fake for method FirmwaresClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware armiotfirmwaredefense.Firmware, options *armiotfirmwaredefense.FirmwaresClientCreateOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwaresClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method FirmwaresClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwaresClientDeleteOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwaresClientDeleteResponse], errResp azfake.ErrorResponder)

	// GenerateDownloadURL is the fake for method FirmwaresClient.GenerateDownloadURL
	// HTTP status codes to indicate success: http.StatusOK
	GenerateDownloadURL func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwaresClientGenerateDownloadURLOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwaresClientGenerateDownloadURLResponse], errResp azfake.ErrorResponder)

	// GenerateFilesystemDownloadURL is the fake for method FirmwaresClient.GenerateFilesystemDownloadURL
	// HTTP status codes to indicate success: http.StatusOK
	GenerateFilesystemDownloadURL func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwaresClientGenerateFilesystemDownloadURLOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwaresClientGenerateFilesystemDownloadURLResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method FirmwaresClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwaresClientGetOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwaresClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByWorkspacePager is the fake for method FirmwaresClient.NewListByWorkspacePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByWorkspacePager func(resourceGroupName string, workspaceName string, options *armiotfirmwaredefense.FirmwaresClientListByWorkspaceOptions) (resp azfake.PagerResponder[armiotfirmwaredefense.FirmwaresClientListByWorkspaceResponse])

	// Update is the fake for method FirmwaresClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware armiotfirmwaredefense.FirmwareUpdateDefinition, options *armiotfirmwaredefense.FirmwaresClientUpdateOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwaresClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewFirmwaresServerTransport creates a new instance of FirmwaresServerTransport with the provided implementation.
// The returned FirmwaresServerTransport instance is connected to an instance of armiotfirmwaredefense.FirmwaresClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFirmwaresServerTransport(srv *FirmwaresServer) *FirmwaresServerTransport {
	return &FirmwaresServerTransport{
		srv:                     srv,
		newListByWorkspacePager: newTracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwaresClientListByWorkspaceResponse]](),
	}
}

// FirmwaresServerTransport connects instances of armiotfirmwaredefense.FirmwaresClient to instances of FirmwaresServer.
// Don't use this type directly, use NewFirmwaresServerTransport instead.
type FirmwaresServerTransport struct {
	srv                     *FirmwaresServer
	newListByWorkspacePager *tracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwaresClientListByWorkspaceResponse]]
}

// Do implements the policy.Transporter interface for FirmwaresServerTransport.
func (f *FirmwaresServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FirmwaresClient.Create":
		resp, err = f.dispatchCreate(req)
	case "FirmwaresClient.Delete":
		resp, err = f.dispatchDelete(req)
	case "FirmwaresClient.GenerateDownloadURL":
		resp, err = f.dispatchGenerateDownloadURL(req)
	case "FirmwaresClient.GenerateFilesystemDownloadURL":
		resp, err = f.dispatchGenerateFilesystemDownloadURL(req)
	case "FirmwaresClient.Get":
		resp, err = f.dispatchGet(req)
	case "FirmwaresClient.NewListByWorkspacePager":
		resp, err = f.dispatchNewListByWorkspacePager(req)
	case "FirmwaresClient.Update":
		resp, err = f.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FirmwaresServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if f.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiotfirmwaredefense.Firmware](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Create(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Firmware, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwaresServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if f.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Delete(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwaresServerTransport) dispatchGenerateDownloadURL(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateDownloadURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateDownloadURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateDownloadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateDownloadURL(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).URLToken, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwaresServerTransport) dispatchGenerateFilesystemDownloadURL(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateFilesystemDownloadURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateFilesystemDownloadURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateFilesystemDownloadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateFilesystemDownloadURL(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).URLToken, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwaresServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if f.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Firmware, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwaresServerTransport) dispatchNewListByWorkspacePager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListByWorkspacePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByWorkspacePager not implemented")}
	}
	newListByWorkspacePager := f.newListByWorkspacePager.get(req)
	if newListByWorkspacePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListByWorkspacePager(resourceGroupNameParam, workspaceNameParam, nil)
		newListByWorkspacePager = &resp
		f.newListByWorkspacePager.add(req, newListByWorkspacePager)
		server.PagerResponderInjectNextLinks(newListByWorkspacePager, req, func(page *armiotfirmwaredefense.FirmwaresClientListByWorkspaceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByWorkspacePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListByWorkspacePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByWorkspacePager) {
		f.newListByWorkspacePager.remove(req)
	}
	return resp, nil
}

func (f *FirmwaresServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if f.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiotfirmwaredefense.FirmwareUpdateDefinition](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Update(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Firmware, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
