//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armintegrationspaces_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/integrationspaces/armintegrationspaces"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/azureintegrationspaces/resource-manager/Microsoft.IntegrationSpaces/preview/2023-11-14-preview/examples/ApplicationResources_ListByApplication.json
func ExampleApplicationResourcesClient_NewListByApplicationPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armintegrationspaces.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewApplicationResourcesClient().NewListByApplicationPager("testrg", "Space1", "Application1", &armintegrationspaces.ApplicationResourcesClientListByApplicationOptions{Top: nil,
		Skip:        nil,
		Maxpagesize: nil,
		Filter:      nil,
		Select:      []string{},
		Expand:      []string{},
		Orderby:     []string{},
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ApplicationResourceListResult = armintegrationspaces.ApplicationResourceListResult{
		// 	Value: []*armintegrationspaces.ApplicationResource{
		// 		{
		// 			Name: to.Ptr("Resource1"),
		// 			Type: to.Ptr("Microsoft.IntegrationSpaces/spaces/applications/resources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.IntegrationSpaces/spaces/Space1/applications/Application1/resources/Resource1"),
		// 			Properties: &armintegrationspaces.ApplicationResourceProperties{
		// 				ProvisioningState: to.Ptr(armintegrationspaces.ProvisioningStateSucceeded),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Web/sites/LogicApp1"),
		// 				ResourceKind: to.Ptr("LogicApp"),
		// 				ResourceType: to.Ptr("Microsoft.Web/sites"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/azureintegrationspaces/resource-manager/Microsoft.IntegrationSpaces/preview/2023-11-14-preview/examples/ApplicationResources_Get.json
func ExampleApplicationResourcesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armintegrationspaces.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationResourcesClient().Get(ctx, "testrg", "Space1", "Application1", "Resource1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationResource = armintegrationspaces.ApplicationResource{
	// 	Name: to.Ptr("Resource1"),
	// 	Type: to.Ptr("Microsoft.IntegrationSpaces/spaces/applications/resources"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.IntegrationSpaces/spaces/Space1/applications/Application1/resources/Resource1"),
	// 	Properties: &armintegrationspaces.ApplicationResourceProperties{
	// 		ProvisioningState: to.Ptr(armintegrationspaces.ProvisioningStateSucceeded),
	// 		ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Web/sites/LogicApp1"),
	// 		ResourceKind: to.Ptr("LogicApp"),
	// 		ResourceType: to.Ptr("Microsoft.Web/sites"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/azureintegrationspaces/resource-manager/Microsoft.IntegrationSpaces/preview/2023-11-14-preview/examples/ApplicationResources_CreateOrUpdate.json
func ExampleApplicationResourcesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armintegrationspaces.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationResourcesClient().CreateOrUpdate(ctx, "testrg", "Space1", "Application1", "Resource1", armintegrationspaces.ApplicationResource{
		Properties: &armintegrationspaces.ApplicationResourceProperties{
			ResourceID:   to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Web/sites/LogicApp1"),
			ResourceKind: to.Ptr("LogicApp"),
			ResourceType: to.Ptr("Microsoft.Web/sites"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationResource = armintegrationspaces.ApplicationResource{
	// 	Name: to.Ptr("Resource1"),
	// 	Type: to.Ptr("Microsoft.IntegrationSpaces/spaces/applications/resources"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.IntegrationSpaces/spaces/Space1/applications/Application1/resources/Resource1"),
	// 	Properties: &armintegrationspaces.ApplicationResourceProperties{
	// 		ProvisioningState: to.Ptr(armintegrationspaces.ProvisioningStateSucceeded),
	// 		ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Web/sites/LogicApp1"),
	// 		ResourceKind: to.Ptr("LogicApp"),
	// 		ResourceType: to.Ptr("Microsoft.Web/sites"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/azureintegrationspaces/resource-manager/Microsoft.IntegrationSpaces/preview/2023-11-14-preview/examples/ApplicationResources_Patch.json
func ExampleApplicationResourcesClient_Patch() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armintegrationspaces.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationResourcesClient().Patch(ctx, "testrg", "Space1", "Application1", "Resource1", armintegrationspaces.ApplicationResourceUpdate{
		Properties: &armintegrationspaces.ApplicationResourceUpdateProperties{
			ResourceID:   to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Web/sites/LogicApp1"),
			ResourceKind: to.Ptr("LogicApp"),
			ResourceType: to.Ptr("Microsoft.Web/sites"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationResource = armintegrationspaces.ApplicationResource{
	// 	Name: to.Ptr("Resource1"),
	// 	Type: to.Ptr("Microsoft.IntegrationSpaces/spaces/applications/resources"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.IntegrationSpaces/spaces/Space1/applications/Application1/resources/Resource1"),
	// 	Properties: &armintegrationspaces.ApplicationResourceProperties{
	// 		ProvisioningState: to.Ptr(armintegrationspaces.ProvisioningStateSucceeded),
	// 		ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Web/sites/LogicApp1"),
	// 		ResourceKind: to.Ptr("LogicApp"),
	// 		ResourceType: to.Ptr("Microsoft.Web/sites"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/azureintegrationspaces/resource-manager/Microsoft.IntegrationSpaces/preview/2023-11-14-preview/examples/ApplicationResources_Delete.json
func ExampleApplicationResourcesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armintegrationspaces.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewApplicationResourcesClient().Delete(ctx, "testrg", "Space1", "Application1", "Resource1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
