//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhealthbot

import "time"

// AvailableOperations - Available operations of the service
type AvailableOperations struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of available operation details
	Value []*OperationDetail
}

// BotResponseList - The list of Azure Health Bot operation response.
type BotResponseList struct {
	// READ-ONLY; The link used to get the next page of bot service resources.
	NextLink *string

	// READ-ONLY; Gets the list of Azure Health Bot results and their properties.
	Value []*HealthBot
}

// Error - The resource management error response.
type Error struct {
	// The error object.
	Error *ErrorError
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorError - The error object.
type ErrorError struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*Error

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// HealthBot - Azure Health Bot resource definition
type HealthBot struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; SKU of the Azure Health Bot.
	SKU *SKU

	// The identity of the Azure Health Bot.
	Identity *Identity

	// The set of properties specific to Azure Health Bot resource.
	Properties *Properties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// Identity for the resource.
type Identity struct {
	// The identity type. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
	// assigned identities. The type 'None' will remove any identities from the Azure
	// Health Bot
	Type *ResourceIdentityType

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The principal ID of resource identity. This property will only be provided for a system assigned identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource. This property will only be provided for a system assigned identity.
	TenantID *string
}

// OperationDetail - Operation detail payload
type OperationDetail struct {
	// Display of the operation
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Name of the operation
	Name *string

	// Origin of the operation
	Origin *string

	// Additional properties.
	Properties any
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// Localized friendly description for the operation
	Description *string

	// Localized friendly name for the operation
	Operation *string

	// Resource provider of the operation
	Provider *string

	// Resource of the operation
	Resource *string
}

// Properties - The properties of a Azure Health Bot. The Health Bot Service is a cloud platform that empowers developers
// in Healthcare organizations to build and deploy their compliant, AI-powered virtual health
// assistants and health bots, that help them improve processes and reduce costs.
type Properties struct {
	// READ-ONLY; The link.
	BotManagementPortalLink *string

	// READ-ONLY; The provisioning state of the Azure Health Bot resource.
	ProvisioningState *string
}

// Resource - The resource model definition for a ARM tracked top level resource
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the Azure Health Bot SKU
	Name *SKUName
}

// SystemData - Read only system data
type SystemData struct {
	// The timestamp of resource creation (UTC)
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource
	CreatedByType *IdentityType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource
	LastModifiedByType *IdentityType
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// UpdateParameters - Parameters for updating a Azure Health Bot.
type UpdateParameters struct {
	// The identity of the Azure Health Bot.
	Identity *Identity
	Location *string

	// SKU of the Azure Health Bot.
	SKU *SKU

	// Tags for a Azure Health Bot.
	Tags map[string]*string
}

// UserAssignedIdentity - The details of the user assigned managed identity used by the Video Analyzer resource.
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of user assigned identity.
	PrincipalID *string
}

// ValidationResult - The response returned from validation process
type ValidationResult struct {
	// The status code of the response validation.
	Status *string
}
