//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armhdinsightcontainers.ClientFactory type.
type ServerFactory struct {
	AvailableClusterPoolVersionsServer AvailableClusterPoolVersionsServer
	AvailableClusterVersionsServer     AvailableClusterVersionsServer
	ClusterAvailableUpgradesServer     ClusterAvailableUpgradesServer
	ClusterJobsServer                  ClusterJobsServer
	ClusterPoolAvailableUpgradesServer ClusterPoolAvailableUpgradesServer
	ClusterPoolsServer                 ClusterPoolsServer
	ClustersServer                     ClustersServer
	LocationsServer                    LocationsServer
	OperationsServer                   OperationsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armhdinsightcontainers.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armhdinsightcontainers.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                  *ServerFactory
	trMu                                 sync.Mutex
	trAvailableClusterPoolVersionsServer *AvailableClusterPoolVersionsServerTransport
	trAvailableClusterVersionsServer     *AvailableClusterVersionsServerTransport
	trClusterAvailableUpgradesServer     *ClusterAvailableUpgradesServerTransport
	trClusterJobsServer                  *ClusterJobsServerTransport
	trClusterPoolAvailableUpgradesServer *ClusterPoolAvailableUpgradesServerTransport
	trClusterPoolsServer                 *ClusterPoolsServerTransport
	trClustersServer                     *ClustersServerTransport
	trLocationsServer                    *LocationsServerTransport
	trOperationsServer                   *OperationsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AvailableClusterPoolVersionsClient":
		initServer(s, &s.trAvailableClusterPoolVersionsServer, func() *AvailableClusterPoolVersionsServerTransport {
			return NewAvailableClusterPoolVersionsServerTransport(&s.srv.AvailableClusterPoolVersionsServer)
		})
		resp, err = s.trAvailableClusterPoolVersionsServer.Do(req)
	case "AvailableClusterVersionsClient":
		initServer(s, &s.trAvailableClusterVersionsServer, func() *AvailableClusterVersionsServerTransport {
			return NewAvailableClusterVersionsServerTransport(&s.srv.AvailableClusterVersionsServer)
		})
		resp, err = s.trAvailableClusterVersionsServer.Do(req)
	case "ClusterAvailableUpgradesClient":
		initServer(s, &s.trClusterAvailableUpgradesServer, func() *ClusterAvailableUpgradesServerTransport {
			return NewClusterAvailableUpgradesServerTransport(&s.srv.ClusterAvailableUpgradesServer)
		})
		resp, err = s.trClusterAvailableUpgradesServer.Do(req)
	case "ClusterJobsClient":
		initServer(s, &s.trClusterJobsServer, func() *ClusterJobsServerTransport { return NewClusterJobsServerTransport(&s.srv.ClusterJobsServer) })
		resp, err = s.trClusterJobsServer.Do(req)
	case "ClusterPoolAvailableUpgradesClient":
		initServer(s, &s.trClusterPoolAvailableUpgradesServer, func() *ClusterPoolAvailableUpgradesServerTransport {
			return NewClusterPoolAvailableUpgradesServerTransport(&s.srv.ClusterPoolAvailableUpgradesServer)
		})
		resp, err = s.trClusterPoolAvailableUpgradesServer.Do(req)
	case "ClusterPoolsClient":
		initServer(s, &s.trClusterPoolsServer, func() *ClusterPoolsServerTransport { return NewClusterPoolsServerTransport(&s.srv.ClusterPoolsServer) })
		resp, err = s.trClusterPoolsServer.Do(req)
	case "ClustersClient":
		initServer(s, &s.trClustersServer, func() *ClustersServerTransport { return NewClustersServerTransport(&s.srv.ClustersServer) })
		resp, err = s.trClustersServer.Do(req)
	case "LocationsClient":
		initServer(s, &s.trLocationsServer, func() *LocationsServerTransport { return NewLocationsServerTransport(&s.srv.LocationsServer) })
		resp, err = s.trLocationsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
