//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhardwaresecuritymodules

import "time"

// APIEntityReference - The API entity reference.
type APIEntityReference struct {
	// The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/…
	ID *string
}

// BackupProperties - Cloud Hsm Cluster backup information
type BackupProperties struct {
	// Azure storage Resource Uri
	AzureStorageResourceURI *string

	// READ-ONLY; Last Date Time that Customer Enabled Backup was taken
	LastBackupDateTime *time.Time

	// READ-ONLY; Status of last backup
	LastBackupStatus *string
}

// CHsmError - Error details
type CHsmError struct {
	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error message.
	Message *string
}

// CloudHsmCluster - Resource information with extended details.
type CloudHsmCluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// Properties of the Cloud HSM Cluster
	Properties *CloudHsmClusterProperties

	// SKU details
	SKU *CloudHsmClusterSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CloudHsmClusterError - The Cloud HSM Cluster error details
type CloudHsmClusterError struct {
	// Error details
	Error *CHsmError
}

// CloudHsmClusterListResult - List of Cloud HSM Clusters
type CloudHsmClusterListResult struct {
	// The URL to get the next set of Cloud HSM Clusters.
	NextLink *string

	// The list of Cloud HSM Clusters.
	Value []*CloudHsmCluster
}

// CloudHsmClusterPatchParameters - Patchable properties of the Cloud HSM Cluster
type CloudHsmClusterPatchParameters struct {
	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// Properties of the Cloud HSM Cluster
	Properties *CloudHsmClusterPatchParametersProperties

	// SKU details
	SKU *CloudHsmClusterSKU

	// The Cloud HSM Cluster's tags
	Tags map[string]*string
}

// CloudHsmClusterPatchParametersProperties - Properties of the Cloud HSM Cluster
type CloudHsmClusterPatchParametersProperties struct {
	// Cloud Hsm Cluster backup information
	BackupProperties *BackupProperties
}

// CloudHsmClusterProperties - Properties of a Cloud HSM Cluster.
type CloudHsmClusterProperties struct {
	// The Cloud HSM Cluster's auto-generated Domain Name Label Scope
	AutoGeneratedDomainNameLabelScope *string

	// Cloud Hsm Cluster backup information
	BackupProperties *BackupProperties

	// An array of Cloud HSM Cluster's HSMs
	Hsms []*CloudHsmProperties

	// List of private endpoint connection resources
	PrivateEndpointConnections []*PrivateEndpointConnection

	// The Cloud HSM Cluster's provisioningState
	ProvisioningState *ProvisioningState

	// The Cloud HSM Cluster public network access
	PublicNetworkAccess *string

	// Cloud Hsm Cluster restore information
	RestoreProperties *RestoreProperties

	// Security domain properties information for Cloud HSM cluster
	SecurityDomain *CloudHsmClusterSecurityDomainProperties

	// READ-ONLY; Cloud HSM Cluster status message
	StatusMessage *string
}

// CloudHsmClusterResource - Cloud HSM Cluster Resource
type CloudHsmClusterResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// SKU details
	SKU *CloudHsmClusterSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CloudHsmClusterSKU - Cloud Hsm Cluster SKU information
type CloudHsmClusterSKU struct {
	// REQUIRED; Sku family of the Cloud HSM Cluster
	Family *CloudHsmClusterSKUFamily

	// REQUIRED; Sku name of the Cloud HSM Cluster
	Name *CloudHsmClusterSKUName

	// Sku capacity
	Capacity *int32
}

// CloudHsmClusterSecurityDomainProperties - Security domain properties information for Cloud HSM cluster
type CloudHsmClusterSecurityDomainProperties struct {
	// status of security domain activation
	ActivationStatus *string

	// FIPS state information for security domain
	FipsState *int32
}

// CloudHsmProperties - The Cloud HSM Properties
type CloudHsmProperties struct {
	// FQDN of the Cloud HSM
	Fqdn *string

	// The Cloud HSM State
	State *string

	// The Cloud HSM State message
	StateMessage *string
}

// DedicatedHsm - Resource information with extended details.
type DedicatedHsm struct {
	// REQUIRED; The supported Azure location where the dedicated HSM should be created.
	Location *string

	// REQUIRED; Properties of the dedicated HSM
	Properties *DedicatedHsmProperties

	// SKU details
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// The Dedicated Hsm zones.
	Zones []*string

	// READ-ONLY; The Azure Resource Manager resource ID for the dedicated HSM.
	ID *string

	// READ-ONLY; The name of the dedicated HSM.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *DedicatedHsmSystemData

	// READ-ONLY; The resource type of the dedicated HSM.
	Type *string
}

// DedicatedHsmError - The error exception.
type DedicatedHsmError struct {
	// READ-ONLY; The error detail of the operation if any.
	Error *Error
}

// DedicatedHsmListResult - List of dedicated HSMs
type DedicatedHsmListResult struct {
	// The URL to get the next set of dedicated hsms.
	NextLink *string

	// The list of dedicated HSMs.
	Value []*DedicatedHsm
}

// DedicatedHsmOperation - REST API operation
type DedicatedHsmOperation struct {
	// The display string.
	Display *DedicatedHsmOperationDisplay

	// The name of the Dedicated HSM Resource Provider Operation.
	Name *string

	// The origin of the operation
	Origin *string

	// READ-ONLY; Gets or sets a value indicating whether it is a data plane action
	IsDataAction *bool
}

// DedicatedHsmOperationDisplay - The display string.
type DedicatedHsmOperationDisplay struct {
	// The object that represents the operation.
	Description *string

	// Operation type: Read, write, delete, etc.
	Operation *string

	// The Resource Provider of the operation
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// DedicatedHsmOperationListResult - Result of the request to list Dedicated HSM Provider operations. It contains a list of
// operations.
type DedicatedHsmOperationListResult struct {
	// List of Dedicated HSM Resource Provider operations.
	Value []*DedicatedHsmOperation
}

// DedicatedHsmPatchParameters - Patchable properties of the dedicated HSM
type DedicatedHsmPatchParameters struct {
	// Resource tags
	Tags map[string]*string
}

// DedicatedHsmProperties - Properties of the dedicated hsm
type DedicatedHsmProperties struct {
	// Specifies the management network interfaces of the dedicated hsm.
	ManagementNetworkProfile *NetworkProfile

	// Specifies the network interfaces of the dedicated hsm.
	NetworkProfile *NetworkProfile

	// This field will be used when RP does not support Availability zones.
	StampID *string

	// READ-ONLY; Provisioning state.
	ProvisioningState *JSONWebKeyType

	// READ-ONLY; Resource Status Message.
	StatusMessage *string
}

// DedicatedHsmResource - Dedicated HSM resource
type DedicatedHsmResource struct {
	// REQUIRED; The supported Azure location where the dedicated HSM should be created.
	Location *string

	// SKU details
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// The Dedicated Hsm zones.
	Zones []*string

	// READ-ONLY; The Azure Resource Manager resource ID for the dedicated HSM.
	ID *string

	// READ-ONLY; The name of the dedicated HSM.
	Name *string

	// READ-ONLY; The resource type of the dedicated HSM.
	Type *string
}

// DedicatedHsmSystemData - Metadata pertaining to creation and last modification of dedicated hsm resource.
type DedicatedHsmSystemData struct {
	// The timestamp of dedicated hsm resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created dedicated hsm resource.
	CreatedBy *string

	// The type of identity that created dedicated hsm resource.
	CreatedByType *IdentityType

	// The timestamp of dedicated hsm resource last modification (UTC).
	LastModifiedAt *time.Time

	// The identity that last modified dedicated hsm resource.
	LastModifiedBy *string

	// The type of identity that last modified dedicated hsm resource.
	LastModifiedByType *IdentityType
}

// EndpointDependency - A domain name that dedicated hsm services are reaching at.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string

	// The Ports and Protocols used when connecting to domainName.
	EndpointDetails []*EndpointDetail
}

// EndpointDetail - Connect information from the dedicated hsm service to a single endpoint.
type EndpointDetail struct {
	// Description of the detail
	Description *string

	// An IP Address that Domain Name currently resolves to.
	IPAddress *string

	// The port an endpoint is connected to.
	Port *int32

	// The protocol used for connection
	Protocol *string
}

// Error - The key vault server error.
type Error struct {
	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; Contains more specific error that narrows down the cause. May be null.
	InnerError *Error

	// READ-ONLY; The error message.
	Message *string
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// NetworkInterface - The network interface definition.
type NetworkInterface struct {
	// Private Ip address of the interface
	PrivateIPAddress *string

	// READ-ONLY; The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/…
	ID *string
}

// NetworkProfile - The network profile definition.
type NetworkProfile struct {
	// Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
	NetworkInterfaces []*NetworkInterface

	// Specifies the identifier of the subnet.
	Subnet *APIEntityReference
}

// OutboundEnvironmentEndpoint - Egress endpoints which dedicated hsm service connects to for common purpose.
type OutboundEnvironmentEndpoint struct {
	// The category of endpoints accessed by the dedicated hsm service, e.g. azure-resource-management, apiserver, etc.
	Category *string

	// The endpoints that dedicated hsm service connects to
	Endpoints []*EndpointDependency
}

// OutboundEnvironmentEndpointCollection - Collection of OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// PrivateEndpoint - The private endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for private endpoint.
	ID *string
}

// PrivateEndpointConnection - The private endpoint connection resource.
type PrivateEndpointConnection struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string

	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connections associated with the specified resource.
type PrivateEndpointConnectionListResult struct {
	// The URL to get the next set of private endpoint connections.
	NextLink *string

	// Array of private endpoint connections.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The private endpoint resource.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The group ids for the private endpoint resource.
	GroupIDs []*string

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource.
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources.
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceListResult - List of dedicated HSM resources.
type ResourceListResult struct {
	// The URL to get the next set of dedicated HSM resources.
	NextLink *string

	// The list of dedicated HSM resources.
	Value []*DedicatedHsmResource
}

// RestoreProperties - Cloud Hsm Cluster restore information
type RestoreProperties struct {
	// Azure Blob storage container Uri
	AzureStorageResourceURI *string

	// Directory name in Azure Storage Blob where the backup is stored
	Foldername *string
}

// SKU of the dedicated HSM
type SKU struct {
	// SKU of the dedicated HSM
	Name *SKUName
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}
