//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armhardwaresecuritymodules.ClientFactory type.
type ServerFactory struct {
	CloudHsmClusterPrivateEndpointConnectionsServer CloudHsmClusterPrivateEndpointConnectionsServer
	CloudHsmClusterPrivateLinkResourcesServer       CloudHsmClusterPrivateLinkResourcesServer
	CloudHsmClustersServer                          CloudHsmClustersServer
	DedicatedHsmServer                              DedicatedHsmServer
	OperationsServer                                OperationsServer
	PrivateEndpointConnectionsServer                PrivateEndpointConnectionsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armhardwaresecuritymodules.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armhardwaresecuritymodules.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                               *ServerFactory
	trMu                                              sync.Mutex
	trCloudHsmClusterPrivateEndpointConnectionsServer *CloudHsmClusterPrivateEndpointConnectionsServerTransport
	trCloudHsmClusterPrivateLinkResourcesServer       *CloudHsmClusterPrivateLinkResourcesServerTransport
	trCloudHsmClustersServer                          *CloudHsmClustersServerTransport
	trDedicatedHsmServer                              *DedicatedHsmServerTransport
	trOperationsServer                                *OperationsServerTransport
	trPrivateEndpointConnectionsServer                *PrivateEndpointConnectionsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "CloudHsmClusterPrivateEndpointConnectionsClient":
		initServer(s, &s.trCloudHsmClusterPrivateEndpointConnectionsServer, func() *CloudHsmClusterPrivateEndpointConnectionsServerTransport {
			return NewCloudHsmClusterPrivateEndpointConnectionsServerTransport(&s.srv.CloudHsmClusterPrivateEndpointConnectionsServer)
		})
		resp, err = s.trCloudHsmClusterPrivateEndpointConnectionsServer.Do(req)
	case "CloudHsmClusterPrivateLinkResourcesClient":
		initServer(s, &s.trCloudHsmClusterPrivateLinkResourcesServer, func() *CloudHsmClusterPrivateLinkResourcesServerTransport {
			return NewCloudHsmClusterPrivateLinkResourcesServerTransport(&s.srv.CloudHsmClusterPrivateLinkResourcesServer)
		})
		resp, err = s.trCloudHsmClusterPrivateLinkResourcesServer.Do(req)
	case "CloudHsmClustersClient":
		initServer(s, &s.trCloudHsmClustersServer, func() *CloudHsmClustersServerTransport {
			return NewCloudHsmClustersServerTransport(&s.srv.CloudHsmClustersServer)
		})
		resp, err = s.trCloudHsmClustersServer.Do(req)
	case "DedicatedHsmClient":
		initServer(s, &s.trDedicatedHsmServer, func() *DedicatedHsmServerTransport { return NewDedicatedHsmServerTransport(&s.srv.DedicatedHsmServer) })
		resp, err = s.trDedicatedHsmServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
