//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armguestconfiguration

import "time"

// Assignment - Guest configuration assignment is an association between a machine and guest configuration.
type Assignment struct {
	// Region where the VM is located.
	Location *string

	// Name of the guest configuration assignment.
	Name *string

	// Properties of the Guest configuration assignment.
	Properties *AssignmentProperties

	// READ-ONLY; ARM resource id of the guest configuration assignment.
	ID *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// AssignmentInfo - Information about the guest configuration assignment.
type AssignmentInfo struct {
	// Information about the configuration.
	Configuration *ConfigurationInfo

	// READ-ONLY; Name of the guest configuration assignment.
	Name *string
}

// AssignmentList - The response of the list guest configuration assignment operation.
type AssignmentList struct {
	// Result of the list guest configuration assignment operation.
	Value []*Assignment
}

// AssignmentProperties - Guest configuration assignment properties.
type AssignmentProperties struct {
	// The source which initiated the guest configuration assignment. Ex: Azure Policy
	Context *string

	// The guest configuration to assign.
	GuestConfiguration *Navigation

	// Last reported guest configuration assignment report.
	LatestAssignmentReport *CommonAssignmentReport

	// The list of VM Compliance data for VMSS
	VmssVMList []*VMSSVMInfo

	// READ-ONLY; Combined hash of the configuration package and parameters.
	AssignmentHash *string

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus

	// READ-ONLY; Date and time when last compliance status was checked.
	LastComplianceStatusChecked *time.Time

	// READ-ONLY; Id of the latest report for the guest configuration assignment.
	LatestReportID *string

	// READ-ONLY; parameter hash for the guest configuration assignment.
	ParameterHash *string

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Type of the resource - VMSS / VM
	ResourceType *string

	// READ-ONLY; VM resource Id.
	TargetResourceID *string
}

// AssignmentReport - Report for the guest configuration assignment. Report contains information such as compliance status,
// reason, and more.
type AssignmentReport struct {
	// Properties of the guest configuration report.
	Properties *AssignmentReportProperties

	// READ-ONLY; ARM resource id of the report for the guest configuration assignment.
	ID *string

	// READ-ONLY; GUID that identifies the guest configuration assignment report under a subscription, resource group.
	Name *string
}

// AssignmentReportDetails - Details of the guest configuration assignment report.
type AssignmentReportDetails struct {
	// The list of resources for which guest configuration assignment compliance is checked.
	Resources []*AssignmentReportResource

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus

	// READ-ONLY; End date and time of the guest configuration assignment compliance status check.
	EndTime *time.Time

	// READ-ONLY; GUID of the report.
	JobID *string

	// READ-ONLY; Type of report, Consistency or Initial
	OperationType *Type

	// READ-ONLY; Start date and time of the guest configuration assignment compliance status check.
	StartTime *time.Time
}

// AssignmentReportList - List of guest configuration assignment reports.
type AssignmentReportList struct {
	// List of reports for the guest configuration. Report contains information such as compliance status, reason and more.
	Value []*AssignmentReport
}

// AssignmentReportProperties - Report for the guest configuration assignment. Report contains information such as compliance
// status, reason, and more.
type AssignmentReportProperties struct {
	// Configuration details of the guest configuration assignment.
	Assignment *AssignmentInfo

	// Details of the assignment report.
	Details *AssignmentReportDetails

	// Information about the VM.
	VM *VMInfo

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus

	// READ-ONLY; End date and time of the guest configuration assignment compliance status check.
	EndTime *time.Time

	// READ-ONLY; GUID that identifies the guest configuration assignment report under a subscription, resource group.
	ReportID *string

	// READ-ONLY; Start date and time of the guest configuration assignment compliance status check.
	StartTime *time.Time

	// READ-ONLY; Azure resource Id of the VMSS.
	VmssResourceID *string
}

// AssignmentReportResource - The guest configuration assignment resource.
type AssignmentReportResource struct {
	// Compliance reason and reason code for a resource.
	Reasons []*AssignmentReportResourceComplianceReason

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus

	// READ-ONLY; Properties of a guest configuration assignment resource.
	Properties any

	// READ-ONLY; Name of the guest configuration assignment resource setting.
	ResourceID *string
}

// AssignmentReportResourceComplianceReason - Reason and code for the compliance of the guest configuration assignment resource.
type AssignmentReportResourceComplianceReason struct {
	// READ-ONLY; Code for the compliance of the guest configuration assignment resource.
	Code *string

	// READ-ONLY; Reason for the compliance of the guest configuration assignment resource.
	Phrase *string
}

type CommonAssignmentReport struct {
	// Configuration details of the guest configuration assignment.
	Assignment *AssignmentInfo

	// The list of resources for which guest configuration assignment compliance is checked.
	Resources []*AssignmentReportResource

	// Information about the VM.
	VM *VMInfo

	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus

	// READ-ONLY; End date and time of the guest configuration assignment compliance status check.
	EndTime *time.Time

	// READ-ONLY; ARM resource id of the report for the guest configuration assignment.
	ID *string

	// READ-ONLY; Type of report, Consistency or Initial
	OperationType *Type

	// READ-ONLY; GUID that identifies the guest configuration assignment report under a subscription, resource group.
	ReportID *string

	// READ-ONLY; Start date and time of the guest configuration assignment compliance status check.
	StartTime *time.Time
}

// ConfigurationInfo - Information about the configuration.
type ConfigurationInfo struct {
	// READ-ONLY; Name of the configuration.
	Name *string

	// READ-ONLY; Version of the configuration.
	Version *string
}

// ConfigurationParameter - Represents a configuration parameter.
type ConfigurationParameter struct {
	// Name of the configuration parameter.
	Name *string

	// Value of the configuration parameter.
	Value *string
}

// ConfigurationSetting - Configuration setting of LCM (Local Configuration Manager).
type ConfigurationSetting struct {
	// READ-ONLY; Specifies what happens after a reboot during the application of a configuration. The possible values are ContinueConfiguration
	// and StopConfiguration
	ActionAfterReboot *ActionAfterReboot

	// READ-ONLY; If true - new configurations downloaded from the pull service are allowed to overwrite the old ones on the target
	// node. Otherwise, false
	AllowModuleOverwrite *bool

	// READ-ONLY; Specifies how the LCM(Local Configuration Manager) actually applies the configuration to the target nodes. Possible
	// values are ApplyOnly, ApplyAndMonitor, and ApplyAndAutoCorrect.
	ConfigurationMode *ConfigurationMode

	// READ-ONLY; How often, in minutes, the current configuration is checked and applied. This property is ignored if the ConfigurationMode
	// property is set to ApplyOnly. The default value is 15.
	ConfigurationModeFrequencyMins *float32

	// READ-ONLY; Set this to true to automatically reboot the node after a configuration that requires reboot is applied. Otherwise,
	// you will have to manually reboot the node for any configuration that requires it.
	// The default value is false. To use this setting when a reboot condition is enacted by something other than DSC (such as
	// Windows Installer), combine this setting with the xPendingReboot module.
	RebootIfNeeded *bool

	// READ-ONLY; The time interval, in minutes, at which the LCM checks a pull service to get updated configurations. This value
	// is ignored if the LCM is not configured in pull mode. The default value is 30.
	RefreshFrequencyMins *float32
}

// ErrorResponse - Error response of an operation failure
type ErrorResponse struct {
	Error *ErrorResponseError
}

type ErrorResponseError struct {
	// Error code.
	Code *string

	// Detail error message indicating why the operation failed.
	Message *string
}

// Navigation - Guest configuration is an artifact that encapsulates DSC configuration and its dependencies. The artifact
// is a zip file containing DSC configuration (as MOF) and dependent resources and other
// dependencies like modules.
type Navigation struct {
	// Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect
	// and ApplyAndMonitor.
	AssignmentType *AssignmentType

	// The configuration parameters for the guest configuration.
	ConfigurationParameter []*ConfigurationParameter

	// The protected configuration parameters for the guest configuration.
	ConfigurationProtectedParameter []*ConfigurationParameter

	// Combined hash of the guest configuration package and configuration parameters.
	ContentHash *string

	// Uri of the storage where guest configuration package is uploaded.
	ContentURI *string

	// Kind of the guest configuration. For example:DSC
	Kind *Kind

	// Name of the guest configuration.
	Name *string

	// Version of the guest configuration.
	Version *string

	// READ-ONLY; Specifies the origin of the configuration.
	AssignmentSource *string

	// READ-ONLY; The configuration setting for the guest configuration.
	ConfigurationSetting *ConfigurationSetting

	// READ-ONLY; Specifies the content type of the configuration. Possible values could be Builtin or Custom.
	ContentType *string
}

// Operation - GuestConfiguration REST API operation
type Operation struct {
	// Provider, Resource, Operation and description values.
	Display *OperationDisplay

	// Operation name: For ex. providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/write or read
	Name *string

	// Provider, Resource, Operation and description values.
	Properties *OperationProperties
}

// OperationDisplay - Provider, Resource, Operation and description values.
type OperationDisplay struct {
	// Description about operation.
	Description *string

	// Operation type: Read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.GuestConfiguration
	Provider *string

	// Resource on which the operation is performed: For ex.
	Resource *string
}

// OperationList - The response model for the list of Automation operations
type OperationList struct {
	// List of Automation operations supported by the Automation resource provider.
	Value []*Operation
}

// OperationProperties - Provider, Resource, Operation and description values.
type OperationProperties struct {
	// Service provider: Microsoft.GuestConfiguration
	StatusCode *string
}

// ProxyResource - ARM proxy resource.
type ProxyResource struct {
	// Region where the VM is located.
	Location *string

	// Name of the guest configuration assignment.
	Name *string

	// READ-ONLY; ARM resource id of the guest configuration assignment.
	ID *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// Resource - The core properties of ARM resources
type Resource struct {
	// Region where the VM is located.
	Location *string

	// Name of the guest configuration assignment.
	Name *string

	// READ-ONLY; ARM resource id of the guest configuration assignment.
	ID *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// VMInfo - Information about the VM.
type VMInfo struct {
	// READ-ONLY; Azure resource Id of the VM.
	ID *string

	// READ-ONLY; UUID(Universally Unique Identifier) of the VM.
	UUID *string
}

// VMSSVMInfo - Information about VMSS VM
type VMSSVMInfo struct {
	// READ-ONLY; A value indicating compliance status of the machine for the assigned guest configuration.
	ComplianceStatus *ComplianceStatus

	// READ-ONLY; Date and time when last compliance status was checked.
	LastComplianceChecked *time.Time

	// READ-ONLY; Id of the latest report for the guest configuration assignment.
	LatestReportID *string

	// READ-ONLY; UUID of the VM.
	VMID *string

	// READ-ONLY; Azure resource Id of the VM.
	VMResourceID *string
}
