//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armfrontdoor

import "encoding/json"

func unmarshalRouteConfigurationClassification(rawMsg json.RawMessage) (RouteConfigurationClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RouteConfigurationClassification
	switch m["@odata.type"] {
	case "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration":
		b = &ForwardingConfiguration{}
	case "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration":
		b = &RedirectConfiguration{}
	default:
		b = &RouteConfiguration{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
