//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/frontdoor/armfrontdoor"
	"net/http"
)

// NameAvailabilityServer is a fake server for instances of the armfrontdoor.NameAvailabilityClient type.
type NameAvailabilityServer struct {
	// Check is the fake for method NameAvailabilityClient.Check
	// HTTP status codes to indicate success: http.StatusOK
	Check func(ctx context.Context, checkFrontDoorNameAvailabilityInput armfrontdoor.CheckNameAvailabilityInput, options *armfrontdoor.NameAvailabilityClientCheckOptions) (resp azfake.Responder[armfrontdoor.NameAvailabilityClientCheckResponse], errResp azfake.ErrorResponder)
}

// NewNameAvailabilityServerTransport creates a new instance of NameAvailabilityServerTransport with the provided implementation.
// The returned NameAvailabilityServerTransport instance is connected to an instance of armfrontdoor.NameAvailabilityClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNameAvailabilityServerTransport(srv *NameAvailabilityServer) *NameAvailabilityServerTransport {
	return &NameAvailabilityServerTransport{srv: srv}
}

// NameAvailabilityServerTransport connects instances of armfrontdoor.NameAvailabilityClient to instances of NameAvailabilityServer.
// Don't use this type directly, use NewNameAvailabilityServerTransport instead.
type NameAvailabilityServerTransport struct {
	srv *NameAvailabilityServer
}

// Do implements the policy.Transporter interface for NameAvailabilityServerTransport.
func (n *NameAvailabilityServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NameAvailabilityClient.Check":
		resp, err = n.dispatchCheck(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NameAvailabilityServerTransport) dispatchCheck(req *http.Request) (*http.Response, error) {
	if n.srv.Check == nil {
		return nil, &nonRetriableError{errors.New("fake for method Check not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[armfrontdoor.CheckNameAvailabilityInput](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Check(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityOutput, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
