//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ChannelsServer is a fake server for instances of the armeventgrid.ChannelsClient type.
type ChannelsServer struct {
	// CreateOrUpdate is the fake for method ChannelsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string, channelInfo armeventgrid.Channel, options *armeventgrid.ChannelsClientCreateOrUpdateOptions) (resp azfake.Responder[armeventgrid.ChannelsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ChannelsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string, options *armeventgrid.ChannelsClientBeginDeleteOptions) (resp azfake.PollerResponder[armeventgrid.ChannelsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ChannelsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string, options *armeventgrid.ChannelsClientGetOptions) (resp azfake.Responder[armeventgrid.ChannelsClientGetResponse], errResp azfake.ErrorResponder)

	// GetFullURL is the fake for method ChannelsClient.GetFullURL
	// HTTP status codes to indicate success: http.StatusOK
	GetFullURL func(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string, options *armeventgrid.ChannelsClientGetFullURLOptions) (resp azfake.Responder[armeventgrid.ChannelsClientGetFullURLResponse], errResp azfake.ErrorResponder)

	// NewListByPartnerNamespacePager is the fake for method ChannelsClient.NewListByPartnerNamespacePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPartnerNamespacePager func(resourceGroupName string, partnerNamespaceName string, options *armeventgrid.ChannelsClientListByPartnerNamespaceOptions) (resp azfake.PagerResponder[armeventgrid.ChannelsClientListByPartnerNamespaceResponse])

	// Update is the fake for method ChannelsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, partnerNamespaceName string, channelName string, channelUpdateParameters armeventgrid.ChannelUpdateParameters, options *armeventgrid.ChannelsClientUpdateOptions) (resp azfake.Responder[armeventgrid.ChannelsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewChannelsServerTransport creates a new instance of ChannelsServerTransport with the provided implementation.
// The returned ChannelsServerTransport instance is connected to an instance of armeventgrid.ChannelsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewChannelsServerTransport(srv *ChannelsServer) *ChannelsServerTransport {
	return &ChannelsServerTransport{
		srv:                            srv,
		beginDelete:                    newTracker[azfake.PollerResponder[armeventgrid.ChannelsClientDeleteResponse]](),
		newListByPartnerNamespacePager: newTracker[azfake.PagerResponder[armeventgrid.ChannelsClientListByPartnerNamespaceResponse]](),
	}
}

// ChannelsServerTransport connects instances of armeventgrid.ChannelsClient to instances of ChannelsServer.
// Don't use this type directly, use NewChannelsServerTransport instead.
type ChannelsServerTransport struct {
	srv                            *ChannelsServer
	beginDelete                    *tracker[azfake.PollerResponder[armeventgrid.ChannelsClientDeleteResponse]]
	newListByPartnerNamespacePager *tracker[azfake.PagerResponder[armeventgrid.ChannelsClientListByPartnerNamespaceResponse]]
}

// Do implements the policy.Transporter interface for ChannelsServerTransport.
func (c *ChannelsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ChannelsClient.CreateOrUpdate":
		resp, err = c.dispatchCreateOrUpdate(req)
	case "ChannelsClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "ChannelsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ChannelsClient.GetFullURL":
		resp, err = c.dispatchGetFullURL(req)
	case "ChannelsClient.NewListByPartnerNamespacePager":
		resp, err = c.dispatchNewListByPartnerNamespacePager(req)
	case "ChannelsClient.Update":
		resp, err = c.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ChannelsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerNamespaces/(?P<partnerNamespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/channels/(?P<channelName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armeventgrid.Channel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	partnerNamespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerNamespaceName")])
	if err != nil {
		return nil, err
	}
	channelNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("channelName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, partnerNamespaceNameParam, channelNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Channel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ChannelsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerNamespaces/(?P<partnerNamespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/channels/(?P<channelName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		partnerNamespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerNamespaceName")])
		if err != nil {
			return nil, err
		}
		channelNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("channelName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, partnerNamespaceNameParam, channelNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *ChannelsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerNamespaces/(?P<partnerNamespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/channels/(?P<channelName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	partnerNamespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerNamespaceName")])
	if err != nil {
		return nil, err
	}
	channelNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("channelName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, partnerNamespaceNameParam, channelNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Channel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ChannelsServerTransport) dispatchGetFullURL(req *http.Request) (*http.Response, error) {
	if c.srv.GetFullURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFullURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerNamespaces/(?P<partnerNamespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/channels/(?P<channelName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getFullUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	partnerNamespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerNamespaceName")])
	if err != nil {
		return nil, err
	}
	channelNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("channelName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetFullURL(req.Context(), resourceGroupNameParam, partnerNamespaceNameParam, channelNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSubscriptionFullURL, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ChannelsServerTransport) dispatchNewListByPartnerNamespacePager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByPartnerNamespacePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPartnerNamespacePager not implemented")}
	}
	newListByPartnerNamespacePager := c.newListByPartnerNamespacePager.get(req)
	if newListByPartnerNamespacePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerNamespaces/(?P<partnerNamespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/channels`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		partnerNamespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerNamespaceName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.ChannelsClientListByPartnerNamespaceOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.ChannelsClientListByPartnerNamespaceOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := c.srv.NewListByPartnerNamespacePager(resourceGroupNameParam, partnerNamespaceNameParam, options)
		newListByPartnerNamespacePager = &resp
		c.newListByPartnerNamespacePager.add(req, newListByPartnerNamespacePager)
		server.PagerResponderInjectNextLinks(newListByPartnerNamespacePager, req, func(page *armeventgrid.ChannelsClientListByPartnerNamespaceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPartnerNamespacePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByPartnerNamespacePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPartnerNamespacePager) {
		c.newListByPartnerNamespacePager.remove(req)
	}
	return resp, nil
}

func (c *ChannelsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerNamespaces/(?P<partnerNamespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/channels/(?P<channelName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armeventgrid.ChannelUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	partnerNamespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerNamespaceName")])
	if err != nil {
		return nil, err
	}
	channelNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("channelName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Update(req.Context(), resourceGroupNameParam, partnerNamespaceNameParam, channelNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
