//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ProjectCatalogsServer is a fake server for instances of the armdevcenter.ProjectCatalogsClient type.
type ProjectCatalogsServer struct {
	// BeginConnect is the fake for method ProjectCatalogsClient.BeginConnect
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginConnect func(ctx context.Context, resourceGroupName string, projectName string, catalogName string, options *armdevcenter.ProjectCatalogsClientBeginConnectOptions) (resp azfake.PollerResponder[armdevcenter.ProjectCatalogsClientConnectResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method ProjectCatalogsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, projectName string, catalogName string, body armdevcenter.Catalog, options *armdevcenter.ProjectCatalogsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdevcenter.ProjectCatalogsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ProjectCatalogsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, projectName string, catalogName string, options *armdevcenter.ProjectCatalogsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdevcenter.ProjectCatalogsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ProjectCatalogsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, projectName string, catalogName string, options *armdevcenter.ProjectCatalogsClientGetOptions) (resp azfake.Responder[armdevcenter.ProjectCatalogsClientGetResponse], errResp azfake.ErrorResponder)

	// GetSyncErrorDetails is the fake for method ProjectCatalogsClient.GetSyncErrorDetails
	// HTTP status codes to indicate success: http.StatusOK
	GetSyncErrorDetails func(ctx context.Context, resourceGroupName string, projectName string, catalogName string, options *armdevcenter.ProjectCatalogsClientGetSyncErrorDetailsOptions) (resp azfake.Responder[armdevcenter.ProjectCatalogsClientGetSyncErrorDetailsResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ProjectCatalogsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, projectName string, options *armdevcenter.ProjectCatalogsClientListOptions) (resp azfake.PagerResponder[armdevcenter.ProjectCatalogsClientListResponse])

	// BeginPatch is the fake for method ProjectCatalogsClient.BeginPatch
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPatch func(ctx context.Context, resourceGroupName string, projectName string, catalogName string, body armdevcenter.CatalogUpdate, options *armdevcenter.ProjectCatalogsClientBeginPatchOptions) (resp azfake.PollerResponder[armdevcenter.ProjectCatalogsClientPatchResponse], errResp azfake.ErrorResponder)

	// BeginSync is the fake for method ProjectCatalogsClient.BeginSync
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginSync func(ctx context.Context, resourceGroupName string, projectName string, catalogName string, options *armdevcenter.ProjectCatalogsClientBeginSyncOptions) (resp azfake.PollerResponder[armdevcenter.ProjectCatalogsClientSyncResponse], errResp azfake.ErrorResponder)
}

// NewProjectCatalogsServerTransport creates a new instance of ProjectCatalogsServerTransport with the provided implementation.
// The returned ProjectCatalogsServerTransport instance is connected to an instance of armdevcenter.ProjectCatalogsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProjectCatalogsServerTransport(srv *ProjectCatalogsServer) *ProjectCatalogsServerTransport {
	return &ProjectCatalogsServerTransport{
		srv:                 srv,
		beginConnect:        newTracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientConnectResponse]](),
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armdevcenter.ProjectCatalogsClientListResponse]](),
		beginPatch:          newTracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientPatchResponse]](),
		beginSync:           newTracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientSyncResponse]](),
	}
}

// ProjectCatalogsServerTransport connects instances of armdevcenter.ProjectCatalogsClient to instances of ProjectCatalogsServer.
// Don't use this type directly, use NewProjectCatalogsServerTransport instead.
type ProjectCatalogsServerTransport struct {
	srv                 *ProjectCatalogsServer
	beginConnect        *tracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientConnectResponse]]
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armdevcenter.ProjectCatalogsClientListResponse]]
	beginPatch          *tracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientPatchResponse]]
	beginSync           *tracker[azfake.PollerResponder[armdevcenter.ProjectCatalogsClientSyncResponse]]
}

// Do implements the policy.Transporter interface for ProjectCatalogsServerTransport.
func (p *ProjectCatalogsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProjectCatalogsClient.BeginConnect":
		resp, err = p.dispatchBeginConnect(req)
	case "ProjectCatalogsClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "ProjectCatalogsClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "ProjectCatalogsClient.Get":
		resp, err = p.dispatchGet(req)
	case "ProjectCatalogsClient.GetSyncErrorDetails":
		resp, err = p.dispatchGetSyncErrorDetails(req)
	case "ProjectCatalogsClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	case "ProjectCatalogsClient.BeginPatch":
		resp, err = p.dispatchBeginPatch(req)
	case "ProjectCatalogsClient.BeginSync":
		resp, err = p.dispatchBeginSync(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProjectCatalogsServerTransport) dispatchBeginConnect(req *http.Request) (*http.Response, error) {
	if p.srv.BeginConnect == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginConnect not implemented")}
	}
	beginConnect := p.beginConnect.get(req)
	if beginConnect == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connect`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginConnect(req.Context(), resourceGroupNameParam, projectNameParam, catalogNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginConnect = &respr
		p.beginConnect.add(req, beginConnect)
	}

	resp, err := server.PollerResponderNext(beginConnect, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		p.beginConnect.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginConnect) {
		p.beginConnect.remove(req)
	}

	return resp, nil
}

func (p *ProjectCatalogsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdevcenter.Catalog](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, projectNameParam, catalogNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *ProjectCatalogsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, projectNameParam, catalogNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *ProjectCatalogsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, projectNameParam, catalogNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Catalog, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProjectCatalogsServerTransport) dispatchGetSyncErrorDetails(req *http.Request) (*http.Response, error) {
	if p.srv.GetSyncErrorDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSyncErrorDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getSyncErrorDetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetSyncErrorDetails(req.Context(), resourceGroupNameParam, projectNameParam, catalogNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SyncErrorDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProjectCatalogsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdevcenter.ProjectCatalogsClientListOptions
		if topParam != nil {
			options = &armdevcenter.ProjectCatalogsClientListOptions{
				Top: topParam,
			}
		}
		resp := p.srv.NewListPager(resourceGroupNameParam, projectNameParam, options)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdevcenter.ProjectCatalogsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}

func (p *ProjectCatalogsServerTransport) dispatchBeginPatch(req *http.Request) (*http.Response, error) {
	if p.srv.BeginPatch == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPatch not implemented")}
	}
	beginPatch := p.beginPatch.get(req)
	if beginPatch == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdevcenter.CatalogUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginPatch(req.Context(), resourceGroupNameParam, projectNameParam, catalogNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPatch = &respr
		p.beginPatch.add(req, beginPatch)
	}

	resp, err := server.PollerResponderNext(beginPatch, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginPatch.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPatch) {
		p.beginPatch.remove(req)
	}

	return resp, nil
}

func (p *ProjectCatalogsServerTransport) dispatchBeginSync(req *http.Request) (*http.Response, error) {
	if p.srv.BeginSync == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSync not implemented")}
	}
	beginSync := p.beginSync.get(req)
	if beginSync == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sync`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginSync(req.Context(), resourceGroupNameParam, projectNameParam, catalogNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSync = &respr
		p.beginSync.add(req, beginSync)
	}

	resp, err := server.PollerResponderNext(beginSync, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		p.beginSync.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSync) {
		p.beginSync.remove(req)
	}

	return resp, nil
}
