//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdesktopvirtualization_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/desktopvirtualization/armdesktopvirtualization/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/3066a973f4baf2e2bf072a013b585a820bb10146/specification/desktopvirtualization/resource-manager/Microsoft.DesktopVirtualization/stable/2023-09-05/examples/OperationDescription_List.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdesktopvirtualization.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceProviderOperationList = armdesktopvirtualization.ResourceProviderOperationList{
		// 	Value: []*armdesktopvirtualization.ResourceProviderOperation{
		// 		{
		// 			Name: to.Ptr("Microsoft.DesktopVirtualization/hostpools/read"),
		// 			Display: &armdesktopvirtualization.ResourceProviderOperationDisplay{
		// 				Description: to.Ptr("Read hostpool"),
		// 				Operation: to.Ptr("Read hostpool"),
		// 				Provider: to.Ptr("Microsoft.DesktopVirtualization"),
		// 				Resource: to.Ptr("hostpools"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DesktopVirtualization/hostpools/write"),
		// 			Display: &armdesktopvirtualization.ResourceProviderOperationDisplay{
		// 				Description: to.Ptr("Write hostpool"),
		// 				Operation: to.Ptr("Write hostpool"),
		// 				Provider: to.Ptr("Microsoft.DesktopVirtualization"),
		// 				Resource: to.Ptr("hostpools"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Properties: &armdesktopvirtualization.OperationProperties{
		// 				ServiceSpecification: &armdesktopvirtualization.ServiceSpecification{
		// 					LogSpecifications: []*armdesktopvirtualization.LogSpecification{
		// 						{
		// 							Name: to.Ptr(""),
		// 							DisplayName: to.Ptr(""),
		// 						},
		// 						{
		// 							Name: to.Ptr(""),
		// 							DisplayName: to.Ptr(""),
		// 						},
		// 						{
		// 							Name: to.Ptr(""),
		// 							DisplayName: to.Ptr(""),
		// 					}},
		// 				},
		// 			},
		// 	}},
		// }
	}
}
