//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatabox

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
	"time"
)

// MarshalJSON implements the json.Marshaller interface for type APIError.
func (a APIError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", a.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIError.
func (a *APIError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountCopyLogDetails.
func (a AccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", a.AccountName)
	objectMap["copyLogDetailsType"] = ClassDiscriminatorDataBox
	populate(objectMap, "copyLogLink", a.CopyLogLink)
	populate(objectMap, "copyVerboseLogLink", a.CopyVerboseLogLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountCopyLogDetails.
func (a *AccountCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &a.CopyLogDetailsType)
			delete(rawMsg, key)
		case "copyLogLink":
			err = unpopulate(val, "CopyLogLink", &a.CopyLogLink)
			delete(rawMsg, key)
		case "copyVerboseLogLink":
			err = unpopulate(val, "CopyVerboseLogLink", &a.CopyVerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountCredentialDetails.
func (a AccountCredentialDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountConnectionString", a.AccountConnectionString)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "dataAccountType", a.DataAccountType)
	populate(objectMap, "shareCredentialDetails", a.ShareCredentialDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountCredentialDetails.
func (a *AccountCredentialDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountConnectionString":
			err = unpopulate(val, "AccountConnectionString", &a.AccountConnectionString)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &a.DataAccountType)
			delete(rawMsg, key)
		case "shareCredentialDetails":
			err = unpopulate(val, "ShareCredentialDetails", &a.ShareCredentialDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdditionalErrorInfo.
func (a AdditionalErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", a.Info)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdditionalErrorInfo.
func (a *AdditionalErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &a.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressValidationOutput.
func (a AddressValidationOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressValidationOutput.
func (a *AddressValidationOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressValidationProperties.
func (a AddressValidationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alternateAddresses", a.AlternateAddresses)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "validationStatus", a.ValidationStatus)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateAddress
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressValidationProperties.
func (a *AddressValidationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateAddresses":
			err = unpopulate(val, "AlternateAddresses", &a.AlternateAddresses)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "validationStatus":
			err = unpopulate(val, "ValidationStatus", &a.ValidationStatus)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &a.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplianceNetworkConfiguration.
func (a ApplianceNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "macAddress", a.MacAddress)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplianceNetworkConfiguration.
func (a *ApplianceNetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "macAddress":
			err = unpopulate(val, "MacAddress", &a.MacAddress)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmBaseObject.
func (a ArmBaseObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmBaseObject.
func (a *ArmBaseObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableSKURequest.
func (a AvailableSKURequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "country", a.Country)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "skuNames", a.SKUNames)
	populate(objectMap, "transferType", a.TransferType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableSKURequest.
func (a *AvailableSKURequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &a.Country)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "skuNames":
			err = unpopulate(val, "SKUNames", &a.SKUNames)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &a.TransferType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableSKUsResult.
func (a AvailableSKUsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableSKUsResult.
func (a *AvailableSKUsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileFilterDetails.
func (a AzureFileFilterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filePathList", a.FilePathList)
	populate(objectMap, "filePrefixList", a.FilePrefixList)
	populate(objectMap, "fileShareList", a.FileShareList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileFilterDetails.
func (a *AzureFileFilterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filePathList":
			err = unpopulate(val, "FilePathList", &a.FilePathList)
			delete(rawMsg, key)
		case "filePrefixList":
			err = unpopulate(val, "FilePrefixList", &a.FilePrefixList)
			delete(rawMsg, key)
		case "fileShareList":
			err = unpopulate(val, "FileShareList", &a.FileShareList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobFilterDetails.
func (b BlobFilterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobPathList", b.BlobPathList)
	populate(objectMap, "blobPrefixList", b.BlobPrefixList)
	populate(objectMap, "containerList", b.ContainerList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobFilterDetails.
func (b *BlobFilterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobPathList":
			err = unpopulate(val, "BlobPathList", &b.BlobPathList)
			delete(rawMsg, key)
		case "blobPrefixList":
			err = unpopulate(val, "BlobPrefixList", &b.BlobPrefixList)
			delete(rawMsg, key)
		case "containerList":
			err = unpopulate(val, "ContainerList", &b.ContainerList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CancellationReason.
func (c CancellationReason) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CancellationReason.
func (c *CancellationReason) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudError.
func (c CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", c.AdditionalInfo)
	populate(objectMap, "code", c.Code)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudError.
func (c *CloudError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &c.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &c.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &c.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonJobDetails.
func (c CommonJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", c.Actions)
	populate(objectMap, "chainOfCustodySasKey", c.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", c.ContactDetails)
	populate(objectMap, "copyLogDetails", c.CopyLogDetails)
	populate(objectMap, "dataCenterCode", c.DataCenterCode)
	populate(objectMap, "dataExportDetails", c.DataExportDetails)
	populate(objectMap, "dataImportDetails", c.DataImportDetails)
	populate(objectMap, "datacenterAddress", c.DatacenterAddress)
	populate(objectMap, "deliveryPackage", c.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", c.DeviceErasureDetails)
	populate(objectMap, "expectedDataSizeInTeraBytes", c.ExpectedDataSizeInTeraBytes)
	objectMap["jobDetailsType"] = c.JobDetailsType
	populate(objectMap, "jobStages", c.JobStages)
	populate(objectMap, "keyEncryptionKey", c.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", c.LastMitigationActionOnJob)
	populate(objectMap, "preferences", c.Preferences)
	populate(objectMap, "returnPackage", c.ReturnPackage)
	populate(objectMap, "reverseShipmentLabelSasKey", c.ReverseShipmentLabelSasKey)
	populate(objectMap, "reverseShippingDetails", c.ReverseShippingDetails)
	populate(objectMap, "shippingAddress", c.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonJobDetails.
func (c *CommonJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &c.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &c.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &c.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			c.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &c.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &c.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &c.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			c.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &c.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &c.DeviceErasureDetails)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &c.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &c.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &c.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &c.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &c.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &c.Preferences)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &c.ReturnPackage)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &c.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "reverseShippingDetails":
			err = unpopulate(val, "ReverseShippingDetails", &c.ReverseShippingDetails)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &c.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonJobSecrets.
func (c CommonJobSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dcAccessSecurityCode", c.DcAccessSecurityCode)
	populate(objectMap, "error", c.Error)
	objectMap["jobSecretsType"] = c.JobSecretsType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonJobSecrets.
func (c *CommonJobSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dcAccessSecurityCode":
			err = unpopulate(val, "DcAccessSecurityCode", &c.DcAccessSecurityCode)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "jobSecretsType":
			err = unpopulate(val, "JobSecretsType", &c.JobSecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonScheduleAvailabilityRequest.
func (c CommonScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "country", c.Country)
	objectMap["skuName"] = c.SKUName
	populate(objectMap, "storageLocation", c.StorageLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonScheduleAvailabilityRequest.
func (c *CommonScheduleAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &c.Country)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &c.SKUName)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &c.StorageLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactDetails.
func (c ContactDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contactName", c.ContactName)
	populate(objectMap, "emailList", c.EmailList)
	populate(objectMap, "mobile", c.Mobile)
	populate(objectMap, "notificationPreference", c.NotificationPreference)
	populate(objectMap, "phone", c.Phone)
	populate(objectMap, "phoneExtension", c.PhoneExtension)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactDetails.
func (c *ContactDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contactName":
			err = unpopulate(val, "ContactName", &c.ContactName)
			delete(rawMsg, key)
		case "emailList":
			err = unpopulate(val, "EmailList", &c.EmailList)
			delete(rawMsg, key)
		case "mobile":
			err = unpopulate(val, "Mobile", &c.Mobile)
			delete(rawMsg, key)
		case "notificationPreference":
			err = unpopulate(val, "NotificationPreference", &c.NotificationPreference)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &c.Phone)
			delete(rawMsg, key)
		case "phoneExtension":
			err = unpopulate(val, "PhoneExtension", &c.PhoneExtension)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactInfo.
func (c ContactInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contactName", c.ContactName)
	populate(objectMap, "mobile", c.Mobile)
	populate(objectMap, "phone", c.Phone)
	populate(objectMap, "phoneExtension", c.PhoneExtension)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactInfo.
func (c *ContactInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contactName":
			err = unpopulate(val, "ContactName", &c.ContactName)
			delete(rawMsg, key)
		case "mobile":
			err = unpopulate(val, "Mobile", &c.Mobile)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &c.Phone)
			delete(rawMsg, key)
		case "phoneExtension":
			err = unpopulate(val, "PhoneExtension", &c.PhoneExtension)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyLogDetails.
func (c CopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["copyLogDetailsType"] = c.CopyLogDetailsType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyLogDetails.
func (c *CopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &c.CopyLogDetailsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyProgress.
func (c CopyProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountId", c.AccountID)
	populate(objectMap, "actions", c.Actions)
	populate(objectMap, "bytesProcessed", c.BytesProcessed)
	populate(objectMap, "dataAccountType", c.DataAccountType)
	populate(objectMap, "directoriesErroredOut", c.DirectoriesErroredOut)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "filesErroredOut", c.FilesErroredOut)
	populate(objectMap, "filesProcessed", c.FilesProcessed)
	populate(objectMap, "invalidDirectoriesProcessed", c.InvalidDirectoriesProcessed)
	populate(objectMap, "invalidFileBytesUploaded", c.InvalidFileBytesUploaded)
	populate(objectMap, "invalidFilesProcessed", c.InvalidFilesProcessed)
	populate(objectMap, "isEnumerationInProgress", c.IsEnumerationInProgress)
	populate(objectMap, "renamedContainerCount", c.RenamedContainerCount)
	populate(objectMap, "storageAccountName", c.StorageAccountName)
	populate(objectMap, "totalBytesToProcess", c.TotalBytesToProcess)
	populate(objectMap, "totalFilesToProcess", c.TotalFilesToProcess)
	populate(objectMap, "transferType", c.TransferType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyProgress.
func (c *CopyProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &c.AccountID)
			delete(rawMsg, key)
		case "actions":
			err = unpopulate(val, "Actions", &c.Actions)
			delete(rawMsg, key)
		case "bytesProcessed":
			err = unpopulate(val, "BytesProcessed", &c.BytesProcessed)
			delete(rawMsg, key)
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &c.DataAccountType)
			delete(rawMsg, key)
		case "directoriesErroredOut":
			err = unpopulate(val, "DirectoriesErroredOut", &c.DirectoriesErroredOut)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "filesErroredOut":
			err = unpopulate(val, "FilesErroredOut", &c.FilesErroredOut)
			delete(rawMsg, key)
		case "filesProcessed":
			err = unpopulate(val, "FilesProcessed", &c.FilesProcessed)
			delete(rawMsg, key)
		case "invalidDirectoriesProcessed":
			err = unpopulate(val, "InvalidDirectoriesProcessed", &c.InvalidDirectoriesProcessed)
			delete(rawMsg, key)
		case "invalidFileBytesUploaded":
			err = unpopulate(val, "InvalidFileBytesUploaded", &c.InvalidFileBytesUploaded)
			delete(rawMsg, key)
		case "invalidFilesProcessed":
			err = unpopulate(val, "InvalidFilesProcessed", &c.InvalidFilesProcessed)
			delete(rawMsg, key)
		case "isEnumerationInProgress":
			err = unpopulate(val, "IsEnumerationInProgress", &c.IsEnumerationInProgress)
			delete(rawMsg, key)
		case "renamedContainerCount":
			err = unpopulate(val, "RenamedContainerCount", &c.RenamedContainerCount)
			delete(rawMsg, key)
		case "storageAccountName":
			err = unpopulate(val, "StorageAccountName", &c.StorageAccountName)
			delete(rawMsg, key)
		case "totalBytesToProcess":
			err = unpopulate(val, "TotalBytesToProcess", &c.TotalBytesToProcess)
			delete(rawMsg, key)
		case "totalFilesToProcess":
			err = unpopulate(val, "TotalFilesToProcess", &c.TotalFilesToProcess)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &c.TransferType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateJobValidations.
func (c CreateJobValidations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "individualRequestDetails", c.IndividualRequestDetails)
	objectMap["validationCategory"] = "JobCreationValidation"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateJobValidations.
func (c *CreateJobValidations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "individualRequestDetails":
			c.IndividualRequestDetails, err = unmarshalValidationInputRequestClassificationArray(val)
			delete(rawMsg, key)
		case "validationCategory":
			err = unpopulate(val, "ValidationCategory", &c.ValidationCategory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateOrderLimitForSubscriptionValidationRequest.
func (c CreateOrderLimitForSubscriptionValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceType", c.DeviceType)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateCreateOrderLimit
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateOrderLimitForSubscriptionValidationRequest.
func (c *CreateOrderLimitForSubscriptionValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &c.DeviceType)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &c.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateOrderLimitForSubscriptionValidationResponseProperties.
func (c CreateOrderLimitForSubscriptionValidationResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "status", c.Status)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateCreateOrderLimit
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateOrderLimitForSubscriptionValidationResponseProperties.
func (c *CreateOrderLimitForSubscriptionValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &c.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerDiskCopyLogDetails.
func (c CustomerDiskCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["copyLogDetailsType"] = ClassDiscriminatorDataBoxCustomerDisk
	populate(objectMap, "errorLogLink", c.ErrorLogLink)
	populate(objectMap, "serialNumber", c.SerialNumber)
	populate(objectMap, "verboseLogLink", c.VerboseLogLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerDiskCopyLogDetails.
func (c *CustomerDiskCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &c.CopyLogDetailsType)
			delete(rawMsg, key)
		case "errorLogLink":
			err = unpopulate(val, "ErrorLogLink", &c.ErrorLogLink)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &c.SerialNumber)
			delete(rawMsg, key)
		case "verboseLogLink":
			err = unpopulate(val, "VerboseLogLink", &c.VerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerDiskCopyProgress.
func (c CustomerDiskCopyProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountId", c.AccountID)
	populate(objectMap, "actions", c.Actions)
	populate(objectMap, "bytesProcessed", c.BytesProcessed)
	populate(objectMap, "copyStatus", c.CopyStatus)
	populate(objectMap, "dataAccountType", c.DataAccountType)
	populate(objectMap, "directoriesErroredOut", c.DirectoriesErroredOut)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "filesErroredOut", c.FilesErroredOut)
	populate(objectMap, "filesProcessed", c.FilesProcessed)
	populate(objectMap, "invalidDirectoriesProcessed", c.InvalidDirectoriesProcessed)
	populate(objectMap, "invalidFileBytesUploaded", c.InvalidFileBytesUploaded)
	populate(objectMap, "invalidFilesProcessed", c.InvalidFilesProcessed)
	populate(objectMap, "isEnumerationInProgress", c.IsEnumerationInProgress)
	populate(objectMap, "renamedContainerCount", c.RenamedContainerCount)
	populate(objectMap, "serialNumber", c.SerialNumber)
	populate(objectMap, "storageAccountName", c.StorageAccountName)
	populate(objectMap, "totalBytesToProcess", c.TotalBytesToProcess)
	populate(objectMap, "totalFilesToProcess", c.TotalFilesToProcess)
	populate(objectMap, "transferType", c.TransferType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerDiskCopyProgress.
func (c *CustomerDiskCopyProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &c.AccountID)
			delete(rawMsg, key)
		case "actions":
			err = unpopulate(val, "Actions", &c.Actions)
			delete(rawMsg, key)
		case "bytesProcessed":
			err = unpopulate(val, "BytesProcessed", &c.BytesProcessed)
			delete(rawMsg, key)
		case "copyStatus":
			err = unpopulate(val, "CopyStatus", &c.CopyStatus)
			delete(rawMsg, key)
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &c.DataAccountType)
			delete(rawMsg, key)
		case "directoriesErroredOut":
			err = unpopulate(val, "DirectoriesErroredOut", &c.DirectoriesErroredOut)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "filesErroredOut":
			err = unpopulate(val, "FilesErroredOut", &c.FilesErroredOut)
			delete(rawMsg, key)
		case "filesProcessed":
			err = unpopulate(val, "FilesProcessed", &c.FilesProcessed)
			delete(rawMsg, key)
		case "invalidDirectoriesProcessed":
			err = unpopulate(val, "InvalidDirectoriesProcessed", &c.InvalidDirectoriesProcessed)
			delete(rawMsg, key)
		case "invalidFileBytesUploaded":
			err = unpopulate(val, "InvalidFileBytesUploaded", &c.InvalidFileBytesUploaded)
			delete(rawMsg, key)
		case "invalidFilesProcessed":
			err = unpopulate(val, "InvalidFilesProcessed", &c.InvalidFilesProcessed)
			delete(rawMsg, key)
		case "isEnumerationInProgress":
			err = unpopulate(val, "IsEnumerationInProgress", &c.IsEnumerationInProgress)
			delete(rawMsg, key)
		case "renamedContainerCount":
			err = unpopulate(val, "RenamedContainerCount", &c.RenamedContainerCount)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &c.SerialNumber)
			delete(rawMsg, key)
		case "storageAccountName":
			err = unpopulate(val, "StorageAccountName", &c.StorageAccountName)
			delete(rawMsg, key)
		case "totalBytesToProcess":
			err = unpopulate(val, "TotalBytesToProcess", &c.TotalBytesToProcess)
			delete(rawMsg, key)
		case "totalFilesToProcess":
			err = unpopulate(val, "TotalFilesToProcess", &c.TotalFilesToProcess)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &c.TransferType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerDiskJobDetails.
func (c CustomerDiskJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", c.Actions)
	populate(objectMap, "chainOfCustodySasKey", c.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", c.ContactDetails)
	populate(objectMap, "copyLogDetails", c.CopyLogDetails)
	populate(objectMap, "copyProgress", c.CopyProgress)
	populate(objectMap, "dataCenterCode", c.DataCenterCode)
	populate(objectMap, "dataExportDetails", c.DataExportDetails)
	populate(objectMap, "dataImportDetails", c.DataImportDetails)
	populate(objectMap, "datacenterAddress", c.DatacenterAddress)
	populate(objectMap, "deliverToDcPackageDetails", c.DeliverToDcPackageDetails)
	populate(objectMap, "deliveryPackage", c.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", c.DeviceErasureDetails)
	populate(objectMap, "enableManifestBackup", c.EnableManifestBackup)
	populate(objectMap, "expectedDataSizeInTeraBytes", c.ExpectedDataSizeInTeraBytes)
	populate(objectMap, "exportDiskDetailsCollection", c.ExportDiskDetailsCollection)
	populate(objectMap, "importDiskDetailsCollection", c.ImportDiskDetailsCollection)
	objectMap["jobDetailsType"] = ClassDiscriminatorDataBoxCustomerDisk
	populate(objectMap, "jobStages", c.JobStages)
	populate(objectMap, "keyEncryptionKey", c.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", c.LastMitigationActionOnJob)
	populate(objectMap, "preferences", c.Preferences)
	populate(objectMap, "returnPackage", c.ReturnPackage)
	populate(objectMap, "returnToCustomerPackageDetails", c.ReturnToCustomerPackageDetails)
	populate(objectMap, "reverseShipmentLabelSasKey", c.ReverseShipmentLabelSasKey)
	populate(objectMap, "reverseShippingDetails", c.ReverseShippingDetails)
	populate(objectMap, "shippingAddress", c.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerDiskJobDetails.
func (c *CustomerDiskJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &c.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &c.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &c.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			c.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "copyProgress":
			err = unpopulate(val, "CopyProgress", &c.CopyProgress)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &c.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &c.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &c.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			c.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliverToDcPackageDetails":
			err = unpopulate(val, "DeliverToDcPackageDetails", &c.DeliverToDcPackageDetails)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &c.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &c.DeviceErasureDetails)
			delete(rawMsg, key)
		case "enableManifestBackup":
			err = unpopulate(val, "EnableManifestBackup", &c.EnableManifestBackup)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &c.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "exportDiskDetailsCollection":
			err = unpopulate(val, "ExportDiskDetailsCollection", &c.ExportDiskDetailsCollection)
			delete(rawMsg, key)
		case "importDiskDetailsCollection":
			err = unpopulate(val, "ImportDiskDetailsCollection", &c.ImportDiskDetailsCollection)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &c.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &c.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &c.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &c.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &c.Preferences)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &c.ReturnPackage)
			delete(rawMsg, key)
		case "returnToCustomerPackageDetails":
			err = unpopulate(val, "ReturnToCustomerPackageDetails", &c.ReturnToCustomerPackageDetails)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &c.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "reverseShippingDetails":
			err = unpopulate(val, "ReverseShippingDetails", &c.ReverseShippingDetails)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &c.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerDiskJobSecrets.
func (c CustomerDiskJobSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "carrierAccountNumber", c.CarrierAccountNumber)
	populate(objectMap, "dcAccessSecurityCode", c.DcAccessSecurityCode)
	populate(objectMap, "diskSecrets", c.DiskSecrets)
	populate(objectMap, "error", c.Error)
	objectMap["jobSecretsType"] = ClassDiscriminatorDataBoxCustomerDisk
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerDiskJobSecrets.
func (c *CustomerDiskJobSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "carrierAccountNumber":
			err = unpopulate(val, "CarrierAccountNumber", &c.CarrierAccountNumber)
			delete(rawMsg, key)
		case "dcAccessSecurityCode":
			err = unpopulate(val, "DcAccessSecurityCode", &c.DcAccessSecurityCode)
			delete(rawMsg, key)
		case "diskSecrets":
			err = unpopulate(val, "DiskSecrets", &c.DiskSecrets)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "jobSecretsType":
			err = unpopulate(val, "JobSecretsType", &c.JobSecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataAccountDetails.
func (d DataAccountDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["dataAccountType"] = d.DataAccountType
	populate(objectMap, "sharePassword", d.SharePassword)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataAccountDetails.
func (d *DataAccountDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &d.DataAccountType)
			delete(rawMsg, key)
		case "sharePassword":
			err = unpopulate(val, "SharePassword", &d.SharePassword)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataExportDetails.
func (d DataExportDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountDetails", d.AccountDetails)
	populate(objectMap, "logCollectionLevel", d.LogCollectionLevel)
	populate(objectMap, "transferConfiguration", d.TransferConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataExportDetails.
func (d *DataExportDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountDetails":
			d.AccountDetails, err = unmarshalDataAccountDetailsClassification(val)
			delete(rawMsg, key)
		case "logCollectionLevel":
			err = unpopulate(val, "LogCollectionLevel", &d.LogCollectionLevel)
			delete(rawMsg, key)
		case "transferConfiguration":
			err = unpopulate(val, "TransferConfiguration", &d.TransferConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataImportDetails.
func (d DataImportDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountDetails", d.AccountDetails)
	populate(objectMap, "logCollectionLevel", d.LogCollectionLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataImportDetails.
func (d *DataImportDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountDetails":
			d.AccountDetails, err = unmarshalDataAccountDetailsClassification(val)
			delete(rawMsg, key)
		case "logCollectionLevel":
			err = unpopulate(val, "LogCollectionLevel", &d.LogCollectionLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataLocationToServiceLocationMap.
func (d DataLocationToServiceLocationMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataLocation", d.DataLocation)
	populate(objectMap, "serviceLocation", d.ServiceLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataLocationToServiceLocationMap.
func (d *DataLocationToServiceLocationMap) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataLocation":
			err = unpopulate(val, "DataLocation", &d.DataLocation)
			delete(rawMsg, key)
		case "serviceLocation":
			err = unpopulate(val, "ServiceLocation", &d.ServiceLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataTransferDetailsValidationRequest.
func (d DataTransferDetailsValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataExportDetails", d.DataExportDetails)
	populate(objectMap, "dataImportDetails", d.DataImportDetails)
	populate(objectMap, "deviceType", d.DeviceType)
	populate(objectMap, "transferType", d.TransferType)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateDataTransferDetails
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataTransferDetailsValidationRequest.
func (d *DataTransferDetailsValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &d.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &d.DataImportDetails)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &d.DeviceType)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &d.TransferType)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &d.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataTransferDetailsValidationResponseProperties.
func (d DataTransferDetailsValidationResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", d.Error)
	populate(objectMap, "status", d.Status)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateDataTransferDetails
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataTransferDetailsValidationResponseProperties.
func (d *DataTransferDetailsValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &d.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatacenterAddressInstructionResponse.
func (d DatacenterAddressInstructionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "communicationInstruction", d.CommunicationInstruction)
	populate(objectMap, "dataCenterAzureLocation", d.DataCenterAzureLocation)
	objectMap["datacenterAddressType"] = DatacenterAddressTypeDatacenterAddressInstruction
	populate(objectMap, "supportedCarriersForReturnShipment", d.SupportedCarriersForReturnShipment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatacenterAddressInstructionResponse.
func (d *DatacenterAddressInstructionResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "communicationInstruction":
			err = unpopulate(val, "CommunicationInstruction", &d.CommunicationInstruction)
			delete(rawMsg, key)
		case "dataCenterAzureLocation":
			err = unpopulate(val, "DataCenterAzureLocation", &d.DataCenterAzureLocation)
			delete(rawMsg, key)
		case "datacenterAddressType":
			err = unpopulate(val, "DatacenterAddressType", &d.DatacenterAddressType)
			delete(rawMsg, key)
		case "supportedCarriersForReturnShipment":
			err = unpopulate(val, "SupportedCarriersForReturnShipment", &d.SupportedCarriersForReturnShipment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatacenterAddressLocationResponse.
func (d DatacenterAddressLocationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalShippingInformation", d.AdditionalShippingInformation)
	populate(objectMap, "addressType", d.AddressType)
	populate(objectMap, "city", d.City)
	populate(objectMap, "company", d.Company)
	populate(objectMap, "contactPersonName", d.ContactPersonName)
	populate(objectMap, "country", d.Country)
	populate(objectMap, "dataCenterAzureLocation", d.DataCenterAzureLocation)
	objectMap["datacenterAddressType"] = DatacenterAddressTypeDatacenterAddressLocation
	populate(objectMap, "phone", d.Phone)
	populate(objectMap, "phoneExtension", d.PhoneExtension)
	populate(objectMap, "state", d.State)
	populate(objectMap, "street1", d.Street1)
	populate(objectMap, "street2", d.Street2)
	populate(objectMap, "street3", d.Street3)
	populate(objectMap, "supportedCarriersForReturnShipment", d.SupportedCarriersForReturnShipment)
	populate(objectMap, "zip", d.Zip)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatacenterAddressLocationResponse.
func (d *DatacenterAddressLocationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalShippingInformation":
			err = unpopulate(val, "AdditionalShippingInformation", &d.AdditionalShippingInformation)
			delete(rawMsg, key)
		case "addressType":
			err = unpopulate(val, "AddressType", &d.AddressType)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &d.City)
			delete(rawMsg, key)
		case "company":
			err = unpopulate(val, "Company", &d.Company)
			delete(rawMsg, key)
		case "contactPersonName":
			err = unpopulate(val, "ContactPersonName", &d.ContactPersonName)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &d.Country)
			delete(rawMsg, key)
		case "dataCenterAzureLocation":
			err = unpopulate(val, "DataCenterAzureLocation", &d.DataCenterAzureLocation)
			delete(rawMsg, key)
		case "datacenterAddressType":
			err = unpopulate(val, "DatacenterAddressType", &d.DatacenterAddressType)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &d.Phone)
			delete(rawMsg, key)
		case "phoneExtension":
			err = unpopulate(val, "PhoneExtension", &d.PhoneExtension)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		case "street1":
			err = unpopulate(val, "Street1", &d.Street1)
			delete(rawMsg, key)
		case "street2":
			err = unpopulate(val, "Street2", &d.Street2)
			delete(rawMsg, key)
		case "street3":
			err = unpopulate(val, "Street3", &d.Street3)
			delete(rawMsg, key)
		case "supportedCarriersForReturnShipment":
			err = unpopulate(val, "SupportedCarriersForReturnShipment", &d.SupportedCarriersForReturnShipment)
			delete(rawMsg, key)
		case "zip":
			err = unpopulate(val, "Zip", &d.Zip)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatacenterAddressRequest.
func (d DatacenterAddressRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skuName", d.SKUName)
	populate(objectMap, "storageLocation", d.StorageLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatacenterAddressRequest.
func (d *DatacenterAddressRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skuName":
			err = unpopulate(val, "SKUName", &d.SKUName)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &d.StorageLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatacenterAddressResponse.
func (d DatacenterAddressResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataCenterAzureLocation", d.DataCenterAzureLocation)
	objectMap["datacenterAddressType"] = d.DatacenterAddressType
	populate(objectMap, "supportedCarriersForReturnShipment", d.SupportedCarriersForReturnShipment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatacenterAddressResponse.
func (d *DatacenterAddressResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataCenterAzureLocation":
			err = unpopulate(val, "DataCenterAzureLocation", &d.DataCenterAzureLocation)
			delete(rawMsg, key)
		case "datacenterAddressType":
			err = unpopulate(val, "DatacenterAddressType", &d.DatacenterAddressType)
			delete(rawMsg, key)
		case "supportedCarriersForReturnShipment":
			err = unpopulate(val, "SupportedCarriersForReturnShipment", &d.SupportedCarriersForReturnShipment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DcAccessSecurityCode.
func (d DcAccessSecurityCode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forwardDCAccessCode", d.ForwardDCAccessCode)
	populate(objectMap, "reverseDCAccessCode", d.ReverseDCAccessCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DcAccessSecurityCode.
func (d *DcAccessSecurityCode) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forwardDCAccessCode":
			err = unpopulate(val, "ForwardDCAccessCode", &d.ForwardDCAccessCode)
			delete(rawMsg, key)
		case "reverseDCAccessCode":
			err = unpopulate(val, "ReverseDCAccessCode", &d.ReverseDCAccessCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Details.
func (d Details) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "message", d.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Details.
func (d *Details) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceErasureDetails.
func (d DeviceErasureDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceErasureStatus", d.DeviceErasureStatus)
	populate(objectMap, "erasureOrDestructionCertificateSasKey", d.ErasureOrDestructionCertificateSasKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceErasureDetails.
func (d *DeviceErasureDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceErasureStatus":
			err = unpopulate(val, "DeviceErasureStatus", &d.DeviceErasureStatus)
			delete(rawMsg, key)
		case "erasureOrDestructionCertificateSasKey":
			err = unpopulate(val, "ErasureOrDestructionCertificateSasKey", &d.ErasureOrDestructionCertificateSasKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskCopyLogDetails.
func (d DiskCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["copyLogDetailsType"] = ClassDiscriminatorDataBoxDisk
	populate(objectMap, "diskSerialNumber", d.DiskSerialNumber)
	populate(objectMap, "errorLogLink", d.ErrorLogLink)
	populate(objectMap, "verboseLogLink", d.VerboseLogLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskCopyLogDetails.
func (d *DiskCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &d.CopyLogDetailsType)
			delete(rawMsg, key)
		case "diskSerialNumber":
			err = unpopulate(val, "DiskSerialNumber", &d.DiskSerialNumber)
			delete(rawMsg, key)
		case "errorLogLink":
			err = unpopulate(val, "ErrorLogLink", &d.ErrorLogLink)
			delete(rawMsg, key)
		case "verboseLogLink":
			err = unpopulate(val, "VerboseLogLink", &d.VerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskCopyProgress.
func (d DiskCopyProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", d.Actions)
	populate(objectMap, "bytesCopied", d.BytesCopied)
	populate(objectMap, "error", d.Error)
	populate(objectMap, "percentComplete", d.PercentComplete)
	populate(objectMap, "serialNumber", d.SerialNumber)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskCopyProgress.
func (d *DiskCopyProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &d.Actions)
			delete(rawMsg, key)
		case "bytesCopied":
			err = unpopulate(val, "BytesCopied", &d.BytesCopied)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &d.PercentComplete)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskGranularCopyLogDetails.
func (d DiskGranularCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountId", d.AccountID)
	objectMap["copyLogDetailsType"] = ClassDiscriminatorDataBoxCustomerDisk
	populate(objectMap, "errorLogLink", d.ErrorLogLink)
	populate(objectMap, "serialNumber", d.SerialNumber)
	populate(objectMap, "verboseLogLink", d.VerboseLogLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskGranularCopyLogDetails.
func (d *DiskGranularCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &d.AccountID)
			delete(rawMsg, key)
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &d.CopyLogDetailsType)
			delete(rawMsg, key)
		case "errorLogLink":
			err = unpopulate(val, "ErrorLogLink", &d.ErrorLogLink)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		case "verboseLogLink":
			err = unpopulate(val, "VerboseLogLink", &d.VerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskGranularCopyProgress.
func (d DiskGranularCopyProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountId", d.AccountID)
	populate(objectMap, "actions", d.Actions)
	populate(objectMap, "bytesProcessed", d.BytesProcessed)
	populate(objectMap, "copyStatus", d.CopyStatus)
	populate(objectMap, "dataAccountType", d.DataAccountType)
	populate(objectMap, "directoriesErroredOut", d.DirectoriesErroredOut)
	populate(objectMap, "error", d.Error)
	populate(objectMap, "filesErroredOut", d.FilesErroredOut)
	populate(objectMap, "filesProcessed", d.FilesProcessed)
	populate(objectMap, "invalidDirectoriesProcessed", d.InvalidDirectoriesProcessed)
	populate(objectMap, "invalidFileBytesUploaded", d.InvalidFileBytesUploaded)
	populate(objectMap, "invalidFilesProcessed", d.InvalidFilesProcessed)
	populate(objectMap, "isEnumerationInProgress", d.IsEnumerationInProgress)
	populate(objectMap, "renamedContainerCount", d.RenamedContainerCount)
	populate(objectMap, "serialNumber", d.SerialNumber)
	populate(objectMap, "storageAccountName", d.StorageAccountName)
	populate(objectMap, "totalBytesToProcess", d.TotalBytesToProcess)
	populate(objectMap, "totalFilesToProcess", d.TotalFilesToProcess)
	populate(objectMap, "transferType", d.TransferType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskGranularCopyProgress.
func (d *DiskGranularCopyProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &d.AccountID)
			delete(rawMsg, key)
		case "actions":
			err = unpopulate(val, "Actions", &d.Actions)
			delete(rawMsg, key)
		case "bytesProcessed":
			err = unpopulate(val, "BytesProcessed", &d.BytesProcessed)
			delete(rawMsg, key)
		case "copyStatus":
			err = unpopulate(val, "CopyStatus", &d.CopyStatus)
			delete(rawMsg, key)
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &d.DataAccountType)
			delete(rawMsg, key)
		case "directoriesErroredOut":
			err = unpopulate(val, "DirectoriesErroredOut", &d.DirectoriesErroredOut)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		case "filesErroredOut":
			err = unpopulate(val, "FilesErroredOut", &d.FilesErroredOut)
			delete(rawMsg, key)
		case "filesProcessed":
			err = unpopulate(val, "FilesProcessed", &d.FilesProcessed)
			delete(rawMsg, key)
		case "invalidDirectoriesProcessed":
			err = unpopulate(val, "InvalidDirectoriesProcessed", &d.InvalidDirectoriesProcessed)
			delete(rawMsg, key)
		case "invalidFileBytesUploaded":
			err = unpopulate(val, "InvalidFileBytesUploaded", &d.InvalidFileBytesUploaded)
			delete(rawMsg, key)
		case "invalidFilesProcessed":
			err = unpopulate(val, "InvalidFilesProcessed", &d.InvalidFilesProcessed)
			delete(rawMsg, key)
		case "isEnumerationInProgress":
			err = unpopulate(val, "IsEnumerationInProgress", &d.IsEnumerationInProgress)
			delete(rawMsg, key)
		case "renamedContainerCount":
			err = unpopulate(val, "RenamedContainerCount", &d.RenamedContainerCount)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		case "storageAccountName":
			err = unpopulate(val, "StorageAccountName", &d.StorageAccountName)
			delete(rawMsg, key)
		case "totalBytesToProcess":
			err = unpopulate(val, "TotalBytesToProcess", &d.TotalBytesToProcess)
			delete(rawMsg, key)
		case "totalFilesToProcess":
			err = unpopulate(val, "TotalFilesToProcess", &d.TotalFilesToProcess)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &d.TransferType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskJobDetails.
func (d DiskJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", d.Actions)
	populate(objectMap, "chainOfCustodySasKey", d.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", d.ContactDetails)
	populate(objectMap, "copyLogDetails", d.CopyLogDetails)
	populate(objectMap, "copyProgress", d.CopyProgress)
	populate(objectMap, "dataCenterCode", d.DataCenterCode)
	populate(objectMap, "dataExportDetails", d.DataExportDetails)
	populate(objectMap, "dataImportDetails", d.DataImportDetails)
	populate(objectMap, "datacenterAddress", d.DatacenterAddress)
	populate(objectMap, "deliveryPackage", d.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", d.DeviceErasureDetails)
	populate(objectMap, "disksAndSizeDetails", d.DisksAndSizeDetails)
	populate(objectMap, "expectedDataSizeInTeraBytes", d.ExpectedDataSizeInTeraBytes)
	populate(objectMap, "granularCopyLogDetails", d.GranularCopyLogDetails)
	populate(objectMap, "granularCopyProgress", d.GranularCopyProgress)
	objectMap["jobDetailsType"] = ClassDiscriminatorDataBoxDisk
	populate(objectMap, "jobStages", d.JobStages)
	populate(objectMap, "keyEncryptionKey", d.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", d.LastMitigationActionOnJob)
	populate(objectMap, "passkey", d.Passkey)
	populate(objectMap, "preferences", d.Preferences)
	populate(objectMap, "preferredDisks", d.PreferredDisks)
	populate(objectMap, "returnPackage", d.ReturnPackage)
	populate(objectMap, "reverseShipmentLabelSasKey", d.ReverseShipmentLabelSasKey)
	populate(objectMap, "reverseShippingDetails", d.ReverseShippingDetails)
	populate(objectMap, "shippingAddress", d.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskJobDetails.
func (d *DiskJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &d.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &d.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &d.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			d.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "copyProgress":
			err = unpopulate(val, "CopyProgress", &d.CopyProgress)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &d.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &d.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &d.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			d.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &d.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &d.DeviceErasureDetails)
			delete(rawMsg, key)
		case "disksAndSizeDetails":
			err = unpopulate(val, "DisksAndSizeDetails", &d.DisksAndSizeDetails)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &d.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "granularCopyLogDetails":
			err = unpopulate(val, "GranularCopyLogDetails", &d.GranularCopyLogDetails)
			delete(rawMsg, key)
		case "granularCopyProgress":
			err = unpopulate(val, "GranularCopyProgress", &d.GranularCopyProgress)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &d.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &d.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &d.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &d.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "passkey":
			err = unpopulate(val, "Passkey", &d.Passkey)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &d.Preferences)
			delete(rawMsg, key)
		case "preferredDisks":
			err = unpopulate(val, "PreferredDisks", &d.PreferredDisks)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &d.ReturnPackage)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &d.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "reverseShippingDetails":
			err = unpopulate(val, "ReverseShippingDetails", &d.ReverseShippingDetails)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &d.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskJobSecrets.
func (d DiskJobSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dcAccessSecurityCode", d.DcAccessSecurityCode)
	populate(objectMap, "diskSecrets", d.DiskSecrets)
	populate(objectMap, "error", d.Error)
	populate(objectMap, "isPasskeyUserDefined", d.IsPasskeyUserDefined)
	objectMap["jobSecretsType"] = ClassDiscriminatorDataBoxDisk
	populate(objectMap, "passKey", d.PassKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskJobSecrets.
func (d *DiskJobSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dcAccessSecurityCode":
			err = unpopulate(val, "DcAccessSecurityCode", &d.DcAccessSecurityCode)
			delete(rawMsg, key)
		case "diskSecrets":
			err = unpopulate(val, "DiskSecrets", &d.DiskSecrets)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		case "isPasskeyUserDefined":
			err = unpopulate(val, "IsPasskeyUserDefined", &d.IsPasskeyUserDefined)
			delete(rawMsg, key)
		case "jobSecretsType":
			err = unpopulate(val, "JobSecretsType", &d.JobSecretsType)
			delete(rawMsg, key)
		case "passKey":
			err = unpopulate(val, "PassKey", &d.PassKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskScheduleAvailabilityRequest.
func (d DiskScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "country", d.Country)
	populate(objectMap, "expectedDataSizeInTeraBytes", d.ExpectedDataSizeInTeraBytes)
	objectMap["skuName"] = SKUNameDataBoxDisk
	populate(objectMap, "storageLocation", d.StorageLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskScheduleAvailabilityRequest.
func (d *DiskScheduleAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &d.Country)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &d.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &d.SKUName)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &d.StorageLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskSecret.
func (d DiskSecret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bitLockerKey", d.BitLockerKey)
	populate(objectMap, "diskSerialNumber", d.DiskSerialNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskSecret.
func (d *DiskSecret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitLockerKey":
			err = unpopulate(val, "BitLockerKey", &d.BitLockerKey)
			delete(rawMsg, key)
		case "diskSerialNumber":
			err = unpopulate(val, "DiskSerialNumber", &d.DiskSerialNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionPreferences.
func (e EncryptionPreferences) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "doubleEncryption", e.DoubleEncryption)
	populate(objectMap, "hardwareEncryption", e.HardwareEncryption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionPreferences.
func (e *EncryptionPreferences) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "doubleEncryption":
			err = unpopulate(val, "DoubleEncryption", &e.DoubleEncryption)
			delete(rawMsg, key)
		case "hardwareEncryption":
			err = unpopulate(val, "HardwareEncryption", &e.HardwareEncryption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportDiskDetails.
func (e ExportDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupManifestCloudPath", e.BackupManifestCloudPath)
	populate(objectMap, "manifestFile", e.ManifestFile)
	populate(objectMap, "manifestHash", e.ManifestHash)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportDiskDetails.
func (e *ExportDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManifestCloudPath":
			err = unpopulate(val, "BackupManifestCloudPath", &e.BackupManifestCloudPath)
			delete(rawMsg, key)
		case "manifestFile":
			err = unpopulate(val, "ManifestFile", &e.ManifestFile)
			delete(rawMsg, key)
		case "manifestHash":
			err = unpopulate(val, "ManifestHash", &e.ManifestHash)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilterFileDetails.
func (f FilterFileDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filterFilePath", f.FilterFilePath)
	populate(objectMap, "filterFileType", f.FilterFileType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilterFileDetails.
func (f *FilterFileDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filterFilePath":
			err = unpopulate(val, "FilterFilePath", &f.FilterFilePath)
			delete(rawMsg, key)
		case "filterFileType":
			err = unpopulate(val, "FilterFileType", &f.FilterFileType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GranularCopyLogDetails.
func (g GranularCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["copyLogDetailsType"] = g.CopyLogDetailsType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GranularCopyLogDetails.
func (g *GranularCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &g.CopyLogDetailsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GranularCopyProgress.
func (g GranularCopyProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountId", g.AccountID)
	populate(objectMap, "actions", g.Actions)
	populate(objectMap, "bytesProcessed", g.BytesProcessed)
	populate(objectMap, "dataAccountType", g.DataAccountType)
	populate(objectMap, "directoriesErroredOut", g.DirectoriesErroredOut)
	populate(objectMap, "error", g.Error)
	populate(objectMap, "filesErroredOut", g.FilesErroredOut)
	populate(objectMap, "filesProcessed", g.FilesProcessed)
	populate(objectMap, "invalidDirectoriesProcessed", g.InvalidDirectoriesProcessed)
	populate(objectMap, "invalidFileBytesUploaded", g.InvalidFileBytesUploaded)
	populate(objectMap, "invalidFilesProcessed", g.InvalidFilesProcessed)
	populate(objectMap, "isEnumerationInProgress", g.IsEnumerationInProgress)
	populate(objectMap, "renamedContainerCount", g.RenamedContainerCount)
	populate(objectMap, "storageAccountName", g.StorageAccountName)
	populate(objectMap, "totalBytesToProcess", g.TotalBytesToProcess)
	populate(objectMap, "totalFilesToProcess", g.TotalFilesToProcess)
	populate(objectMap, "transferType", g.TransferType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GranularCopyProgress.
func (g *GranularCopyProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &g.AccountID)
			delete(rawMsg, key)
		case "actions":
			err = unpopulate(val, "Actions", &g.Actions)
			delete(rawMsg, key)
		case "bytesProcessed":
			err = unpopulate(val, "BytesProcessed", &g.BytesProcessed)
			delete(rawMsg, key)
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &g.DataAccountType)
			delete(rawMsg, key)
		case "directoriesErroredOut":
			err = unpopulate(val, "DirectoriesErroredOut", &g.DirectoriesErroredOut)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &g.Error)
			delete(rawMsg, key)
		case "filesErroredOut":
			err = unpopulate(val, "FilesErroredOut", &g.FilesErroredOut)
			delete(rawMsg, key)
		case "filesProcessed":
			err = unpopulate(val, "FilesProcessed", &g.FilesProcessed)
			delete(rawMsg, key)
		case "invalidDirectoriesProcessed":
			err = unpopulate(val, "InvalidDirectoriesProcessed", &g.InvalidDirectoriesProcessed)
			delete(rawMsg, key)
		case "invalidFileBytesUploaded":
			err = unpopulate(val, "InvalidFileBytesUploaded", &g.InvalidFileBytesUploaded)
			delete(rawMsg, key)
		case "invalidFilesProcessed":
			err = unpopulate(val, "InvalidFilesProcessed", &g.InvalidFilesProcessed)
			delete(rawMsg, key)
		case "isEnumerationInProgress":
			err = unpopulate(val, "IsEnumerationInProgress", &g.IsEnumerationInProgress)
			delete(rawMsg, key)
		case "renamedContainerCount":
			err = unpopulate(val, "RenamedContainerCount", &g.RenamedContainerCount)
			delete(rawMsg, key)
		case "storageAccountName":
			err = unpopulate(val, "StorageAccountName", &g.StorageAccountName)
			delete(rawMsg, key)
		case "totalBytesToProcess":
			err = unpopulate(val, "TotalBytesToProcess", &g.TotalBytesToProcess)
			delete(rawMsg, key)
		case "totalFilesToProcess":
			err = unpopulate(val, "TotalFilesToProcess", &g.TotalFilesToProcess)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &g.TransferType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeavyAccountCopyLogDetails.
func (h HeavyAccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", h.AccountName)
	objectMap["copyLogDetailsType"] = ClassDiscriminatorDataBoxHeavy
	populate(objectMap, "copyLogLink", h.CopyLogLink)
	populate(objectMap, "copyVerboseLogLink", h.CopyVerboseLogLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeavyAccountCopyLogDetails.
func (h *HeavyAccountCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &h.AccountName)
			delete(rawMsg, key)
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &h.CopyLogDetailsType)
			delete(rawMsg, key)
		case "copyLogLink":
			err = unpopulate(val, "CopyLogLink", &h.CopyLogLink)
			delete(rawMsg, key)
		case "copyVerboseLogLink":
			err = unpopulate(val, "CopyVerboseLogLink", &h.CopyVerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeavyJobDetails.
func (h HeavyJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", h.Actions)
	populate(objectMap, "chainOfCustodySasKey", h.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", h.ContactDetails)
	populate(objectMap, "copyLogDetails", h.CopyLogDetails)
	populate(objectMap, "copyProgress", h.CopyProgress)
	populate(objectMap, "dataCenterCode", h.DataCenterCode)
	populate(objectMap, "dataExportDetails", h.DataExportDetails)
	populate(objectMap, "dataImportDetails", h.DataImportDetails)
	populate(objectMap, "datacenterAddress", h.DatacenterAddress)
	populate(objectMap, "deliveryPackage", h.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", h.DeviceErasureDetails)
	populate(objectMap, "devicePassword", h.DevicePassword)
	populate(objectMap, "expectedDataSizeInTeraBytes", h.ExpectedDataSizeInTeraBytes)
	objectMap["jobDetailsType"] = ClassDiscriminatorDataBoxHeavy
	populate(objectMap, "jobStages", h.JobStages)
	populate(objectMap, "keyEncryptionKey", h.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", h.LastMitigationActionOnJob)
	populate(objectMap, "preferences", h.Preferences)
	populate(objectMap, "returnPackage", h.ReturnPackage)
	populate(objectMap, "reverseShipmentLabelSasKey", h.ReverseShipmentLabelSasKey)
	populate(objectMap, "reverseShippingDetails", h.ReverseShippingDetails)
	populate(objectMap, "shippingAddress", h.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeavyJobDetails.
func (h *HeavyJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &h.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &h.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &h.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			h.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "copyProgress":
			err = unpopulate(val, "CopyProgress", &h.CopyProgress)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &h.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &h.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &h.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			h.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &h.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &h.DeviceErasureDetails)
			delete(rawMsg, key)
		case "devicePassword":
			err = unpopulate(val, "DevicePassword", &h.DevicePassword)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &h.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &h.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &h.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &h.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &h.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &h.Preferences)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &h.ReturnPackage)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &h.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "reverseShippingDetails":
			err = unpopulate(val, "ReverseShippingDetails", &h.ReverseShippingDetails)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &h.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeavyJobSecrets.
func (h HeavyJobSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cabinetPodSecrets", h.CabinetPodSecrets)
	populate(objectMap, "dcAccessSecurityCode", h.DcAccessSecurityCode)
	populate(objectMap, "error", h.Error)
	objectMap["jobSecretsType"] = ClassDiscriminatorDataBoxHeavy
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeavyJobSecrets.
func (h *HeavyJobSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cabinetPodSecrets":
			err = unpopulate(val, "CabinetPodSecrets", &h.CabinetPodSecrets)
			delete(rawMsg, key)
		case "dcAccessSecurityCode":
			err = unpopulate(val, "DcAccessSecurityCode", &h.DcAccessSecurityCode)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &h.Error)
			delete(rawMsg, key)
		case "jobSecretsType":
			err = unpopulate(val, "JobSecretsType", &h.JobSecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeavyScheduleAvailabilityRequest.
func (h HeavyScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "country", h.Country)
	objectMap["skuName"] = SKUNameDataBoxHeavy
	populate(objectMap, "storageLocation", h.StorageLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeavyScheduleAvailabilityRequest.
func (h *HeavyScheduleAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &h.Country)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &h.SKUName)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &h.StorageLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeavySecret.
func (h HeavySecret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountCredentialDetails", h.AccountCredentialDetails)
	populate(objectMap, "devicePassword", h.DevicePassword)
	populate(objectMap, "deviceSerialNumber", h.DeviceSerialNumber)
	populate(objectMap, "encodedValidationCertPubKey", h.EncodedValidationCertPubKey)
	populate(objectMap, "networkConfigurations", h.NetworkConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeavySecret.
func (h *HeavySecret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountCredentialDetails":
			err = unpopulate(val, "AccountCredentialDetails", &h.AccountCredentialDetails)
			delete(rawMsg, key)
		case "devicePassword":
			err = unpopulate(val, "DevicePassword", &h.DevicePassword)
			delete(rawMsg, key)
		case "deviceSerialNumber":
			err = unpopulate(val, "DeviceSerialNumber", &h.DeviceSerialNumber)
			delete(rawMsg, key)
		case "encodedValidationCertPubKey":
			err = unpopulate(val, "EncodedValidationCertPubKey", &h.EncodedValidationCertPubKey)
			delete(rawMsg, key)
		case "networkConfigurations":
			err = unpopulate(val, "NetworkConfigurations", &h.NetworkConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProperties.
func (i IdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssigned", i.UserAssigned)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProperties.
func (i *IdentityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "userAssigned":
			err = unpopulate(val, "UserAssigned", &i.UserAssigned)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportDiskDetails.
func (i ImportDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupManifestCloudPath", i.BackupManifestCloudPath)
	populate(objectMap, "bitLockerKey", i.BitLockerKey)
	populate(objectMap, "manifestFile", i.ManifestFile)
	populate(objectMap, "manifestHash", i.ManifestHash)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportDiskDetails.
func (i *ImportDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManifestCloudPath":
			err = unpopulate(val, "BackupManifestCloudPath", &i.BackupManifestCloudPath)
			delete(rawMsg, key)
		case "bitLockerKey":
			err = unpopulate(val, "BitLockerKey", &i.BitLockerKey)
			delete(rawMsg, key)
		case "manifestFile":
			err = unpopulate(val, "ManifestFile", &i.ManifestFile)
			delete(rawMsg, key)
		case "manifestHash":
			err = unpopulate(val, "ManifestHash", &i.ManifestHash)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobDeliveryInfo.
func (j JobDeliveryInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "scheduledDateTime", j.ScheduledDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobDeliveryInfo.
func (j *JobDeliveryInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scheduledDateTime":
			err = unpopulateDateTimeRFC3339(val, "ScheduledDateTime", &j.ScheduledDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobDetails.
func (j JobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", j.Actions)
	populate(objectMap, "chainOfCustodySasKey", j.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", j.ContactDetails)
	populate(objectMap, "copyLogDetails", j.CopyLogDetails)
	populate(objectMap, "copyProgress", j.CopyProgress)
	populate(objectMap, "dataCenterCode", j.DataCenterCode)
	populate(objectMap, "dataExportDetails", j.DataExportDetails)
	populate(objectMap, "dataImportDetails", j.DataImportDetails)
	populate(objectMap, "datacenterAddress", j.DatacenterAddress)
	populate(objectMap, "deliveryPackage", j.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", j.DeviceErasureDetails)
	populate(objectMap, "devicePassword", j.DevicePassword)
	populate(objectMap, "expectedDataSizeInTeraBytes", j.ExpectedDataSizeInTeraBytes)
	objectMap["jobDetailsType"] = ClassDiscriminatorDataBox
	populate(objectMap, "jobStages", j.JobStages)
	populate(objectMap, "keyEncryptionKey", j.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", j.LastMitigationActionOnJob)
	populate(objectMap, "preferences", j.Preferences)
	populate(objectMap, "returnPackage", j.ReturnPackage)
	populate(objectMap, "reverseShipmentLabelSasKey", j.ReverseShipmentLabelSasKey)
	populate(objectMap, "reverseShippingDetails", j.ReverseShippingDetails)
	populate(objectMap, "shippingAddress", j.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobDetails.
func (j *JobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &j.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &j.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &j.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			j.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "copyProgress":
			err = unpopulate(val, "CopyProgress", &j.CopyProgress)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &j.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &j.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &j.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			j.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &j.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &j.DeviceErasureDetails)
			delete(rawMsg, key)
		case "devicePassword":
			err = unpopulate(val, "DevicePassword", &j.DevicePassword)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &j.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &j.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &j.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &j.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &j.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &j.Preferences)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &j.ReturnPackage)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &j.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "reverseShippingDetails":
			err = unpopulate(val, "ReverseShippingDetails", &j.ReverseShippingDetails)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &j.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cancellationReason", j.CancellationReason)
	populate(objectMap, "deliveryInfo", j.DeliveryInfo)
	populate(objectMap, "deliveryType", j.DeliveryType)
	populate(objectMap, "details", j.Details)
	populate(objectMap, "error", j.Error)
	populate(objectMap, "isCancellable", j.IsCancellable)
	populate(objectMap, "isCancellableWithoutFee", j.IsCancellableWithoutFee)
	populate(objectMap, "isDeletable", j.IsDeletable)
	populate(objectMap, "isPrepareToShipEnabled", j.IsPrepareToShipEnabled)
	populate(objectMap, "isShippingAddressEditable", j.IsShippingAddressEditable)
	populate(objectMap, "reverseShippingDetailsUpdate", j.ReverseShippingDetailsUpdate)
	populate(objectMap, "reverseTransportPreferenceUpdate", j.ReverseTransportPreferenceUpdate)
	populateDateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "transferType", j.TransferType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cancellationReason":
			err = unpopulate(val, "CancellationReason", &j.CancellationReason)
			delete(rawMsg, key)
		case "deliveryInfo":
			err = unpopulate(val, "DeliveryInfo", &j.DeliveryInfo)
			delete(rawMsg, key)
		case "deliveryType":
			err = unpopulate(val, "DeliveryType", &j.DeliveryType)
			delete(rawMsg, key)
		case "details":
			j.Details, err = unmarshalCommonJobDetailsClassification(val)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &j.IsCancellable)
			delete(rawMsg, key)
		case "isCancellableWithoutFee":
			err = unpopulate(val, "IsCancellableWithoutFee", &j.IsCancellableWithoutFee)
			delete(rawMsg, key)
		case "isDeletable":
			err = unpopulate(val, "IsDeletable", &j.IsDeletable)
			delete(rawMsg, key)
		case "isPrepareToShipEnabled":
			err = unpopulate(val, "IsPrepareToShipEnabled", &j.IsPrepareToShipEnabled)
			delete(rawMsg, key)
		case "isShippingAddressEditable":
			err = unpopulate(val, "IsShippingAddressEditable", &j.IsShippingAddressEditable)
			delete(rawMsg, key)
		case "reverseShippingDetailsUpdate":
			err = unpopulate(val, "ReverseShippingDetailsUpdate", &j.ReverseShippingDetailsUpdate)
			delete(rawMsg, key)
		case "reverseTransportPreferenceUpdate":
			err = unpopulate(val, "ReverseTransportPreferenceUpdate", &j.ReverseTransportPreferenceUpdate)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &j.TransferType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobResource.
func (j JobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "identity", j.Identity)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "sku", j.SKU)
	populate(objectMap, "systemData", j.SystemData)
	populate(objectMap, "tags", j.Tags)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobResource.
func (j *JobResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &j.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &j.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &j.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &j.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &j.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobResourceList.
func (j JobResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobResourceList.
func (j *JobResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobResourceUpdateParameter.
func (j JobResourceUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", j.Identity)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "tags", j.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobResourceUpdateParameter.
func (j *JobResourceUpdateParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &j.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &j.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobSecrets.
func (j JobSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dcAccessSecurityCode", j.DcAccessSecurityCode)
	populate(objectMap, "error", j.Error)
	objectMap["jobSecretsType"] = ClassDiscriminatorDataBox
	populate(objectMap, "podSecrets", j.PodSecrets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobSecrets.
func (j *JobSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dcAccessSecurityCode":
			err = unpopulate(val, "DcAccessSecurityCode", &j.DcAccessSecurityCode)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "jobSecretsType":
			err = unpopulate(val, "JobSecretsType", &j.JobSecretsType)
			delete(rawMsg, key)
		case "podSecrets":
			err = unpopulate(val, "PodSecrets", &j.PodSecrets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStages.
func (j JobStages) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", j.DisplayName)
	populateAny(objectMap, "jobStageDetails", j.JobStageDetails)
	populate(objectMap, "stageName", j.StageName)
	populate(objectMap, "stageStatus", j.StageStatus)
	populateDateTimeRFC3339(objectMap, "stageTime", j.StageTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStages.
func (j *JobStages) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &j.DisplayName)
			delete(rawMsg, key)
		case "jobStageDetails":
			err = unpopulate(val, "JobStageDetails", &j.JobStageDetails)
			delete(rawMsg, key)
		case "stageName":
			err = unpopulate(val, "StageName", &j.StageName)
			delete(rawMsg, key)
		case "stageStatus":
			err = unpopulate(val, "StageStatus", &j.StageStatus)
			delete(rawMsg, key)
		case "stageTime":
			err = unpopulateDateTimeRFC3339(val, "StageTime", &j.StageTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyEncryptionKey.
func (k KeyEncryptionKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identityProperties", k.IdentityProperties)
	populate(objectMap, "kekType", k.KekType)
	populate(objectMap, "kekUrl", k.KekURL)
	populate(objectMap, "kekVaultResourceID", k.KekVaultResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyEncryptionKey.
func (k *KeyEncryptionKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityProperties":
			err = unpopulate(val, "IdentityProperties", &k.IdentityProperties)
			delete(rawMsg, key)
		case "kekType":
			err = unpopulate(val, "KekType", &k.KekType)
			delete(rawMsg, key)
		case "kekUrl":
			err = unpopulate(val, "KekURL", &k.KekURL)
			delete(rawMsg, key)
		case "kekVaultResourceID":
			err = unpopulate(val, "KekVaultResourceID", &k.KekVaultResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LastMitigationActionOnJob.
func (l LastMitigationActionOnJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "actionDateTimeInUtc", l.ActionDateTimeInUTC)
	populate(objectMap, "customerResolution", l.CustomerResolution)
	populate(objectMap, "isPerformedByCustomer", l.IsPerformedByCustomer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LastMitigationActionOnJob.
func (l *LastMitigationActionOnJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionDateTimeInUtc":
			err = unpopulateDateTimeRFC3339(val, "ActionDateTimeInUTC", &l.ActionDateTimeInUTC)
			delete(rawMsg, key)
		case "customerResolution":
			err = unpopulate(val, "CustomerResolution", &l.CustomerResolution)
			delete(rawMsg, key)
		case "isPerformedByCustomer":
			err = unpopulate(val, "IsPerformedByCustomer", &l.IsPerformedByCustomer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedDiskDetails.
func (m ManagedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["dataAccountType"] = DataAccountTypeManagedDisk
	populate(objectMap, "resourceGroupId", m.ResourceGroupID)
	populate(objectMap, "sharePassword", m.SharePassword)
	populate(objectMap, "stagingStorageAccountId", m.StagingStorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedDiskDetails.
func (m *ManagedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &m.DataAccountType)
			delete(rawMsg, key)
		case "resourceGroupId":
			err = unpopulate(val, "ResourceGroupID", &m.ResourceGroupID)
			delete(rawMsg, key)
		case "sharePassword":
			err = unpopulate(val, "SharePassword", &m.SharePassword)
			delete(rawMsg, key)
		case "stagingStorageAccountId":
			err = unpopulate(val, "StagingStorageAccountID", &m.StagingStorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MarkDevicesShippedRequest.
func (m MarkDevicesShippedRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deliverToDcPackageDetails", m.DeliverToDcPackageDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MarkDevicesShippedRequest.
func (m *MarkDevicesShippedRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deliverToDcPackageDetails":
			err = unpopulate(val, "DeliverToDcPackageDetails", &m.DeliverToDcPackageDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MitigateJobRequest.
func (m MitigateJobRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customerResolutionCode", m.CustomerResolutionCode)
	populate(objectMap, "serialNumberCustomerResolutionMap", m.SerialNumberCustomerResolutionMap)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MitigateJobRequest.
func (m *MitigateJobRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customerResolutionCode":
			err = unpopulate(val, "CustomerResolutionCode", &m.CustomerResolutionCode)
			delete(rawMsg, key)
		case "serialNumberCustomerResolutionMap":
			err = unpopulate(val, "SerialNumberCustomerResolutionMap", &m.SerialNumberCustomerResolutionMap)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationPreference.
func (n NotificationPreference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sendNotification", n.SendNotification)
	populate(objectMap, "stageName", n.StageName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationPreference.
func (n *NotificationPreference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sendNotification":
			err = unpopulate(val, "SendNotification", &n.SendNotification)
			delete(rawMsg, key)
		case "stageName":
			err = unpopulate(val, "StageName", &n.StageName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationList.
func (o OperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationList.
func (o *OperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageCarrierDetails.
func (p PackageCarrierDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "carrierAccountNumber", p.CarrierAccountNumber)
	populate(objectMap, "carrierName", p.CarrierName)
	populate(objectMap, "trackingId", p.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageCarrierDetails.
func (p *PackageCarrierDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "carrierAccountNumber":
			err = unpopulate(val, "CarrierAccountNumber", &p.CarrierAccountNumber)
			delete(rawMsg, key)
		case "carrierName":
			err = unpopulate(val, "CarrierName", &p.CarrierName)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &p.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageCarrierInfo.
func (p PackageCarrierInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "carrierName", p.CarrierName)
	populate(objectMap, "trackingId", p.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageCarrierInfo.
func (p *PackageCarrierInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "carrierName":
			err = unpopulate(val, "CarrierName", &p.CarrierName)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &p.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageShippingDetails.
func (p PackageShippingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "carrierName", p.CarrierName)
	populate(objectMap, "trackingId", p.TrackingID)
	populate(objectMap, "trackingUrl", p.TrackingURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageShippingDetails.
func (p *PackageShippingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "carrierName":
			err = unpopulate(val, "CarrierName", &p.CarrierName)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &p.TrackingID)
			delete(rawMsg, key)
		case "trackingUrl":
			err = unpopulate(val, "TrackingURL", &p.TrackingURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Preferences.
func (p Preferences) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionPreferences", p.EncryptionPreferences)
	populate(objectMap, "preferredDataCenterRegion", p.PreferredDataCenterRegion)
	populate(objectMap, "reverseTransportPreferences", p.ReverseTransportPreferences)
	populate(objectMap, "storageAccountAccessTierPreferences", p.StorageAccountAccessTierPreferences)
	populate(objectMap, "transportPreferences", p.TransportPreferences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Preferences.
func (p *Preferences) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionPreferences":
			err = unpopulate(val, "EncryptionPreferences", &p.EncryptionPreferences)
			delete(rawMsg, key)
		case "preferredDataCenterRegion":
			err = unpopulate(val, "PreferredDataCenterRegion", &p.PreferredDataCenterRegion)
			delete(rawMsg, key)
		case "reverseTransportPreferences":
			err = unpopulate(val, "ReverseTransportPreferences", &p.ReverseTransportPreferences)
			delete(rawMsg, key)
		case "storageAccountAccessTierPreferences":
			err = unpopulate(val, "StorageAccountAccessTierPreferences", &p.StorageAccountAccessTierPreferences)
			delete(rawMsg, key)
		case "transportPreferences":
			err = unpopulate(val, "TransportPreferences", &p.TransportPreferences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PreferencesValidationRequest.
func (p PreferencesValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceType", p.DeviceType)
	populate(objectMap, "preference", p.Preference)
	objectMap["validationType"] = ValidationInputDiscriminatorValidatePreferences
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreferencesValidationRequest.
func (p *PreferencesValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &p.DeviceType)
			delete(rawMsg, key)
		case "preference":
			err = unpopulate(val, "Preference", &p.Preference)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &p.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PreferencesValidationResponseProperties.
func (p PreferencesValidationResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", p.Error)
	populate(objectMap, "status", p.Status)
	objectMap["validationType"] = ValidationInputDiscriminatorValidatePreferences
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreferencesValidationResponseProperties.
func (p *PreferencesValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &p.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &p.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionConfigurationRequest.
func (r RegionConfigurationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datacenterAddressRequest", r.DatacenterAddressRequest)
	populate(objectMap, "scheduleAvailabilityRequest", r.ScheduleAvailabilityRequest)
	populate(objectMap, "transportAvailabilityRequest", r.TransportAvailabilityRequest)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionConfigurationRequest.
func (r *RegionConfigurationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datacenterAddressRequest":
			err = unpopulate(val, "DatacenterAddressRequest", &r.DatacenterAddressRequest)
			delete(rawMsg, key)
		case "scheduleAvailabilityRequest":
			r.ScheduleAvailabilityRequest, err = unmarshalCommonScheduleAvailabilityRequestClassification(val)
			delete(rawMsg, key)
		case "transportAvailabilityRequest":
			err = unpopulate(val, "TransportAvailabilityRequest", &r.TransportAvailabilityRequest)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionConfigurationResponse.
func (r RegionConfigurationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datacenterAddressResponse", r.DatacenterAddressResponse)
	populate(objectMap, "scheduleAvailabilityResponse", r.ScheduleAvailabilityResponse)
	populate(objectMap, "transportAvailabilityResponse", r.TransportAvailabilityResponse)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionConfigurationResponse.
func (r *RegionConfigurationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datacenterAddressResponse":
			r.DatacenterAddressResponse, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "scheduleAvailabilityResponse":
			err = unpopulate(val, "ScheduleAvailabilityResponse", &r.ScheduleAvailabilityResponse)
			delete(rawMsg, key)
		case "transportAvailabilityResponse":
			err = unpopulate(val, "TransportAvailabilityResponse", &r.TransportAvailabilityResponse)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &r.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceIdentity.
func (r ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "tenantId", r.TenantID)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "userAssignedIdentities", r.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceIdentity.
func (r *ResourceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &r.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReverseShippingDetails.
func (r ReverseShippingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contactDetails", r.ContactDetails)
	populate(objectMap, "isUpdated", r.IsUpdated)
	populate(objectMap, "shippingAddress", r.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReverseShippingDetails.
func (r *ReverseShippingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &r.ContactDetails)
			delete(rawMsg, key)
		case "isUpdated":
			err = unpopulate(val, "IsUpdated", &r.IsUpdated)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &r.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "family", s.Family)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &s.Family)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUAvailabilityValidationRequest.
func (s SKUAvailabilityValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "country", s.Country)
	populate(objectMap, "deviceType", s.DeviceType)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "transferType", s.TransferType)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateSKUAvailability
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUAvailabilityValidationRequest.
func (s *SKUAvailabilityValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &s.Country)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &s.DeviceType)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &s.TransferType)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &s.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUAvailabilityValidationResponseProperties.
func (s SKUAvailabilityValidationResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", s.Error)
	populate(objectMap, "status", s.Status)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateSKUAvailability
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUAvailabilityValidationResponseProperties.
func (s *SKUAvailabilityValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &s.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapacity.
func (s SKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maximum", s.Maximum)
	populate(objectMap, "usable", s.Usable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapacity.
func (s *SKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maximum":
			err = unpopulate(val, "Maximum", &s.Maximum)
			delete(rawMsg, key)
		case "usable":
			err = unpopulate(val, "Usable", &s.Usable)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCost.
func (s SKUCost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "meterId", s.MeterID)
	populate(objectMap, "meterType", s.MeterType)
	populate(objectMap, "multiplier", s.Multiplier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCost.
func (s *SKUCost) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "meterId":
			err = unpopulate(val, "MeterID", &s.MeterID)
			delete(rawMsg, key)
		case "meterType":
			err = unpopulate(val, "MeterType", &s.MeterType)
			delete(rawMsg, key)
		case "multiplier":
			err = unpopulate(val, "Multiplier", &s.Multiplier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUInformation.
func (s SKUInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUInformation.
func (s *SKUInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUProperties.
func (s SKUProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersions", s.APIVersions)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "costs", s.Costs)
	populate(objectMap, "countriesWithinCommerceBoundary", s.CountriesWithinCommerceBoundary)
	populate(objectMap, "dataLocationToServiceLocationMap", s.DataLocationToServiceLocationMap)
	populate(objectMap, "disabledReason", s.DisabledReason)
	populate(objectMap, "disabledReasonMessage", s.DisabledReasonMessage)
	populate(objectMap, "requiredFeature", s.RequiredFeature)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUProperties.
func (s *SKUProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersions":
			err = unpopulate(val, "APIVersions", &s.APIVersions)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "costs":
			err = unpopulate(val, "Costs", &s.Costs)
			delete(rawMsg, key)
		case "countriesWithinCommerceBoundary":
			err = unpopulate(val, "CountriesWithinCommerceBoundary", &s.CountriesWithinCommerceBoundary)
			delete(rawMsg, key)
		case "dataLocationToServiceLocationMap":
			err = unpopulate(val, "DataLocationToServiceLocationMap", &s.DataLocationToServiceLocationMap)
			delete(rawMsg, key)
		case "disabledReason":
			err = unpopulate(val, "DisabledReason", &s.DisabledReason)
			delete(rawMsg, key)
		case "disabledReasonMessage":
			err = unpopulate(val, "DisabledReasonMessage", &s.DisabledReasonMessage)
			delete(rawMsg, key)
		case "requiredFeature":
			err = unpopulate(val, "RequiredFeature", &s.RequiredFeature)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleAvailabilityRequest.
func (s ScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "country", s.Country)
	objectMap["skuName"] = SKUNameDataBox
	populate(objectMap, "storageLocation", s.StorageLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleAvailabilityRequest.
func (s *ScheduleAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &s.Country)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &s.SKUName)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &s.StorageLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleAvailabilityResponse.
func (s ScheduleAvailabilityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	aux := make([]*dateTimeRFC3339, len(s.AvailableDates), len(s.AvailableDates))
	for i := 0; i < len(s.AvailableDates); i++ {
		aux[i] = (*dateTimeRFC3339)(s.AvailableDates[i])
	}
	populate(objectMap, "availableDates", aux)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleAvailabilityResponse.
func (s *ScheduleAvailabilityResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableDates":
			var aux []*dateTimeRFC3339
			err = unpopulate(val, "AvailableDates", &aux)
			for _, au := range aux {
				s.AvailableDates = append(s.AvailableDates, (*time.Time)(au))
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountCredentialDetails", s.AccountCredentialDetails)
	populate(objectMap, "devicePassword", s.DevicePassword)
	populate(objectMap, "deviceSerialNumber", s.DeviceSerialNumber)
	populate(objectMap, "encodedValidationCertPubKey", s.EncodedValidationCertPubKey)
	populate(objectMap, "networkConfigurations", s.NetworkConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Secret.
func (s *Secret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountCredentialDetails":
			err = unpopulate(val, "AccountCredentialDetails", &s.AccountCredentialDetails)
			delete(rawMsg, key)
		case "devicePassword":
			err = unpopulate(val, "DevicePassword", &s.DevicePassword)
			delete(rawMsg, key)
		case "deviceSerialNumber":
			err = unpopulate(val, "DeviceSerialNumber", &s.DeviceSerialNumber)
			delete(rawMsg, key)
		case "encodedValidationCertPubKey":
			err = unpopulate(val, "EncodedValidationCertPubKey", &s.EncodedValidationCertPubKey)
			delete(rawMsg, key)
		case "networkConfigurations":
			err = unpopulate(val, "NetworkConfigurations", &s.NetworkConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShareCredentialDetails.
func (s ShareCredentialDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", s.Password)
	populate(objectMap, "shareName", s.ShareName)
	populate(objectMap, "shareType", s.ShareType)
	populate(objectMap, "supportedAccessProtocols", s.SupportedAccessProtocols)
	populate(objectMap, "userName", s.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShareCredentialDetails.
func (s *ShareCredentialDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &s.Password)
			delete(rawMsg, key)
		case "shareName":
			err = unpopulate(val, "ShareName", &s.ShareName)
			delete(rawMsg, key)
		case "shareType":
			err = unpopulate(val, "ShareType", &s.ShareType)
			delete(rawMsg, key)
		case "supportedAccessProtocols":
			err = unpopulate(val, "SupportedAccessProtocols", &s.SupportedAccessProtocols)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &s.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShipmentPickUpRequest.
func (s ShipmentPickUpRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "shipmentLocation", s.ShipmentLocation)
	populateDateTimeRFC3339(objectMap, "startTime", s.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShipmentPickUpRequest.
func (s *ShipmentPickUpRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "shipmentLocation":
			err = unpopulate(val, "ShipmentLocation", &s.ShipmentLocation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShipmentPickUpResponse.
func (s ShipmentPickUpResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "confirmationNumber", s.ConfirmationNumber)
	populateDateTimeRFC3339(objectMap, "readyByTime", s.ReadyByTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShipmentPickUpResponse.
func (s *ShipmentPickUpResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "confirmationNumber":
			err = unpopulate(val, "ConfirmationNumber", &s.ConfirmationNumber)
			delete(rawMsg, key)
		case "readyByTime":
			err = unpopulateDateTimeRFC3339(val, "ReadyByTime", &s.ReadyByTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShippingAddress.
func (s ShippingAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressType", s.AddressType)
	populate(objectMap, "city", s.City)
	populate(objectMap, "companyName", s.CompanyName)
	populate(objectMap, "country", s.Country)
	populate(objectMap, "postalCode", s.PostalCode)
	populate(objectMap, "skipAddressValidation", s.SkipAddressValidation)
	populate(objectMap, "stateOrProvince", s.StateOrProvince)
	populate(objectMap, "streetAddress1", s.StreetAddress1)
	populate(objectMap, "streetAddress2", s.StreetAddress2)
	populate(objectMap, "streetAddress3", s.StreetAddress3)
	populate(objectMap, "taxIdentificationNumber", s.TaxIdentificationNumber)
	populate(objectMap, "zipExtendedCode", s.ZipExtendedCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShippingAddress.
func (s *ShippingAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressType":
			err = unpopulate(val, "AddressType", &s.AddressType)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &s.City)
			delete(rawMsg, key)
		case "companyName":
			err = unpopulate(val, "CompanyName", &s.CompanyName)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &s.Country)
			delete(rawMsg, key)
		case "postalCode":
			err = unpopulate(val, "PostalCode", &s.PostalCode)
			delete(rawMsg, key)
		case "skipAddressValidation":
			err = unpopulate(val, "SkipAddressValidation", &s.SkipAddressValidation)
			delete(rawMsg, key)
		case "stateOrProvince":
			err = unpopulate(val, "StateOrProvince", &s.StateOrProvince)
			delete(rawMsg, key)
		case "streetAddress1":
			err = unpopulate(val, "StreetAddress1", &s.StreetAddress1)
			delete(rawMsg, key)
		case "streetAddress2":
			err = unpopulate(val, "StreetAddress2", &s.StreetAddress2)
			delete(rawMsg, key)
		case "streetAddress3":
			err = unpopulate(val, "StreetAddress3", &s.StreetAddress3)
			delete(rawMsg, key)
		case "taxIdentificationNumber":
			err = unpopulate(val, "TaxIdentificationNumber", &s.TaxIdentificationNumber)
			delete(rawMsg, key)
		case "zipExtendedCode":
			err = unpopulate(val, "ZipExtendedCode", &s.ZipExtendedCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccountDetails.
func (s StorageAccountDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["dataAccountType"] = DataAccountTypeStorageAccount
	populate(objectMap, "sharePassword", s.SharePassword)
	populate(objectMap, "storageAccountId", s.StorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccountDetails.
func (s *StorageAccountDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &s.DataAccountType)
			delete(rawMsg, key)
		case "sharePassword":
			err = unpopulate(val, "SharePassword", &s.SharePassword)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &s.StorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionIsAllowedToCreateJobValidationRequest.
func (s SubscriptionIsAllowedToCreateJobValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateSubscriptionIsAllowedToCreateJob
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionIsAllowedToCreateJobValidationRequest.
func (s *SubscriptionIsAllowedToCreateJobValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "validationType":
			err = unpopulate(val, "ValidationType", &s.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (s SubscriptionIsAllowedToCreateJobValidationResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", s.Error)
	populate(objectMap, "status", s.Status)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateSubscriptionIsAllowedToCreateJob
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (s *SubscriptionIsAllowedToCreateJobValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &s.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferAllDetails.
func (t TransferAllDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataAccountType", t.DataAccountType)
	populate(objectMap, "transferAllBlobs", t.TransferAllBlobs)
	populate(objectMap, "transferAllFiles", t.TransferAllFiles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferAllDetails.
func (t *TransferAllDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &t.DataAccountType)
			delete(rawMsg, key)
		case "transferAllBlobs":
			err = unpopulate(val, "TransferAllBlobs", &t.TransferAllBlobs)
			delete(rawMsg, key)
		case "transferAllFiles":
			err = unpopulate(val, "TransferAllFiles", &t.TransferAllFiles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferConfiguration.
func (t TransferConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "transferAllDetails", t.TransferAllDetails)
	populate(objectMap, "transferConfigurationType", t.TransferConfigurationType)
	populate(objectMap, "transferFilterDetails", t.TransferFilterDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferConfiguration.
func (t *TransferConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "transferAllDetails":
			err = unpopulate(val, "TransferAllDetails", &t.TransferAllDetails)
			delete(rawMsg, key)
		case "transferConfigurationType":
			err = unpopulate(val, "TransferConfigurationType", &t.TransferConfigurationType)
			delete(rawMsg, key)
		case "transferFilterDetails":
			err = unpopulate(val, "TransferFilterDetails", &t.TransferFilterDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferConfigurationTransferAllDetails.
func (t TransferConfigurationTransferAllDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "include", t.Include)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferConfigurationTransferAllDetails.
func (t *TransferConfigurationTransferAllDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "include":
			err = unpopulate(val, "Include", &t.Include)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferConfigurationTransferFilterDetails.
func (t TransferConfigurationTransferFilterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "include", t.Include)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferConfigurationTransferFilterDetails.
func (t *TransferConfigurationTransferFilterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "include":
			err = unpopulate(val, "Include", &t.Include)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferFilterDetails.
func (t TransferFilterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFileFilterDetails", t.AzureFileFilterDetails)
	populate(objectMap, "blobFilterDetails", t.BlobFilterDetails)
	populate(objectMap, "dataAccountType", t.DataAccountType)
	populate(objectMap, "filterFileDetails", t.FilterFileDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferFilterDetails.
func (t *TransferFilterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFileFilterDetails":
			err = unpopulate(val, "AzureFileFilterDetails", &t.AzureFileFilterDetails)
			delete(rawMsg, key)
		case "blobFilterDetails":
			err = unpopulate(val, "BlobFilterDetails", &t.BlobFilterDetails)
			delete(rawMsg, key)
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &t.DataAccountType)
			delete(rawMsg, key)
		case "filterFileDetails":
			err = unpopulate(val, "FilterFileDetails", &t.FilterFileDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransportAvailabilityDetails.
func (t TransportAvailabilityDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "shipmentType", t.ShipmentType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransportAvailabilityDetails.
func (t *TransportAvailabilityDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "shipmentType":
			err = unpopulate(val, "ShipmentType", &t.ShipmentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransportAvailabilityRequest.
func (t TransportAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skuName", t.SKUName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransportAvailabilityRequest.
func (t *TransportAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skuName":
			err = unpopulate(val, "SKUName", &t.SKUName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransportAvailabilityResponse.
func (t TransportAvailabilityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "transportAvailabilityDetails", t.TransportAvailabilityDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransportAvailabilityResponse.
func (t *TransportAvailabilityResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "transportAvailabilityDetails":
			err = unpopulate(val, "TransportAvailabilityDetails", &t.TransportAvailabilityDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransportPreferences.
func (t TransportPreferences) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isUpdated", t.IsUpdated)
	populate(objectMap, "preferredShipmentType", t.PreferredShipmentType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransportPreferences.
func (t *TransportPreferences) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isUpdated":
			err = unpopulate(val, "IsUpdated", &t.IsUpdated)
			delete(rawMsg, key)
		case "preferredShipmentType":
			err = unpopulate(val, "PreferredShipmentType", &t.PreferredShipmentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnencryptedCredentials.
func (u UnencryptedCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobName", u.JobName)
	populate(objectMap, "jobSecrets", u.JobSecrets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnencryptedCredentials.
func (u *UnencryptedCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobName":
			err = unpopulate(val, "JobName", &u.JobName)
			delete(rawMsg, key)
		case "jobSecrets":
			u.JobSecrets, err = unmarshalCommonJobSecretsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnencryptedCredentialsList.
func (u UnencryptedCredentialsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnencryptedCredentialsList.
func (u *UnencryptedCredentialsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateJobDetails.
func (u UpdateJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contactDetails", u.ContactDetails)
	populate(objectMap, "keyEncryptionKey", u.KeyEncryptionKey)
	populate(objectMap, "preferences", u.Preferences)
	populate(objectMap, "returnToCustomerPackageDetails", u.ReturnToCustomerPackageDetails)
	populate(objectMap, "reverseShippingDetails", u.ReverseShippingDetails)
	populate(objectMap, "shippingAddress", u.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateJobDetails.
func (u *UpdateJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &u.ContactDetails)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &u.KeyEncryptionKey)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &u.Preferences)
			delete(rawMsg, key)
		case "returnToCustomerPackageDetails":
			err = unpopulate(val, "ReturnToCustomerPackageDetails", &u.ReturnToCustomerPackageDetails)
			delete(rawMsg, key)
		case "reverseShippingDetails":
			err = unpopulate(val, "ReverseShippingDetails", &u.ReverseShippingDetails)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &u.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateJobProperties.
func (u UpdateJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", u.Details)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateJobProperties.
func (u *UpdateJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &u.Details)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedProperties.
func (u UserAssignedProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceId", u.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedProperties.
func (u *UserAssignedProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceId":
			err = unpopulate(val, "ResourceID", &u.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateAddress.
func (v ValidateAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceType", v.DeviceType)
	populate(objectMap, "shippingAddress", v.ShippingAddress)
	populate(objectMap, "transportPreferences", v.TransportPreferences)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateAddress
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateAddress.
func (v *ValidateAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &v.DeviceType)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &v.ShippingAddress)
			delete(rawMsg, key)
		case "transportPreferences":
			err = unpopulate(val, "TransportPreferences", &v.TransportPreferences)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &v.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationInputRequest.
func (v ValidationInputRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["validationType"] = v.ValidationType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationInputRequest.
func (v *ValidationInputRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "validationType":
			err = unpopulate(val, "ValidationType", &v.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationInputResponse.
func (v ValidationInputResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", v.Error)
	objectMap["validationType"] = v.ValidationType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationInputResponse.
func (v *ValidationInputResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &v.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationRequest.
func (v ValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "individualRequestDetails", v.IndividualRequestDetails)
	objectMap["validationCategory"] = v.ValidationCategory
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationRequest.
func (v *ValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "individualRequestDetails":
			v.IndividualRequestDetails, err = unmarshalValidationInputRequestClassificationArray(val)
			delete(rawMsg, key)
		case "validationCategory":
			err = unpopulate(val, "ValidationCategory", &v.ValidationCategory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationResponse.
func (v ValidationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationResponse.
func (v *ValidationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationResponseProperties.
func (v ValidationResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "individualResponseDetails", v.IndividualResponseDetails)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationResponseProperties.
func (v *ValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "individualResponseDetails":
			v.IndividualResponseDetails, err = unmarshalValidationInputResponseClassificationArray(val)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
