# Release History

## 2.4.0 (2023-11-24)
### Features Added

- Support for test fakes and OpenTelemetry trace spans.


## 2.3.0 (2023-04-28)
### Features Added

- New value `ContainerGroupSKUConfidential` added to enum type `ContainerGroupSKU`
- New enum type `ContainerGroupPriority` with values `ContainerGroupPriorityRegular`, `ContainerGroupPrioritySpot`
- New struct `ConfidentialComputeProperties`
- New struct `SecurityContextCapabilitiesDefinition`
- New struct `SecurityContextDefinition`
- New field `ConfidentialComputeProperties`, `Priority` in struct `ContainerGroupPropertiesProperties`
- New field `SecurityContext` in struct `ContainerProperties`
- New field `SecurityContext` in struct `InitContainerPropertiesDefinition`


## 2.2.1 (2023-04-18)
### Bug Fixes

- Fix serialization bug of empty value of `any` type.


## 2.2.0 (2023-04-07)
### Features Added

- New struct `ClientFactory` which is a client factory used to create any client in this module


## 2.1.0 (2022-11-08)
### Features Added

- New struct `DeploymentExtensionSpec`
- New struct `DeploymentExtensionSpecProperties`
- New field `Extensions` in struct `ContainerGroupPropertiesProperties`
- New field `Identity` in struct `EncryptionProperties`


## 2.0.0 (2022-08-26)
### Breaking Changes

- Type of `ContainerGroup.Properties` has been changed from `*ContainerGroupProperties` to `*ContainerGroupPropertiesProperties`
- Type of `ContainerGroupIdentity.UserAssignedIdentities` has been changed from `map[string]*Components10Wh5UdSchemasContainergroupidentityPropertiesUserassignedidentitiesAdditionalproperties` to `map[string]*UserAssignedIdentities`
- Const `AutoGeneratedDomainNameLabelScopeResourceGroupReuse` has been removed
- Const `AutoGeneratedDomainNameLabelScopeSubscriptionReuse` has been removed
- Const `AutoGeneratedDomainNameLabelScopeNoreuse` has been removed
- Const `AutoGeneratedDomainNameLabelScopeTenantReuse` has been removed
- Const `AutoGeneratedDomainNameLabelScopeUnsecure` has been removed
- Type alias `AutoGeneratedDomainNameLabelScope` has been removed
- Function `PossibleAutoGeneratedDomainNameLabelScopeValues` has been removed
- Struct `Components10Wh5UdSchemasContainergroupidentityPropertiesUserassignedidentitiesAdditionalproperties` has been removed
- Field `DNSNameLabelReusePolicy` of struct `IPAddress` has been removed
- Field `Containers` of struct `ContainerGroupProperties` has been removed
- Field `SubnetIDs` of struct `ContainerGroupProperties` has been removed
- Field `RestartPolicy` of struct `ContainerGroupProperties` has been removed
- Field `Volumes` of struct `ContainerGroupProperties` has been removed
- Field `ProvisioningState` of struct `ContainerGroupProperties` has been removed
- Field `Diagnostics` of struct `ContainerGroupProperties` has been removed
- Field `SKU` of struct `ContainerGroupProperties` has been removed
- Field `InstanceView` of struct `ContainerGroupProperties` has been removed
- Field `OSType` of struct `ContainerGroupProperties` has been removed
- Field `EncryptionProperties` of struct `ContainerGroupProperties` has been removed
- Field `InitContainers` of struct `ContainerGroupProperties` has been removed
- Field `DNSConfig` of struct `ContainerGroupProperties` has been removed
- Field `IPAddress` of struct `ContainerGroupProperties` has been removed
- Field `ImageRegistryCredentials` of struct `ContainerGroupProperties` has been removed

### Features Added

- New const `DNSNameLabelReusePolicyNoreuse`
- New const `DNSNameLabelReusePolicyUnsecure`
- New const `DNSNameLabelReusePolicySubscriptionReuse`
- New const `DNSNameLabelReusePolicyTenantReuse`
- New const `DNSNameLabelReusePolicyResourceGroupReuse`
- New type alias `DNSNameLabelReusePolicy`
- New function `*SubnetServiceAssociationLinkClient.BeginDelete(context.Context, string, string, string, *SubnetServiceAssociationLinkClientBeginDeleteOptions) (*runtime.Poller[SubnetServiceAssociationLinkClientDeleteResponse], error)`
- New function `NewSubnetServiceAssociationLinkClient(string, azcore.TokenCredential, *arm.ClientOptions) (*SubnetServiceAssociationLinkClient, error)`
- New function `PossibleDNSNameLabelReusePolicyValues() []DNSNameLabelReusePolicy`
- New struct `ContainerGroupPropertiesProperties`
- New struct `SubnetServiceAssociationLinkClient`
- New struct `SubnetServiceAssociationLinkClientBeginDeleteOptions`
- New struct `SubnetServiceAssociationLinkClientDeleteResponse`
- New struct `UserAssignedIdentities`
- New field `Properties` in struct `ContainerGroupProperties`
- New field `Identity` in struct `ContainerGroupProperties`
- New field `ID` in struct `Usage`
- New field `AutoGeneratedDomainNameLabelScope` in struct `IPAddress`


## 1.0.0 (2022-05-17)

The package of `github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerinstance/armcontainerinstance` is using our [next generation design principles](https://azure.github.io/azure-sdk/general_introduction.html) since version 1.0.0, which contains breaking changes.

To migrate the existing applications to the latest version, please refer to [Migration Guide](https://aka.ms/azsdk/go/mgmt/migration).

To learn more, please refer to our documentation [Quick Start](https://aka.ms/azsdk/go/mgmt).