//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// UsageDetailsServer is a fake server for instances of the armconsumption.UsageDetailsClient type.
type UsageDetailsServer struct {
	// NewListPager is the fake for method UsageDetailsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	NewListPager func(scope string, options *armconsumption.UsageDetailsClientListOptions) (resp azfake.PagerResponder[armconsumption.UsageDetailsClientListResponse])
}

// NewUsageDetailsServerTransport creates a new instance of UsageDetailsServerTransport with the provided implementation.
// The returned UsageDetailsServerTransport instance is connected to an instance of armconsumption.UsageDetailsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUsageDetailsServerTransport(srv *UsageDetailsServer) *UsageDetailsServerTransport {
	return &UsageDetailsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armconsumption.UsageDetailsClientListResponse]](),
	}
}

// UsageDetailsServerTransport connects instances of armconsumption.UsageDetailsClient to instances of UsageDetailsServer.
// Don't use this type directly, use NewUsageDetailsServerTransport instead.
type UsageDetailsServerTransport struct {
	srv          *UsageDetailsServer
	newListPager *tracker[azfake.PagerResponder[armconsumption.UsageDetailsClientListResponse]]
}

// Do implements the policy.Transporter interface for UsageDetailsServerTransport.
func (u *UsageDetailsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UsageDetailsClient.NewListPager":
		resp, err = u.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UsageDetailsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if u.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := u.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/usageDetails`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		metricUnescaped, err := url.QueryUnescape(qp.Get("metric"))
		if err != nil {
			return nil, err
		}
		metricParam := getOptional(armconsumption.Metrictype(metricUnescaped))
		var options *armconsumption.UsageDetailsClientListOptions
		if expandParam != nil || filterParam != nil || skiptokenParam != nil || topParam != nil || metricParam != nil {
			options = &armconsumption.UsageDetailsClientListOptions{
				Expand:    expandParam,
				Filter:    filterParam,
				Skiptoken: skiptokenParam,
				Top:       topParam,
				Metric:    metricParam,
			}
		}
		resp := u.srv.NewListPager(scopeParam, options)
		newListPager = &resp
		u.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armconsumption.UsageDetailsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK, http.StatusNoContent}, resp.StatusCode) {
		u.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		u.newListPager.remove(req)
	}
	return resp, nil
}
