//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/commerce/armcommerce"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
	"time"
)

// UsageAggregatesServer is a fake server for instances of the armcommerce.UsageAggregatesClient type.
type UsageAggregatesServer struct {
	// NewListPager is the fake for method UsageAggregatesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(reportedStartTime time.Time, reportedEndTime time.Time, options *armcommerce.UsageAggregatesClientListOptions) (resp azfake.PagerResponder[armcommerce.UsageAggregatesClientListResponse])
}

// NewUsageAggregatesServerTransport creates a new instance of UsageAggregatesServerTransport with the provided implementation.
// The returned UsageAggregatesServerTransport instance is connected to an instance of armcommerce.UsageAggregatesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUsageAggregatesServerTransport(srv *UsageAggregatesServer) *UsageAggregatesServerTransport {
	return &UsageAggregatesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armcommerce.UsageAggregatesClientListResponse]](),
	}
}

// UsageAggregatesServerTransport connects instances of armcommerce.UsageAggregatesClient to instances of UsageAggregatesServer.
// Don't use this type directly, use NewUsageAggregatesServerTransport instead.
type UsageAggregatesServerTransport struct {
	srv          *UsageAggregatesServer
	newListPager *tracker[azfake.PagerResponder[armcommerce.UsageAggregatesClientListResponse]]
}

// Do implements the policy.Transporter interface for UsageAggregatesServerTransport.
func (u *UsageAggregatesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UsageAggregatesClient.NewListPager":
		resp, err = u.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UsageAggregatesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if u.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := u.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Commerce/UsageAggregates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		reportedStartTimeUnescaped, err := url.QueryUnescape(qp.Get("reportedStartTime"))
		if err != nil {
			return nil, err
		}
		reportedStartTimeParam, err := time.Parse(time.RFC3339Nano, reportedStartTimeUnescaped)
		if err != nil {
			return nil, err
		}
		reportedEndTimeUnescaped, err := url.QueryUnescape(qp.Get("reportedEndTime"))
		if err != nil {
			return nil, err
		}
		reportedEndTimeParam, err := time.Parse(time.RFC3339Nano, reportedEndTimeUnescaped)
		if err != nil {
			return nil, err
		}
		showDetailsUnescaped, err := url.QueryUnescape(qp.Get("showDetails"))
		if err != nil {
			return nil, err
		}
		showDetailsParam, err := parseOptional(showDetailsUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		aggregationGranularityUnescaped, err := url.QueryUnescape(qp.Get("aggregationGranularity"))
		if err != nil {
			return nil, err
		}
		aggregationGranularityParam := getOptional(armcommerce.AggregationGranularity(aggregationGranularityUnescaped))
		continuationTokenUnescaped, err := url.QueryUnescape(qp.Get("continuationToken"))
		if err != nil {
			return nil, err
		}
		continuationTokenParam := getOptional(continuationTokenUnescaped)
		var options *armcommerce.UsageAggregatesClientListOptions
		if showDetailsParam != nil || aggregationGranularityParam != nil || continuationTokenParam != nil {
			options = &armcommerce.UsageAggregatesClientListOptions{
				ShowDetails:            showDetailsParam,
				AggregationGranularity: aggregationGranularityParam,
				ContinuationToken:      continuationTokenParam,
			}
		}
		resp := u.srv.NewListPager(reportedStartTimeParam, reportedEndTimeParam, options)
		newListPager = &resp
		u.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcommerce.UsageAggregatesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		u.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		u.newListPager.remove(req)
	}
	return resp, nil
}
