//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armbilling_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingSubscriptionsListByCustomer.json
func ExampleSubscriptionsClient_NewListByCustomerPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSubscriptionsClient().NewListByCustomerPager("{billingAccountName}", "{customerName}", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SubscriptionsListResult = armbilling.SubscriptionsListResult{
		// 	Value: []*armbilling.Subscription{
		// 		{
		// 			Name: to.Ptr("billingSubscriptionId1"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/billinSubscriptionId1"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				CustomerDisplayName: to.Ptr("Customer1"),
		// 				CustomerID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}"),
		// 				DisplayName: to.Ptr("My subscription"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](5000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](600),
		// 				},
		// 				Reseller: &armbilling.Reseller{
		// 					Description: to.Ptr("Reseller1"),
		// 					ResellerID: to.Ptr("89e87bdf-a2a2-4687-925f-4c18b27bccfd"),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan for DevTest"),
		// 				SKUID: to.Ptr("0002"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-f87744185aa3"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("billingSubscriptionId2"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/billinSubscriptionId2"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				CustomerDisplayName: to.Ptr("Customer1"),
		// 				CustomerID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}"),
		// 				DisplayName: to.Ptr("Test subscription"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](1000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](400),
		// 				},
		// 				Reseller: &armbilling.Reseller{
		// 					Description: to.Ptr("Reseller3"),
		// 					ResellerID: to.Ptr("3b65b5a8-bd4f-4084-90e9-e1bd667a2b19"),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan for DevTest"),
		// 				SKUID: to.Ptr("0002"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-6b96d3f2"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingSubscriptionsListByBillingAccount.json
func ExampleSubscriptionsClient_NewListByBillingAccountPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSubscriptionsClient().NewListByBillingAccountPager("{billingAccountName}", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SubscriptionsListResult = armbilling.SubscriptionsListResult{
		// 	Value: []*armbilling.Subscription{
		// 		{
		// 			Name: to.Ptr("90000000-0000-0000-0000-000000000000"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/90000000-0000-0000-0000-000000000000"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				DisplayName: to.Ptr("My subscription"),
		// 				InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
		// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/22000000-0000-0000-0000-000000000000"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](5000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](600),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 				SKUID: to.Ptr("0001"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-f87744185aa3"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("90000000-0000-0000-0000-000000000001"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/90000000-0000-0000-0000-000000000001"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				DisplayName: to.Ptr("Test subscription"),
		// 				InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
		// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/22000000-0000-0000-0000-000000000000"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](1000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](400),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 				SKUID: to.Ptr("0001"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-6b96d3f2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("90000000-0000-0000-0000-000000000002"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/90000000-0000-0000-0000-000000000002"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				DisplayName: to.Ptr("Dev Subscription"),
		// 				InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
		// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/22000000-0000-0000-0000-000000000000"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](6000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](900),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 				SKUID: to.Ptr("0001"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-4a9d-9008-912f-f87744185aa3"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingSubscriptionsListByBillingProfile.json
func ExampleSubscriptionsClient_NewListByBillingProfilePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSubscriptionsClient().NewListByBillingProfilePager("{billingAccountName}", "{billingProfileName}", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SubscriptionsListResult = armbilling.SubscriptionsListResult{
		// 	Value: []*armbilling.Subscription{
		// 		{
		// 			Name: to.Ptr("billingSubscriptionId1"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/billinSubscriptionId1"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				DisplayName: to.Ptr("My subscription"),
		// 				InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
		// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/22000000-0000-0000-0000-000000000000"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](5000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](600),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 				SKUID: to.Ptr("0001"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-f87744185aa3"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("billingSubscriptionId2"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/billinSubscriptionId2"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				DisplayName: to.Ptr("Test subscription"),
		// 				InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
		// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/22000000-0000-0000-0000-000000000000"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](1000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](400),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 				SKUID: to.Ptr("0001"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-6b96d3f2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("billingSubscriptionId3"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/billinSubscriptionId3"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				DisplayName: to.Ptr("Dev Subscription"),
		// 				InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
		// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/22000000-0000-0000-0000-000000000000"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](6000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](900),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 				SKUID: to.Ptr("0001"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-4a9d-9008-912f-f87744185aa3"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingSubscriptionsListByInvoiceSection.json
func ExampleSubscriptionsClient_NewListByInvoiceSectionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSubscriptionsClient().NewListByInvoiceSectionPager("{billingAccountName}", "{billingProfileName}", "{invoiceSectionName}", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SubscriptionsListResult = armbilling.SubscriptionsListResult{
		// 	Value: []*armbilling.Subscription{
		// 		{
		// 			Name: to.Ptr("billingSubscriptionId1"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/billinSubscriptionId1"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				DisplayName: to.Ptr("My subscription"),
		// 				InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
		// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](5000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](600),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 				SKUID: to.Ptr("0001"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-f87744185aa3"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("billingSubscriptionId2"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/billinSubscriptionId2"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				DisplayName: to.Ptr("Test subscription"),
		// 				InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
		// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](1000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](400),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 				SKUID: to.Ptr("0001"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-6b96d3f2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("billingSubscriptionId3"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/billinSubscriptionId3"),
		// 			Properties: &armbilling.SubscriptionProperties{
		// 				BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CostCenter: to.Ptr("ABC1234"),
		// 				DisplayName: to.Ptr("Dev Subscription"),
		// 				InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
		// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}"),
		// 				LastMonthCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](6000),
		// 				},
		// 				MonthToDateCharges: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](900),
		// 				},
		// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 				SKUID: to.Ptr("0001"),
		// 				SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
		// 				SubscriptionID: to.Ptr("6b96d3f2-4a9d-9008-912f-f87744185aa3"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingSubscription.json
func ExampleSubscriptionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSubscriptionsClient().Get(ctx, "{billingAccountName}", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Subscription = armbilling.Subscription{
	// 	Name: to.Ptr("{subscriptionId}"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
	// 	ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}"),
	// 	Properties: &armbilling.SubscriptionProperties{
	// 		BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
	// 		BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
	// 		CostCenter: to.Ptr("ABC1234"),
	// 		DisplayName: to.Ptr("My Subscription"),
	// 		InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
	// 		InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000/invoiceSections/22000000-0000-0000-0000-000000000000"),
	// 		LastMonthCharges: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](5000),
	// 		},
	// 		MonthToDateCharges: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](600),
	// 		},
	// 		SKUDescription: to.Ptr("Microsoft Azure Plan"),
	// 		SKUID: to.Ptr("0001"),
	// 		SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
	// 		SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-f87744185aa3"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/UpdateBillingSubscription.json
func ExampleSubscriptionsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSubscriptionsClient().Update(ctx, "{billingAccountName}", armbilling.Subscription{
		Properties: &armbilling.SubscriptionProperties{
			CostCenter: to.Ptr("ABC1234"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Subscription = armbilling.Subscription{
	// 	Name: to.Ptr("{subscriptionId}"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions"),
	// 	ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}"),
	// 	Properties: &armbilling.SubscriptionProperties{
	// 		BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
	// 		BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
	// 		CostCenter: to.Ptr("ABC1234"),
	// 		DisplayName: to.Ptr("My Subscription"),
	// 		InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
	// 		InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000/invoiceSections/22000000-0000-0000-0000-000000000000"),
	// 		LastMonthCharges: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](5000),
	// 		},
	// 		MonthToDateCharges: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](600),
	// 		},
	// 		SKUDescription: to.Ptr("Microsoft Azure Plan"),
	// 		SKUID: to.Ptr("0001"),
	// 		SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
	// 		SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-f87744185aa3"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/MoveBillingSubscription.json
func ExampleSubscriptionsClient_BeginMove() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionsClient().BeginMove(ctx, "{billingAccountName}", armbilling.TransferBillingSubscriptionRequestProperties{
		DestinationInvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{newInvoiceSectionName}"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Subscription = armbilling.Subscription{
	// 	Properties: &armbilling.SubscriptionProperties{
	// 		BillingProfileDisplayName: to.Ptr("Contoso operations billing"),
	// 		BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
	// 		CostCenter: to.Ptr("ABC1234"),
	// 		DisplayName: to.Ptr("My Subscription"),
	// 		InvoiceSectionDisplayName: to.Ptr("Contoso operations invoiceSection"),
	// 		InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000/invoiceSections/22000000-0000-0000-0000-000000000000"),
	// 		LastMonthCharges: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](5000),
	// 		},
	// 		MonthToDateCharges: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](600),
	// 		},
	// 		SKUDescription: to.Ptr("Microsoft Azure Plan"),
	// 		SKUID: to.Ptr("0001"),
	// 		SubscriptionBillingStatus: to.Ptr(armbilling.BillingSubscriptionStatusTypeActive),
	// 		SubscriptionID: to.Ptr("6b96d3f2-9008-4a9d-912f-f87744185aa3"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/ValidateSubscriptionMoveFailure.json
func ExampleSubscriptionsClient_ValidateMove_subscriptionMoveValidateFailure() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSubscriptionsClient().ValidateMove(ctx, "{billingAccountName}", armbilling.TransferBillingSubscriptionRequestProperties{
		DestinationInvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{newInvoiceSectionName}"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ValidateSubscriptionTransferEligibilityResult = armbilling.ValidateSubscriptionTransferEligibilityResult{
	// 	ErrorDetails: &armbilling.ValidateSubscriptionTransferEligibilityError{
	// 		Code: to.Ptr(armbilling.SubscriptionTransferValidationErrorCodeSubscriptionNotActive),
	// 		Message: to.Ptr("Invoice Sections can only be changed for active subscriptions."),
	// 	},
	// 	IsMoveEligible: to.Ptr(false),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/ValidateSubscriptionMoveSuccess.json
func ExampleSubscriptionsClient_ValidateMove_subscriptionMoveValidateSuccess() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSubscriptionsClient().ValidateMove(ctx, "{billingAccountName}", armbilling.TransferBillingSubscriptionRequestProperties{
		DestinationInvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{newInvoiceSectionName}"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ValidateSubscriptionTransferEligibilityResult = armbilling.ValidateSubscriptionTransferEligibilityResult{
	// 	IsMoveEligible: to.Ptr(true),
	// }
}
