//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
)

// AddressServer is a fake server for instances of the armbilling.AddressClient type.
type AddressServer struct {
	// Validate is the fake for method AddressClient.Validate
	// HTTP status codes to indicate success: http.StatusOK
	Validate func(ctx context.Context, address armbilling.AddressDetails, options *armbilling.AddressClientValidateOptions) (resp azfake.Responder[armbilling.AddressClientValidateResponse], errResp azfake.ErrorResponder)
}

// NewAddressServerTransport creates a new instance of AddressServerTransport with the provided implementation.
// The returned AddressServerTransport instance is connected to an instance of armbilling.AddressClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAddressServerTransport(srv *AddressServer) *AddressServerTransport {
	return &AddressServerTransport{srv: srv}
}

// AddressServerTransport connects instances of armbilling.AddressClient to instances of AddressServer.
// Don't use this type directly, use NewAddressServerTransport instead.
type AddressServerTransport struct {
	srv *AddressServer
}

// Do implements the policy.Transporter interface for AddressServerTransport.
func (a *AddressServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AddressClient.Validate":
		resp, err = a.dispatchValidate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AddressServerTransport) dispatchValidate(req *http.Request) (*http.Response, error) {
	if a.srv.Validate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Validate not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[armbilling.AddressDetails](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Validate(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ValidateAddressResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
