//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armavs_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/avs/armavs"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_List.json
func ExamplePrivateCloudsClient_NewListPager_privateCloudsList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPrivateCloudsClient().NewListPager("group1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateCloudList = armavs.PrivateCloudList{
		// 	Value: []*armavs.PrivateCloud{
		// 		{
		// 			Name: to.Ptr("cloud1"),
		// 			Type: to.Ptr("Microsoft.AVS/privateClouds"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
		// 			Location: to.Ptr("eastus2"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armavs.PrivateCloudProperties{
		// 				Availability: &armavs.AvailabilityProperties{
		// 					Strategy: to.Ptr(armavs.AvailabilityStrategySingleZone),
		// 					Zone: to.Ptr[int32](1),
		// 				},
		// 				IdentitySources: []*armavs.IdentitySource{
		// 					{
		// 						Name: to.Ptr("group1"),
		// 						Alias: to.Ptr("groupAlias"),
		// 						BaseGroupDN: to.Ptr("ou=baseGroup"),
		// 						BaseUserDN: to.Ptr("ou=baseUser"),
		// 						Domain: to.Ptr("domain1"),
		// 						PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
		// 						SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
		// 						SSL: to.Ptr(armavs.SSLEnumEnabled),
		// 				}},
		// 				Internet: to.Ptr(armavs.InternetEnumDisabled),
		// 				ManagementCluster: &armavs.ManagementCluster{
		// 					ClusterID: to.Ptr[int32](1),
		// 					ClusterSize: to.Ptr[int32](4),
		// 					Hosts: []*string{
		// 						to.Ptr("fakehost18.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost19.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost20.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost21.nyc1.kubernetes.center")},
		// 					},
		// 					Circuit: &armavs.Circuit{
		// 						ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
		// 						ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er/peerings/AzurePrivatePeering"),
		// 						PrimarySubnet: to.Ptr("192.168.53.0/30"),
		// 						SecondarySubnet: to.Ptr("192.168.53.4/30"),
		// 					},
		// 					Endpoints: &armavs.Endpoints{
		// 						HcxCloudManager: to.Ptr("https://192.168.50.4/"),
		// 						NsxtManager: to.Ptr("https://192.168.50.3/"),
		// 						Vcsa: to.Ptr("https://192.168.50.2/"),
		// 					},
		// 					ExternalCloudLinks: []*string{
		// 						to.Ptr("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")},
		// 						NetworkBlock: to.Ptr("192.168.48.0/22"),
		// 						ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
		// 					},
		// 					SKU: &armavs.SKU{
		// 						Name: to.Ptr("AV36"),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_List_Stretched.json
func ExamplePrivateCloudsClient_NewListPager_privateCloudsListStretched() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPrivateCloudsClient().NewListPager("group1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateCloudList = armavs.PrivateCloudList{
		// 	Value: []*armavs.PrivateCloud{
		// 		{
		// 			Name: to.Ptr("cloud1"),
		// 			Type: to.Ptr("Microsoft.AVS/privateClouds"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
		// 			Location: to.Ptr("eastus2"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armavs.PrivateCloudProperties{
		// 				Availability: &armavs.AvailabilityProperties{
		// 					SecondaryZone: to.Ptr[int32](2),
		// 					Strategy: to.Ptr(armavs.AvailabilityStrategyDualZone),
		// 					Zone: to.Ptr[int32](1),
		// 				},
		// 				IdentitySources: []*armavs.IdentitySource{
		// 					{
		// 						Name: to.Ptr("group1"),
		// 						Alias: to.Ptr("groupAlias"),
		// 						BaseGroupDN: to.Ptr("ou=baseGroup"),
		// 						BaseUserDN: to.Ptr("ou=baseUser"),
		// 						Domain: to.Ptr("domain1"),
		// 						PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
		// 						SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
		// 						SSL: to.Ptr(armavs.SSLEnumEnabled),
		// 				}},
		// 				Internet: to.Ptr(armavs.InternetEnumDisabled),
		// 				ManagementCluster: &armavs.ManagementCluster{
		// 					ClusterID: to.Ptr[int32](1),
		// 					ClusterSize: to.Ptr[int32](4),
		// 					Hosts: []*string{
		// 						to.Ptr("fakehost18.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost19.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost20.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost21.nyc1.kubernetes.center")},
		// 					},
		// 					Circuit: &armavs.Circuit{
		// 						ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
		// 						ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er/peerings/AzurePrivatePeering"),
		// 						PrimarySubnet: to.Ptr("192.168.53.0/30"),
		// 						SecondarySubnet: to.Ptr("192.168.53.4/30"),
		// 					},
		// 					Endpoints: &armavs.Endpoints{
		// 						HcxCloudManager: to.Ptr("https://192.168.50.4/"),
		// 						NsxtManager: to.Ptr("https://192.168.50.3/"),
		// 						Vcsa: to.Ptr("https://192.168.50.2/"),
		// 					},
		// 					ExternalCloudLinks: []*string{
		// 						to.Ptr("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")},
		// 						NetworkBlock: to.Ptr("192.168.48.0/22"),
		// 						ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
		// 						SecondaryCircuit: &armavs.Circuit{
		// 							ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect2"),
		// 							ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er2/peerings/AzurePrivatePeering"),
		// 							PrimarySubnet: to.Ptr("192.168.53.0/30"),
		// 							SecondarySubnet: to.Ptr("192.168.53.4/30"),
		// 						},
		// 					},
		// 					SKU: &armavs.SKU{
		// 						Name: to.Ptr("AV36"),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_ListInSubscription.json
func ExamplePrivateCloudsClient_NewListInSubscriptionPager_privateCloudsListInSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPrivateCloudsClient().NewListInSubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateCloudList = armavs.PrivateCloudList{
		// 	Value: []*armavs.PrivateCloud{
		// 		{
		// 			Name: to.Ptr("cloud1"),
		// 			Type: to.Ptr("Microsoft.AVS/privateClouds"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
		// 			Location: to.Ptr("eastus2"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armavs.PrivateCloudProperties{
		// 				Availability: &armavs.AvailabilityProperties{
		// 					Strategy: to.Ptr(armavs.AvailabilityStrategySingleZone),
		// 					Zone: to.Ptr[int32](1),
		// 				},
		// 				IdentitySources: []*armavs.IdentitySource{
		// 					{
		// 						Name: to.Ptr("group1"),
		// 						Alias: to.Ptr("groupAlias"),
		// 						BaseGroupDN: to.Ptr("ou=baseGroup"),
		// 						BaseUserDN: to.Ptr("ou=baseUser"),
		// 						Domain: to.Ptr("domain1"),
		// 						PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
		// 						SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
		// 						SSL: to.Ptr(armavs.SSLEnumEnabled),
		// 				}},
		// 				Internet: to.Ptr(armavs.InternetEnumDisabled),
		// 				ManagementCluster: &armavs.ManagementCluster{
		// 					ClusterID: to.Ptr[int32](1),
		// 					ClusterSize: to.Ptr[int32](4),
		// 					Hosts: []*string{
		// 						to.Ptr("fakehost18.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost19.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost20.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost21.nyc1.kubernetes.center")},
		// 					},
		// 					Circuit: &armavs.Circuit{
		// 						ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
		// 						ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er/peerings/AzurePrivatePeering"),
		// 						PrimarySubnet: to.Ptr("192.168.53.0/30"),
		// 						SecondarySubnet: to.Ptr("192.168.53.4/30"),
		// 					},
		// 					Endpoints: &armavs.Endpoints{
		// 						HcxCloudManager: to.Ptr("https://192.168.50.4/"),
		// 						NsxtManager: to.Ptr("https://192.168.50.3/"),
		// 						Vcsa: to.Ptr("https://192.168.50.2/"),
		// 					},
		// 					NetworkBlock: to.Ptr("192.168.48.0/22"),
		// 					ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
		// 				},
		// 				SKU: &armavs.SKU{
		// 					Name: to.Ptr("AV36"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_ListInSubscription_Stretched.json
func ExamplePrivateCloudsClient_NewListInSubscriptionPager_privateCloudsListInSubscriptionStretched() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPrivateCloudsClient().NewListInSubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateCloudList = armavs.PrivateCloudList{
		// 	Value: []*armavs.PrivateCloud{
		// 		{
		// 			Name: to.Ptr("cloud1"),
		// 			Type: to.Ptr("Microsoft.AVS/privateClouds"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
		// 			Location: to.Ptr("eastus2"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armavs.PrivateCloudProperties{
		// 				Availability: &armavs.AvailabilityProperties{
		// 					SecondaryZone: to.Ptr[int32](2),
		// 					Strategy: to.Ptr(armavs.AvailabilityStrategyDualZone),
		// 					Zone: to.Ptr[int32](1),
		// 				},
		// 				IdentitySources: []*armavs.IdentitySource{
		// 					{
		// 						Name: to.Ptr("group1"),
		// 						Alias: to.Ptr("groupAlias"),
		// 						BaseGroupDN: to.Ptr("ou=baseGroup"),
		// 						BaseUserDN: to.Ptr("ou=baseUser"),
		// 						Domain: to.Ptr("domain1"),
		// 						PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
		// 						SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
		// 						SSL: to.Ptr(armavs.SSLEnumEnabled),
		// 				}},
		// 				Internet: to.Ptr(armavs.InternetEnumDisabled),
		// 				ManagementCluster: &armavs.ManagementCluster{
		// 					ClusterID: to.Ptr[int32](1),
		// 					ClusterSize: to.Ptr[int32](4),
		// 					Hosts: []*string{
		// 						to.Ptr("fakehost18.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost19.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost20.nyc1.kubernetes.center"),
		// 						to.Ptr("fakehost21.nyc1.kubernetes.center")},
		// 					},
		// 					Circuit: &armavs.Circuit{
		// 						ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
		// 						ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er/peerings/AzurePrivatePeering"),
		// 						PrimarySubnet: to.Ptr("192.168.53.0/30"),
		// 						SecondarySubnet: to.Ptr("192.168.53.4/30"),
		// 					},
		// 					Endpoints: &armavs.Endpoints{
		// 						HcxCloudManager: to.Ptr("https://192.168.50.4/"),
		// 						NsxtManager: to.Ptr("https://192.168.50.3/"),
		// 						Vcsa: to.Ptr("https://192.168.50.2/"),
		// 					},
		// 					NetworkBlock: to.Ptr("192.168.48.0/22"),
		// 					ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
		// 					SecondaryCircuit: &armavs.Circuit{
		// 						ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect2"),
		// 						ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er2/peerings/AzurePrivatePeering"),
		// 						PrimarySubnet: to.Ptr("192.168.53.0/30"),
		// 						SecondarySubnet: to.Ptr("192.168.53.4/30"),
		// 					},
		// 				},
		// 				SKU: &armavs.SKU{
		// 					Name: to.Ptr("AV36"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_Get.json
func ExamplePrivateCloudsClient_Get_privateCloudsGet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateCloudsClient().Get(ctx, "group1", "cloud1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateCloud = armavs.PrivateCloud{
	// 	Name: to.Ptr("cloud1"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armavs.PrivateCloudIdentity{
	// 		Type: to.Ptr(armavs.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("881e5573-063f-49e4-8c08-79d7df0169d8"),
	// 		TenantID: to.Ptr("881e5573-063f-49e4-8c08-79d7df0169d8"),
	// 	},
	// 	Properties: &armavs.PrivateCloudProperties{
	// 		Availability: &armavs.AvailabilityProperties{
	// 			Strategy: to.Ptr(armavs.AvailabilityStrategySingleZone),
	// 			Zone: to.Ptr[int32](1),
	// 		},
	// 		Encryption: &armavs.Encryption{
	// 			KeyVaultProperties: &armavs.EncryptionKeyVaultProperties{
	// 				KeyName: to.Ptr("keyname1"),
	// 				KeyState: to.Ptr(armavs.EncryptionKeyStatusConnected),
	// 				KeyVaultURL: to.Ptr("https://keyvault1-kmip-kvault.vault.azure.net/"),
	// 				KeyVersion: to.Ptr("ver1.0"),
	// 				VersionType: to.Ptr(armavs.EncryptionVersionTypeFixed),
	// 			},
	// 			Status: to.Ptr(armavs.EncryptionStateEnabled),
	// 		},
	// 		IdentitySources: []*armavs.IdentitySource{
	// 			{
	// 				Name: to.Ptr("group1"),
	// 				Alias: to.Ptr("groupAlias"),
	// 				BaseGroupDN: to.Ptr("ou=baseGroup"),
	// 				BaseUserDN: to.Ptr("ou=baseUser"),
	// 				Domain: to.Ptr("domain1"),
	// 				PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
	// 				SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
	// 				SSL: to.Ptr(armavs.SSLEnumEnabled),
	// 		}},
	// 		Internet: to.Ptr(armavs.InternetEnumDisabled),
	// 		ManagementCluster: &armavs.ManagementCluster{
	// 			ClusterID: to.Ptr[int32](1),
	// 			ClusterSize: to.Ptr[int32](4),
	// 			Hosts: []*string{
	// 				to.Ptr("fakehost18.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost19.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost20.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost21.nyc1.kubernetes.center")},
	// 			},
	// 			Circuit: &armavs.Circuit{
	// 				ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
	// 				ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er/peerings/AzurePrivatePeering"),
	// 				PrimarySubnet: to.Ptr("192.168.53.0/30"),
	// 				SecondarySubnet: to.Ptr("192.168.53.4/30"),
	// 			},
	// 			Endpoints: &armavs.Endpoints{
	// 				HcxCloudManager: to.Ptr("https://192.168.50.4/"),
	// 				NsxtManager: to.Ptr("https://192.168.50.3/"),
	// 				Vcsa: to.Ptr("https://192.168.50.2/"),
	// 			},
	// 			ExternalCloudLinks: []*string{
	// 				to.Ptr("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")},
	// 				NetworkBlock: to.Ptr("192.168.48.0/22"),
	// 				ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
	// 			},
	// 			SKU: &armavs.SKU{
	// 				Name: to.Ptr("AV36"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_Get_Stretched.json
func ExamplePrivateCloudsClient_Get_privateCloudsGetStretched() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateCloudsClient().Get(ctx, "group1", "cloud1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateCloud = armavs.PrivateCloud{
	// 	Name: to.Ptr("cloud1"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armavs.PrivateCloudProperties{
	// 		Availability: &armavs.AvailabilityProperties{
	// 			SecondaryZone: to.Ptr[int32](2),
	// 			Strategy: to.Ptr(armavs.AvailabilityStrategyDualZone),
	// 			Zone: to.Ptr[int32](1),
	// 		},
	// 		IdentitySources: []*armavs.IdentitySource{
	// 			{
	// 				Name: to.Ptr("group1"),
	// 				Alias: to.Ptr("groupAlias"),
	// 				BaseGroupDN: to.Ptr("ou=baseGroup"),
	// 				BaseUserDN: to.Ptr("ou=baseUser"),
	// 				Domain: to.Ptr("domain1"),
	// 				PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
	// 				SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
	// 				SSL: to.Ptr(armavs.SSLEnumEnabled),
	// 		}},
	// 		Internet: to.Ptr(armavs.InternetEnumDisabled),
	// 		ManagementCluster: &armavs.ManagementCluster{
	// 			ClusterID: to.Ptr[int32](1),
	// 			ClusterSize: to.Ptr[int32](4),
	// 			Hosts: []*string{
	// 				to.Ptr("fakehost18.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost19.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost20.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost21.nyc1.kubernetes.center")},
	// 			},
	// 			Circuit: &armavs.Circuit{
	// 				ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
	// 				ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er/peerings/AzurePrivatePeering"),
	// 				PrimarySubnet: to.Ptr("192.168.53.0/30"),
	// 				SecondarySubnet: to.Ptr("192.168.53.4/30"),
	// 			},
	// 			Endpoints: &armavs.Endpoints{
	// 				HcxCloudManager: to.Ptr("https://192.168.50.4/"),
	// 				NsxtManager: to.Ptr("https://192.168.50.3/"),
	// 				Vcsa: to.Ptr("https://192.168.50.2/"),
	// 			},
	// 			ExternalCloudLinks: []*string{
	// 				to.Ptr("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")},
	// 				NetworkBlock: to.Ptr("192.168.48.0/22"),
	// 				ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
	// 				SecondaryCircuit: &armavs.Circuit{
	// 					ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
	// 					ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er2/peerings/AzurePrivatePeering"),
	// 					PrimarySubnet: to.Ptr("192.168.53.0/30"),
	// 					SecondarySubnet: to.Ptr("192.168.53.4/30"),
	// 				},
	// 			},
	// 			SKU: &armavs.SKU{
	// 				Name: to.Ptr("AV36"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_CreateOrUpdate.json
func ExamplePrivateCloudsClient_BeginCreateOrUpdate_privateCloudsCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateCloudsClient().BeginCreateOrUpdate(ctx, "group1", "cloud1", armavs.PrivateCloud{
		Location: to.Ptr("eastus2"),
		Tags:     map[string]*string{},
		Identity: &armavs.PrivateCloudIdentity{
			Type: to.Ptr(armavs.ResourceIdentityTypeSystemAssigned),
		},
		Properties: &armavs.PrivateCloudProperties{
			ManagementCluster: &armavs.ManagementCluster{
				ClusterSize: to.Ptr[int32](4),
			},
			NetworkBlock: to.Ptr("192.168.48.0/22"),
		},
		SKU: &armavs.SKU{
			Name: to.Ptr("AV36"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateCloud = armavs.PrivateCloud{
	// 	Name: to.Ptr("cloud1"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armavs.PrivateCloudProperties{
	// 		Availability: &armavs.AvailabilityProperties{
	// 			Strategy: to.Ptr(armavs.AvailabilityStrategySingleZone),
	// 			Zone: to.Ptr[int32](1),
	// 		},
	// 		IdentitySources: []*armavs.IdentitySource{
	// 			{
	// 				Name: to.Ptr("group1"),
	// 				Alias: to.Ptr("groupAlias"),
	// 				BaseGroupDN: to.Ptr("ou=baseGroup"),
	// 				BaseUserDN: to.Ptr("ou=baseUser"),
	// 				Domain: to.Ptr("domain1"),
	// 				PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
	// 				SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
	// 				SSL: to.Ptr(armavs.SSLEnumEnabled),
	// 		}},
	// 		Internet: to.Ptr(armavs.InternetEnumDisabled),
	// 		ManagementCluster: &armavs.ManagementCluster{
	// 			ClusterID: to.Ptr[int32](1),
	// 			ClusterSize: to.Ptr[int32](4),
	// 			Hosts: []*string{
	// 				to.Ptr("fakehost18.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost19.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost20.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost21.nyc1.kubernetes.center")},
	// 			},
	// 			Circuit: &armavs.Circuit{
	// 				ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
	// 				PrimarySubnet: to.Ptr("192.168.53.0/30"),
	// 				SecondarySubnet: to.Ptr("192.168.53.4/30"),
	// 			},
	// 			Endpoints: &armavs.Endpoints{
	// 				NsxtManager: to.Ptr("https://192.168.50.3/"),
	// 				Vcsa: to.Ptr("https://192.168.50.2/"),
	// 			},
	// 			ExternalCloudLinks: []*string{
	// 				to.Ptr("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")},
	// 				NetworkBlock: to.Ptr("192.168.48.0/22"),
	// 				ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
	// 			},
	// 			SKU: &armavs.SKU{
	// 				Name: to.Ptr("AV36"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_CreateOrUpdate_Stretched.json
func ExamplePrivateCloudsClient_BeginCreateOrUpdate_privateCloudsCreateOrUpdateStretched() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateCloudsClient().BeginCreateOrUpdate(ctx, "group1", "cloud1", armavs.PrivateCloud{
		Location: to.Ptr("eastus2"),
		Tags:     map[string]*string{},
		Properties: &armavs.PrivateCloudProperties{
			Availability: &armavs.AvailabilityProperties{
				SecondaryZone: to.Ptr[int32](2),
				Strategy:      to.Ptr(armavs.AvailabilityStrategyDualZone),
				Zone:          to.Ptr[int32](1),
			},
			ManagementCluster: &armavs.ManagementCluster{
				ClusterSize: to.Ptr[int32](4),
			},
			NetworkBlock: to.Ptr("192.168.48.0/22"),
		},
		SKU: &armavs.SKU{
			Name: to.Ptr("AV36"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateCloud = armavs.PrivateCloud{
	// 	Name: to.Ptr("cloud1"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armavs.PrivateCloudProperties{
	// 		Availability: &armavs.AvailabilityProperties{
	// 			SecondaryZone: to.Ptr[int32](2),
	// 			Strategy: to.Ptr(armavs.AvailabilityStrategyDualZone),
	// 			Zone: to.Ptr[int32](1),
	// 		},
	// 		IdentitySources: []*armavs.IdentitySource{
	// 			{
	// 				Name: to.Ptr("group1"),
	// 				Alias: to.Ptr("groupAlias"),
	// 				BaseGroupDN: to.Ptr("ou=baseGroup"),
	// 				BaseUserDN: to.Ptr("ou=baseUser"),
	// 				Domain: to.Ptr("domain1"),
	// 				PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
	// 				SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
	// 				SSL: to.Ptr(armavs.SSLEnumEnabled),
	// 		}},
	// 		Internet: to.Ptr(armavs.InternetEnumDisabled),
	// 		ManagementCluster: &armavs.ManagementCluster{
	// 			ClusterID: to.Ptr[int32](1),
	// 			ClusterSize: to.Ptr[int32](4),
	// 			Hosts: []*string{
	// 				to.Ptr("fakehost18.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost19.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost20.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost21.nyc1.kubernetes.center")},
	// 			},
	// 			Circuit: &armavs.Circuit{
	// 				ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
	// 				PrimarySubnet: to.Ptr("192.168.53.0/30"),
	// 				SecondarySubnet: to.Ptr("192.168.53.4/30"),
	// 			},
	// 			Endpoints: &armavs.Endpoints{
	// 				NsxtManager: to.Ptr("https://192.168.50.3/"),
	// 				Vcsa: to.Ptr("https://192.168.50.2/"),
	// 			},
	// 			ExternalCloudLinks: []*string{
	// 				to.Ptr("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")},
	// 				NetworkBlock: to.Ptr("192.168.48.0/22"),
	// 				ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
	// 				SecondaryCircuit: &armavs.Circuit{
	// 					ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect2"),
	// 					PrimarySubnet: to.Ptr("192.168.53.0/30"),
	// 					SecondarySubnet: to.Ptr("192.168.53.4/30"),
	// 				},
	// 			},
	// 			SKU: &armavs.SKU{
	// 				Name: to.Ptr("AV36"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_Update.json
func ExamplePrivateCloudsClient_BeginUpdate_privateCloudsUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateCloudsClient().BeginUpdate(ctx, "group1", "cloud1", armavs.PrivateCloudUpdate{
		Identity: &armavs.PrivateCloudIdentity{
			Type: to.Ptr(armavs.ResourceIdentityTypeNone),
		},
		Properties: &armavs.PrivateCloudUpdateProperties{
			Encryption: &armavs.Encryption{
				KeyVaultProperties: &armavs.EncryptionKeyVaultProperties{
					KeyName:     to.Ptr("keyname1"),
					KeyVaultURL: to.Ptr("https://keyvault1-kmip-kvault.vault.azure.net/"),
					KeyVersion:  to.Ptr("ver1.0"),
				},
				Status: to.Ptr(armavs.EncryptionStateEnabled),
			},
			ManagementCluster: &armavs.ManagementCluster{
				ClusterSize: to.Ptr[int32](4),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateCloud = armavs.PrivateCloud{
	// 	Name: to.Ptr("cloud1"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armavs.PrivateCloudProperties{
	// 		Availability: &armavs.AvailabilityProperties{
	// 			Strategy: to.Ptr(armavs.AvailabilityStrategySingleZone),
	// 			Zone: to.Ptr[int32](1),
	// 		},
	// 		Encryption: &armavs.Encryption{
	// 			KeyVaultProperties: &armavs.EncryptionKeyVaultProperties{
	// 				KeyName: to.Ptr("keyname1"),
	// 				KeyVaultURL: to.Ptr("https://keyvault1-kmip-kvault.vault.azure.net/"),
	// 				KeyVersion: to.Ptr("ver1.0"),
	// 				VersionType: to.Ptr(armavs.EncryptionVersionTypeFixed),
	// 			},
	// 			Status: to.Ptr(armavs.EncryptionStateEnabled),
	// 		},
	// 		IdentitySources: []*armavs.IdentitySource{
	// 			{
	// 				Name: to.Ptr("group1"),
	// 				Alias: to.Ptr("groupAlias"),
	// 				BaseGroupDN: to.Ptr("ou=baseGroup"),
	// 				BaseUserDN: to.Ptr("ou=baseUser"),
	// 				Domain: to.Ptr("domain1"),
	// 				PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
	// 				SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
	// 				SSL: to.Ptr(armavs.SSLEnumEnabled),
	// 		}},
	// 		Internet: to.Ptr(armavs.InternetEnumDisabled),
	// 		ManagementCluster: &armavs.ManagementCluster{
	// 			ClusterID: to.Ptr[int32](1),
	// 			ClusterSize: to.Ptr[int32](4),
	// 			Hosts: []*string{
	// 				to.Ptr("fakehost18.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost19.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost20.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost21.nyc1.kubernetes.center")},
	// 			},
	// 			Circuit: &armavs.Circuit{
	// 				ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
	// 				ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er/peerings/AzurePrivatePeering"),
	// 				PrimarySubnet: to.Ptr("192.168.53.0/30"),
	// 				SecondarySubnet: to.Ptr("192.168.53.4/30"),
	// 			},
	// 			Endpoints: &armavs.Endpoints{
	// 				HcxCloudManager: to.Ptr("https://192.168.50.4/"),
	// 				NsxtManager: to.Ptr("https://192.168.50.3/"),
	// 				Vcsa: to.Ptr("https://192.168.50.2/"),
	// 			},
	// 			ExternalCloudLinks: []*string{
	// 				to.Ptr("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")},
	// 				NetworkBlock: to.Ptr("192.168.48.0/22"),
	// 				ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
	// 			},
	// 			SKU: &armavs.SKU{
	// 				Name: to.Ptr("AV36"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_Update_Stretched.json
func ExamplePrivateCloudsClient_BeginUpdate_privateCloudsUpdateStretched() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateCloudsClient().BeginUpdate(ctx, "group1", "cloud1", armavs.PrivateCloudUpdate{
		Properties: &armavs.PrivateCloudUpdateProperties{
			ManagementCluster: &armavs.ManagementCluster{
				ClusterSize: to.Ptr[int32](4),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateCloud = armavs.PrivateCloud{
	// 	Name: to.Ptr("cloud1"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1"),
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armavs.PrivateCloudProperties{
	// 		Availability: &armavs.AvailabilityProperties{
	// 			SecondaryZone: to.Ptr[int32](2),
	// 			Strategy: to.Ptr(armavs.AvailabilityStrategyDualZone),
	// 			Zone: to.Ptr[int32](1),
	// 		},
	// 		IdentitySources: []*armavs.IdentitySource{
	// 			{
	// 				Name: to.Ptr("group1"),
	// 				Alias: to.Ptr("groupAlias"),
	// 				BaseGroupDN: to.Ptr("ou=baseGroup"),
	// 				BaseUserDN: to.Ptr("ou=baseUser"),
	// 				Domain: to.Ptr("domain1"),
	// 				PrimaryServer: to.Ptr("ldaps://1.1.1.1:636/"),
	// 				SecondaryServer: to.Ptr("ldaps://1.1.1.2:636/"),
	// 				SSL: to.Ptr(armavs.SSLEnumEnabled),
	// 		}},
	// 		Internet: to.Ptr(armavs.InternetEnumDisabled),
	// 		ManagementCluster: &armavs.ManagementCluster{
	// 			ClusterID: to.Ptr[int32](1),
	// 			ClusterSize: to.Ptr[int32](4),
	// 			Hosts: []*string{
	// 				to.Ptr("fakehost18.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost19.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost20.nyc1.kubernetes.center"),
	// 				to.Ptr("fakehost21.nyc1.kubernetes.center")},
	// 			},
	// 			Circuit: &armavs.Circuit{
	// 				ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect"),
	// 				ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er/peerings/AzurePrivatePeering"),
	// 				PrimarySubnet: to.Ptr("192.168.53.0/30"),
	// 				SecondarySubnet: to.Ptr("192.168.53.4/30"),
	// 			},
	// 			Endpoints: &armavs.Endpoints{
	// 				HcxCloudManager: to.Ptr("https://192.168.50.4/"),
	// 				NsxtManager: to.Ptr("https://192.168.50.3/"),
	// 				Vcsa: to.Ptr("https://192.168.50.2/"),
	// 			},
	// 			ExternalCloudLinks: []*string{
	// 				to.Ptr("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")},
	// 				NetworkBlock: to.Ptr("192.168.48.0/22"),
	// 				ProvisioningState: to.Ptr(armavs.PrivateCloudProvisioningStateSucceeded),
	// 				SecondaryCircuit: &armavs.Circuit{
	// 					ExpressRouteID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2/providers/Microsoft.Network/expressroutecircuits/tnt13-41a90db2-9d5e-4bd5-a77a-5ce7b58213d6-eastus2-xconnect2"),
	// 					ExpressRoutePrivatePeeringID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/tnt42-cust-p01-dmo01/providers/Microsoft.Network/expressroutecircuits/tnt42-cust-p01-dmo01-er2/peerings/AzurePrivatePeering"),
	// 					PrimarySubnet: to.Ptr("192.168.53.0/30"),
	// 					SecondarySubnet: to.Ptr("192.168.53.4/30"),
	// 				},
	// 			},
	// 			SKU: &armavs.SKU{
	// 				Name: to.Ptr("AV36"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_Delete.json
func ExamplePrivateCloudsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateCloudsClient().BeginDelete(ctx, "group1", "cloud1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_RotateVcenterPassword.json
func ExamplePrivateCloudsClient_BeginRotateVcenterPassword() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateCloudsClient().BeginRotateVcenterPassword(ctx, "group1", "cloud1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_RotateNsxtPassword.json
func ExamplePrivateCloudsClient_BeginRotateNsxtPassword() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPrivateCloudsClient().BeginRotateNsxtPassword(ctx, "group1", "cloud1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/PrivateClouds_ListAdminCredentials.json
func ExamplePrivateCloudsClient_ListAdminCredentials() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateCloudsClient().ListAdminCredentials(ctx, "group1", "cloud1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AdminCredentials = armavs.AdminCredentials{
	// 	NsxtPassword: to.Ptr("$(1X4Dkk"),
	// 	NsxtUsername: to.Ptr("admin"),
	// 	VcenterPassword: to.Ptr("<vcenterPassword>"),
	// 	VcenterUsername: to.Ptr("cloudadmin@vsphere.local"),
	// }
}
