//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/createOrUpdateVariable.json
func ExampleVariableClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVariableClient().CreateOrUpdate(ctx, "rg", "sampleAccount9", "sampleVariable", armautomation.VariableCreateOrUpdateParameters{
		Name: to.Ptr("sampleVariable"),
		Properties: &armautomation.VariableCreateOrUpdateProperties{
			Description: to.Ptr("my description"),
			IsEncrypted: to.Ptr(false),
			Value:       to.Ptr("\"ComputerName.domain.com\""),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Variable = armautomation.Variable{
	// 	Name: to.Ptr("sampleVariable"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable"),
	// 	Properties: &armautomation.VariableProperties{
	// 		Description: to.Ptr("my description"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T22:59:00.937Z"); return t}()),
	// 		IsEncrypted: to.Ptr(false),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T22:59:00.937Z"); return t}()),
	// 		Value: to.Ptr("\"ComputerName2.domain.com\""),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/updateVariable_patch.json
func ExampleVariableClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVariableClient().Update(ctx, "rg", "sampleAccount9", "sampleVariable", armautomation.VariableUpdateParameters{
		Name: to.Ptr("sampleVariable"),
		Properties: &armautomation.VariableUpdateProperties{
			Value: to.Ptr("\"ComputerName3.domain.com\""),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Variable = armautomation.Variable{
	// 	Name: to.Ptr("sampleVariable"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable"),
	// 	Properties: &armautomation.VariableProperties{
	// 		Description: to.Ptr("my description"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:00:53.363Z"); return t}()),
	// 		IsEncrypted: to.Ptr(false),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:00:57.987Z"); return t}()),
	// 		Value: to.Ptr("\"ComputerName3.domain.com\""),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteVariable.json
func ExampleVariableClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewVariableClient().Delete(ctx, "rg", "sampleAccount9", "sampleVariable", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getVariable.json
func ExampleVariableClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVariableClient().Get(ctx, "rg", "sampleAccount9", "sampleVariable", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Variable = armautomation.Variable{
	// 	Name: to.Ptr("sampleVariable"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable"),
	// 	Properties: &armautomation.VariableProperties{
	// 		Description: to.Ptr("my description"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T22:59:00.937Z"); return t}()),
	// 		IsEncrypted: to.Ptr(false),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T22:59:00.937Z"); return t}()),
	// 		Value: to.Ptr("\"ComputerName.domain.com\""),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listVariables_First100.json
func ExampleVariableClient_NewListByAutomationAccountPager_listVariablesFirst100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVariableClient().NewListByAutomationAccountPager("rg", "sampleAccount9", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VariableListResult = armautomation.VariableListResult{
		// 	Value: []*armautomation.Variable{
		// 		{
		// 			Name: to.Ptr("sampleVariable"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:00:53.363Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:00:57.987Z"); return t}()),
		// 				Value: to.Ptr("\"ComputerName3.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable0"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable0"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:00:58.847Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:00:58.847Z"); return t}()),
		// 				Value: to.Ptr("\"server0.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable1"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable1"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:00:59.690Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:00:59.690Z"); return t}()),
		// 				Value: to.Ptr("\"server1.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable10"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable10"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:08.393Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:08.393Z"); return t}()),
		// 				Value: to.Ptr("\"server10.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable100"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable100"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:27.380Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:27.380Z"); return t}()),
		// 				Value: to.Ptr("\"server100.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable101"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable101"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:28.223Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:28.223Z"); return t}()),
		// 				Value: to.Ptr("\"server101.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable102"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable102"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:28.990Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:28.990Z"); return t}()),
		// 				Value: to.Ptr("\"server102.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable103"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable103"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:29.770Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:29.770Z"); return t}()),
		// 				Value: to.Ptr("\"server103.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable104"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable104"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:30.647Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:30.647Z"); return t}()),
		// 				Value: to.Ptr("\"server104.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable105"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable105"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:31.490Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:31.490Z"); return t}()),
		// 				Value: to.Ptr("\"server105.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable106"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable106"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:32.303Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:32.303Z"); return t}()),
		// 				Value: to.Ptr("\"server106.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable107"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable107"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:34.583Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:34.583Z"); return t}()),
		// 				Value: to.Ptr("\"server107.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable108"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable108"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:35.367Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:35.367Z"); return t}()),
		// 				Value: to.Ptr("\"server108.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable109"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable109"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:36.147Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:36.147Z"); return t}()),
		// 				Value: to.Ptr("\"server109.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable11"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable11"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:09.270Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:09.270Z"); return t}()),
		// 				Value: to.Ptr("\"server11.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable12"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable12"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:10.160Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:10.160Z"); return t}()),
		// 				Value: to.Ptr("\"server12.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable13"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable13"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:11.003Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:11.003Z"); return t}()),
		// 				Value: to.Ptr("\"server13.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable14"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable14"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:11.863Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:11.863Z"); return t}()),
		// 				Value: to.Ptr("\"server14.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable15"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable15"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:12.740Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:12.740Z"); return t}()),
		// 				Value: to.Ptr("\"server15.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable16"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable16"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:13.597Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:13.597Z"); return t}()),
		// 				Value: to.Ptr("\"server16.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable17"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable17"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:16.287Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:16.287Z"); return t}()),
		// 				Value: to.Ptr("\"server17.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable18"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable18"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:17.160Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:17.160Z"); return t}()),
		// 				Value: to.Ptr("\"server18.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable19"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable19"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:18.020Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:18.020Z"); return t}()),
		// 				Value: to.Ptr("\"server19.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable2"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable2"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:00.567Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:00.567Z"); return t}()),
		// 				Value: to.Ptr("\"server2.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable20"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable20"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:18.847Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:18.847Z"); return t}()),
		// 				Value: to.Ptr("\"server20.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable21"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable21"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:19.723Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:19.723Z"); return t}()),
		// 				Value: to.Ptr("\"server21.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable22"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable22"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:21.597Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:21.597Z"); return t}()),
		// 				Value: to.Ptr("\"server22.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable23"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable23"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:22.393Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:22.393Z"); return t}()),
		// 				Value: to.Ptr("\"server23.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable24"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable24"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:23.207Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:23.207Z"); return t}()),
		// 				Value: to.Ptr("\"server24.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable25"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable25"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:23.973Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:23.973Z"); return t}()),
		// 				Value: to.Ptr("\"server25.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable26"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable26"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:24.800Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:24.800Z"); return t}()),
		// 				Value: to.Ptr("\"server26.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable27"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable27"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:25.597Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:25.597Z"); return t}()),
		// 				Value: to.Ptr("\"server27.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable28"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable28"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:26.550Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:26.550Z"); return t}()),
		// 				Value: to.Ptr("\"server28.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable29"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable29"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:27.457Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:27.457Z"); return t}()),
		// 				Value: to.Ptr("\"server29.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable3"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable3"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:01.427Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:01.427Z"); return t}()),
		// 				Value: to.Ptr("\"server3.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable30"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable30"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:28.253Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:28.253Z"); return t}()),
		// 				Value: to.Ptr("\"server30.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable31"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable31"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:29.050Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:29.050Z"); return t}()),
		// 				Value: to.Ptr("\"server31.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable32"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable32"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:29.817Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:29.817Z"); return t}()),
		// 				Value: to.Ptr("\"server32.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable33"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable33"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:30.643Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:30.643Z"); return t}()),
		// 				Value: to.Ptr("\"server33.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable34"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable34"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:31.473Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:31.473Z"); return t}()),
		// 				Value: to.Ptr("\"server34.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable35"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable35"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:32.253Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:32.253Z"); return t}()),
		// 				Value: to.Ptr("\"server35.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable36"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable36"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:33.270Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:33.270Z"); return t}()),
		// 				Value: to.Ptr("\"server36.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable37"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable37"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:34.037Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:34.037Z"); return t}()),
		// 				Value: to.Ptr("\"server37.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable38"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable38"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:34.817Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:34.817Z"); return t}()),
		// 				Value: to.Ptr("\"server38.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable39"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable39"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:35.613Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:35.613Z"); return t}()),
		// 				Value: to.Ptr("\"server39.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable4"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable4"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:02.380Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:02.380Z"); return t}()),
		// 				Value: to.Ptr("\"server4.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable40"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable40"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:36.397Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:36.397Z"); return t}()),
		// 				Value: to.Ptr("\"server40.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable41"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable41"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:37.190Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:37.190Z"); return t}()),
		// 				Value: to.Ptr("\"server41.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable42"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable42"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:38.037Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:38.037Z"); return t}()),
		// 				Value: to.Ptr("\"server42.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable43"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable43"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:38.880Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:38.880Z"); return t}()),
		// 				Value: to.Ptr("\"server43.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable44"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable44"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:39.707Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:39.707Z"); return t}()),
		// 				Value: to.Ptr("\"server44.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable45"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable45"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:41.457Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:41.457Z"); return t}()),
		// 				Value: to.Ptr("\"server45.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable46"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable46"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:42.253Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:42.253Z"); return t}()),
		// 				Value: to.Ptr("\"server46.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable47"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable47"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:43.083Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:43.083Z"); return t}()),
		// 				Value: to.Ptr("\"server47.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable48"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable48"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:43.957Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:43.957Z"); return t}()),
		// 				Value: to.Ptr("\"server48.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable49"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable49"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:44.740Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:44.740Z"); return t}()),
		// 				Value: to.Ptr("\"server49.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable5"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable5"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:03.253Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:03.253Z"); return t}()),
		// 				Value: to.Ptr("\"server5.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable50"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable50"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:46.350Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:46.350Z"); return t}()),
		// 				Value: to.Ptr("\"server50.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable51"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable51"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:47.100Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:47.100Z"); return t}()),
		// 				Value: to.Ptr("\"server51.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable52"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable52"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:47.880Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:47.880Z"); return t}()),
		// 				Value: to.Ptr("\"server52.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable53"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable53"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:48.677Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:48.677Z"); return t}()),
		// 				Value: to.Ptr("\"server53.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable54"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable54"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:49.473Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:49.473Z"); return t}()),
		// 				Value: to.Ptr("\"server54.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable55"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable55"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:51.160Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:51.160Z"); return t}()),
		// 				Value: to.Ptr("\"server55.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable56"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable56"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:51.927Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:51.927Z"); return t}()),
		// 				Value: to.Ptr("\"server56.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable57"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable57"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:52.757Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:52.757Z"); return t}()),
		// 				Value: to.Ptr("\"server57.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable58"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable58"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:53.550Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:53.550Z"); return t}()),
		// 				Value: to.Ptr("\"server58.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable59"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable59"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:54.317Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:54.317Z"); return t}()),
		// 				Value: to.Ptr("\"server59.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable6"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable6"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:04.143Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:04.143Z"); return t}()),
		// 				Value: to.Ptr("\"server6.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable60"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable60"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:55.177Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:55.177Z"); return t}()),
		// 				Value: to.Ptr("\"server60.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable61"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable61"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:56.583Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:56.583Z"); return t}()),
		// 				Value: to.Ptr("\"server61.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable62"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable62"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:57.270Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:57.270Z"); return t}()),
		// 				Value: to.Ptr("\"server62.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable63"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable63"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:57.943Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:57.943Z"); return t}()),
		// 				Value: to.Ptr("\"server63.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable64"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable64"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:58.660Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:58.660Z"); return t}()),
		// 				Value: to.Ptr("\"server64.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable65"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable65"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:59.350Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:59.350Z"); return t}()),
		// 				Value: to.Ptr("\"server65.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable66"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable66"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:00.020Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:00.020Z"); return t}()),
		// 				Value: to.Ptr("\"server66.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable67"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable67"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:01.507Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:01.507Z"); return t}()),
		// 				Value: to.Ptr("\"server67.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable68"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable68"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:02.177Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:02.177Z"); return t}()),
		// 				Value: to.Ptr("\"server68.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable69"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable69"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:02.863Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:02.863Z"); return t}()),
		// 				Value: to.Ptr("\"server69.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable7"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable7"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:05.393Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:05.393Z"); return t}()),
		// 				Value: to.Ptr("\"server7.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable70"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable70"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:03.600Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:03.600Z"); return t}()),
		// 				Value: to.Ptr("\"server70.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable71"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable71"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:04.333Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:04.333Z"); return t}()),
		// 				Value: to.Ptr("\"server71.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable72"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable72"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:05.100Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:05.100Z"); return t}()),
		// 				Value: to.Ptr("\"server72.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable73"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable73"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:05.833Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:05.833Z"); return t}()),
		// 				Value: to.Ptr("\"server73.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable74"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable74"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:06.647Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:06.647Z"); return t}()),
		// 				Value: to.Ptr("\"server74.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable75"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable75"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:07.363Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:07.363Z"); return t}()),
		// 				Value: to.Ptr("\"server75.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable76"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable76"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:08.100Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:08.100Z"); return t}()),
		// 				Value: to.Ptr("\"server76.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable77"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable77"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:08.820Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:08.820Z"); return t}()),
		// 				Value: to.Ptr("\"server77.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable78"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable78"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:09.553Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:09.553Z"); return t}()),
		// 				Value: to.Ptr("\"server78.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable79"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable79"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:10.630Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:10.630Z"); return t}()),
		// 				Value: to.Ptr("\"server79.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable8"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable8"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:06.520Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:06.520Z"); return t}()),
		// 				Value: to.Ptr("\"server8.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable80"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable80"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:11.320Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:11.320Z"); return t}()),
		// 				Value: to.Ptr("\"server80.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable81"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable81"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:12.020Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:12.020Z"); return t}()),
		// 				Value: to.Ptr("\"server81.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable82"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable82"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:12.723Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:12.723Z"); return t}()),
		// 				Value: to.Ptr("\"server82.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable83"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable83"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:13.443Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:13.443Z"); return t}()),
		// 				Value: to.Ptr("\"server83.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable84"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable84"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:14.160Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:14.160Z"); return t}()),
		// 				Value: to.Ptr("\"server84.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable85"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable85"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:15.177Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:15.177Z"); return t}()),
		// 				Value: to.Ptr("\"server85.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable86"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable86"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:16.053Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:16.053Z"); return t}()),
		// 				Value: to.Ptr("\"server86.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable87"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable87"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:16.820Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:16.820Z"); return t}()),
		// 				Value: to.Ptr("\"server87.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable88"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable88"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:17.583Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:17.583Z"); return t}()),
		// 				Value: to.Ptr("\"server88.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable89"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable89"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:18.333Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:18.333Z"); return t}()),
		// 				Value: to.Ptr("\"server89.domain.com\""),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listVariables_Next100.json
func ExampleVariableClient_NewListByAutomationAccountPager_listVariablesNext100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVariableClient().NewListByAutomationAccountPager("rg", "sampleAccount9", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VariableListResult = armautomation.VariableListResult{
		// 	Value: []*armautomation.Variable{
		// 		{
		// 			Name: to.Ptr("sampleVariable9"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable9"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:07.380Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:01:07.380Z"); return t}()),
		// 				Value: to.Ptr("\"server9.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable90"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable90"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:19.147Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:19.147Z"); return t}()),
		// 				Value: to.Ptr("\"server90.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable91"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable91"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:20.257Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:20.257Z"); return t}()),
		// 				Value: to.Ptr("\"server91.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable92"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable92"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:21.037Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:21.037Z"); return t}()),
		// 				Value: to.Ptr("\"server92.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable93"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable93"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:21.803Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:21.803Z"); return t}()),
		// 				Value: to.Ptr("\"server93.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable94"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable94"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:22.583Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:22.583Z"); return t}()),
		// 				Value: to.Ptr("\"server94.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable95"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable95"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:23.333Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:23.333Z"); return t}()),
		// 				Value: to.Ptr("\"server95.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable96"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable96"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:24.163Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:24.163Z"); return t}()),
		// 				Value: to.Ptr("\"server96.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable97"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable97"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:24.973Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:24.973Z"); return t}()),
		// 				Value: to.Ptr("\"server97.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable98"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable98"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:25.757Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:25.757Z"); return t}()),
		// 				Value: to.Ptr("\"server98.domain.com\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sampleVariable99"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/sampleAccount9/variables/sampleVariable99"),
		// 			Properties: &armautomation.VariableProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:26.553Z"); return t}()),
		// 				IsEncrypted: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:02:26.553Z"); return t}()),
		// 				Value: to.Ptr("\"server99.domain.com\""),
		// 			},
		// 	}},
		// }
	}
}
