//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// TestJobServer is a fake server for instances of the armautomation.TestJobClient type.
type TestJobServer struct {
	// Create is the fake for method TestJobClient.Create
	// HTTP status codes to indicate success: http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, parameters armautomation.TestJobCreateParameters, options *armautomation.TestJobClientCreateOptions) (resp azfake.Responder[armautomation.TestJobClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method TestJobClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, options *armautomation.TestJobClientGetOptions) (resp azfake.Responder[armautomation.TestJobClientGetResponse], errResp azfake.ErrorResponder)

	// Resume is the fake for method TestJobClient.Resume
	// HTTP status codes to indicate success: http.StatusOK
	Resume func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, options *armautomation.TestJobClientResumeOptions) (resp azfake.Responder[armautomation.TestJobClientResumeResponse], errResp azfake.ErrorResponder)

	// Stop is the fake for method TestJobClient.Stop
	// HTTP status codes to indicate success: http.StatusOK
	Stop func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, options *armautomation.TestJobClientStopOptions) (resp azfake.Responder[armautomation.TestJobClientStopResponse], errResp azfake.ErrorResponder)

	// Suspend is the fake for method TestJobClient.Suspend
	// HTTP status codes to indicate success: http.StatusOK
	Suspend func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, options *armautomation.TestJobClientSuspendOptions) (resp azfake.Responder[armautomation.TestJobClientSuspendResponse], errResp azfake.ErrorResponder)
}

// NewTestJobServerTransport creates a new instance of TestJobServerTransport with the provided implementation.
// The returned TestJobServerTransport instance is connected to an instance of armautomation.TestJobClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTestJobServerTransport(srv *TestJobServer) *TestJobServerTransport {
	return &TestJobServerTransport{srv: srv}
}

// TestJobServerTransport connects instances of armautomation.TestJobClient to instances of TestJobServer.
// Don't use this type directly, use NewTestJobServerTransport instead.
type TestJobServerTransport struct {
	srv *TestJobServer
}

// Do implements the policy.Transporter interface for TestJobServerTransport.
func (t *TestJobServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TestJobClient.Create":
		resp, err = t.dispatchCreate(req)
	case "TestJobClient.Get":
		resp, err = t.dispatchGet(req)
	case "TestJobClient.Resume":
		resp, err = t.dispatchResume(req)
	case "TestJobClient.Stop":
		resp, err = t.dispatchStop(req)
	case "TestJobClient.Suspend":
		resp, err = t.dispatchSuspend(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TestJobServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if t.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/testJob`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armautomation.TestJobCreateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Create(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TestJob, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TestJobServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/testJob`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TestJob, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TestJobServerTransport) dispatchResume(req *http.Request) (*http.Response, error) {
	if t.srv.Resume == nil {
		return nil, &nonRetriableError{errors.New("fake for method Resume not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/testJob/resume`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Resume(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TestJobServerTransport) dispatchStop(req *http.Request) (*http.Response, error) {
	if t.srv.Stop == nil {
		return nil, &nonRetriableError{errors.New("fake for method Stop not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/testJob/stop`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Stop(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TestJobServerTransport) dispatchSuspend(req *http.Request) (*http.Response, error) {
	if t.srv.Suspend == nil {
		return nil, &nonRetriableError{errors.New("fake for method Suspend not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/testJob/suspend`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Suspend(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
