//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automanage/armautomanage"
	"net/http"
	"net/url"
	"regexp"
)

// ConfigurationProfileAssignmentsServer is a fake server for instances of the armautomanage.ConfigurationProfileAssignmentsClient type.
type ConfigurationProfileAssignmentsServer struct {
	// CreateOrUpdate is the fake for method ConfigurationProfileAssignmentsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, configurationProfileAssignmentName string, resourceGroupName string, vmName string, parameters armautomanage.ConfigurationProfileAssignment, options *armautomanage.ConfigurationProfileAssignmentsClientCreateOrUpdateOptions) (resp azfake.Responder[armautomanage.ConfigurationProfileAssignmentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ConfigurationProfileAssignmentsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, configurationProfileAssignmentName string, vmName string, options *armautomanage.ConfigurationProfileAssignmentsClientDeleteOptions) (resp azfake.Responder[armautomanage.ConfigurationProfileAssignmentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ConfigurationProfileAssignmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, configurationProfileAssignmentName string, vmName string, options *armautomanage.ConfigurationProfileAssignmentsClientGetOptions) (resp azfake.Responder[armautomanage.ConfigurationProfileAssignmentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ConfigurationProfileAssignmentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armautomanage.ConfigurationProfileAssignmentsClientListOptions) (resp azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListResponse])

	// NewListByClusterNamePager is the fake for method ConfigurationProfileAssignmentsClient.NewListByClusterNamePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByClusterNamePager func(resourceGroupName string, clusterName string, options *armautomanage.ConfigurationProfileAssignmentsClientListByClusterNameOptions) (resp azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListByClusterNameResponse])

	// NewListByMachineNamePager is the fake for method ConfigurationProfileAssignmentsClient.NewListByMachineNamePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByMachineNamePager func(resourceGroupName string, machineName string, options *armautomanage.ConfigurationProfileAssignmentsClientListByMachineNameOptions) (resp azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListByMachineNameResponse])

	// NewListBySubscriptionPager is the fake for method ConfigurationProfileAssignmentsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armautomanage.ConfigurationProfileAssignmentsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListBySubscriptionResponse])

	// NewListByVirtualMachinesPager is the fake for method ConfigurationProfileAssignmentsClient.NewListByVirtualMachinesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByVirtualMachinesPager func(resourceGroupName string, vmName string, options *armautomanage.ConfigurationProfileAssignmentsClientListByVirtualMachinesOptions) (resp azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListByVirtualMachinesResponse])
}

// NewConfigurationProfileAssignmentsServerTransport creates a new instance of ConfigurationProfileAssignmentsServerTransport with the provided implementation.
// The returned ConfigurationProfileAssignmentsServerTransport instance is connected to an instance of armautomanage.ConfigurationProfileAssignmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConfigurationProfileAssignmentsServerTransport(srv *ConfigurationProfileAssignmentsServer) *ConfigurationProfileAssignmentsServerTransport {
	return &ConfigurationProfileAssignmentsServerTransport{
		srv:                           srv,
		newListPager:                  newTracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListResponse]](),
		newListByClusterNamePager:     newTracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListByClusterNameResponse]](),
		newListByMachineNamePager:     newTracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListByMachineNameResponse]](),
		newListBySubscriptionPager:    newTracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListBySubscriptionResponse]](),
		newListByVirtualMachinesPager: newTracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListByVirtualMachinesResponse]](),
	}
}

// ConfigurationProfileAssignmentsServerTransport connects instances of armautomanage.ConfigurationProfileAssignmentsClient to instances of ConfigurationProfileAssignmentsServer.
// Don't use this type directly, use NewConfigurationProfileAssignmentsServerTransport instead.
type ConfigurationProfileAssignmentsServerTransport struct {
	srv                           *ConfigurationProfileAssignmentsServer
	newListPager                  *tracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListResponse]]
	newListByClusterNamePager     *tracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListByClusterNameResponse]]
	newListByMachineNamePager     *tracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListByMachineNameResponse]]
	newListBySubscriptionPager    *tracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListBySubscriptionResponse]]
	newListByVirtualMachinesPager *tracker[azfake.PagerResponder[armautomanage.ConfigurationProfileAssignmentsClientListByVirtualMachinesResponse]]
}

// Do implements the policy.Transporter interface for ConfigurationProfileAssignmentsServerTransport.
func (c *ConfigurationProfileAssignmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConfigurationProfileAssignmentsClient.CreateOrUpdate":
		resp, err = c.dispatchCreateOrUpdate(req)
	case "ConfigurationProfileAssignmentsClient.Delete":
		resp, err = c.dispatchDelete(req)
	case "ConfigurationProfileAssignmentsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConfigurationProfileAssignmentsClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "ConfigurationProfileAssignmentsClient.NewListByClusterNamePager":
		resp, err = c.dispatchNewListByClusterNamePager(req)
	case "ConfigurationProfileAssignmentsClient.NewListByMachineNamePager":
		resp, err = c.dispatchNewListByMachineNamePager(req)
	case "ConfigurationProfileAssignmentsClient.NewListBySubscriptionPager":
		resp, err = c.dispatchNewListBySubscriptionPager(req)
	case "ConfigurationProfileAssignmentsClient.NewListByVirtualMachinesPager":
		resp, err = c.dispatchNewListByVirtualMachinesPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConfigurationProfileAssignmentsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfileAssignments/(?P<configurationProfileAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armautomanage.ConfigurationProfileAssignment](req)
	if err != nil {
		return nil, err
	}
	configurationProfileAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationProfileAssignmentName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateOrUpdate(req.Context(), configurationProfileAssignmentNameParam, resourceGroupNameParam, vmNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigurationProfileAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationProfileAssignmentsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if c.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfileAssignments/(?P<configurationProfileAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	configurationProfileAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationProfileAssignmentName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Delete(req.Context(), resourceGroupNameParam, configurationProfileAssignmentNameParam, vmNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationProfileAssignmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfileAssignments/(?P<configurationProfileAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	configurationProfileAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationProfileAssignmentName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, configurationProfileAssignmentNameParam, vmNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigurationProfileAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationProfileAssignmentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfileAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *ConfigurationProfileAssignmentsServerTransport) dispatchNewListByClusterNamePager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByClusterNamePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByClusterNamePager not implemented")}
	}
	newListByClusterNamePager := c.newListByClusterNamePager.get(req)
	if newListByClusterNamePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureStackHci/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfileAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByClusterNamePager(resourceGroupNameParam, clusterNameParam, nil)
		newListByClusterNamePager = &resp
		c.newListByClusterNamePager.add(req, newListByClusterNamePager)
	}
	resp, err := server.PagerResponderNext(newListByClusterNamePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByClusterNamePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByClusterNamePager) {
		c.newListByClusterNamePager.remove(req)
	}
	return resp, nil
}

func (c *ConfigurationProfileAssignmentsServerTransport) dispatchNewListByMachineNamePager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByMachineNamePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByMachineNamePager not implemented")}
	}
	newListByMachineNamePager := c.newListByMachineNamePager.get(req)
	if newListByMachineNamePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridCompute/machines/(?P<machineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfileAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		machineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("machineName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByMachineNamePager(resourceGroupNameParam, machineNameParam, nil)
		newListByMachineNamePager = &resp
		c.newListByMachineNamePager.add(req, newListByMachineNamePager)
	}
	resp, err := server.PagerResponderNext(newListByMachineNamePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByMachineNamePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByMachineNamePager) {
		c.newListByMachineNamePager.remove(req)
	}
	return resp, nil
}

func (c *ConfigurationProfileAssignmentsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := c.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfileAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		c.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		c.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (c *ConfigurationProfileAssignmentsServerTransport) dispatchNewListByVirtualMachinesPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByVirtualMachinesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByVirtualMachinesPager not implemented")}
	}
	newListByVirtualMachinesPager := c.newListByVirtualMachinesPager.get(req)
	if newListByVirtualMachinesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automanage/configurationProfileAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByVirtualMachinesPager(resourceGroupNameParam, vmNameParam, nil)
		newListByVirtualMachinesPager = &resp
		c.newListByVirtualMachinesPager.add(req, newListByVirtualMachinesPager)
	}
	resp, err := server.PagerResponderNext(newListByVirtualMachinesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByVirtualMachinesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByVirtualMachinesPager) {
		c.newListByVirtualMachinesPager.remove(req)
	}
	return resp, nil
}
