//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// APIProductServer is a fake server for instances of the armapimanagement.APIProductClient type.
type APIProductServer struct {
	// NewListByApisPager is the fake for method APIProductClient.NewListByApisPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByApisPager func(resourceGroupName string, serviceName string, apiID string, options *armapimanagement.APIProductClientListByApisOptions) (resp azfake.PagerResponder[armapimanagement.APIProductClientListByApisResponse])
}

// NewAPIProductServerTransport creates a new instance of APIProductServerTransport with the provided implementation.
// The returned APIProductServerTransport instance is connected to an instance of armapimanagement.APIProductClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAPIProductServerTransport(srv *APIProductServer) *APIProductServerTransport {
	return &APIProductServerTransport{
		srv:                srv,
		newListByApisPager: newTracker[azfake.PagerResponder[armapimanagement.APIProductClientListByApisResponse]](),
	}
}

// APIProductServerTransport connects instances of armapimanagement.APIProductClient to instances of APIProductServer.
// Don't use this type directly, use NewAPIProductServerTransport instead.
type APIProductServerTransport struct {
	srv                *APIProductServer
	newListByApisPager *tracker[azfake.PagerResponder[armapimanagement.APIProductClientListByApisResponse]]
}

// Do implements the policy.Transporter interface for APIProductServerTransport.
func (a *APIProductServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "APIProductClient.NewListByApisPager":
		resp, err = a.dispatchNewListByApisPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *APIProductServerTransport) dispatchNewListByApisPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByApisPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByApisPager not implemented")}
	}
	newListByApisPager := a.newListByApisPager.get(req)
	if newListByApisPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apis/(?P<apiId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		apiIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armapimanagement.APIProductClientListByApisOptions
		if filterParam != nil || topParam != nil || skipParam != nil {
			options = &armapimanagement.APIProductClientListByApisOptions{
				Filter: filterParam,
				Top:    topParam,
				Skip:   skipParam,
			}
		}
		resp := a.srv.NewListByApisPager(resourceGroupNameParam, serviceNameParam, apiIDParam, options)
		newListByApisPager = &resp
		a.newListByApisPager.add(req, newListByApisPager)
		server.PagerResponderInjectNextLinks(newListByApisPager, req, func(page *armapimanagement.APIProductClientListByApisResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByApisPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByApisPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByApisPager) {
		a.newListByApisPager.remove(req)
	}
	return resp, nil
}
