//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdns

type HTTPStatusCode string

const (
	HTTPStatusCodeContinue                     HTTPStatusCode = "Continue"
	HTTPStatusCodeSwitchingProtocols           HTTPStatusCode = "SwitchingProtocols"
	HTTPStatusCodeOK                           HTTPStatusCode = "OK"
	HTTPStatusCodeCreated                      HTTPStatusCode = "Created"
	HTTPStatusCodeAccepted                     HTTPStatusCode = "Accepted"
	HTTPStatusCodeNonAuthoritativeInformation  HTTPStatusCode = "NonAuthoritativeInformation"
	HTTPStatusCodeNoContent                    HTTPStatusCode = "NoContent"
	HTTPStatusCodeResetContent                 HTTPStatusCode = "ResetContent"
	HTTPStatusCodePartialContent               HTTPStatusCode = "PartialContent"
	HTTPStatusCodeMultipleChoices              HTTPStatusCode = "MultipleChoices"
	HTTPStatusCodeAmbiguous                    HTTPStatusCode = "Ambiguous"
	HTTPStatusCodeMovedPermanently             HTTPStatusCode = "MovedPermanently"
	HTTPStatusCodeMoved                        HTTPStatusCode = "Moved"
	HTTPStatusCodeFound                        HTTPStatusCode = "Found"
	HTTPStatusCodeRedirect                     HTTPStatusCode = "Redirect"
	HTTPStatusCodeSeeOther                     HTTPStatusCode = "SeeOther"
	HTTPStatusCodeRedirectMethod               HTTPStatusCode = "RedirectMethod"
	HTTPStatusCodeNotModified                  HTTPStatusCode = "NotModified"
	HTTPStatusCodeUseProxy                     HTTPStatusCode = "UseProxy"
	HTTPStatusCodeUnused                       HTTPStatusCode = "Unused"
	HTTPStatusCodeTemporaryRedirect            HTTPStatusCode = "TemporaryRedirect"
	HTTPStatusCodeRedirectKeepVerb             HTTPStatusCode = "RedirectKeepVerb"
	HTTPStatusCodeBadRequest                   HTTPStatusCode = "BadRequest"
	HTTPStatusCodeUnauthorized                 HTTPStatusCode = "Unauthorized"
	HTTPStatusCodePaymentRequired              HTTPStatusCode = "PaymentRequired"
	HTTPStatusCodeForbidden                    HTTPStatusCode = "Forbidden"
	HTTPStatusCodeNotFound                     HTTPStatusCode = "NotFound"
	HTTPStatusCodeMethodNotAllowed             HTTPStatusCode = "MethodNotAllowed"
	HTTPStatusCodeNotAcceptable                HTTPStatusCode = "NotAcceptable"
	HTTPStatusCodeProxyAuthenticationRequired  HTTPStatusCode = "ProxyAuthenticationRequired"
	HTTPStatusCodeRequestTimeout               HTTPStatusCode = "RequestTimeout"
	HTTPStatusCodeConflict                     HTTPStatusCode = "Conflict"
	HTTPStatusCodeGone                         HTTPStatusCode = "Gone"
	HTTPStatusCodeLengthRequired               HTTPStatusCode = "LengthRequired"
	HTTPStatusCodePreconditionFailed           HTTPStatusCode = "PreconditionFailed"
	HTTPStatusCodeRequestEntityTooLarge        HTTPStatusCode = "RequestEntityTooLarge"
	HTTPStatusCodeRequestURITooLong            HTTPStatusCode = "RequestUriTooLong"
	HTTPStatusCodeUnsupportedMediaType         HTTPStatusCode = "UnsupportedMediaType"
	HTTPStatusCodeRequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	HTTPStatusCodeExpectationFailed            HTTPStatusCode = "ExpectationFailed"
	HTTPStatusCodeUpgradeRequired              HTTPStatusCode = "UpgradeRequired"
	HTTPStatusCodeInternalServerError          HTTPStatusCode = "InternalServerError"
	HTTPStatusCodeNotImplemented               HTTPStatusCode = "NotImplemented"
	HTTPStatusCodeBadGateway                   HTTPStatusCode = "BadGateway"
	HTTPStatusCodeServiceUnavailable           HTTPStatusCode = "ServiceUnavailable"
	HTTPStatusCodeGatewayTimeout               HTTPStatusCode = "GatewayTimeout"
	HTTPStatusCodeHTTPVersionNotSupported      HTTPStatusCode = "HttpVersionNotSupported"
)

// PossibleHTTPStatusCodeValues returns the possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{
		HTTPStatusCodeContinue,
		HTTPStatusCodeSwitchingProtocols,
		HTTPStatusCodeOK,
		HTTPStatusCodeCreated,
		HTTPStatusCodeAccepted,
		HTTPStatusCodeNonAuthoritativeInformation,
		HTTPStatusCodeNoContent,
		HTTPStatusCodeResetContent,
		HTTPStatusCodePartialContent,
		HTTPStatusCodeMultipleChoices,
		HTTPStatusCodeAmbiguous,
		HTTPStatusCodeMovedPermanently,
		HTTPStatusCodeMoved,
		HTTPStatusCodeFound,
		HTTPStatusCodeRedirect,
		HTTPStatusCodeSeeOther,
		HTTPStatusCodeRedirectMethod,
		HTTPStatusCodeNotModified,
		HTTPStatusCodeUseProxy,
		HTTPStatusCodeUnused,
		HTTPStatusCodeTemporaryRedirect,
		HTTPStatusCodeRedirectKeepVerb,
		HTTPStatusCodeBadRequest,
		HTTPStatusCodeUnauthorized,
		HTTPStatusCodePaymentRequired,
		HTTPStatusCodeForbidden,
		HTTPStatusCodeNotFound,
		HTTPStatusCodeMethodNotAllowed,
		HTTPStatusCodeNotAcceptable,
		HTTPStatusCodeProxyAuthenticationRequired,
		HTTPStatusCodeRequestTimeout,
		HTTPStatusCodeConflict,
		HTTPStatusCodeGone,
		HTTPStatusCodeLengthRequired,
		HTTPStatusCodePreconditionFailed,
		HTTPStatusCodeRequestEntityTooLarge,
		HTTPStatusCodeRequestURITooLong,
		HTTPStatusCodeUnsupportedMediaType,
		HTTPStatusCodeRequestedRangeNotSatisfiable,
		HTTPStatusCodeExpectationFailed,
		HTTPStatusCodeUpgradeRequired,
		HTTPStatusCodeInternalServerError,
		HTTPStatusCodeNotImplemented,
		HTTPStatusCodeBadGateway,
		HTTPStatusCodeServiceUnavailable,
		HTTPStatusCodeGatewayTimeout,
		HTTPStatusCodeHTTPVersionNotSupported,
	}
}

type OperationStatus string

const (
	OperationStatusInProgress OperationStatus = "InProgress"
	OperationStatusSucceeded  OperationStatus = "Succeeded"
	OperationStatusFailed     OperationStatus = "Failed"
)

// PossibleOperationStatusValues returns the possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{
		OperationStatusInProgress,
		OperationStatusSucceeded,
		OperationStatusFailed,
	}
}

type RecordType string

const (
	RecordTypeA     RecordType = "A"
	RecordTypeAAAA  RecordType = "AAAA"
	RecordTypeCNAME RecordType = "CNAME"
	RecordTypeMX    RecordType = "MX"
	RecordTypeNS    RecordType = "NS"
	RecordTypePTR   RecordType = "PTR"
	RecordTypeSOA   RecordType = "SOA"
	RecordTypeSRV   RecordType = "SRV"
	RecordTypeTXT   RecordType = "TXT"
)

// PossibleRecordTypeValues returns the possible values for the RecordType const type.
func PossibleRecordTypeValues() []RecordType {
	return []RecordType{
		RecordTypeA,
		RecordTypeAAAA,
		RecordTypeCNAME,
		RecordTypeMX,
		RecordTypeNS,
		RecordTypePTR,
		RecordTypeSOA,
		RecordTypeSRV,
		RecordTypeTXT,
	}
}

// ZoneType - The type of this DNS zone (Public or Private).
type ZoneType string

const (
	ZoneTypePublic  ZoneType = "Public"
	ZoneTypePrivate ZoneType = "Private"
)

// PossibleZoneTypeValues returns the possible values for the ZoneType const type.
func PossibleZoneTypeValues() []ZoneType {
	return []ZoneType{
		ZoneTypePublic,
		ZoneTypePrivate,
	}
}
