//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdataboxedge

// AccountType - Type of storage accessed on the storage account.
type AccountType string

const (
	AccountTypeBlobStorage           AccountType = "BlobStorage"
	AccountTypeGeneralPurposeStorage AccountType = "GeneralPurposeStorage"
)

// PossibleAccountTypeValues returns the possible values for the AccountType const type.
func PossibleAccountTypeValues() []AccountType {
	return []AccountType{
		AccountTypeBlobStorage,
		AccountTypeGeneralPurposeStorage,
	}
}

// AlertSeverity - Severity of the alert.
type AlertSeverity string

const (
	AlertSeverityCritical      AlertSeverity = "Critical"
	AlertSeverityInformational AlertSeverity = "Informational"
	AlertSeverityWarning       AlertSeverity = "Warning"
)

// PossibleAlertSeverityValues returns the possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{
		AlertSeverityCritical,
		AlertSeverityInformational,
		AlertSeverityWarning,
	}
}

// AuthenticationType - The authentication type.
type AuthenticationType string

const (
	AuthenticationTypeAzureActiveDirectory AuthenticationType = "AzureActiveDirectory"
	AuthenticationTypeInvalid              AuthenticationType = "Invalid"
)

// PossibleAuthenticationTypeValues returns the possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{
		AuthenticationTypeAzureActiveDirectory,
		AuthenticationTypeInvalid,
	}
}

// AzureContainerDataFormat - Storage format used for the file represented by the share.
type AzureContainerDataFormat string

const (
	AzureContainerDataFormatAzureFile AzureContainerDataFormat = "AzureFile"
	AzureContainerDataFormatBlockBlob AzureContainerDataFormat = "BlockBlob"
	AzureContainerDataFormatPageBlob  AzureContainerDataFormat = "PageBlob"
)

// PossibleAzureContainerDataFormatValues returns the possible values for the AzureContainerDataFormat const type.
func PossibleAzureContainerDataFormatValues() []AzureContainerDataFormat {
	return []AzureContainerDataFormat{
		AzureContainerDataFormatAzureFile,
		AzureContainerDataFormatBlockBlob,
		AzureContainerDataFormatPageBlob,
	}
}

// ClientPermissionType - Type of access to be allowed for the client.
type ClientPermissionType string

const (
	ClientPermissionTypeNoAccess  ClientPermissionType = "NoAccess"
	ClientPermissionTypeReadOnly  ClientPermissionType = "ReadOnly"
	ClientPermissionTypeReadWrite ClientPermissionType = "ReadWrite"
)

// PossibleClientPermissionTypeValues returns the possible values for the ClientPermissionType const type.
func PossibleClientPermissionTypeValues() []ClientPermissionType {
	return []ClientPermissionType{
		ClientPermissionTypeNoAccess,
		ClientPermissionTypeReadOnly,
		ClientPermissionTypeReadWrite,
	}
}

// ContainerStatus - Current status of the container.
type ContainerStatus string

const (
	ContainerStatusNeedsAttention ContainerStatus = "NeedsAttention"
	ContainerStatusOK             ContainerStatus = "OK"
	ContainerStatusOffline        ContainerStatus = "Offline"
	ContainerStatusUnknown        ContainerStatus = "Unknown"
	ContainerStatusUpdating       ContainerStatus = "Updating"
)

// PossibleContainerStatusValues returns the possible values for the ContainerStatus const type.
func PossibleContainerStatusValues() []ContainerStatus {
	return []ContainerStatus{
		ContainerStatusNeedsAttention,
		ContainerStatusOK,
		ContainerStatusOffline,
		ContainerStatusUnknown,
		ContainerStatusUpdating,
	}
}

// DataBoxEdgeDeviceStatus - The status of the Data Box Edge/Gateway device.
type DataBoxEdgeDeviceStatus string

const (
	DataBoxEdgeDeviceStatusDisconnected          DataBoxEdgeDeviceStatus = "Disconnected"
	DataBoxEdgeDeviceStatusMaintenance           DataBoxEdgeDeviceStatus = "Maintenance"
	DataBoxEdgeDeviceStatusNeedsAttention        DataBoxEdgeDeviceStatus = "NeedsAttention"
	DataBoxEdgeDeviceStatusOffline               DataBoxEdgeDeviceStatus = "Offline"
	DataBoxEdgeDeviceStatusOnline                DataBoxEdgeDeviceStatus = "Online"
	DataBoxEdgeDeviceStatusPartiallyDisconnected DataBoxEdgeDeviceStatus = "PartiallyDisconnected"
	DataBoxEdgeDeviceStatusReadyToSetup          DataBoxEdgeDeviceStatus = "ReadyToSetup"
)

// PossibleDataBoxEdgeDeviceStatusValues returns the possible values for the DataBoxEdgeDeviceStatus const type.
func PossibleDataBoxEdgeDeviceStatusValues() []DataBoxEdgeDeviceStatus {
	return []DataBoxEdgeDeviceStatus{
		DataBoxEdgeDeviceStatusDisconnected,
		DataBoxEdgeDeviceStatusMaintenance,
		DataBoxEdgeDeviceStatusNeedsAttention,
		DataBoxEdgeDeviceStatusOffline,
		DataBoxEdgeDeviceStatusOnline,
		DataBoxEdgeDeviceStatusPartiallyDisconnected,
		DataBoxEdgeDeviceStatusReadyToSetup,
	}
}

// DataPolicy - Data policy of the share.
type DataPolicy string

const (
	DataPolicyCloud DataPolicy = "Cloud"
	DataPolicyLocal DataPolicy = "Local"
)

// PossibleDataPolicyValues returns the possible values for the DataPolicy const type.
func PossibleDataPolicyValues() []DataPolicy {
	return []DataPolicy{
		DataPolicyCloud,
		DataPolicyLocal,
	}
}

type DayOfWeek string

const (
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekFriday,
		DayOfWeekMonday,
		DayOfWeekSaturday,
		DayOfWeekSunday,
		DayOfWeekThursday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
	}
}

// DeviceType - The type of the Data Box Edge/Gateway device.
type DeviceType string

const (
	DeviceTypeDataBoxEdgeDevice DeviceType = "DataBoxEdgeDevice"
)

// PossibleDeviceTypeValues returns the possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{
		DeviceTypeDataBoxEdgeDevice,
	}
}

// DownloadPhase - The download phase.
type DownloadPhase string

const (
	DownloadPhaseDownloading  DownloadPhase = "Downloading"
	DownloadPhaseInitializing DownloadPhase = "Initializing"
	DownloadPhaseUnknown      DownloadPhase = "Unknown"
	DownloadPhaseVerifying    DownloadPhase = "Verifying"
)

// PossibleDownloadPhaseValues returns the possible values for the DownloadPhase const type.
func PossibleDownloadPhaseValues() []DownloadPhase {
	return []DownloadPhase{
		DownloadPhaseDownloading,
		DownloadPhaseInitializing,
		DownloadPhaseUnknown,
		DownloadPhaseVerifying,
	}
}

// EncryptionAlgorithm - The algorithm used to encrypt "Value".
type EncryptionAlgorithm string

const (
	EncryptionAlgorithmAES256        EncryptionAlgorithm = "AES256"
	EncryptionAlgorithmNone          EncryptionAlgorithm = "None"
	EncryptionAlgorithmRSAESPKCS1V15 EncryptionAlgorithm = "RSAES_PKCS1_v_1_5"
)

// PossibleEncryptionAlgorithmValues returns the possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{
		EncryptionAlgorithmAES256,
		EncryptionAlgorithmNone,
		EncryptionAlgorithmRSAESPKCS1V15,
	}
}

// InstallRebootBehavior - Indicates if updates are available and at least one of the updates needs a reboot.
type InstallRebootBehavior string

const (
	InstallRebootBehaviorNeverReboots   InstallRebootBehavior = "NeverReboots"
	InstallRebootBehaviorRequestReboot  InstallRebootBehavior = "RequestReboot"
	InstallRebootBehaviorRequiresReboot InstallRebootBehavior = "RequiresReboot"
)

// PossibleInstallRebootBehaviorValues returns the possible values for the InstallRebootBehavior const type.
func PossibleInstallRebootBehaviorValues() []InstallRebootBehavior {
	return []InstallRebootBehavior{
		InstallRebootBehaviorNeverReboots,
		InstallRebootBehaviorRequestReboot,
		InstallRebootBehaviorRequiresReboot,
	}
}

// JobStatus - The current status of the job.
type JobStatus string

const (
	JobStatusCanceled  JobStatus = "Canceled"
	JobStatusFailed    JobStatus = "Failed"
	JobStatusInvalid   JobStatus = "Invalid"
	JobStatusPaused    JobStatus = "Paused"
	JobStatusRunning   JobStatus = "Running"
	JobStatusScheduled JobStatus = "Scheduled"
	JobStatusSucceeded JobStatus = "Succeeded"
)

// PossibleJobStatusValues returns the possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{
		JobStatusCanceled,
		JobStatusFailed,
		JobStatusInvalid,
		JobStatusPaused,
		JobStatusRunning,
		JobStatusScheduled,
		JobStatusSucceeded,
	}
}

// JobType - The type of the job.
type JobType string

const (
	JobTypeDownloadUpdates  JobType = "DownloadUpdates"
	JobTypeInstallUpdates   JobType = "InstallUpdates"
	JobTypeInvalid          JobType = "Invalid"
	JobTypeRefreshContainer JobType = "RefreshContainer"
	JobTypeRefreshShare     JobType = "RefreshShare"
	JobTypeScanForUpdates   JobType = "ScanForUpdates"
)

// PossibleJobTypeValues returns the possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{
		JobTypeDownloadUpdates,
		JobTypeInstallUpdates,
		JobTypeInvalid,
		JobTypeRefreshContainer,
		JobTypeRefreshShare,
		JobTypeScanForUpdates,
	}
}

// MetricAggregationType - Metric aggregation type.
type MetricAggregationType string

const (
	MetricAggregationTypeAverage      MetricAggregationType = "Average"
	MetricAggregationTypeCount        MetricAggregationType = "Count"
	MetricAggregationTypeMaximum      MetricAggregationType = "Maximum"
	MetricAggregationTypeMinimum      MetricAggregationType = "Minimum"
	MetricAggregationTypeNone         MetricAggregationType = "None"
	MetricAggregationTypeNotSpecified MetricAggregationType = "NotSpecified"
	MetricAggregationTypeTotal        MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns the possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{
		MetricAggregationTypeAverage,
		MetricAggregationTypeCount,
		MetricAggregationTypeMaximum,
		MetricAggregationTypeMinimum,
		MetricAggregationTypeNone,
		MetricAggregationTypeNotSpecified,
		MetricAggregationTypeTotal,
	}
}

// MetricCategory - Metric category.
type MetricCategory string

const (
	MetricCategoryCapacity    MetricCategory = "Capacity"
	MetricCategoryTransaction MetricCategory = "Transaction"
)

// PossibleMetricCategoryValues returns the possible values for the MetricCategory const type.
func PossibleMetricCategoryValues() []MetricCategory {
	return []MetricCategory{
		MetricCategoryCapacity,
		MetricCategoryTransaction,
	}
}

// MetricUnit - Metric units.
type MetricUnit string

const (
	MetricUnitBytes          MetricUnit = "Bytes"
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	MetricUnitCount          MetricUnit = "Count"
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	MetricUnitMilliseconds   MetricUnit = "Milliseconds"
	MetricUnitNotSpecified   MetricUnit = "NotSpecified"
	MetricUnitPercent        MetricUnit = "Percent"
	MetricUnitSeconds        MetricUnit = "Seconds"
)

// PossibleMetricUnitValues returns the possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{
		MetricUnitBytes,
		MetricUnitBytesPerSecond,
		MetricUnitCount,
		MetricUnitCountPerSecond,
		MetricUnitMilliseconds,
		MetricUnitNotSpecified,
		MetricUnitPercent,
		MetricUnitSeconds,
	}
}

// MonitoringStatus - Current monitoring status of the share.
type MonitoringStatus string

const (
	MonitoringStatusDisabled MonitoringStatus = "Disabled"
	MonitoringStatusEnabled  MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns the possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{
		MonitoringStatusDisabled,
		MonitoringStatusEnabled,
	}
}

// NetworkAdapterDHCPStatus - Value indicating whether this adapter has DHCP enabled.
type NetworkAdapterDHCPStatus string

const (
	NetworkAdapterDHCPStatusDisabled NetworkAdapterDHCPStatus = "Disabled"
	NetworkAdapterDHCPStatusEnabled  NetworkAdapterDHCPStatus = "Enabled"
)

// PossibleNetworkAdapterDHCPStatusValues returns the possible values for the NetworkAdapterDHCPStatus const type.
func PossibleNetworkAdapterDHCPStatusValues() []NetworkAdapterDHCPStatus {
	return []NetworkAdapterDHCPStatus{
		NetworkAdapterDHCPStatusDisabled,
		NetworkAdapterDHCPStatusEnabled,
	}
}

// NetworkAdapterRDMAStatus - Value indicating whether this adapter is RDMA capable.
type NetworkAdapterRDMAStatus string

const (
	NetworkAdapterRDMAStatusCapable   NetworkAdapterRDMAStatus = "Capable"
	NetworkAdapterRDMAStatusIncapable NetworkAdapterRDMAStatus = "Incapable"
)

// PossibleNetworkAdapterRDMAStatusValues returns the possible values for the NetworkAdapterRDMAStatus const type.
func PossibleNetworkAdapterRDMAStatusValues() []NetworkAdapterRDMAStatus {
	return []NetworkAdapterRDMAStatus{
		NetworkAdapterRDMAStatusCapable,
		NetworkAdapterRDMAStatusIncapable,
	}
}

// NetworkAdapterStatus - Value indicating whether this adapter is valid.
type NetworkAdapterStatus string

const (
	NetworkAdapterStatusActive   NetworkAdapterStatus = "Active"
	NetworkAdapterStatusInactive NetworkAdapterStatus = "Inactive"
)

// PossibleNetworkAdapterStatusValues returns the possible values for the NetworkAdapterStatus const type.
func PossibleNetworkAdapterStatusValues() []NetworkAdapterStatus {
	return []NetworkAdapterStatus{
		NetworkAdapterStatusActive,
		NetworkAdapterStatusInactive,
	}
}

// NetworkGroup - The network group.
type NetworkGroup string

const (
	NetworkGroupNonRDMA NetworkGroup = "NonRDMA"
	NetworkGroupNone    NetworkGroup = "None"
	NetworkGroupRDMA    NetworkGroup = "RDMA"
)

// PossibleNetworkGroupValues returns the possible values for the NetworkGroup const type.
func PossibleNetworkGroupValues() []NetworkGroup {
	return []NetworkGroup{
		NetworkGroupNonRDMA,
		NetworkGroupNone,
		NetworkGroupRDMA,
	}
}

// NodeStatus - The current status of the individual node
type NodeStatus string

const (
	NodeStatusDown         NodeStatus = "Down"
	NodeStatusRebooting    NodeStatus = "Rebooting"
	NodeStatusShuttingDown NodeStatus = "ShuttingDown"
	NodeStatusUnknown      NodeStatus = "Unknown"
	NodeStatusUp           NodeStatus = "Up"
)

// PossibleNodeStatusValues returns the possible values for the NodeStatus const type.
func PossibleNodeStatusValues() []NodeStatus {
	return []NodeStatus{
		NodeStatusDown,
		NodeStatusRebooting,
		NodeStatusShuttingDown,
		NodeStatusUnknown,
		NodeStatusUp,
	}
}

// OrderState - Status of the order as per the allowed status types.
type OrderState string

const (
	OrderStateArriving               OrderState = "Arriving"
	OrderStateAwaitingFulfilment     OrderState = "AwaitingFulfilment"
	OrderStateAwaitingPreparation    OrderState = "AwaitingPreparation"
	OrderStateAwaitingReturnShipment OrderState = "AwaitingReturnShipment"
	OrderStateAwaitingShipment       OrderState = "AwaitingShipment"
	OrderStateCollectedAtMicrosoft   OrderState = "CollectedAtMicrosoft"
	OrderStateDeclined               OrderState = "Declined"
	OrderStateDelivered              OrderState = "Delivered"
	OrderStateLostDevice             OrderState = "LostDevice"
	OrderStateReplacementRequested   OrderState = "ReplacementRequested"
	OrderStateReturnInitiated        OrderState = "ReturnInitiated"
	OrderStateShipped                OrderState = "Shipped"
	OrderStateShippedBack            OrderState = "ShippedBack"
	OrderStateUntracked              OrderState = "Untracked"
)

// PossibleOrderStateValues returns the possible values for the OrderState const type.
func PossibleOrderStateValues() []OrderState {
	return []OrderState{
		OrderStateArriving,
		OrderStateAwaitingFulfilment,
		OrderStateAwaitingPreparation,
		OrderStateAwaitingReturnShipment,
		OrderStateAwaitingShipment,
		OrderStateCollectedAtMicrosoft,
		OrderStateDeclined,
		OrderStateDelivered,
		OrderStateLostDevice,
		OrderStateReplacementRequested,
		OrderStateReturnInitiated,
		OrderStateShipped,
		OrderStateShippedBack,
		OrderStateUntracked,
	}
}

// PlatformType - Host OS supported by the IoT role.
type PlatformType string

const (
	PlatformTypeLinux   PlatformType = "Linux"
	PlatformTypeWindows PlatformType = "Windows"
)

// PossiblePlatformTypeValues returns the possible values for the PlatformType const type.
func PossiblePlatformTypeValues() []PlatformType {
	return []PlatformType{
		PlatformTypeLinux,
		PlatformTypeWindows,
	}
}

// RoleStatus - Role status.
type RoleStatus string

const (
	RoleStatusDisabled RoleStatus = "Disabled"
	RoleStatusEnabled  RoleStatus = "Enabled"
)

// PossibleRoleStatusValues returns the possible values for the RoleStatus const type.
func PossibleRoleStatusValues() []RoleStatus {
	return []RoleStatus{
		RoleStatusDisabled,
		RoleStatusEnabled,
	}
}

type RoleTypes string

const (
	RoleTypesASA       RoleTypes = "ASA"
	RoleTypesCognitive RoleTypes = "Cognitive"
	RoleTypesFunctions RoleTypes = "Functions"
	RoleTypesIOT       RoleTypes = "IOT"
)

// PossibleRoleTypesValues returns the possible values for the RoleTypes const type.
func PossibleRoleTypesValues() []RoleTypes {
	return []RoleTypes{
		RoleTypesASA,
		RoleTypesCognitive,
		RoleTypesFunctions,
		RoleTypesIOT,
	}
}

// SKUName - The Sku name
type SKUName string

const (
	SKUNameEdge              SKUName = "Edge"
	SKUNameGateway           SKUName = "Gateway"
	SKUNameTEA1Node          SKUName = "TEA_1Node"
	SKUNameTEA1NodeHeater    SKUName = "TEA_1Node_Heater"
	SKUNameTEA1NodeUPS       SKUName = "TEA_1Node_UPS"
	SKUNameTEA1NodeUPSHeater SKUName = "TEA_1Node_UPS_Heater"
	SKUNameTEA4NodeHeater    SKUName = "TEA_4Node_Heater"
	SKUNameTEA4NodeUPSHeater SKUName = "TEA_4Node_UPS_Heater"
	SKUNameTMA               SKUName = "TMA"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameEdge,
		SKUNameGateway,
		SKUNameTEA1Node,
		SKUNameTEA1NodeHeater,
		SKUNameTEA1NodeUPS,
		SKUNameTEA1NodeUPSHeater,
		SKUNameTEA4NodeHeater,
		SKUNameTEA4NodeUPSHeater,
		SKUNameTMA,
	}
}

// SKURestrictionReasonCode - The SKU restriction reason.
type SKURestrictionReasonCode string

const (
	SKURestrictionReasonCodeNotAvailableForSubscription SKURestrictionReasonCode = "NotAvailableForSubscription"
	SKURestrictionReasonCodeQuotaID                     SKURestrictionReasonCode = "QuotaId"
)

// PossibleSKURestrictionReasonCodeValues returns the possible values for the SKURestrictionReasonCode const type.
func PossibleSKURestrictionReasonCodeValues() []SKURestrictionReasonCode {
	return []SKURestrictionReasonCode{
		SKURestrictionReasonCodeNotAvailableForSubscription,
		SKURestrictionReasonCodeQuotaID,
	}
}

// SKUTier - The Sku tier
type SKUTier string

const (
	SKUTierStandard SKUTier = "Standard"
)

// PossibleSKUTierValues returns the possible values for the SKUTier const type.
func PossibleSKUTierValues() []SKUTier {
	return []SKUTier{
		SKUTierStandard,
	}
}

// SSLStatus - Signifies whether SSL needs to be enabled or not.
type SSLStatus string

const (
	SSLStatusDisabled SSLStatus = "Disabled"
	SSLStatusEnabled  SSLStatus = "Enabled"
)

// PossibleSSLStatusValues returns the possible values for the SSLStatus const type.
func PossibleSSLStatusValues() []SSLStatus {
	return []SSLStatus{
		SSLStatusDisabled,
		SSLStatusEnabled,
	}
}

// ShareAccessProtocol - Access protocol to be used by the share.
type ShareAccessProtocol string

const (
	ShareAccessProtocolNFS ShareAccessProtocol = "NFS"
	ShareAccessProtocolSMB ShareAccessProtocol = "SMB"
)

// PossibleShareAccessProtocolValues returns the possible values for the ShareAccessProtocol const type.
func PossibleShareAccessProtocolValues() []ShareAccessProtocol {
	return []ShareAccessProtocol{
		ShareAccessProtocolNFS,
		ShareAccessProtocolSMB,
	}
}

// ShareAccessType - Type of access to be allowed on the share for this user.
type ShareAccessType string

const (
	ShareAccessTypeChange ShareAccessType = "Change"
	ShareAccessTypeCustom ShareAccessType = "Custom"
	ShareAccessTypeRead   ShareAccessType = "Read"
)

// PossibleShareAccessTypeValues returns the possible values for the ShareAccessType const type.
func PossibleShareAccessTypeValues() []ShareAccessType {
	return []ShareAccessType{
		ShareAccessTypeChange,
		ShareAccessTypeCustom,
		ShareAccessTypeRead,
	}
}

// ShareStatus - Current status of the share.
type ShareStatus string

const (
	ShareStatusNeedsAttention ShareStatus = "NeedsAttention"
	ShareStatusOK             ShareStatus = "OK"
	ShareStatusOffline        ShareStatus = "Offline"
	ShareStatusUnknown        ShareStatus = "Unknown"
	ShareStatusUpdating       ShareStatus = "Updating"
)

// PossibleShareStatusValues returns the possible values for the ShareStatus const type.
func PossibleShareStatusValues() []ShareStatus {
	return []ShareStatus{
		ShareStatusNeedsAttention,
		ShareStatusOK,
		ShareStatusOffline,
		ShareStatusUnknown,
		ShareStatusUpdating,
	}
}

// StorageAccountStatus - Current status of the storage account
type StorageAccountStatus string

const (
	StorageAccountStatusNeedsAttention StorageAccountStatus = "NeedsAttention"
	StorageAccountStatusOK             StorageAccountStatus = "OK"
	StorageAccountStatusOffline        StorageAccountStatus = "Offline"
	StorageAccountStatusUnknown        StorageAccountStatus = "Unknown"
	StorageAccountStatusUpdating       StorageAccountStatus = "Updating"
)

// PossibleStorageAccountStatusValues returns the possible values for the StorageAccountStatus const type.
func PossibleStorageAccountStatusValues() []StorageAccountStatus {
	return []StorageAccountStatus{
		StorageAccountStatusNeedsAttention,
		StorageAccountStatusOK,
		StorageAccountStatusOffline,
		StorageAccountStatusUnknown,
		StorageAccountStatusUpdating,
	}
}

type TimeGrain string

const (
	TimeGrainPT12H TimeGrain = "PT12H"
	TimeGrainPT15M TimeGrain = "PT15M"
	TimeGrainPT1D  TimeGrain = "PT1D"
	TimeGrainPT1H  TimeGrain = "PT1H"
	TimeGrainPT1M  TimeGrain = "PT1M"
	TimeGrainPT30M TimeGrain = "PT30M"
	TimeGrainPT5M  TimeGrain = "PT5M"
	TimeGrainPT6H  TimeGrain = "PT6H"
)

// PossibleTimeGrainValues returns the possible values for the TimeGrain const type.
func PossibleTimeGrainValues() []TimeGrain {
	return []TimeGrain{
		TimeGrainPT12H,
		TimeGrainPT15M,
		TimeGrainPT1D,
		TimeGrainPT1H,
		TimeGrainPT1M,
		TimeGrainPT30M,
		TimeGrainPT5M,
		TimeGrainPT6H,
	}
}

// TriggerEventType - Trigger Kind.
type TriggerEventType string

const (
	TriggerEventTypeFileEvent          TriggerEventType = "FileEvent"
	TriggerEventTypePeriodicTimerEvent TriggerEventType = "PeriodicTimerEvent"
)

// PossibleTriggerEventTypeValues returns the possible values for the TriggerEventType const type.
func PossibleTriggerEventTypeValues() []TriggerEventType {
	return []TriggerEventType{
		TriggerEventTypeFileEvent,
		TriggerEventTypePeriodicTimerEvent,
	}
}

// UpdateOperation - The current update operation.
type UpdateOperation string

const (
	UpdateOperationDownload UpdateOperation = "Download"
	UpdateOperationInstall  UpdateOperation = "Install"
	UpdateOperationNone     UpdateOperation = "None"
	UpdateOperationScan     UpdateOperation = "Scan"
)

// PossibleUpdateOperationValues returns the possible values for the UpdateOperation const type.
func PossibleUpdateOperationValues() []UpdateOperation {
	return []UpdateOperation{
		UpdateOperationDownload,
		UpdateOperationInstall,
		UpdateOperationNone,
		UpdateOperationScan,
	}
}

// UpdateOperationStage - Current stage of the update operation.
type UpdateOperationStage string

const (
	UpdateOperationStageDownloadComplete UpdateOperationStage = "DownloadComplete"
	UpdateOperationStageDownloadFailed   UpdateOperationStage = "DownloadFailed"
	UpdateOperationStageDownloadStarted  UpdateOperationStage = "DownloadStarted"
	UpdateOperationStageFailure          UpdateOperationStage = "Failure"
	UpdateOperationStageInitial          UpdateOperationStage = "Initial"
	UpdateOperationStageInstallComplete  UpdateOperationStage = "InstallComplete"
	UpdateOperationStageInstallFailed    UpdateOperationStage = "InstallFailed"
	UpdateOperationStageInstallStarted   UpdateOperationStage = "InstallStarted"
	UpdateOperationStageRebootInitiated  UpdateOperationStage = "RebootInitiated"
	UpdateOperationStageRescanComplete   UpdateOperationStage = "RescanComplete"
	UpdateOperationStageRescanFailed     UpdateOperationStage = "RescanFailed"
	UpdateOperationStageRescanStarted    UpdateOperationStage = "RescanStarted"
	UpdateOperationStageScanComplete     UpdateOperationStage = "ScanComplete"
	UpdateOperationStageScanFailed       UpdateOperationStage = "ScanFailed"
	UpdateOperationStageScanStarted      UpdateOperationStage = "ScanStarted"
	UpdateOperationStageSuccess          UpdateOperationStage = "Success"
	UpdateOperationStageUnknown          UpdateOperationStage = "Unknown"
)

// PossibleUpdateOperationStageValues returns the possible values for the UpdateOperationStage const type.
func PossibleUpdateOperationStageValues() []UpdateOperationStage {
	return []UpdateOperationStage{
		UpdateOperationStageDownloadComplete,
		UpdateOperationStageDownloadFailed,
		UpdateOperationStageDownloadStarted,
		UpdateOperationStageFailure,
		UpdateOperationStageInitial,
		UpdateOperationStageInstallComplete,
		UpdateOperationStageInstallFailed,
		UpdateOperationStageInstallStarted,
		UpdateOperationStageRebootInitiated,
		UpdateOperationStageRescanComplete,
		UpdateOperationStageRescanFailed,
		UpdateOperationStageRescanStarted,
		UpdateOperationStageScanComplete,
		UpdateOperationStageScanFailed,
		UpdateOperationStageScanStarted,
		UpdateOperationStageSuccess,
		UpdateOperationStageUnknown,
	}
}

// UserType - Type of the user.
type UserType string

const (
	UserTypeARM             UserType = "ARM"
	UserTypeLocalManagement UserType = "LocalManagement"
	UserTypeShare           UserType = "Share"
)

// PossibleUserTypeValues returns the possible values for the UserType const type.
func PossibleUserTypeValues() []UserType {
	return []UserType{
		UserTypeARM,
		UserTypeLocalManagement,
		UserTypeShare,
	}
}
