//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcompute

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIEntityReference.
func (a APIEntityReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIEntityReference.
func (a *APIEntityReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIError.
func (a APIError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "details", a.Details)
	populate(objectMap, "innererror", a.Innererror)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "target", a.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIError.
func (a *APIError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &a.Details)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &a.Innererror)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &a.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIErrorBase.
func (a APIErrorBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "target", a.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIErrorBase.
func (a *APIErrorBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &a.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessURI.
func (a AccessURI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessSAS", a.AccessSAS)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessURI.
func (a *AccessURI) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessSAS":
			err = unpopulate(val, "AccessSAS", &a.AccessSAS)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdditionalCapabilities.
func (a AdditionalCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ultraSSDEnabled", a.UltraSSDEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdditionalCapabilities.
func (a *AdditionalCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ultraSSDEnabled":
			err = unpopulate(val, "UltraSSDEnabled", &a.UltraSSDEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdditionalUnattendContent.
func (a AdditionalUnattendContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["componentName"] = "Microsoft-Windows-Shell-Setup"
	populate(objectMap, "content", a.Content)
	objectMap["passName"] = "OobeSystem"
	populate(objectMap, "settingName", a.SettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdditionalUnattendContent.
func (a *AdditionalUnattendContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentName":
			err = unpopulate(val, "ComponentName", &a.ComponentName)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "passName":
			err = unpopulate(val, "PassName", &a.PassName)
			delete(rawMsg, key)
		case "settingName":
			err = unpopulate(val, "SettingName", &a.SettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomaticOSUpgradePolicy.
func (a AutomaticOSUpgradePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disableAutomaticRollback", a.DisableAutomaticRollback)
	populate(objectMap, "enableAutomaticOSUpgrade", a.EnableAutomaticOSUpgrade)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomaticOSUpgradePolicy.
func (a *AutomaticOSUpgradePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableAutomaticRollback":
			err = unpopulate(val, "DisableAutomaticRollback", &a.DisableAutomaticRollback)
			delete(rawMsg, key)
		case "enableAutomaticOSUpgrade":
			err = unpopulate(val, "EnableAutomaticOSUpgrade", &a.EnableAutomaticOSUpgrade)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomaticOSUpgradeProperties.
func (a AutomaticOSUpgradeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "automaticOSUpgradeSupported", a.AutomaticOSUpgradeSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomaticOSUpgradeProperties.
func (a *AutomaticOSUpgradeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automaticOSUpgradeSupported":
			err = unpopulate(val, "AutomaticOSUpgradeSupported", &a.AutomaticOSUpgradeSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomaticRepairsPolicy.
func (a AutomaticRepairsPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "gracePeriod", a.GracePeriod)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomaticRepairsPolicy.
func (a *AutomaticRepairsPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "gracePeriod":
			err = unpopulate(val, "GracePeriod", &a.GracePeriod)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySet.
func (a AvailabilitySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySet.
func (a *AvailabilitySet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetListResult.
func (a AvailabilitySetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetListResult.
func (a *AvailabilitySetListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetProperties.
func (a AvailabilitySetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "platformFaultDomainCount", a.PlatformFaultDomainCount)
	populate(objectMap, "platformUpdateDomainCount", a.PlatformUpdateDomainCount)
	populate(objectMap, "proximityPlacementGroup", a.ProximityPlacementGroup)
	populate(objectMap, "statuses", a.Statuses)
	populate(objectMap, "virtualMachines", a.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetProperties.
func (a *AvailabilitySetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "platformFaultDomainCount":
			err = unpopulate(val, "PlatformFaultDomainCount", &a.PlatformFaultDomainCount)
			delete(rawMsg, key)
		case "platformUpdateDomainCount":
			err = unpopulate(val, "PlatformUpdateDomainCount", &a.PlatformUpdateDomainCount)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &a.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &a.Statuses)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &a.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetUpdate.
func (a AvailabilitySetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetUpdate.
func (a *AvailabilitySetUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailablePatchSummary.
func (a AvailablePatchSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assessmentActivityId", a.AssessmentActivityID)
	populate(objectMap, "criticalAndSecurityPatchCount", a.CriticalAndSecurityPatchCount)
	populate(objectMap, "error", a.Error)
	populateTimeRFC3339(objectMap, "lastModifiedTime", a.LastModifiedTime)
	populate(objectMap, "otherPatchCount", a.OtherPatchCount)
	populate(objectMap, "rebootPending", a.RebootPending)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailablePatchSummary.
func (a *AvailablePatchSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentActivityId":
			err = unpopulate(val, "AssessmentActivityID", &a.AssessmentActivityID)
			delete(rawMsg, key)
		case "criticalAndSecurityPatchCount":
			err = unpopulate(val, "CriticalAndSecurityPatchCount", &a.CriticalAndSecurityPatchCount)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &a.LastModifiedTime)
			delete(rawMsg, key)
		case "otherPatchCount":
			err = unpopulate(val, "OtherPatchCount", &a.OtherPatchCount)
			delete(rawMsg, key)
		case "rebootPending":
			err = unpopulate(val, "RebootPending", &a.RebootPending)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingProfile.
func (b BillingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxPrice", b.MaxPrice)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingProfile.
func (b *BillingProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxPrice":
			err = unpopulate(val, "MaxPrice", &b.MaxPrice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BootDiagnostics.
func (b BootDiagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", b.Enabled)
	populate(objectMap, "storageUri", b.StorageURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BootDiagnostics.
func (b *BootDiagnostics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &b.Enabled)
			delete(rawMsg, key)
		case "storageUri":
			err = unpopulate(val, "StorageURI", &b.StorageURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BootDiagnosticsInstanceView.
func (b BootDiagnosticsInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consoleScreenshotBlobUri", b.ConsoleScreenshotBlobURI)
	populate(objectMap, "serialConsoleLogBlobUri", b.SerialConsoleLogBlobURI)
	populate(objectMap, "status", b.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BootDiagnosticsInstanceView.
func (b *BootDiagnosticsInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consoleScreenshotBlobUri":
			err = unpopulate(val, "ConsoleScreenshotBlobURI", &b.ConsoleScreenshotBlobURI)
			delete(rawMsg, key)
		case "serialConsoleLogBlobUri":
			err = unpopulate(val, "SerialConsoleLogBlobURI", &b.SerialConsoleLogBlobURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &b.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreationData.
func (c CreationData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createOption", c.CreateOption)
	populate(objectMap, "imageReference", c.ImageReference)
	populate(objectMap, "sourceResourceId", c.SourceResourceID)
	populate(objectMap, "sourceUri", c.SourceURI)
	populate(objectMap, "sourceUniqueId", c.SourceUniqueID)
	populate(objectMap, "storageAccountId", c.StorageAccountID)
	populate(objectMap, "uploadSizeBytes", c.UploadSizeBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreationData.
func (c *CreationData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createOption":
			err = unpopulate(val, "CreateOption", &c.CreateOption)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &c.ImageReference)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &c.SourceResourceID)
			delete(rawMsg, key)
		case "sourceUri":
			err = unpopulate(val, "SourceURI", &c.SourceURI)
			delete(rawMsg, key)
		case "sourceUniqueId":
			err = unpopulate(val, "SourceUniqueID", &c.SourceUniqueID)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &c.StorageAccountID)
			delete(rawMsg, key)
		case "uploadSizeBytes":
			err = unpopulate(val, "UploadSizeBytes", &c.UploadSizeBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDisk.
func (d DataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", d.Caching)
	populate(objectMap, "createOption", d.CreateOption)
	populate(objectMap, "diskIOPSReadWrite", d.DiskIOPSReadWrite)
	populate(objectMap, "diskMBpsReadWrite", d.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeGB", d.DiskSizeGB)
	populate(objectMap, "image", d.Image)
	populate(objectMap, "lun", d.Lun)
	populate(objectMap, "managedDisk", d.ManagedDisk)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "toBeDetached", d.ToBeDetached)
	populate(objectMap, "vhd", d.Vhd)
	populate(objectMap, "writeAcceleratorEnabled", d.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDisk.
func (d *DataDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &d.Caching)
			delete(rawMsg, key)
		case "createOption":
			err = unpopulate(val, "CreateOption", &d.CreateOption)
			delete(rawMsg, key)
		case "diskIOPSReadWrite":
			err = unpopulate(val, "DiskIOPSReadWrite", &d.DiskIOPSReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &d.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &d.DiskSizeGB)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &d.Image)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &d.Lun)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &d.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "toBeDetached":
			err = unpopulate(val, "ToBeDetached", &d.ToBeDetached)
			delete(rawMsg, key)
		case "vhd":
			err = unpopulate(val, "Vhd", &d.Vhd)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &d.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDiskImage.
func (d DataDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lun", d.Lun)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDiskImage.
func (d *DataDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lun":
			err = unpopulate(val, "Lun", &d.Lun)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHost.
func (d DedicatedHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHost.
func (d *DedicatedHost) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostAllocatableVM.
func (d DedicatedHostAllocatableVM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", d.Count)
	populate(objectMap, "vmSize", d.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostAllocatableVM.
func (d *DedicatedHostAllocatableVM) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &d.Count)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &d.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostAvailableCapacity.
func (d DedicatedHostAvailableCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocatableVMs", d.AllocatableVMs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostAvailableCapacity.
func (d *DedicatedHostAvailableCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocatableVMs":
			err = unpopulate(val, "AllocatableVMs", &d.AllocatableVMs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroup.
func (d DedicatedHostGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "zones", d.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroup.
func (d *DedicatedHostGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &d.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupInstanceView.
func (d DedicatedHostGroupInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hosts", d.Hosts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroupInstanceView.
func (d *DedicatedHostGroupInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hosts":
			err = unpopulate(val, "Hosts", &d.Hosts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupListResult.
func (d DedicatedHostGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroupListResult.
func (d *DedicatedHostGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupProperties.
func (d DedicatedHostGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hosts", d.Hosts)
	populate(objectMap, "instanceView", d.InstanceView)
	populate(objectMap, "platformFaultDomainCount", d.PlatformFaultDomainCount)
	populate(objectMap, "supportAutomaticPlacement", d.SupportAutomaticPlacement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroupProperties.
func (d *DedicatedHostGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hosts":
			err = unpopulate(val, "Hosts", &d.Hosts)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &d.InstanceView)
			delete(rawMsg, key)
		case "platformFaultDomainCount":
			err = unpopulate(val, "PlatformFaultDomainCount", &d.PlatformFaultDomainCount)
			delete(rawMsg, key)
		case "supportAutomaticPlacement":
			err = unpopulate(val, "SupportAutomaticPlacement", &d.SupportAutomaticPlacement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupUpdate.
func (d DedicatedHostGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "zones", d.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroupUpdate.
func (d *DedicatedHostGroupUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &d.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostInstanceView.
func (d DedicatedHostInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assetId", d.AssetID)
	populate(objectMap, "availableCapacity", d.AvailableCapacity)
	populate(objectMap, "statuses", d.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostInstanceView.
func (d *DedicatedHostInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetId":
			err = unpopulate(val, "AssetID", &d.AssetID)
			delete(rawMsg, key)
		case "availableCapacity":
			err = unpopulate(val, "AvailableCapacity", &d.AvailableCapacity)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &d.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostInstanceViewWithName.
func (d DedicatedHostInstanceViewWithName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assetId", d.AssetID)
	populate(objectMap, "availableCapacity", d.AvailableCapacity)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "statuses", d.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostInstanceViewWithName.
func (d *DedicatedHostInstanceViewWithName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetId":
			err = unpopulate(val, "AssetID", &d.AssetID)
			delete(rawMsg, key)
		case "availableCapacity":
			err = unpopulate(val, "AvailableCapacity", &d.AvailableCapacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &d.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostListResult.
func (d DedicatedHostListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostListResult.
func (d *DedicatedHostListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostProperties.
func (d DedicatedHostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoReplaceOnFailure", d.AutoReplaceOnFailure)
	populate(objectMap, "hostId", d.HostID)
	populate(objectMap, "instanceView", d.InstanceView)
	populate(objectMap, "licenseType", d.LicenseType)
	populate(objectMap, "platformFaultDomain", d.PlatformFaultDomain)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populateTimeRFC3339(objectMap, "provisioningTime", d.ProvisioningTime)
	populate(objectMap, "virtualMachines", d.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostProperties.
func (d *DedicatedHostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoReplaceOnFailure":
			err = unpopulate(val, "AutoReplaceOnFailure", &d.AutoReplaceOnFailure)
			delete(rawMsg, key)
		case "hostId":
			err = unpopulate(val, "HostID", &d.HostID)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &d.InstanceView)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &d.LicenseType)
			delete(rawMsg, key)
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &d.PlatformFaultDomain)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "provisioningTime":
			err = unpopulateTimeRFC3339(val, "ProvisioningTime", &d.ProvisioningTime)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &d.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostUpdate.
func (d DedicatedHostUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostUpdate.
func (d *DedicatedHostUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsProfile.
func (d DiagnosticsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bootDiagnostics", d.BootDiagnostics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsProfile.
func (d *DiagnosticsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bootDiagnostics":
			err = unpopulate(val, "BootDiagnostics", &d.BootDiagnostics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiffDiskSettings.
func (d DiffDiskSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "option", d.Option)
	populate(objectMap, "placement", d.Placement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiffDiskSettings.
func (d *DiffDiskSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "option":
			err = unpopulate(val, "Option", &d.Option)
			delete(rawMsg, key)
		case "placement":
			err = unpopulate(val, "Placement", &d.Placement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DisallowedConfiguration.
func (d DisallowedConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmDiskType", d.VMDiskType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DisallowedConfiguration.
func (d *DisallowedConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmDiskType":
			err = unpopulate(val, "VMDiskType", &d.VMDiskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "managedBy", d.ManagedBy)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "zones", d.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Disk.
func (d *Disk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &d.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &d.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSet.
func (d DiskEncryptionSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSet.
func (d *DiskEncryptionSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &d.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetList.
func (d DiskEncryptionSetList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSetList.
func (d *DiskEncryptionSetList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetParameters.
func (d DiskEncryptionSetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSetParameters.
func (d *DiskEncryptionSetParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetUpdate.
func (d DiskEncryptionSetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSetUpdate.
func (d *DiskEncryptionSetUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetUpdateProperties.
func (d DiskEncryptionSetUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeKey", d.ActiveKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSetUpdateProperties.
func (d *DiskEncryptionSetUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeKey":
			err = unpopulate(val, "ActiveKey", &d.ActiveKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSettings.
func (d DiskEncryptionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionKey", d.DiskEncryptionKey)
	populate(objectMap, "enabled", d.Enabled)
	populate(objectMap, "keyEncryptionKey", d.KeyEncryptionKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSettings.
func (d *DiskEncryptionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionKey":
			err = unpopulate(val, "DiskEncryptionKey", &d.DiskEncryptionKey)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &d.KeyEncryptionKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskInstanceView.
func (d DiskInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionSettings", d.EncryptionSettings)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "statuses", d.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskInstanceView.
func (d *DiskInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &d.EncryptionSettings)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &d.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskList.
func (d DiskList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskList.
func (d *DiskList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskProperties.
func (d DiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "creationData", d.CreationData)
	populate(objectMap, "diskIOPSReadWrite", d.DiskIOPSReadWrite)
	populate(objectMap, "diskMBpsReadWrite", d.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeBytes", d.DiskSizeBytes)
	populate(objectMap, "diskSizeGB", d.DiskSizeGB)
	populate(objectMap, "diskState", d.DiskState)
	populate(objectMap, "encryption", d.Encryption)
	populate(objectMap, "encryptionSettingsCollection", d.EncryptionSettingsCollection)
	populate(objectMap, "hyperVGeneration", d.HyperVGeneration)
	populate(objectMap, "osType", d.OSType)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populateTimeRFC3339(objectMap, "timeCreated", d.TimeCreated)
	populate(objectMap, "uniqueId", d.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskProperties.
func (d *DiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationData":
			err = unpopulate(val, "CreationData", &d.CreationData)
			delete(rawMsg, key)
		case "diskIOPSReadWrite":
			err = unpopulate(val, "DiskIOPSReadWrite", &d.DiskIOPSReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &d.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeBytes":
			err = unpopulate(val, "DiskSizeBytes", &d.DiskSizeBytes)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &d.DiskSizeGB)
			delete(rawMsg, key)
		case "diskState":
			err = unpopulate(val, "DiskState", &d.DiskState)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &d.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &d.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &d.HyperVGeneration)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &d.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &d.TimeCreated)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &d.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskSKU.
func (d DiskSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "tier", d.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskSKU.
func (d *DiskSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &d.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskUpdate.
func (d DiskUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskUpdate.
func (d *DiskUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskUpdateProperties.
func (d DiskUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskIOPSReadWrite", d.DiskIOPSReadWrite)
	populate(objectMap, "diskMBpsReadWrite", d.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeGB", d.DiskSizeGB)
	populate(objectMap, "encryption", d.Encryption)
	populate(objectMap, "encryptionSettingsCollection", d.EncryptionSettingsCollection)
	populate(objectMap, "osType", d.OSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskUpdateProperties.
func (d *DiskUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskIOPSReadWrite":
			err = unpopulate(val, "DiskIOPSReadWrite", &d.DiskIOPSReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &d.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &d.DiskSizeGB)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &d.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &d.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &d.OSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Encryption.
func (e Encryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", e.DiskEncryptionSetID)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Encryption.
func (e *Encryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &e.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSetIdentity.
func (e EncryptionSetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", e.PrincipalID)
	populate(objectMap, "tenantId", e.TenantID)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSetIdentity.
func (e *EncryptionSetIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &e.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &e.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSetProperties.
func (e EncryptionSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeKey", e.ActiveKey)
	populate(objectMap, "previousKeys", e.PreviousKeys)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSetProperties.
func (e *EncryptionSetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeKey":
			err = unpopulate(val, "ActiveKey", &e.ActiveKey)
			delete(rawMsg, key)
		case "previousKeys":
			err = unpopulate(val, "PreviousKeys", &e.PreviousKeys)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSettingsCollection.
func (e EncryptionSettingsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", e.Enabled)
	populate(objectMap, "encryptionSettings", e.EncryptionSettings)
	populate(objectMap, "encryptionSettingsVersion", e.EncryptionSettingsVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSettingsCollection.
func (e *EncryptionSettingsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &e.Enabled)
			delete(rawMsg, key)
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &e.EncryptionSettings)
			delete(rawMsg, key)
		case "encryptionSettingsVersion":
			err = unpopulate(val, "EncryptionSettingsVersion", &e.EncryptionSettingsVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSettingsElement.
func (e EncryptionSettingsElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionKey", e.DiskEncryptionKey)
	populate(objectMap, "keyEncryptionKey", e.KeyEncryptionKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSettingsElement.
func (e *EncryptionSettingsElement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionKey":
			err = unpopulate(val, "DiskEncryptionKey", &e.DiskEncryptionKey)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &e.KeyEncryptionKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GrantAccessData.
func (g GrantAccessData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", g.Access)
	populate(objectMap, "durationInSeconds", g.DurationInSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GrantAccessData.
func (g *GrantAccessData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &g.Access)
			delete(rawMsg, key)
		case "durationInSeconds":
			err = unpopulate(val, "DurationInSeconds", &g.DurationInSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareProfile.
func (h HardwareProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmSize", h.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareProfile.
func (h *HardwareProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmSize":
			err = unpopulate(val, "VMSize", &h.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Image.
func (i Image) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Image.
func (i *Image) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageDataDisk.
func (i ImageDataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobUri", i.BlobURI)
	populate(objectMap, "caching", i.Caching)
	populate(objectMap, "diskEncryptionSet", i.DiskEncryptionSet)
	populate(objectMap, "diskSizeGB", i.DiskSizeGB)
	populate(objectMap, "lun", i.Lun)
	populate(objectMap, "managedDisk", i.ManagedDisk)
	populate(objectMap, "snapshot", i.Snapshot)
	populate(objectMap, "storageAccountType", i.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageDataDisk.
func (i *ImageDataDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobUri":
			err = unpopulate(val, "BlobURI", &i.BlobURI)
			delete(rawMsg, key)
		case "caching":
			err = unpopulate(val, "Caching", &i.Caching)
			delete(rawMsg, key)
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &i.DiskEncryptionSet)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &i.DiskSizeGB)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &i.Lun)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &i.ManagedDisk)
			delete(rawMsg, key)
		case "snapshot":
			err = unpopulate(val, "Snapshot", &i.Snapshot)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &i.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageDisk.
func (i ImageDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobUri", i.BlobURI)
	populate(objectMap, "caching", i.Caching)
	populate(objectMap, "diskEncryptionSet", i.DiskEncryptionSet)
	populate(objectMap, "diskSizeGB", i.DiskSizeGB)
	populate(objectMap, "managedDisk", i.ManagedDisk)
	populate(objectMap, "snapshot", i.Snapshot)
	populate(objectMap, "storageAccountType", i.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageDisk.
func (i *ImageDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobUri":
			err = unpopulate(val, "BlobURI", &i.BlobURI)
			delete(rawMsg, key)
		case "caching":
			err = unpopulate(val, "Caching", &i.Caching)
			delete(rawMsg, key)
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &i.DiskEncryptionSet)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &i.DiskSizeGB)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &i.ManagedDisk)
			delete(rawMsg, key)
		case "snapshot":
			err = unpopulate(val, "Snapshot", &i.Snapshot)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &i.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageDiskReference.
func (i ImageDiskReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "lun", i.Lun)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageDiskReference.
func (i *ImageDiskReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &i.Lun)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageListResult.
func (i ImageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageListResult.
func (i *ImageListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageOSDisk.
func (i ImageOSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobUri", i.BlobURI)
	populate(objectMap, "caching", i.Caching)
	populate(objectMap, "diskEncryptionSet", i.DiskEncryptionSet)
	populate(objectMap, "diskSizeGB", i.DiskSizeGB)
	populate(objectMap, "managedDisk", i.ManagedDisk)
	populate(objectMap, "osState", i.OSState)
	populate(objectMap, "osType", i.OSType)
	populate(objectMap, "snapshot", i.Snapshot)
	populate(objectMap, "storageAccountType", i.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageOSDisk.
func (i *ImageOSDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobUri":
			err = unpopulate(val, "BlobURI", &i.BlobURI)
			delete(rawMsg, key)
		case "caching":
			err = unpopulate(val, "Caching", &i.Caching)
			delete(rawMsg, key)
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &i.DiskEncryptionSet)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &i.DiskSizeGB)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &i.ManagedDisk)
			delete(rawMsg, key)
		case "osState":
			err = unpopulate(val, "OSState", &i.OSState)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &i.OSType)
			delete(rawMsg, key)
		case "snapshot":
			err = unpopulate(val, "Snapshot", &i.Snapshot)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &i.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageProperties.
func (i ImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hyperVGeneration", i.HyperVGeneration)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "sourceVirtualMachine", i.SourceVirtualMachine)
	populate(objectMap, "storageProfile", i.StorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageProperties.
func (i *ImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &i.HyperVGeneration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "sourceVirtualMachine":
			err = unpopulate(val, "SourceVirtualMachine", &i.SourceVirtualMachine)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &i.StorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageReference.
func (i ImageReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exactVersion", i.ExactVersion)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "offer", i.Offer)
	populate(objectMap, "publisher", i.Publisher)
	populate(objectMap, "sku", i.SKU)
	populate(objectMap, "version", i.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageReference.
func (i *ImageReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exactVersion":
			err = unpopulate(val, "ExactVersion", &i.ExactVersion)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "offer":
			err = unpopulate(val, "Offer", &i.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &i.Publisher)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &i.SKU)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageStorageProfile.
func (i ImageStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisks", i.DataDisks)
	populate(objectMap, "osDisk", i.OSDisk)
	populate(objectMap, "zoneResilient", i.ZoneResilient)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageStorageProfile.
func (i *ImageStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &i.DataDisks)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &i.OSDisk)
			delete(rawMsg, key)
		case "zoneResilient":
			err = unpopulate(val, "ZoneResilient", &i.ZoneResilient)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageUpdate.
func (i ImageUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageUpdate.
func (i *ImageUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InnerError.
func (i InnerError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errordetail", i.Errordetail)
	populate(objectMap, "exceptiontype", i.Exceptiontype)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InnerError.
func (i *InnerError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errordetail":
			err = unpopulate(val, "Errordetail", &i.Errordetail)
			delete(rawMsg, key)
		case "exceptiontype":
			err = unpopulate(val, "Exceptiontype", &i.Exceptiontype)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InstanceViewStatus.
func (i InstanceViewStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", i.Code)
	populate(objectMap, "displayStatus", i.DisplayStatus)
	populate(objectMap, "level", i.Level)
	populate(objectMap, "message", i.Message)
	populateTimeRFC3339(objectMap, "time", i.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstanceViewStatus.
func (i *InstanceViewStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &i.Code)
			delete(rawMsg, key)
		case "displayStatus":
			err = unpopulate(val, "DisplayStatus", &i.DisplayStatus)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &i.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &i.Message)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &i.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultAndKeyReference.
func (k KeyVaultAndKeyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyUrl", k.KeyURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultAndKeyReference.
func (k *KeyVaultAndKeyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyUrl":
			err = unpopulate(val, "KeyURL", &k.KeyURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultAndSecretReference.
func (k KeyVaultAndSecretReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretUrl", k.SecretURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultAndSecretReference.
func (k *KeyVaultAndSecretReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretUrl":
			err = unpopulate(val, "SecretURL", &k.SecretURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyReference.
func (k KeyVaultKeyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyUrl", k.KeyURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyReference.
func (k *KeyVaultKeyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyUrl":
			err = unpopulate(val, "KeyURL", &k.KeyURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultSecretReference.
func (k KeyVaultSecretReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretUrl", k.SecretURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultSecretReference.
func (k *KeyVaultSecretReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretUrl":
			err = unpopulate(val, "SecretURL", &k.SecretURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LastPatchInstallationSummary.
func (l LastPatchInstallationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", l.Error)
	populate(objectMap, "excludedPatchCount", l.ExcludedPatchCount)
	populate(objectMap, "failedPatchCount", l.FailedPatchCount)
	populate(objectMap, "installationActivityId", l.InstallationActivityID)
	populate(objectMap, "installedPatchCount", l.InstalledPatchCount)
	populateTimeRFC3339(objectMap, "lastModifiedTime", l.LastModifiedTime)
	populate(objectMap, "maintenanceWindowExceeded", l.MaintenanceWindowExceeded)
	populate(objectMap, "notSelectedPatchCount", l.NotSelectedPatchCount)
	populate(objectMap, "pendingPatchCount", l.PendingPatchCount)
	populate(objectMap, "rebootStatus", l.RebootStatus)
	populateTimeRFC3339(objectMap, "startTime", l.StartTime)
	populate(objectMap, "startedBy", l.StartedBy)
	populate(objectMap, "status", l.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LastPatchInstallationSummary.
func (l *LastPatchInstallationSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &l.Error)
			delete(rawMsg, key)
		case "excludedPatchCount":
			err = unpopulate(val, "ExcludedPatchCount", &l.ExcludedPatchCount)
			delete(rawMsg, key)
		case "failedPatchCount":
			err = unpopulate(val, "FailedPatchCount", &l.FailedPatchCount)
			delete(rawMsg, key)
		case "installationActivityId":
			err = unpopulate(val, "InstallationActivityID", &l.InstallationActivityID)
			delete(rawMsg, key)
		case "installedPatchCount":
			err = unpopulate(val, "InstalledPatchCount", &l.InstalledPatchCount)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &l.LastModifiedTime)
			delete(rawMsg, key)
		case "maintenanceWindowExceeded":
			err = unpopulate(val, "MaintenanceWindowExceeded", &l.MaintenanceWindowExceeded)
			delete(rawMsg, key)
		case "notSelectedPatchCount":
			err = unpopulate(val, "NotSelectedPatchCount", &l.NotSelectedPatchCount)
			delete(rawMsg, key)
		case "pendingPatchCount":
			err = unpopulate(val, "PendingPatchCount", &l.PendingPatchCount)
			delete(rawMsg, key)
		case "rebootStatus":
			err = unpopulate(val, "RebootStatus", &l.RebootStatus)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &l.StartTime)
			delete(rawMsg, key)
		case "startedBy":
			err = unpopulate(val, "StartedBy", &l.StartedBy)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxConfiguration.
func (l LinuxConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disablePasswordAuthentication", l.DisablePasswordAuthentication)
	populate(objectMap, "provisionVMAgent", l.ProvisionVMAgent)
	populate(objectMap, "ssh", l.SSH)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxConfiguration.
func (l *LinuxConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disablePasswordAuthentication":
			err = unpopulate(val, "DisablePasswordAuthentication", &l.DisablePasswordAuthentication)
			delete(rawMsg, key)
		case "provisionVMAgent":
			err = unpopulate(val, "ProvisionVMAgent", &l.ProvisionVMAgent)
			delete(rawMsg, key)
		case "ssh":
			err = unpopulate(val, "SSH", &l.SSH)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListUsagesResult.
func (l ListUsagesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListUsagesResult.
func (l *ListUsagesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsInputBase.
func (l LogAnalyticsInputBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobContainerSasUri", l.BlobContainerSasURI)
	populateTimeRFC3339(objectMap, "fromTime", l.FromTime)
	populate(objectMap, "groupByClientApplicationId", l.GroupByClientApplicationID)
	populate(objectMap, "groupByOperationName", l.GroupByOperationName)
	populate(objectMap, "groupByResourceName", l.GroupByResourceName)
	populate(objectMap, "groupByThrottlePolicy", l.GroupByThrottlePolicy)
	populate(objectMap, "groupByUserAgent", l.GroupByUserAgent)
	populateTimeRFC3339(objectMap, "toTime", l.ToTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsInputBase.
func (l *LogAnalyticsInputBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerSasUri":
			err = unpopulate(val, "BlobContainerSasURI", &l.BlobContainerSasURI)
			delete(rawMsg, key)
		case "fromTime":
			err = unpopulateTimeRFC3339(val, "FromTime", &l.FromTime)
			delete(rawMsg, key)
		case "groupByClientApplicationId":
			err = unpopulate(val, "GroupByClientApplicationID", &l.GroupByClientApplicationID)
			delete(rawMsg, key)
		case "groupByOperationName":
			err = unpopulate(val, "GroupByOperationName", &l.GroupByOperationName)
			delete(rawMsg, key)
		case "groupByResourceName":
			err = unpopulate(val, "GroupByResourceName", &l.GroupByResourceName)
			delete(rawMsg, key)
		case "groupByThrottlePolicy":
			err = unpopulate(val, "GroupByThrottlePolicy", &l.GroupByThrottlePolicy)
			delete(rawMsg, key)
		case "groupByUserAgent":
			err = unpopulate(val, "GroupByUserAgent", &l.GroupByUserAgent)
			delete(rawMsg, key)
		case "toTime":
			err = unpopulateTimeRFC3339(val, "ToTime", &l.ToTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsOperationResult.
func (l LogAnalyticsOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsOperationResult.
func (l *LogAnalyticsOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsOutput.
func (l LogAnalyticsOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "output", l.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsOutput.
func (l *LogAnalyticsOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "output":
			err = unpopulate(val, "Output", &l.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceRedeployStatus.
func (m MaintenanceRedeployStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isCustomerInitiatedMaintenanceAllowed", m.IsCustomerInitiatedMaintenanceAllowed)
	populate(objectMap, "lastOperationMessage", m.LastOperationMessage)
	populate(objectMap, "lastOperationResultCode", m.LastOperationResultCode)
	populateTimeRFC3339(objectMap, "maintenanceWindowEndTime", m.MaintenanceWindowEndTime)
	populateTimeRFC3339(objectMap, "maintenanceWindowStartTime", m.MaintenanceWindowStartTime)
	populateTimeRFC3339(objectMap, "preMaintenanceWindowEndTime", m.PreMaintenanceWindowEndTime)
	populateTimeRFC3339(objectMap, "preMaintenanceWindowStartTime", m.PreMaintenanceWindowStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceRedeployStatus.
func (m *MaintenanceRedeployStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isCustomerInitiatedMaintenanceAllowed":
			err = unpopulate(val, "IsCustomerInitiatedMaintenanceAllowed", &m.IsCustomerInitiatedMaintenanceAllowed)
			delete(rawMsg, key)
		case "lastOperationMessage":
			err = unpopulate(val, "LastOperationMessage", &m.LastOperationMessage)
			delete(rawMsg, key)
		case "lastOperationResultCode":
			err = unpopulate(val, "LastOperationResultCode", &m.LastOperationResultCode)
			delete(rawMsg, key)
		case "maintenanceWindowEndTime":
			err = unpopulateTimeRFC3339(val, "MaintenanceWindowEndTime", &m.MaintenanceWindowEndTime)
			delete(rawMsg, key)
		case "maintenanceWindowStartTime":
			err = unpopulateTimeRFC3339(val, "MaintenanceWindowStartTime", &m.MaintenanceWindowStartTime)
			delete(rawMsg, key)
		case "preMaintenanceWindowEndTime":
			err = unpopulateTimeRFC3339(val, "PreMaintenanceWindowEndTime", &m.PreMaintenanceWindowEndTime)
			delete(rawMsg, key)
		case "preMaintenanceWindowStartTime":
			err = unpopulateTimeRFC3339(val, "PreMaintenanceWindowStartTime", &m.PreMaintenanceWindowStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedDiskParameters.
func (m ManagedDiskParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSet", m.DiskEncryptionSet)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "storageAccountType", m.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedDiskParameters.
func (m *ManagedDiskParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &m.DiskEncryptionSet)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &m.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceReference.
func (n NetworkInterfaceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "properties", n.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaceReference.
func (n *NetworkInterfaceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceReferenceProperties.
func (n NetworkInterfaceReferenceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primary", n.Primary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaceReferenceProperties.
func (n *NetworkInterfaceReferenceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primary":
			err = unpopulate(val, "Primary", &n.Primary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &n.NetworkInterfaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSDisk.
func (o OSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", o.Caching)
	populate(objectMap, "createOption", o.CreateOption)
	populate(objectMap, "diffDiskSettings", o.DiffDiskSettings)
	populate(objectMap, "diskSizeGB", o.DiskSizeGB)
	populate(objectMap, "encryptionSettings", o.EncryptionSettings)
	populate(objectMap, "image", o.Image)
	populate(objectMap, "managedDisk", o.ManagedDisk)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "osType", o.OSType)
	populate(objectMap, "vhd", o.Vhd)
	populate(objectMap, "writeAcceleratorEnabled", o.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSDisk.
func (o *OSDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &o.Caching)
			delete(rawMsg, key)
		case "createOption":
			err = unpopulate(val, "CreateOption", &o.CreateOption)
			delete(rawMsg, key)
		case "diffDiskSettings":
			err = unpopulate(val, "DiffDiskSettings", &o.DiffDiskSettings)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &o.DiskSizeGB)
			delete(rawMsg, key)
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &o.EncryptionSettings)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &o.Image)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &o.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &o.OSType)
			delete(rawMsg, key)
		case "vhd":
			err = unpopulate(val, "Vhd", &o.Vhd)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &o.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSDiskImage.
func (o OSDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operatingSystem", o.OperatingSystem)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSDiskImage.
func (o *OSDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operatingSystem":
			err = unpopulate(val, "OperatingSystem", &o.OperatingSystem)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSProfile.
func (o OSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPassword", o.AdminPassword)
	populate(objectMap, "adminUsername", o.AdminUsername)
	populate(objectMap, "allowExtensionOperations", o.AllowExtensionOperations)
	populate(objectMap, "computerName", o.ComputerName)
	populate(objectMap, "customData", o.CustomData)
	populate(objectMap, "linuxConfiguration", o.LinuxConfiguration)
	populate(objectMap, "requireGuestProvisionSignal", o.RequireGuestProvisionSignal)
	populate(objectMap, "secrets", o.Secrets)
	populate(objectMap, "windowsConfiguration", o.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSProfile.
func (o *OSProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &o.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &o.AdminUsername)
			delete(rawMsg, key)
		case "allowExtensionOperations":
			err = unpopulate(val, "AllowExtensionOperations", &o.AllowExtensionOperations)
			delete(rawMsg, key)
		case "computerName":
			err = unpopulate(val, "ComputerName", &o.ComputerName)
			delete(rawMsg, key)
		case "customData":
			err = unpopulate(val, "CustomData", &o.CustomData)
			delete(rawMsg, key)
		case "linuxConfiguration":
			err = unpopulate(val, "LinuxConfiguration", &o.LinuxConfiguration)
			delete(rawMsg, key)
		case "requireGuestProvisionSignal":
			err = unpopulate(val, "RequireGuestProvisionSignal", &o.RequireGuestProvisionSignal)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &o.Secrets)
			delete(rawMsg, key)
		case "windowsConfiguration":
			err = unpopulate(val, "WindowsConfiguration", &o.WindowsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationValue.
func (o OperationValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationValue.
func (o *OperationValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationValueDisplay.
func (o OperationValueDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationValueDisplay.
func (o *OperationValueDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestrationServiceStateInput.
func (o OrchestrationServiceStateInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", o.Action)
	populate(objectMap, "serviceName", o.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestrationServiceStateInput.
func (o *OrchestrationServiceStateInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &o.Action)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &o.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestrationServiceSummary.
func (o OrchestrationServiceSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceName", o.ServiceName)
	populate(objectMap, "serviceState", o.ServiceState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestrationServiceSummary.
func (o *OrchestrationServiceSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceName":
			err = unpopulate(val, "ServiceName", &o.ServiceName)
			delete(rawMsg, key)
		case "serviceState":
			err = unpopulate(val, "ServiceState", &o.ServiceState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchSettings.
func (p PatchSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "patchMode", p.PatchMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchSettings.
func (p *PatchSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "patchMode":
			err = unpopulate(val, "PatchMode", &p.PatchMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Plan.
func (p Plan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "promotionCode", p.PromotionCode)
	populate(objectMap, "publisher", p.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Plan.
func (p *Plan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "promotionCode":
			err = unpopulate(val, "PromotionCode", &p.PromotionCode)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &p.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroup.
func (p ProximityPlacementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProximityPlacementGroup.
func (p *ProximityPlacementGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupListResult.
func (p ProximityPlacementGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProximityPlacementGroupListResult.
func (p *ProximityPlacementGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupProperties.
func (p ProximityPlacementGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilitySets", p.AvailabilitySets)
	populate(objectMap, "colocationStatus", p.ColocationStatus)
	populate(objectMap, "proximityPlacementGroupType", p.ProximityPlacementGroupType)
	populate(objectMap, "virtualMachineScaleSets", p.VirtualMachineScaleSets)
	populate(objectMap, "virtualMachines", p.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProximityPlacementGroupProperties.
func (p *ProximityPlacementGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilitySets":
			err = unpopulate(val, "AvailabilitySets", &p.AvailabilitySets)
			delete(rawMsg, key)
		case "colocationStatus":
			err = unpopulate(val, "ColocationStatus", &p.ColocationStatus)
			delete(rawMsg, key)
		case "proximityPlacementGroupType":
			err = unpopulate(val, "ProximityPlacementGroupType", &p.ProximityPlacementGroupType)
			delete(rawMsg, key)
		case "virtualMachineScaleSets":
			err = unpopulate(val, "VirtualMachineScaleSets", &p.VirtualMachineScaleSets)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &p.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupUpdate.
func (p ProximityPlacementGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProximityPlacementGroupUpdate.
func (p *ProximityPlacementGroupUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurchasePlan.
func (p PurchasePlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "publisher", p.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurchasePlan.
func (p *PurchasePlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &p.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryWalkResponse.
func (r RecoveryWalkResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextPlatformUpdateDomain", r.NextPlatformUpdateDomain)
	populate(objectMap, "walkPerformed", r.WalkPerformed)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryWalkResponse.
func (r *RecoveryWalkResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextPlatformUpdateDomain":
			err = unpopulate(val, "NextPlatformUpdateDomain", &r.NextPlatformUpdateDomain)
			delete(rawMsg, key)
		case "walkPerformed":
			err = unpopulate(val, "WalkPerformed", &r.WalkPerformed)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestRateByIntervalInput.
func (r RequestRateByIntervalInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobContainerSasUri", r.BlobContainerSasURI)
	populateTimeRFC3339(objectMap, "fromTime", r.FromTime)
	populate(objectMap, "groupByClientApplicationId", r.GroupByClientApplicationID)
	populate(objectMap, "groupByOperationName", r.GroupByOperationName)
	populate(objectMap, "groupByResourceName", r.GroupByResourceName)
	populate(objectMap, "groupByThrottlePolicy", r.GroupByThrottlePolicy)
	populate(objectMap, "groupByUserAgent", r.GroupByUserAgent)
	populate(objectMap, "intervalLength", r.IntervalLength)
	populateTimeRFC3339(objectMap, "toTime", r.ToTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestRateByIntervalInput.
func (r *RequestRateByIntervalInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerSasUri":
			err = unpopulate(val, "BlobContainerSasURI", &r.BlobContainerSasURI)
			delete(rawMsg, key)
		case "fromTime":
			err = unpopulateTimeRFC3339(val, "FromTime", &r.FromTime)
			delete(rawMsg, key)
		case "groupByClientApplicationId":
			err = unpopulate(val, "GroupByClientApplicationID", &r.GroupByClientApplicationID)
			delete(rawMsg, key)
		case "groupByOperationName":
			err = unpopulate(val, "GroupByOperationName", &r.GroupByOperationName)
			delete(rawMsg, key)
		case "groupByResourceName":
			err = unpopulate(val, "GroupByResourceName", &r.GroupByResourceName)
			delete(rawMsg, key)
		case "groupByThrottlePolicy":
			err = unpopulate(val, "GroupByThrottlePolicy", &r.GroupByThrottlePolicy)
			delete(rawMsg, key)
		case "groupByUserAgent":
			err = unpopulate(val, "GroupByUserAgent", &r.GroupByUserAgent)
			delete(rawMsg, key)
		case "intervalLength":
			err = unpopulate(val, "IntervalLength", &r.IntervalLength)
			delete(rawMsg, key)
		case "toTime":
			err = unpopulateTimeRFC3339(val, "ToTime", &r.ToTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetrieveBootDiagnosticsDataResult.
func (r RetrieveBootDiagnosticsDataResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consoleScreenshotBlobUri", r.ConsoleScreenshotBlobURI)
	populate(objectMap, "serialConsoleLogBlobUri", r.SerialConsoleLogBlobURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetrieveBootDiagnosticsDataResult.
func (r *RetrieveBootDiagnosticsDataResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consoleScreenshotBlobUri":
			err = unpopulate(val, "ConsoleScreenshotBlobURI", &r.ConsoleScreenshotBlobURI)
			delete(rawMsg, key)
		case "serialConsoleLogBlobUri":
			err = unpopulate(val, "SerialConsoleLogBlobURI", &r.SerialConsoleLogBlobURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollbackStatusInfo.
func (r RollbackStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failedRolledbackInstanceCount", r.FailedRolledbackInstanceCount)
	populate(objectMap, "rollbackError", r.RollbackError)
	populate(objectMap, "successfullyRolledbackInstanceCount", r.SuccessfullyRolledbackInstanceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollbackStatusInfo.
func (r *RollbackStatusInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failedRolledbackInstanceCount":
			err = unpopulate(val, "FailedRolledbackInstanceCount", &r.FailedRolledbackInstanceCount)
			delete(rawMsg, key)
		case "rollbackError":
			err = unpopulate(val, "RollbackError", &r.RollbackError)
			delete(rawMsg, key)
		case "successfullyRolledbackInstanceCount":
			err = unpopulate(val, "SuccessfullyRolledbackInstanceCount", &r.SuccessfullyRolledbackInstanceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradePolicy.
func (r RollingUpgradePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxBatchInstancePercent", r.MaxBatchInstancePercent)
	populate(objectMap, "maxUnhealthyInstancePercent", r.MaxUnhealthyInstancePercent)
	populate(objectMap, "maxUnhealthyUpgradedInstancePercent", r.MaxUnhealthyUpgradedInstancePercent)
	populate(objectMap, "pauseTimeBetweenBatches", r.PauseTimeBetweenBatches)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradePolicy.
func (r *RollingUpgradePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxBatchInstancePercent":
			err = unpopulate(val, "MaxBatchInstancePercent", &r.MaxBatchInstancePercent)
			delete(rawMsg, key)
		case "maxUnhealthyInstancePercent":
			err = unpopulate(val, "MaxUnhealthyInstancePercent", &r.MaxUnhealthyInstancePercent)
			delete(rawMsg, key)
		case "maxUnhealthyUpgradedInstancePercent":
			err = unpopulate(val, "MaxUnhealthyUpgradedInstancePercent", &r.MaxUnhealthyUpgradedInstancePercent)
			delete(rawMsg, key)
		case "pauseTimeBetweenBatches":
			err = unpopulate(val, "PauseTimeBetweenBatches", &r.PauseTimeBetweenBatches)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeProgressInfo.
func (r RollingUpgradeProgressInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failedInstanceCount", r.FailedInstanceCount)
	populate(objectMap, "inProgressInstanceCount", r.InProgressInstanceCount)
	populate(objectMap, "pendingInstanceCount", r.PendingInstanceCount)
	populate(objectMap, "successfulInstanceCount", r.SuccessfulInstanceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradeProgressInfo.
func (r *RollingUpgradeProgressInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failedInstanceCount":
			err = unpopulate(val, "FailedInstanceCount", &r.FailedInstanceCount)
			delete(rawMsg, key)
		case "inProgressInstanceCount":
			err = unpopulate(val, "InProgressInstanceCount", &r.InProgressInstanceCount)
			delete(rawMsg, key)
		case "pendingInstanceCount":
			err = unpopulate(val, "PendingInstanceCount", &r.PendingInstanceCount)
			delete(rawMsg, key)
		case "successfulInstanceCount":
			err = unpopulate(val, "SuccessfulInstanceCount", &r.SuccessfulInstanceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeRunningStatus.
func (r RollingUpgradeRunningStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", r.Code)
	populate(objectMap, "lastAction", r.LastAction)
	populateTimeRFC3339(objectMap, "lastActionTime", r.LastActionTime)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradeRunningStatus.
func (r *RollingUpgradeRunningStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "lastAction":
			err = unpopulate(val, "LastAction", &r.LastAction)
			delete(rawMsg, key)
		case "lastActionTime":
			err = unpopulateTimeRFC3339(val, "LastActionTime", &r.LastActionTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeStatusInfo.
func (r RollingUpgradeStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradeStatusInfo.
func (r *RollingUpgradeStatusInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeStatusInfoProperties.
func (r RollingUpgradeStatusInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "policy", r.Policy)
	populate(objectMap, "progress", r.Progress)
	populate(objectMap, "runningStatus", r.RunningStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradeStatusInfoProperties.
func (r *RollingUpgradeStatusInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &r.Policy)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &r.Progress)
			delete(rawMsg, key)
		case "runningStatus":
			err = unpopulate(val, "RunningStatus", &r.RunningStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHConfiguration.
func (s SSHConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicKeys", s.PublicKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHConfiguration.
func (s *SSHConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKeys":
			err = unpopulate(val, "PublicKeys", &s.PublicKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKey.
func (s SSHPublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyData", s.KeyData)
	populate(objectMap, "path", s.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKey.
func (s *SSHPublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyData":
			err = unpopulate(val, "KeyData", &s.KeyData)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyGenerateKeyPairResult.
func (s SSHPublicKeyGenerateKeyPairResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "privateKey", s.PrivateKey)
	populate(objectMap, "publicKey", s.PublicKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeyGenerateKeyPairResult.
func (s *SSHPublicKeyGenerateKeyPairResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "privateKey":
			err = unpopulate(val, "PrivateKey", &s.PrivateKey)
			delete(rawMsg, key)
		case "publicKey":
			err = unpopulate(val, "PublicKey", &s.PublicKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyResource.
func (s SSHPublicKeyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeyResource.
func (s *SSHPublicKeyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyResourceProperties.
func (s SSHPublicKeyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicKey", s.PublicKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeyResourceProperties.
func (s *SSHPublicKeyResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKey":
			err = unpopulate(val, "PublicKey", &s.PublicKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyUpdateResource.
func (s SSHPublicKeyUpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeyUpdateResource.
func (s *SSHPublicKeyUpdateResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeysGroupListResult.
func (s SSHPublicKeysGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeysGroupListResult.
func (s *SSHPublicKeysGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScaleInPolicy.
func (s ScaleInPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rules", s.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScaleInPolicy.
func (s *ScaleInPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rules":
			err = unpopulate(val, "Rules", &s.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduledEventsProfile.
func (s ScheduledEventsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "terminateNotificationProfile", s.TerminateNotificationProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduledEventsProfile.
func (s *ScheduledEventsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "terminateNotificationProfile":
			err = unpopulate(val, "TerminateNotificationProfile", &s.TerminateNotificationProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityProfile.
func (s SecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionAtHost", s.EncryptionAtHost)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityProfile.
func (s *SecurityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionAtHost":
			err = unpopulate(val, "EncryptionAtHost", &s.EncryptionAtHost)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "managedBy", s.ManagedBy)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Snapshot.
func (s *Snapshot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &s.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotList.
func (s SnapshotList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotList.
func (s *SnapshotList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotProperties.
func (s SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "creationData", s.CreationData)
	populate(objectMap, "diskSizeBytes", s.DiskSizeBytes)
	populate(objectMap, "diskSizeGB", s.DiskSizeGB)
	populate(objectMap, "encryption", s.Encryption)
	populate(objectMap, "encryptionSettingsCollection", s.EncryptionSettingsCollection)
	populate(objectMap, "hyperVGeneration", s.HyperVGeneration)
	populate(objectMap, "incremental", s.Incremental)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populateTimeRFC3339(objectMap, "timeCreated", s.TimeCreated)
	populate(objectMap, "uniqueId", s.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotProperties.
func (s *SnapshotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationData":
			err = unpopulate(val, "CreationData", &s.CreationData)
			delete(rawMsg, key)
		case "diskSizeBytes":
			err = unpopulate(val, "DiskSizeBytes", &s.DiskSizeBytes)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &s.DiskSizeGB)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &s.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &s.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &s.HyperVGeneration)
			delete(rawMsg, key)
		case "incremental":
			err = unpopulate(val, "Incremental", &s.Incremental)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &s.TimeCreated)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &s.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotSKU.
func (s SnapshotSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotSKU.
func (s *SnapshotSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotUpdate.
func (s SnapshotUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotUpdate.
func (s *SnapshotUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotUpdateProperties.
func (s SnapshotUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskSizeGB", s.DiskSizeGB)
	populate(objectMap, "encryption", s.Encryption)
	populate(objectMap, "encryptionSettingsCollection", s.EncryptionSettingsCollection)
	populate(objectMap, "osType", s.OSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotUpdateProperties.
func (s *SnapshotUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &s.DiskSizeGB)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &s.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &s.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceVault.
func (s SourceVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceVault.
func (s *SourceVault) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfile.
func (s StorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisks", s.DataDisks)
	populate(objectMap, "imageReference", s.ImageReference)
	populate(objectMap, "osDisk", s.OSDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageProfile.
func (s *StorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &s.DataDisks)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &s.ImageReference)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &s.OSDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResourceReadOnly.
func (s SubResourceReadOnly) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResourceReadOnly.
func (s *SubResourceReadOnly) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResourceWithColocationStatus.
func (s SubResourceWithColocationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "colocationStatus", s.ColocationStatus)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResourceWithColocationStatus.
func (s *SubResourceWithColocationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "colocationStatus":
			err = unpopulate(val, "ColocationStatus", &s.ColocationStatus)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TerminateNotificationProfile.
func (t TerminateNotificationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enable", t.Enable)
	populate(objectMap, "notBeforeTimeout", t.NotBeforeTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TerminateNotificationProfile.
func (t *TerminateNotificationProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enable":
			err = unpopulate(val, "Enable", &t.Enable)
			delete(rawMsg, key)
		case "notBeforeTimeout":
			err = unpopulate(val, "NotBeforeTimeout", &t.NotBeforeTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThrottledRequestsInput.
func (t ThrottledRequestsInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobContainerSasUri", t.BlobContainerSasURI)
	populateTimeRFC3339(objectMap, "fromTime", t.FromTime)
	populate(objectMap, "groupByClientApplicationId", t.GroupByClientApplicationID)
	populate(objectMap, "groupByOperationName", t.GroupByOperationName)
	populate(objectMap, "groupByResourceName", t.GroupByResourceName)
	populate(objectMap, "groupByThrottlePolicy", t.GroupByThrottlePolicy)
	populate(objectMap, "groupByUserAgent", t.GroupByUserAgent)
	populateTimeRFC3339(objectMap, "toTime", t.ToTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThrottledRequestsInput.
func (t *ThrottledRequestsInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerSasUri":
			err = unpopulate(val, "BlobContainerSasURI", &t.BlobContainerSasURI)
			delete(rawMsg, key)
		case "fromTime":
			err = unpopulateTimeRFC3339(val, "FromTime", &t.FromTime)
			delete(rawMsg, key)
		case "groupByClientApplicationId":
			err = unpopulate(val, "GroupByClientApplicationID", &t.GroupByClientApplicationID)
			delete(rawMsg, key)
		case "groupByOperationName":
			err = unpopulate(val, "GroupByOperationName", &t.GroupByOperationName)
			delete(rawMsg, key)
		case "groupByResourceName":
			err = unpopulate(val, "GroupByResourceName", &t.GroupByResourceName)
			delete(rawMsg, key)
		case "groupByThrottlePolicy":
			err = unpopulate(val, "GroupByThrottlePolicy", &t.GroupByThrottlePolicy)
			delete(rawMsg, key)
		case "groupByUserAgent":
			err = unpopulate(val, "GroupByUserAgent", &t.GroupByUserAgent)
			delete(rawMsg, key)
		case "toTime":
			err = unpopulateTimeRFC3339(val, "ToTime", &t.ToTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateResource.
func (u UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateResource.
func (u *UpdateResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradeOperationHistoricalStatusInfo.
func (u UpgradeOperationHistoricalStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", u.Location)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradeOperationHistoricalStatusInfo.
func (u *UpgradeOperationHistoricalStatusInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &u.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradeOperationHistoricalStatusInfoProperties.
func (u UpgradeOperationHistoricalStatusInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", u.Error)
	populate(objectMap, "progress", u.Progress)
	populate(objectMap, "rollbackInfo", u.RollbackInfo)
	populate(objectMap, "runningStatus", u.RunningStatus)
	populate(objectMap, "startedBy", u.StartedBy)
	populate(objectMap, "targetImageReference", u.TargetImageReference)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradeOperationHistoricalStatusInfoProperties.
func (u *UpgradeOperationHistoricalStatusInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &u.Error)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &u.Progress)
			delete(rawMsg, key)
		case "rollbackInfo":
			err = unpopulate(val, "RollbackInfo", &u.RollbackInfo)
			delete(rawMsg, key)
		case "runningStatus":
			err = unpopulate(val, "RunningStatus", &u.RunningStatus)
			delete(rawMsg, key)
		case "startedBy":
			err = unpopulate(val, "StartedBy", &u.StartedBy)
			delete(rawMsg, key)
		case "targetImageReference":
			err = unpopulate(val, "TargetImageReference", &u.TargetImageReference)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradeOperationHistoryStatus.
func (u UpgradeOperationHistoryStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", u.Code)
	populateTimeRFC3339(objectMap, "endTime", u.EndTime)
	populateTimeRFC3339(objectMap, "startTime", u.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradeOperationHistoryStatus.
func (u *UpgradeOperationHistoryStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &u.Code)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &u.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &u.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradePolicy.
func (u UpgradePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "automaticOSUpgradePolicy", u.AutomaticOSUpgradePolicy)
	populate(objectMap, "mode", u.Mode)
	populate(objectMap, "rollingUpgradePolicy", u.RollingUpgradePolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradePolicy.
func (u *UpgradePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automaticOSUpgradePolicy":
			err = unpopulate(val, "AutomaticOSUpgradePolicy", &u.AutomaticOSUpgradePolicy)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &u.Mode)
			delete(rawMsg, key)
		case "rollingUpgradePolicy":
			err = unpopulate(val, "RollingUpgradePolicy", &u.RollingUpgradePolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	objectMap["unit"] = "Count"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageName.
func (u UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", u.LocalizedValue)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageName.
func (u *UsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &u.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentitiesValue.
func (u UserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentitiesValue.
func (u *UserAssignedIdentitiesValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMScaleSetConvertToSinglePlacementGroupInput.
func (v VMScaleSetConvertToSinglePlacementGroupInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activePlacementGroupId", v.ActivePlacementGroupID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMScaleSetConvertToSinglePlacementGroupInput.
func (v *VMScaleSetConvertToSinglePlacementGroupInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activePlacementGroupId":
			err = unpopulate(val, "ActivePlacementGroupID", &v.ActivePlacementGroupID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultCertificate.
func (v VaultCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateStore", v.CertificateStore)
	populate(objectMap, "certificateUrl", v.CertificateURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultCertificate.
func (v *VaultCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateStore":
			err = unpopulate(val, "CertificateStore", &v.CertificateStore)
			delete(rawMsg, key)
		case "certificateUrl":
			err = unpopulate(val, "CertificateURL", &v.CertificateURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultSecretGroup.
func (v VaultSecretGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceVault", v.SourceVault)
	populate(objectMap, "vaultCertificates", v.VaultCertificates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultSecretGroup.
func (v *VaultSecretGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &v.SourceVault)
			delete(rawMsg, key)
		case "vaultCertificates":
			err = unpopulate(val, "VaultCertificates", &v.VaultCertificates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualHardDisk.
func (v VirtualHardDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "uri", v.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualHardDisk.
func (v *VirtualHardDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uri":
			err = unpopulate(val, "URI", &v.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachine.
func (v VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "resources", v.Resources)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachine.
func (v *VirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &v.Resources)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineAgentInstanceView.
func (v VirtualMachineAgentInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extensionHandlers", v.ExtensionHandlers)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "vmAgentVersion", v.VMAgentVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineAgentInstanceView.
func (v *VirtualMachineAgentInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extensionHandlers":
			err = unpopulate(val, "ExtensionHandlers", &v.ExtensionHandlers)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "vmAgentVersion":
			err = unpopulate(val, "VMAgentVersion", &v.VMAgentVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineAssessPatchesResult.
func (v VirtualMachineAssessPatchesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assessmentActivityId", v.AssessmentActivityID)
	populate(objectMap, "criticalAndSecurityPatchCount", v.CriticalAndSecurityPatchCount)
	populate(objectMap, "error", v.Error)
	populate(objectMap, "otherPatchCount", v.OtherPatchCount)
	populate(objectMap, "patches", v.Patches)
	populate(objectMap, "rebootPending", v.RebootPending)
	populateTimeRFC3339(objectMap, "startDateTime", v.StartDateTime)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineAssessPatchesResult.
func (v *VirtualMachineAssessPatchesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentActivityId":
			err = unpopulate(val, "AssessmentActivityID", &v.AssessmentActivityID)
			delete(rawMsg, key)
		case "criticalAndSecurityPatchCount":
			err = unpopulate(val, "CriticalAndSecurityPatchCount", &v.CriticalAndSecurityPatchCount)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "otherPatchCount":
			err = unpopulate(val, "OtherPatchCount", &v.OtherPatchCount)
			delete(rawMsg, key)
		case "patches":
			err = unpopulate(val, "Patches", &v.Patches)
			delete(rawMsg, key)
		case "rebootPending":
			err = unpopulate(val, "RebootPending", &v.RebootPending)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateTimeRFC3339(val, "StartDateTime", &v.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineCaptureParameters.
func (v VirtualMachineCaptureParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationContainerName", v.DestinationContainerName)
	populate(objectMap, "overwriteVhds", v.OverwriteVhds)
	populate(objectMap, "vhdPrefix", v.VhdPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineCaptureParameters.
func (v *VirtualMachineCaptureParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationContainerName":
			err = unpopulate(val, "DestinationContainerName", &v.DestinationContainerName)
			delete(rawMsg, key)
		case "overwriteVhds":
			err = unpopulate(val, "OverwriteVhds", &v.OverwriteVhds)
			delete(rawMsg, key)
		case "vhdPrefix":
			err = unpopulate(val, "VhdPrefix", &v.VhdPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineCaptureResult.
func (v VirtualMachineCaptureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentVersion", v.ContentVersion)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "parameters", &v.Parameters)
	populate(objectMap, "resources", v.Resources)
	populate(objectMap, "$schema", v.Schema)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineCaptureResult.
func (v *VirtualMachineCaptureResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentVersion":
			err = unpopulate(val, "ContentVersion", &v.ContentVersion)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &v.Parameters)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &v.Resources)
			delete(rawMsg, key)
		case "$schema":
			err = unpopulate(val, "Schema", &v.Schema)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtension.
func (v VirtualMachineExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtension.
func (v *VirtualMachineExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionHandlerInstanceView.
func (v VirtualMachineExtensionHandlerInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", v.Status)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionHandlerInstanceView.
func (v *VirtualMachineExtensionHandlerInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionImage.
func (v VirtualMachineExtensionImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionImage.
func (v *VirtualMachineExtensionImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionImageProperties.
func (v VirtualMachineExtensionImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeRole", v.ComputeRole)
	populate(objectMap, "handlerSchema", v.HandlerSchema)
	populate(objectMap, "operatingSystem", v.OperatingSystem)
	populate(objectMap, "supportsMultipleExtensions", v.SupportsMultipleExtensions)
	populate(objectMap, "vmScaleSetEnabled", v.VMScaleSetEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionImageProperties.
func (v *VirtualMachineExtensionImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeRole":
			err = unpopulate(val, "ComputeRole", &v.ComputeRole)
			delete(rawMsg, key)
		case "handlerSchema":
			err = unpopulate(val, "HandlerSchema", &v.HandlerSchema)
			delete(rawMsg, key)
		case "operatingSystem":
			err = unpopulate(val, "OperatingSystem", &v.OperatingSystem)
			delete(rawMsg, key)
		case "supportsMultipleExtensions":
			err = unpopulate(val, "SupportsMultipleExtensions", &v.SupportsMultipleExtensions)
			delete(rawMsg, key)
		case "vmScaleSetEnabled":
			err = unpopulate(val, "VMScaleSetEnabled", &v.VMScaleSetEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionInstanceView.
func (v VirtualMachineExtensionInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "substatuses", v.Substatuses)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionInstanceView.
func (v *VirtualMachineExtensionInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "substatuses":
			err = unpopulate(val, "Substatuses", &v.Substatuses)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionProperties.
func (v VirtualMachineExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpgradeMinorVersion", v.AutoUpgradeMinorVersion)
	populate(objectMap, "enableAutomaticUpgrade", v.EnableAutomaticUpgrade)
	populate(objectMap, "forceUpdateTag", v.ForceUpdateTag)
	populate(objectMap, "instanceView", v.InstanceView)
	populate(objectMap, "protectedSettings", &v.ProtectedSettings)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "publisher", v.Publisher)
	populate(objectMap, "settings", &v.Settings)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionProperties.
func (v *VirtualMachineExtensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &v.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &v.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &v.ForceUpdateTag)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &v.InstanceView)
			delete(rawMsg, key)
		case "protectedSettings":
			err = unpopulate(val, "ProtectedSettings", &v.ProtectedSettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &v.Publisher)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &v.Settings)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionUpdate.
func (v VirtualMachineExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionUpdate.
func (v *VirtualMachineExtensionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionUpdateProperties.
func (v VirtualMachineExtensionUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpgradeMinorVersion", v.AutoUpgradeMinorVersion)
	populate(objectMap, "enableAutomaticUpgrade", v.EnableAutomaticUpgrade)
	populate(objectMap, "forceUpdateTag", v.ForceUpdateTag)
	populate(objectMap, "protectedSettings", &v.ProtectedSettings)
	populate(objectMap, "publisher", v.Publisher)
	populate(objectMap, "settings", &v.Settings)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionUpdateProperties.
func (v *VirtualMachineExtensionUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &v.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &v.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &v.ForceUpdateTag)
			delete(rawMsg, key)
		case "protectedSettings":
			err = unpopulate(val, "ProtectedSettings", &v.ProtectedSettings)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &v.Publisher)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &v.Settings)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionsListResult.
func (v VirtualMachineExtensionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionsListResult.
func (v *VirtualMachineExtensionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineHealthStatus.
func (v VirtualMachineHealthStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineHealthStatus.
func (v *VirtualMachineHealthStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineIdentity.
func (v VirtualMachineIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", v.PrincipalID)
	populate(objectMap, "tenantId", v.TenantID)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "userAssignedIdentities", v.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineIdentity.
func (v *VirtualMachineIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &v.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &v.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &v.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImage.
func (v VirtualMachineImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineImage.
func (v *VirtualMachineImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImageProperties.
func (v VirtualMachineImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "automaticOSUpgradeProperties", v.AutomaticOSUpgradeProperties)
	populate(objectMap, "dataDiskImages", v.DataDiskImages)
	populate(objectMap, "disallowed", v.Disallowed)
	populate(objectMap, "hyperVGeneration", v.HyperVGeneration)
	populate(objectMap, "osDiskImage", v.OSDiskImage)
	populate(objectMap, "plan", v.Plan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineImageProperties.
func (v *VirtualMachineImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automaticOSUpgradeProperties":
			err = unpopulate(val, "AutomaticOSUpgradeProperties", &v.AutomaticOSUpgradeProperties)
			delete(rawMsg, key)
		case "dataDiskImages":
			err = unpopulate(val, "DataDiskImages", &v.DataDiskImages)
			delete(rawMsg, key)
		case "disallowed":
			err = unpopulate(val, "Disallowed", &v.Disallowed)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &v.HyperVGeneration)
			delete(rawMsg, key)
		case "osDiskImage":
			err = unpopulate(val, "OSDiskImage", &v.OSDiskImage)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImageResource.
func (v VirtualMachineImageResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineImageResource.
func (v *VirtualMachineImageResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineInstanceView.
func (v VirtualMachineInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignedHost", v.AssignedHost)
	populate(objectMap, "bootDiagnostics", v.BootDiagnostics)
	populate(objectMap, "computerName", v.ComputerName)
	populate(objectMap, "disks", v.Disks)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "hyperVGeneration", v.HyperVGeneration)
	populate(objectMap, "maintenanceRedeployStatus", v.MaintenanceRedeployStatus)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osVersion", v.OSVersion)
	populate(objectMap, "patchStatus", v.PatchStatus)
	populate(objectMap, "platformFaultDomain", v.PlatformFaultDomain)
	populate(objectMap, "platformUpdateDomain", v.PlatformUpdateDomain)
	populate(objectMap, "rdpThumbPrint", v.RdpThumbPrint)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "vmAgent", v.VMAgent)
	populate(objectMap, "vmHealth", v.VMHealth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineInstanceView.
func (v *VirtualMachineInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignedHost":
			err = unpopulate(val, "AssignedHost", &v.AssignedHost)
			delete(rawMsg, key)
		case "bootDiagnostics":
			err = unpopulate(val, "BootDiagnostics", &v.BootDiagnostics)
			delete(rawMsg, key)
		case "computerName":
			err = unpopulate(val, "ComputerName", &v.ComputerName)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &v.Disks)
			delete(rawMsg, key)
		case "extensions":
			err = unpopulate(val, "Extensions", &v.Extensions)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &v.HyperVGeneration)
			delete(rawMsg, key)
		case "maintenanceRedeployStatus":
			err = unpopulate(val, "MaintenanceRedeployStatus", &v.MaintenanceRedeployStatus)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &v.OSVersion)
			delete(rawMsg, key)
		case "patchStatus":
			err = unpopulate(val, "PatchStatus", &v.PatchStatus)
			delete(rawMsg, key)
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &v.PlatformFaultDomain)
			delete(rawMsg, key)
		case "platformUpdateDomain":
			err = unpopulate(val, "PlatformUpdateDomain", &v.PlatformUpdateDomain)
			delete(rawMsg, key)
		case "rdpThumbPrint":
			err = unpopulate(val, "RdpThumbPrint", &v.RdpThumbPrint)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "vmAgent":
			err = unpopulate(val, "VMAgent", &v.VMAgent)
			delete(rawMsg, key)
		case "vmHealth":
			err = unpopulate(val, "VMHealth", &v.VMHealth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineListResult.
func (v VirtualMachineListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineListResult.
func (v *VirtualMachineListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePatchStatus.
func (v VirtualMachinePatchStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availablePatchSummary", v.AvailablePatchSummary)
	populate(objectMap, "lastPatchInstallationSummary", v.LastPatchInstallationSummary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinePatchStatus.
func (v *VirtualMachinePatchStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availablePatchSummary":
			err = unpopulate(val, "AvailablePatchSummary", &v.AvailablePatchSummary)
			delete(rawMsg, key)
		case "lastPatchInstallationSummary":
			err = unpopulate(val, "LastPatchInstallationSummary", &v.LastPatchInstallationSummary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineProperties.
func (v VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "availabilitySet", v.AvailabilitySet)
	populate(objectMap, "billingProfile", v.BillingProfile)
	populate(objectMap, "diagnosticsProfile", v.DiagnosticsProfile)
	populate(objectMap, "evictionPolicy", v.EvictionPolicy)
	populate(objectMap, "extensionsTimeBudget", v.ExtensionsTimeBudget)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "host", v.Host)
	populate(objectMap, "hostGroup", v.HostGroup)
	populate(objectMap, "instanceView", v.InstanceView)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "priority", v.Priority)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "proximityPlacementGroup", v.ProximityPlacementGroup)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populate(objectMap, "vmId", v.VMID)
	populate(objectMap, "virtualMachineScaleSet", v.VirtualMachineScaleSet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineProperties.
func (v *VirtualMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "availabilitySet":
			err = unpopulate(val, "AvailabilitySet", &v.AvailabilitySet)
			delete(rawMsg, key)
		case "billingProfile":
			err = unpopulate(val, "BillingProfile", &v.BillingProfile)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &v.DiagnosticsProfile)
			delete(rawMsg, key)
		case "evictionPolicy":
			err = unpopulate(val, "EvictionPolicy", &v.EvictionPolicy)
			delete(rawMsg, key)
		case "extensionsTimeBudget":
			err = unpopulate(val, "ExtensionsTimeBudget", &v.ExtensionsTimeBudget)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &v.Host)
			delete(rawMsg, key)
		case "hostGroup":
			err = unpopulate(val, "HostGroup", &v.HostGroup)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &v.InstanceView)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &v.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &v.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &v.VMID)
			delete(rawMsg, key)
		case "virtualMachineScaleSet":
			err = unpopulate(val, "VirtualMachineScaleSet", &v.VirtualMachineScaleSet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineReimageParameters.
func (v VirtualMachineReimageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tempDisk", v.TempDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineReimageParameters.
func (v *VirtualMachineReimageParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tempDisk":
			err = unpopulate(val, "TempDisk", &v.TempDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSet.
func (v VirtualMachineScaleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSet.
func (v *VirtualMachineScaleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetDataDisk.
func (v VirtualMachineScaleSetDataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", v.Caching)
	populate(objectMap, "createOption", v.CreateOption)
	populate(objectMap, "diskIOPSReadWrite", v.DiskIOPSReadWrite)
	populate(objectMap, "diskMBpsReadWrite", v.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "lun", v.Lun)
	populate(objectMap, "managedDisk", v.ManagedDisk)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "writeAcceleratorEnabled", v.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetDataDisk.
func (v *VirtualMachineScaleSetDataDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &v.Caching)
			delete(rawMsg, key)
		case "createOption":
			err = unpopulate(val, "CreateOption", &v.CreateOption)
			delete(rawMsg, key)
		case "diskIOPSReadWrite":
			err = unpopulate(val, "DiskIOPSReadWrite", &v.DiskIOPSReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &v.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &v.Lun)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &v.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &v.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtension.
func (v VirtualMachineScaleSetExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtension.
func (v *VirtualMachineScaleSetExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionListResult.
func (v VirtualMachineScaleSetExtensionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtensionListResult.
func (v *VirtualMachineScaleSetExtensionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionProfile.
func (v VirtualMachineScaleSetExtensionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "extensionsTimeBudget", v.ExtensionsTimeBudget)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtensionProfile.
func (v *VirtualMachineScaleSetExtensionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extensions":
			err = unpopulate(val, "Extensions", &v.Extensions)
			delete(rawMsg, key)
		case "extensionsTimeBudget":
			err = unpopulate(val, "ExtensionsTimeBudget", &v.ExtensionsTimeBudget)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionProperties.
func (v VirtualMachineScaleSetExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpgradeMinorVersion", v.AutoUpgradeMinorVersion)
	populate(objectMap, "enableAutomaticUpgrade", v.EnableAutomaticUpgrade)
	populate(objectMap, "forceUpdateTag", v.ForceUpdateTag)
	populate(objectMap, "protectedSettings", &v.ProtectedSettings)
	populate(objectMap, "provisionAfterExtensions", v.ProvisionAfterExtensions)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "publisher", v.Publisher)
	populate(objectMap, "settings", &v.Settings)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtensionProperties.
func (v *VirtualMachineScaleSetExtensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &v.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &v.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &v.ForceUpdateTag)
			delete(rawMsg, key)
		case "protectedSettings":
			err = unpopulate(val, "ProtectedSettings", &v.ProtectedSettings)
			delete(rawMsg, key)
		case "provisionAfterExtensions":
			err = unpopulate(val, "ProvisionAfterExtensions", &v.ProvisionAfterExtensions)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &v.Publisher)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &v.Settings)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionUpdate.
func (v VirtualMachineScaleSetExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtensionUpdate.
func (v *VirtualMachineScaleSetExtensionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIPConfiguration.
func (v VirtualMachineScaleSetIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetIPConfiguration.
func (v *VirtualMachineScaleSetIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIPConfigurationProperties.
func (v VirtualMachineScaleSetIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGatewayBackendAddressPools", v.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", v.ApplicationSecurityGroups)
	populate(objectMap, "loadBalancerBackendAddressPools", v.LoadBalancerBackendAddressPools)
	populate(objectMap, "loadBalancerInboundNatPools", v.LoadBalancerInboundNatPools)
	populate(objectMap, "primary", v.Primary)
	populate(objectMap, "privateIPAddressVersion", v.PrivateIPAddressVersion)
	populate(objectMap, "publicIPAddressConfiguration", v.PublicIPAddressConfiguration)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetIPConfigurationProperties.
func (v *VirtualMachineScaleSetIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGatewayBackendAddressPools":
			err = unpopulate(val, "ApplicationGatewayBackendAddressPools", &v.ApplicationGatewayBackendAddressPools)
			delete(rawMsg, key)
		case "applicationSecurityGroups":
			err = unpopulate(val, "ApplicationSecurityGroups", &v.ApplicationSecurityGroups)
			delete(rawMsg, key)
		case "loadBalancerBackendAddressPools":
			err = unpopulate(val, "LoadBalancerBackendAddressPools", &v.LoadBalancerBackendAddressPools)
			delete(rawMsg, key)
		case "loadBalancerInboundNatPools":
			err = unpopulate(val, "LoadBalancerInboundNatPools", &v.LoadBalancerInboundNatPools)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		case "privateIPAddressVersion":
			err = unpopulate(val, "PrivateIPAddressVersion", &v.PrivateIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPAddressConfiguration":
			err = unpopulate(val, "PublicIPAddressConfiguration", &v.PublicIPAddressConfiguration)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &v.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIPTag.
func (v VirtualMachineScaleSetIPTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipTagType", v.IPTagType)
	populate(objectMap, "tag", v.Tag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetIPTag.
func (v *VirtualMachineScaleSetIPTag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipTagType":
			err = unpopulate(val, "IPTagType", &v.IPTagType)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &v.Tag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIdentity.
func (v VirtualMachineScaleSetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", v.PrincipalID)
	populate(objectMap, "tenantId", v.TenantID)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "userAssignedIdentities", v.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetIdentity.
func (v *VirtualMachineScaleSetIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &v.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &v.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &v.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue.
func (v VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", v.ClientID)
	populate(objectMap, "principalId", v.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue.
func (v *VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &v.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &v.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetInstanceView.
func (v VirtualMachineScaleSetInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "orchestrationServices", v.OrchestrationServices)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "virtualMachine", v.VirtualMachine)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetInstanceView.
func (v *VirtualMachineScaleSetInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extensions":
			err = unpopulate(val, "Extensions", &v.Extensions)
			delete(rawMsg, key)
		case "orchestrationServices":
			err = unpopulate(val, "OrchestrationServices", &v.OrchestrationServices)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "virtualMachine":
			err = unpopulate(val, "VirtualMachine", &v.VirtualMachine)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetInstanceViewStatusesSummary.
func (v VirtualMachineScaleSetInstanceViewStatusesSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "statusesSummary", v.StatusesSummary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetInstanceViewStatusesSummary.
func (v *VirtualMachineScaleSetInstanceViewStatusesSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "statusesSummary":
			err = unpopulate(val, "StatusesSummary", &v.StatusesSummary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetListOSUpgradeHistory.
func (v VirtualMachineScaleSetListOSUpgradeHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetListOSUpgradeHistory.
func (v *VirtualMachineScaleSetListOSUpgradeHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetListResult.
func (v VirtualMachineScaleSetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetListResult.
func (v *VirtualMachineScaleSetListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetListSKUsResult.
func (v VirtualMachineScaleSetListSKUsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetListSKUsResult.
func (v *VirtualMachineScaleSetListSKUsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetListWithLinkResult.
func (v VirtualMachineScaleSetListWithLinkResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetListWithLinkResult.
func (v *VirtualMachineScaleSetListWithLinkResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetManagedDiskParameters.
func (v VirtualMachineScaleSetManagedDiskParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSet", v.DiskEncryptionSet)
	populate(objectMap, "storageAccountType", v.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetManagedDiskParameters.
func (v *VirtualMachineScaleSetManagedDiskParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &v.DiskEncryptionSet)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &v.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkConfiguration.
func (v VirtualMachineScaleSetNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetNetworkConfiguration.
func (v *VirtualMachineScaleSetNetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkConfigurationDNSSettings.
func (v VirtualMachineScaleSetNetworkConfigurationDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServers", v.DNSServers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetNetworkConfigurationDNSSettings.
func (v *VirtualMachineScaleSetNetworkConfigurationDNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &v.DNSServers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkConfigurationProperties.
func (v VirtualMachineScaleSetNetworkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "enableAcceleratedNetworking", v.EnableAcceleratedNetworking)
	populate(objectMap, "enableFpga", v.EnableFpga)
	populate(objectMap, "enableIPForwarding", v.EnableIPForwarding)
	populate(objectMap, "ipConfigurations", v.IPConfigurations)
	populate(objectMap, "networkSecurityGroup", v.NetworkSecurityGroup)
	populate(objectMap, "primary", v.Primary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetNetworkConfigurationProperties.
func (v *VirtualMachineScaleSetNetworkConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "enableAcceleratedNetworking":
			err = unpopulate(val, "EnableAcceleratedNetworking", &v.EnableAcceleratedNetworking)
			delete(rawMsg, key)
		case "enableFpga":
			err = unpopulate(val, "EnableFpga", &v.EnableFpga)
			delete(rawMsg, key)
		case "enableIPForwarding":
			err = unpopulate(val, "EnableIPForwarding", &v.EnableIPForwarding)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &v.IPConfigurations)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &v.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkProfile.
func (v VirtualMachineScaleSetNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthProbe", v.HealthProbe)
	populate(objectMap, "networkInterfaceConfigurations", v.NetworkInterfaceConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetNetworkProfile.
func (v *VirtualMachineScaleSetNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthProbe":
			err = unpopulate(val, "HealthProbe", &v.HealthProbe)
			delete(rawMsg, key)
		case "networkInterfaceConfigurations":
			err = unpopulate(val, "NetworkInterfaceConfigurations", &v.NetworkInterfaceConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetOSDisk.
func (v VirtualMachineScaleSetOSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", v.Caching)
	populate(objectMap, "createOption", v.CreateOption)
	populate(objectMap, "diffDiskSettings", v.DiffDiskSettings)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "image", v.Image)
	populate(objectMap, "managedDisk", v.ManagedDisk)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "vhdContainers", v.VhdContainers)
	populate(objectMap, "writeAcceleratorEnabled", v.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetOSDisk.
func (v *VirtualMachineScaleSetOSDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &v.Caching)
			delete(rawMsg, key)
		case "createOption":
			err = unpopulate(val, "CreateOption", &v.CreateOption)
			delete(rawMsg, key)
		case "diffDiskSettings":
			err = unpopulate(val, "DiffDiskSettings", &v.DiffDiskSettings)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &v.Image)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &v.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "vhdContainers":
			err = unpopulate(val, "VhdContainers", &v.VhdContainers)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &v.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetOSProfile.
func (v VirtualMachineScaleSetOSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPassword", v.AdminPassword)
	populate(objectMap, "adminUsername", v.AdminUsername)
	populate(objectMap, "computerNamePrefix", v.ComputerNamePrefix)
	populate(objectMap, "customData", v.CustomData)
	populate(objectMap, "linuxConfiguration", v.LinuxConfiguration)
	populate(objectMap, "secrets", v.Secrets)
	populate(objectMap, "windowsConfiguration", v.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetOSProfile.
func (v *VirtualMachineScaleSetOSProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &v.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &v.AdminUsername)
			delete(rawMsg, key)
		case "computerNamePrefix":
			err = unpopulate(val, "ComputerNamePrefix", &v.ComputerNamePrefix)
			delete(rawMsg, key)
		case "customData":
			err = unpopulate(val, "CustomData", &v.CustomData)
			delete(rawMsg, key)
		case "linuxConfiguration":
			err = unpopulate(val, "LinuxConfiguration", &v.LinuxConfiguration)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &v.Secrets)
			delete(rawMsg, key)
		case "windowsConfiguration":
			err = unpopulate(val, "WindowsConfiguration", &v.WindowsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetProperties.
func (v VirtualMachineScaleSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "automaticRepairsPolicy", v.AutomaticRepairsPolicy)
	populate(objectMap, "doNotRunExtensionsOnOverprovisionedVMs", v.DoNotRunExtensionsOnOverprovisionedVMs)
	populate(objectMap, "hostGroup", v.HostGroup)
	populate(objectMap, "overprovision", v.Overprovision)
	populate(objectMap, "platformFaultDomainCount", v.PlatformFaultDomainCount)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "proximityPlacementGroup", v.ProximityPlacementGroup)
	populate(objectMap, "scaleInPolicy", v.ScaleInPolicy)
	populate(objectMap, "singlePlacementGroup", v.SinglePlacementGroup)
	populate(objectMap, "uniqueId", v.UniqueID)
	populate(objectMap, "upgradePolicy", v.UpgradePolicy)
	populate(objectMap, "virtualMachineProfile", v.VirtualMachineProfile)
	populate(objectMap, "zoneBalance", v.ZoneBalance)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetProperties.
func (v *VirtualMachineScaleSetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "automaticRepairsPolicy":
			err = unpopulate(val, "AutomaticRepairsPolicy", &v.AutomaticRepairsPolicy)
			delete(rawMsg, key)
		case "doNotRunExtensionsOnOverprovisionedVMs":
			err = unpopulate(val, "DoNotRunExtensionsOnOverprovisionedVMs", &v.DoNotRunExtensionsOnOverprovisionedVMs)
			delete(rawMsg, key)
		case "hostGroup":
			err = unpopulate(val, "HostGroup", &v.HostGroup)
			delete(rawMsg, key)
		case "overprovision":
			err = unpopulate(val, "Overprovision", &v.Overprovision)
			delete(rawMsg, key)
		case "platformFaultDomainCount":
			err = unpopulate(val, "PlatformFaultDomainCount", &v.PlatformFaultDomainCount)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &v.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "scaleInPolicy":
			err = unpopulate(val, "ScaleInPolicy", &v.ScaleInPolicy)
			delete(rawMsg, key)
		case "singlePlacementGroup":
			err = unpopulate(val, "SinglePlacementGroup", &v.SinglePlacementGroup)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &v.UniqueID)
			delete(rawMsg, key)
		case "upgradePolicy":
			err = unpopulate(val, "UpgradePolicy", &v.UpgradePolicy)
			delete(rawMsg, key)
		case "virtualMachineProfile":
			err = unpopulate(val, "VirtualMachineProfile", &v.VirtualMachineProfile)
			delete(rawMsg, key)
		case "zoneBalance":
			err = unpopulate(val, "ZoneBalance", &v.ZoneBalance)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetPublicIPAddressConfiguration.
func (v VirtualMachineScaleSetPublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetPublicIPAddressConfiguration.
func (v *VirtualMachineScaleSetPublicIPAddressConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings.
func (v VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainNameLabel", v.DomainNameLabel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings.
func (v *VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainNameLabel":
			err = unpopulate(val, "DomainNameLabel", &v.DomainNameLabel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetPublicIPAddressConfigurationProperties.
func (v VirtualMachineScaleSetPublicIPAddressConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "ipTags", v.IPTags)
	populate(objectMap, "idleTimeoutInMinutes", v.IdleTimeoutInMinutes)
	populate(objectMap, "publicIPAddressVersion", v.PublicIPAddressVersion)
	populate(objectMap, "publicIPPrefix", v.PublicIPPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetPublicIPAddressConfigurationProperties.
func (v *VirtualMachineScaleSetPublicIPAddressConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "ipTags":
			err = unpopulate(val, "IPTags", &v.IPTags)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &v.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "publicIPAddressVersion":
			err = unpopulate(val, "PublicIPAddressVersion", &v.PublicIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPPrefix":
			err = unpopulate(val, "PublicIPPrefix", &v.PublicIPPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetReimageParameters.
func (v VirtualMachineScaleSetReimageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceIds", v.InstanceIDs)
	populate(objectMap, "tempDisk", v.TempDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetReimageParameters.
func (v *VirtualMachineScaleSetReimageParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceIds":
			err = unpopulate(val, "InstanceIDs", &v.InstanceIDs)
			delete(rawMsg, key)
		case "tempDisk":
			err = unpopulate(val, "TempDisk", &v.TempDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetSKU.
func (v VirtualMachineScaleSetSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", v.Capacity)
	populate(objectMap, "resourceType", v.ResourceType)
	populate(objectMap, "sku", v.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetSKU.
func (v *VirtualMachineScaleSetSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &v.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &v.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetSKUCapacity.
func (v VirtualMachineScaleSetSKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultCapacity", v.DefaultCapacity)
	populate(objectMap, "maximum", v.Maximum)
	populate(objectMap, "minimum", v.Minimum)
	populate(objectMap, "scaleType", v.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetSKUCapacity.
func (v *VirtualMachineScaleSetSKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultCapacity":
			err = unpopulate(val, "DefaultCapacity", &v.DefaultCapacity)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &v.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &v.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &v.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetStorageProfile.
func (v VirtualMachineScaleSetStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisks", v.DataDisks)
	populate(objectMap, "imageReference", v.ImageReference)
	populate(objectMap, "osDisk", v.OSDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetStorageProfile.
func (v *VirtualMachineScaleSetStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &v.DataDisks)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &v.ImageReference)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &v.OSDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdate.
func (v VirtualMachineScaleSetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdate.
func (v *VirtualMachineScaleSetUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateIPConfiguration.
func (v VirtualMachineScaleSetUpdateIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateIPConfiguration.
func (v *VirtualMachineScaleSetUpdateIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateIPConfigurationProperties.
func (v VirtualMachineScaleSetUpdateIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGatewayBackendAddressPools", v.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", v.ApplicationSecurityGroups)
	populate(objectMap, "loadBalancerBackendAddressPools", v.LoadBalancerBackendAddressPools)
	populate(objectMap, "loadBalancerInboundNatPools", v.LoadBalancerInboundNatPools)
	populate(objectMap, "primary", v.Primary)
	populate(objectMap, "privateIPAddressVersion", v.PrivateIPAddressVersion)
	populate(objectMap, "publicIPAddressConfiguration", v.PublicIPAddressConfiguration)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateIPConfigurationProperties.
func (v *VirtualMachineScaleSetUpdateIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGatewayBackendAddressPools":
			err = unpopulate(val, "ApplicationGatewayBackendAddressPools", &v.ApplicationGatewayBackendAddressPools)
			delete(rawMsg, key)
		case "applicationSecurityGroups":
			err = unpopulate(val, "ApplicationSecurityGroups", &v.ApplicationSecurityGroups)
			delete(rawMsg, key)
		case "loadBalancerBackendAddressPools":
			err = unpopulate(val, "LoadBalancerBackendAddressPools", &v.LoadBalancerBackendAddressPools)
			delete(rawMsg, key)
		case "loadBalancerInboundNatPools":
			err = unpopulate(val, "LoadBalancerInboundNatPools", &v.LoadBalancerInboundNatPools)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		case "privateIPAddressVersion":
			err = unpopulate(val, "PrivateIPAddressVersion", &v.PrivateIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPAddressConfiguration":
			err = unpopulate(val, "PublicIPAddressConfiguration", &v.PublicIPAddressConfiguration)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &v.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateNetworkConfiguration.
func (v VirtualMachineScaleSetUpdateNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateNetworkConfiguration.
func (v *VirtualMachineScaleSetUpdateNetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateNetworkConfigurationProperties.
func (v VirtualMachineScaleSetUpdateNetworkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "enableAcceleratedNetworking", v.EnableAcceleratedNetworking)
	populate(objectMap, "enableFpga", v.EnableFpga)
	populate(objectMap, "enableIPForwarding", v.EnableIPForwarding)
	populate(objectMap, "ipConfigurations", v.IPConfigurations)
	populate(objectMap, "networkSecurityGroup", v.NetworkSecurityGroup)
	populate(objectMap, "primary", v.Primary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateNetworkConfigurationProperties.
func (v *VirtualMachineScaleSetUpdateNetworkConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "enableAcceleratedNetworking":
			err = unpopulate(val, "EnableAcceleratedNetworking", &v.EnableAcceleratedNetworking)
			delete(rawMsg, key)
		case "enableFpga":
			err = unpopulate(val, "EnableFpga", &v.EnableFpga)
			delete(rawMsg, key)
		case "enableIPForwarding":
			err = unpopulate(val, "EnableIPForwarding", &v.EnableIPForwarding)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &v.IPConfigurations)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &v.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateNetworkProfile.
func (v VirtualMachineScaleSetUpdateNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthProbe", v.HealthProbe)
	populate(objectMap, "networkInterfaceConfigurations", v.NetworkInterfaceConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateNetworkProfile.
func (v *VirtualMachineScaleSetUpdateNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthProbe":
			err = unpopulate(val, "HealthProbe", &v.HealthProbe)
			delete(rawMsg, key)
		case "networkInterfaceConfigurations":
			err = unpopulate(val, "NetworkInterfaceConfigurations", &v.NetworkInterfaceConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateOSDisk.
func (v VirtualMachineScaleSetUpdateOSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", v.Caching)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "image", v.Image)
	populate(objectMap, "managedDisk", v.ManagedDisk)
	populate(objectMap, "vhdContainers", v.VhdContainers)
	populate(objectMap, "writeAcceleratorEnabled", v.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateOSDisk.
func (v *VirtualMachineScaleSetUpdateOSDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &v.Caching)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &v.Image)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &v.ManagedDisk)
			delete(rawMsg, key)
		case "vhdContainers":
			err = unpopulate(val, "VhdContainers", &v.VhdContainers)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &v.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateOSProfile.
func (v VirtualMachineScaleSetUpdateOSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customData", v.CustomData)
	populate(objectMap, "linuxConfiguration", v.LinuxConfiguration)
	populate(objectMap, "secrets", v.Secrets)
	populate(objectMap, "windowsConfiguration", v.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateOSProfile.
func (v *VirtualMachineScaleSetUpdateOSProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customData":
			err = unpopulate(val, "CustomData", &v.CustomData)
			delete(rawMsg, key)
		case "linuxConfiguration":
			err = unpopulate(val, "LinuxConfiguration", &v.LinuxConfiguration)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &v.Secrets)
			delete(rawMsg, key)
		case "windowsConfiguration":
			err = unpopulate(val, "WindowsConfiguration", &v.WindowsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateProperties.
func (v VirtualMachineScaleSetUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "automaticRepairsPolicy", v.AutomaticRepairsPolicy)
	populate(objectMap, "doNotRunExtensionsOnOverprovisionedVMs", v.DoNotRunExtensionsOnOverprovisionedVMs)
	populate(objectMap, "overprovision", v.Overprovision)
	populate(objectMap, "proximityPlacementGroup", v.ProximityPlacementGroup)
	populate(objectMap, "scaleInPolicy", v.ScaleInPolicy)
	populate(objectMap, "singlePlacementGroup", v.SinglePlacementGroup)
	populate(objectMap, "upgradePolicy", v.UpgradePolicy)
	populate(objectMap, "virtualMachineProfile", v.VirtualMachineProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateProperties.
func (v *VirtualMachineScaleSetUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "automaticRepairsPolicy":
			err = unpopulate(val, "AutomaticRepairsPolicy", &v.AutomaticRepairsPolicy)
			delete(rawMsg, key)
		case "doNotRunExtensionsOnOverprovisionedVMs":
			err = unpopulate(val, "DoNotRunExtensionsOnOverprovisionedVMs", &v.DoNotRunExtensionsOnOverprovisionedVMs)
			delete(rawMsg, key)
		case "overprovision":
			err = unpopulate(val, "Overprovision", &v.Overprovision)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &v.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "scaleInPolicy":
			err = unpopulate(val, "ScaleInPolicy", &v.ScaleInPolicy)
			delete(rawMsg, key)
		case "singlePlacementGroup":
			err = unpopulate(val, "SinglePlacementGroup", &v.SinglePlacementGroup)
			delete(rawMsg, key)
		case "upgradePolicy":
			err = unpopulate(val, "UpgradePolicy", &v.UpgradePolicy)
			delete(rawMsg, key)
		case "virtualMachineProfile":
			err = unpopulate(val, "VirtualMachineProfile", &v.VirtualMachineProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdatePublicIPAddressConfiguration.
func (v VirtualMachineScaleSetUpdatePublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdatePublicIPAddressConfiguration.
func (v *VirtualMachineScaleSetUpdatePublicIPAddressConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties.
func (v VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "idleTimeoutInMinutes", v.IdleTimeoutInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties.
func (v *VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &v.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateStorageProfile.
func (v VirtualMachineScaleSetUpdateStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisks", v.DataDisks)
	populate(objectMap, "imageReference", v.ImageReference)
	populate(objectMap, "osDisk", v.OSDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateStorageProfile.
func (v *VirtualMachineScaleSetUpdateStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &v.DataDisks)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &v.ImageReference)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &v.OSDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateVMProfile.
func (v VirtualMachineScaleSetUpdateVMProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingProfile", v.BillingProfile)
	populate(objectMap, "diagnosticsProfile", v.DiagnosticsProfile)
	populate(objectMap, "extensionProfile", v.ExtensionProfile)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "scheduledEventsProfile", v.ScheduledEventsProfile)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateVMProfile.
func (v *VirtualMachineScaleSetUpdateVMProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingProfile":
			err = unpopulate(val, "BillingProfile", &v.BillingProfile)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &v.DiagnosticsProfile)
			delete(rawMsg, key)
		case "extensionProfile":
			err = unpopulate(val, "ExtensionProfile", &v.ExtensionProfile)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "scheduledEventsProfile":
			err = unpopulate(val, "ScheduledEventsProfile", &v.ScheduledEventsProfile)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVM.
func (v VirtualMachineScaleSetVM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "instanceId", v.InstanceID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "resources", v.Resources)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVM.
func (v *VirtualMachineScaleSetVM) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "instanceId":
			err = unpopulate(val, "InstanceID", &v.InstanceID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &v.Resources)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMExtension.
func (v VirtualMachineScaleSetVMExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMExtension.
func (v *VirtualMachineScaleSetVMExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMExtensionUpdate.
func (v VirtualMachineScaleSetVMExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMExtensionUpdate.
func (v *VirtualMachineScaleSetVMExtensionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMExtensionsListResult.
func (v VirtualMachineScaleSetVMExtensionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMExtensionsListResult.
func (v *VirtualMachineScaleSetVMExtensionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMExtensionsSummary.
func (v VirtualMachineScaleSetVMExtensionsSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "statusesSummary", v.StatusesSummary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMExtensionsSummary.
func (v *VirtualMachineScaleSetVMExtensionsSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "statusesSummary":
			err = unpopulate(val, "StatusesSummary", &v.StatusesSummary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMInstanceIDs.
func (v VirtualMachineScaleSetVMInstanceIDs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceIds", v.InstanceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMInstanceIDs.
func (v *VirtualMachineScaleSetVMInstanceIDs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceIds":
			err = unpopulate(val, "InstanceIDs", &v.InstanceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMInstanceRequiredIDs.
func (v VirtualMachineScaleSetVMInstanceRequiredIDs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceIds", v.InstanceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMInstanceRequiredIDs.
func (v *VirtualMachineScaleSetVMInstanceRequiredIDs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceIds":
			err = unpopulate(val, "InstanceIDs", &v.InstanceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMInstanceView.
func (v VirtualMachineScaleSetVMInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignedHost", v.AssignedHost)
	populate(objectMap, "bootDiagnostics", v.BootDiagnostics)
	populate(objectMap, "disks", v.Disks)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "maintenanceRedeployStatus", v.MaintenanceRedeployStatus)
	populate(objectMap, "placementGroupId", v.PlacementGroupID)
	populate(objectMap, "platformFaultDomain", v.PlatformFaultDomain)
	populate(objectMap, "platformUpdateDomain", v.PlatformUpdateDomain)
	populate(objectMap, "rdpThumbPrint", v.RdpThumbPrint)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "vmAgent", v.VMAgent)
	populate(objectMap, "vmHealth", v.VMHealth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMInstanceView.
func (v *VirtualMachineScaleSetVMInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignedHost":
			err = unpopulate(val, "AssignedHost", &v.AssignedHost)
			delete(rawMsg, key)
		case "bootDiagnostics":
			err = unpopulate(val, "BootDiagnostics", &v.BootDiagnostics)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &v.Disks)
			delete(rawMsg, key)
		case "extensions":
			err = unpopulate(val, "Extensions", &v.Extensions)
			delete(rawMsg, key)
		case "maintenanceRedeployStatus":
			err = unpopulate(val, "MaintenanceRedeployStatus", &v.MaintenanceRedeployStatus)
			delete(rawMsg, key)
		case "placementGroupId":
			err = unpopulate(val, "PlacementGroupID", &v.PlacementGroupID)
			delete(rawMsg, key)
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &v.PlatformFaultDomain)
			delete(rawMsg, key)
		case "platformUpdateDomain":
			err = unpopulate(val, "PlatformUpdateDomain", &v.PlatformUpdateDomain)
			delete(rawMsg, key)
		case "rdpThumbPrint":
			err = unpopulate(val, "RdpThumbPrint", &v.RdpThumbPrint)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "vmAgent":
			err = unpopulate(val, "VMAgent", &v.VMAgent)
			delete(rawMsg, key)
		case "vmHealth":
			err = unpopulate(val, "VMHealth", &v.VMHealth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMListResult.
func (v VirtualMachineScaleSetVMListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMListResult.
func (v *VirtualMachineScaleSetVMListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMNetworkProfileConfiguration.
func (v VirtualMachineScaleSetVMNetworkProfileConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkInterfaceConfigurations", v.NetworkInterfaceConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMNetworkProfileConfiguration.
func (v *VirtualMachineScaleSetVMNetworkProfileConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterfaceConfigurations":
			err = unpopulate(val, "NetworkInterfaceConfigurations", &v.NetworkInterfaceConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMProfile.
func (v VirtualMachineScaleSetVMProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingProfile", v.BillingProfile)
	populate(objectMap, "diagnosticsProfile", v.DiagnosticsProfile)
	populate(objectMap, "evictionPolicy", v.EvictionPolicy)
	populate(objectMap, "extensionProfile", v.ExtensionProfile)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "priority", v.Priority)
	populate(objectMap, "scheduledEventsProfile", v.ScheduledEventsProfile)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMProfile.
func (v *VirtualMachineScaleSetVMProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingProfile":
			err = unpopulate(val, "BillingProfile", &v.BillingProfile)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &v.DiagnosticsProfile)
			delete(rawMsg, key)
		case "evictionPolicy":
			err = unpopulate(val, "EvictionPolicy", &v.EvictionPolicy)
			delete(rawMsg, key)
		case "extensionProfile":
			err = unpopulate(val, "ExtensionProfile", &v.ExtensionProfile)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &v.Priority)
			delete(rawMsg, key)
		case "scheduledEventsProfile":
			err = unpopulate(val, "ScheduledEventsProfile", &v.ScheduledEventsProfile)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMProperties.
func (v VirtualMachineScaleSetVMProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "availabilitySet", v.AvailabilitySet)
	populate(objectMap, "diagnosticsProfile", v.DiagnosticsProfile)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "instanceView", v.InstanceView)
	populate(objectMap, "latestModelApplied", v.LatestModelApplied)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "modelDefinitionApplied", v.ModelDefinitionApplied)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "networkProfileConfiguration", v.NetworkProfileConfiguration)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "protectionPolicy", v.ProtectionPolicy)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populate(objectMap, "vmId", v.VMID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMProperties.
func (v *VirtualMachineScaleSetVMProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "availabilitySet":
			err = unpopulate(val, "AvailabilitySet", &v.AvailabilitySet)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &v.DiagnosticsProfile)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &v.InstanceView)
			delete(rawMsg, key)
		case "latestModelApplied":
			err = unpopulate(val, "LatestModelApplied", &v.LatestModelApplied)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "modelDefinitionApplied":
			err = unpopulate(val, "ModelDefinitionApplied", &v.ModelDefinitionApplied)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "networkProfileConfiguration":
			err = unpopulate(val, "NetworkProfileConfiguration", &v.NetworkProfileConfiguration)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "protectionPolicy":
			err = unpopulate(val, "ProtectionPolicy", &v.ProtectionPolicy)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &v.VMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMProtectionPolicy.
func (v VirtualMachineScaleSetVMProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "protectFromScaleIn", v.ProtectFromScaleIn)
	populate(objectMap, "protectFromScaleSetActions", v.ProtectFromScaleSetActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMProtectionPolicy.
func (v *VirtualMachineScaleSetVMProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protectFromScaleIn":
			err = unpopulate(val, "ProtectFromScaleIn", &v.ProtectFromScaleIn)
			delete(rawMsg, key)
		case "protectFromScaleSetActions":
			err = unpopulate(val, "ProtectFromScaleSetActions", &v.ProtectFromScaleSetActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMReimageParameters.
func (v VirtualMachineScaleSetVMReimageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tempDisk", v.TempDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMReimageParameters.
func (v *VirtualMachineScaleSetVMReimageParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tempDisk":
			err = unpopulate(val, "TempDisk", &v.TempDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSize.
func (v VirtualMachineSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxDataDiskCount", v.MaxDataDiskCount)
	populate(objectMap, "memoryInMB", v.MemoryInMB)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "numberOfCores", v.NumberOfCores)
	populate(objectMap, "osDiskSizeInMB", v.OSDiskSizeInMB)
	populate(objectMap, "resourceDiskSizeInMB", v.ResourceDiskSizeInMB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSize.
func (v *VirtualMachineSize) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxDataDiskCount":
			err = unpopulate(val, "MaxDataDiskCount", &v.MaxDataDiskCount)
			delete(rawMsg, key)
		case "memoryInMB":
			err = unpopulate(val, "MemoryInMB", &v.MemoryInMB)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "numberOfCores":
			err = unpopulate(val, "NumberOfCores", &v.NumberOfCores)
			delete(rawMsg, key)
		case "osDiskSizeInMB":
			err = unpopulate(val, "OSDiskSizeInMB", &v.OSDiskSizeInMB)
			delete(rawMsg, key)
		case "resourceDiskSizeInMB":
			err = unpopulate(val, "ResourceDiskSizeInMB", &v.ResourceDiskSizeInMB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSizeListResult.
func (v VirtualMachineSizeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSizeListResult.
func (v *VirtualMachineSizeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSoftwarePatchProperties.
func (v VirtualMachineSoftwarePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activityId", v.ActivityID)
	populate(objectMap, "assessmentState", v.AssessmentState)
	populate(objectMap, "classifications", v.Classifications)
	populate(objectMap, "kbid", v.Kbid)
	populateTimeRFC3339(objectMap, "lastModifiedDateTime", v.LastModifiedDateTime)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "patchId", v.PatchID)
	populateTimeRFC3339(objectMap, "publishedDate", v.PublishedDate)
	populate(objectMap, "rebootBehavior", v.RebootBehavior)
	populate(objectMap, "version", v.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSoftwarePatchProperties.
func (v *VirtualMachineSoftwarePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &v.ActivityID)
			delete(rawMsg, key)
		case "assessmentState":
			err = unpopulate(val, "AssessmentState", &v.AssessmentState)
			delete(rawMsg, key)
		case "classifications":
			err = unpopulate(val, "Classifications", &v.Classifications)
			delete(rawMsg, key)
		case "kbid":
			err = unpopulate(val, "Kbid", &v.Kbid)
			delete(rawMsg, key)
		case "lastModifiedDateTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedDateTime", &v.LastModifiedDateTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "patchId":
			err = unpopulate(val, "PatchID", &v.PatchID)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateTimeRFC3339(val, "PublishedDate", &v.PublishedDate)
			delete(rawMsg, key)
		case "rebootBehavior":
			err = unpopulate(val, "RebootBehavior", &v.RebootBehavior)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &v.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineStatusCodeCount.
func (v VirtualMachineStatusCodeCount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "count", v.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineStatusCodeCount.
func (v *VirtualMachineStatusCodeCount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &v.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineUpdate.
func (v VirtualMachineUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineUpdate.
func (v *VirtualMachineUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WinRMConfiguration.
func (w WinRMConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "listeners", w.Listeners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WinRMConfiguration.
func (w *WinRMConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "listeners":
			err = unpopulate(val, "Listeners", &w.Listeners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WinRMListener.
func (w WinRMListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateUrl", w.CertificateURL)
	populate(objectMap, "protocol", w.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WinRMListener.
func (w *WinRMListener) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateUrl":
			err = unpopulate(val, "CertificateURL", &w.CertificateURL)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &w.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsConfiguration.
func (w WindowsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalUnattendContent", w.AdditionalUnattendContent)
	populate(objectMap, "enableAutomaticUpdates", w.EnableAutomaticUpdates)
	populate(objectMap, "patchSettings", w.PatchSettings)
	populate(objectMap, "provisionVMAgent", w.ProvisionVMAgent)
	populate(objectMap, "timeZone", w.TimeZone)
	populate(objectMap, "winRM", w.WinRM)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsConfiguration.
func (w *WindowsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalUnattendContent":
			err = unpopulate(val, "AdditionalUnattendContent", &w.AdditionalUnattendContent)
			delete(rawMsg, key)
		case "enableAutomaticUpdates":
			err = unpopulate(val, "EnableAutomaticUpdates", &w.EnableAutomaticUpdates)
			delete(rawMsg, key)
		case "patchSettings":
			err = unpopulate(val, "PatchSettings", &w.PatchSettings)
			delete(rawMsg, key)
		case "provisionVMAgent":
			err = unpopulate(val, "ProvisionVMAgent", &w.ProvisionVMAgent)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &w.TimeZone)
			delete(rawMsg, key)
		case "winRM":
			err = unpopulate(val, "WinRM", &w.WinRM)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
