module mrtindex_parameters
  use imbfits_parameters
  !---------------------------------------------------------------------
  !  Tables of translation between IMB-FITS fields and codes used in
  ! Mrtcal index files
  !  + few other parameters
  !---------------------------------------------------------------------
  !
  integer(kind=4), parameter :: fitsname_length=40  ! Warning: used in data format
  !
  ! Known observation types
  integer(kind=4), parameter :: obstype_length=11
  integer(kind=4), parameter :: nobstypes_imbfits=9
  integer(kind=4), parameter :: nobstypes_mrtcal =8
  ! Ad vitam aeternam codes:
  integer(kind=4), parameter :: obstype_unknown  =0
  integer(kind=4), parameter :: obstype_pointing =1
  integer(kind=4), parameter :: obstype_focus    =2
  integer(kind=4), parameter :: obstype_calibrate=3
  integer(kind=4), parameter :: obstype_tracked  =4
  integer(kind=4), parameter :: obstype_otf      =5
  integer(kind=4), parameter :: obstype_diy      =6
  integer(kind=4), parameter :: obstype_lissajous=7
  integer(kind=4), parameter :: obstype_tip      =8
  ! Used by IMBFITS, do not use for MRTCAL (this code can be modified)
  integer(kind=4), parameter :: obstype_onoff    =9
  ! Order must match obstype codes:
  ! 1) As found in IMBFITS files
  character(len=obstype_length), parameter :: obstypes_imbfits(0:nobstypes_imbfits) =  &
    (/ 'UNKNOWN    ','POINTING   ','FOCUS      ','CALIBRATE  ',  &
       'TRACK      ','ONTHEFLYMAP','DIY        ','LISSAJOUS  ',  &
       'TIP        ','ONOFF      ' /)
  ! 2) As displayed by MRTCAL
  character(len=obstype_length), parameter :: obstypes_mrtcal(0:nobstypes_mrtcal) =  &
    (/ 'UNKNOWN    ','POINTING   ','FOCUS      ','CALIBRATE  ',  &
       'TRACKED    ','ONTHEFLYMAP','DIY        ','LISSAJOUS  ',  &
       'TIP        ' /)
  !
  ! Known switching mode
  integer(kind=4), parameter :: switchmode_length=18
  integer(kind=4), parameter :: nswitchmodes=4
  ! Ad vitam aeternam codes:
  integer(kind=4), parameter :: switchmode_unk=0
  integer(kind=4), parameter :: switchmode_pos=1
  integer(kind=4), parameter :: switchmode_wob=2
  integer(kind=4), parameter :: switchmode_fre=3
  integer(kind=4), parameter :: switchmode_bea=4
  ! Order must match switchmode codes:
  ! 1) As found in IMBFITS files
  character(len=switchmode_length), parameter :: switchmodes_imbfits(nswitchmodes) =  &
    (/                      'TOTALPOWER        ','WOBBLERSWITCHING  ',  &
       'FREQUENCYSWITCHING','BEAMSWITCHING     ' /)
  ! 2) As displayed by MRTCAL
  character(len=3), parameter :: switchmodes_mrtcal(0:nswitchmodes) =  &
    (/ 'UNK','PSW','WSW','FSW','BSW' /)
  character(len=switchmode_length), parameter :: switchmodes_voxml(0:nswitchmodes) =  &
    (/ 'unknownSwitching  ','totalPower        ','wobblerSwitching  ',  &
       'frequencySwitching','beamSwitching     ' /)
  !
  ! Known polarimetry statuses
  integer(kind=4), parameter :: polstatus_length=3
  integer(kind=4), parameter :: npolstatus=2
  ! Ad vitam aeternam codes:
  integer(kind=4), parameter :: polstatus_no =0
  integer(kind=4), parameter :: polstatus_yes=1
  ! Order must match calibration status codes:
  character(len=polstatus_length), parameter ::  &
    polstatus(0:npolstatus-1) = (/ 'NO ','YES' /)
  !
  ! Known file completeness
  integer(kind=4), parameter :: completeness_length=10
  integer(kind=4), parameter :: ncompleteness=4
  ! Ad vitam aeternam codes:
  integer(kind=4), parameter :: complete_unreadable=1  ! Nothing usable
  integer(kind=4), parameter :: complete_empty     =2  ! 0 subscans
  integer(kind=4), parameter :: complete_partial   =3  ! A few subscans
  integer(kind=4), parameter :: complete_full      =4  ! All the subscans
  ! Order must match completeness codes:
  character(len=completeness_length), parameter :: completenesses(ncompleteness) =   &
    (/ 'UNREADABLE','EMPTY     ','INCOMPLETE','COMPLETE  ' /)
  !
  ! Known calibration statuses
  integer(kind=4), parameter :: calstatus_length=7
  integer(kind=4), parameter :: ncalstatus=5
  ! Ad vitam aeternam codes:
  integer(kind=4), parameter :: calstatus_none   =1
  integer(kind=4), parameter :: calstatus_done   =2
  integer(kind=4), parameter :: calstatus_failed =3
  integer(kind=4), parameter :: calstatus_empty  =4
  integer(kind=4), parameter :: calstatus_skipped=5
  ! Order must match calibration status codes:
  character(len=calstatus_length), parameter ::  &
    calstatus(ncalstatus) = (/ 'NONE   ','DONE   ','FAILED ','EMPTY  ','SKIPPED' /)
  !
  ! Known solve statuses
  integer(kind=4), parameter :: solstatus_length=6
  integer(kind=4), parameter :: nsolstatus=3
  ! Ad vitam aeternam codes:
  integer(kind=4), parameter :: solstatus_none  =1
  integer(kind=4), parameter :: solstatus_done  =2
  integer(kind=4), parameter :: solstatus_failed=3
  ! Order must match solve status codes:
  character(len=solstatus_length), parameter ::  &
    solstatus(nsolstatus) = (/ 'NONE   ','DONE   ','FAILED ' /)
  !
end module mrtindex_parameters
