/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import org.catacombae.hfsexplorer.types.hfs.CatKeyRec;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfsexplorer.types.hfsplus.BTHeaderRec;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogKey;
import org.catacombae.hfsexplorer.types.hfsx.HFSXCatalogKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHFSCatalogIndexNode
extends CommonBTIndexNode<CommonHFSCatalogKey> {
    protected CommonHFSCatalogIndexNode(byte[] data, int offset, int nodeSize, CommonBTNode.FSType type) {
        super(data, offset, nodeSize, type);
    }

    public static CommonHFSCatalogIndexNode createHFS(byte[] data, int offset, int nodeSize) {
        return new HFSImplementation(data, offset, nodeSize).getNode();
    }

    public static CommonHFSCatalogIndexNode createHFSPlus(byte[] data, int offset, int nodeSize) {
        return new HFSPlusImplementation(data, offset, nodeSize).getNode();
    }

    public static CommonHFSCatalogIndexNode createHFSX(byte[] data, int offset, int nodeSize, BTHeaderRec bthr) {
        return new HFSXImplementation(data, offset, nodeSize, bthr).getNode();
    }

    private static class HFSXImplementation {
        private final Internal i;
        private final BTHeaderRec catalogHeaderRec;

        public HFSXImplementation(byte[] data, int offset, int nodeSize, BTHeaderRec catalogHeaderRec) {
            this.catalogHeaderRec = catalogHeaderRec;
            this.i = new Internal(data, offset, nodeSize);
        }

        public CommonHFSCatalogIndexNode getNode() {
            return this.i;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Internal
        extends CommonHFSCatalogIndexNode {
            public Internal(byte[] data, int offset, int nodeSize) {
                super(data, offset, nodeSize, CommonBTNode.FSType.HFS_PLUS);
            }

            @Override
            protected CommonBTIndexRecord<CommonHFSCatalogKey> createBTRecord(int recordNumber, byte[] data, int offset, int length) {
                CommonHFSCatalogKey currentKey = CommonHFSCatalogKey.create(new HFSXCatalogKey(data, offset, HFSXImplementation.this.catalogHeaderRec));
                return CommonBTIndexRecord.createHFSPlus(currentKey, data, offset);
            }
        }
    }

    private static class HFSPlusImplementation {
        private final Internal i;

        public HFSPlusImplementation(byte[] data, int offset, int nodeSize) {
            this.i = new Internal(data, offset, nodeSize);
        }

        public CommonHFSCatalogIndexNode getNode() {
            return this.i;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Internal
        extends CommonHFSCatalogIndexNode {
            public Internal(byte[] data, int offset, int nodeSize) {
                super(data, offset, nodeSize, CommonBTNode.FSType.HFS_PLUS);
            }

            @Override
            protected CommonBTIndexRecord<CommonHFSCatalogKey> createBTRecord(int recordNumber, byte[] data, int offset, int length) {
                CommonHFSCatalogKey currentKey = CommonHFSCatalogKey.create(new HFSPlusCatalogKey(data, offset));
                return CommonBTIndexRecord.createHFSPlus(currentKey, data, offset);
            }
        }
    }

    private static class HFSImplementation {
        private final Internal i;

        public HFSImplementation(byte[] data, int offset, int nodeSize) {
            this.i = new Internal(data, offset, nodeSize);
        }

        public CommonHFSCatalogIndexNode getNode() {
            return this.i;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Internal
        extends CommonHFSCatalogIndexNode {
            public Internal(byte[] data, int offset, int nodeSize) {
                super(data, offset, nodeSize, CommonBTNode.FSType.HFS);
            }

            @Override
            protected CommonBTIndexRecord<CommonHFSCatalogKey> createBTRecord(int recordNumber, byte[] data, int offset, int length) {
                CommonHFSCatalogKey currentKey = CommonHFSCatalogKey.create(new CatKeyRec(data, offset));
                return CommonBTIndexRecord.createHFS(currentKey, data, offset);
            }
        }
    }
}

