/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { describe, it, expect, vi, beforeEach, afterEach } from 'vitest';
import { patchStdio, createInkStdio } from './stdio.js';
import { coreEvents } from '@google/gemini-cli-core';
vi.mock('@google/gemini-cli-core', () => ({
    coreEvents: {
        emitOutput: vi.fn(),
    },
}));
describe('stdio utils', () => {
    let originalStdoutWrite;
    let originalStderrWrite;
    beforeEach(() => {
        originalStdoutWrite = process.stdout.write;
        originalStderrWrite = process.stderr.write;
    });
    afterEach(() => {
        process.stdout.write = originalStdoutWrite;
        process.stderr.write = originalStderrWrite;
        vi.restoreAllMocks();
    });
    it('patchStdio redirects stdout and stderr to coreEvents', () => {
        const cleanup = patchStdio();
        process.stdout.write('test stdout');
        expect(coreEvents.emitOutput).toHaveBeenCalledWith(false, 'test stdout', undefined);
        process.stderr.write('test stderr');
        expect(coreEvents.emitOutput).toHaveBeenCalledWith(true, 'test stderr', undefined);
        cleanup();
        // Verify cleanup
        expect(process.stdout.write).toBe(originalStdoutWrite);
        expect(process.stderr.write).toBe(originalStderrWrite);
    });
    it('createInkStdio writes to real stdout/stderr bypassing patch', () => {
        const cleanup = patchStdio();
        const { stdout: inkStdout, stderr: inkStderr } = createInkStdio();
        inkStdout.write('ink stdout');
        expect(coreEvents.emitOutput).not.toHaveBeenCalled();
        inkStderr.write('ink stderr');
        expect(coreEvents.emitOutput).not.toHaveBeenCalled();
        cleanup();
    });
});
//# sourceMappingURL=stdio.test.js.map