/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.codec.Codec;
import com.singlestore.jdbc.codec.Parameter;
import com.singlestore.jdbc.codec.ParameterWithCal;
import com.singlestore.jdbc.codec.list.BigDecimalCodec;
import com.singlestore.jdbc.codec.list.BlobCodec;
import com.singlestore.jdbc.codec.list.BooleanCodec;
import com.singlestore.jdbc.codec.list.ByteArrayCodec;
import com.singlestore.jdbc.codec.list.ByteCodec;
import com.singlestore.jdbc.codec.list.ClobCodec;
import com.singlestore.jdbc.codec.list.DateCodec;
import com.singlestore.jdbc.codec.list.DoubleCodec;
import com.singlestore.jdbc.codec.list.FloatCodec;
import com.singlestore.jdbc.codec.list.IntCodec;
import com.singlestore.jdbc.codec.list.LongCodec;
import com.singlestore.jdbc.codec.list.ReaderCodec;
import com.singlestore.jdbc.codec.list.ShortCodec;
import com.singlestore.jdbc.codec.list.StreamCodec;
import com.singlestore.jdbc.codec.list.StringCodec;
import com.singlestore.jdbc.codec.list.TimeCodec;
import com.singlestore.jdbc.codec.list.TimestampCodec;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.message.server.PrepareResultPacket;
import com.singlestore.jdbc.util.ParameterList;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BasePreparedStatement
extends Statement
implements PreparedStatement {
    protected ParameterList parameters;
    protected List<ParameterList> batchParameters;
    protected final String sql;
    protected PrepareResultPacket prepareResult = null;

    public BasePreparedStatement(String sql, Connection con, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) {
        super(con, lock, canUseServerTimeout, canUseServerMaxRows, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        this.sql = sql;
    }

    public void setPrepareResult(PrepareResultPacket prepareResult) {
        this.prepareResult = prepareResult;
    }

    public ColumnDefinitionPacket[] getMeta() {
        return this.prepareResult.getColumns();
    }

    public void updateMeta(ColumnDefinitionPacket[] ci) {
        this.prepareResult.setColumns(ci);
    }

    @Override
    public abstract boolean execute() throws SQLException;

    @Override
    public abstract ResultSet executeQuery() throws SQLException;

    @Override
    public abstract int executeUpdate() throws SQLException;

    @Override
    public abstract long executeLargeUpdate() throws SQLException;

    @Override
    public abstract void addBatch() throws SQLException;

    @Override
    public abstract void clearBatch() throws SQLException;

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    public void setParameters(ParameterList parameters) {
        this.parameters = parameters;
    }

    public void setParameter(int index, Parameter<?> param) {
        this.parameters.set(index, param);
    }

    @Override
    public abstract int[] executeBatch() throws SQLException;

    @Override
    public abstract long[] executeLargeBatch() throws SQLException;

    @Override
    public void addBatch(String sql) throws SQLException {
        throw this.exceptionFactory().create("addBatch(String sql) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql, int autoGeneratedKeys) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql, int[] columnIndexes) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql, String[] columnNames) cannot be called on preparedStatement");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw this.exceptionFactory().create("executeQuery(String sql) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql, int autoGeneratedKeys) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql, int[] columnIndexes) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql, String[] columnNames) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql, int autoGeneratedKeys) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql, int[] columnIndexes) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql, String[] columnNames) cannot be called on preparedStatement");
    }

    private void checkIndex(int index) throws SQLException {
        if (index <= 0) {
            throw this.exceptionFactory().create(String.format("wrong parameter index %s", index));
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, Parameter.NULL_PARAMETER);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Boolean>(BooleanCodec.INSTANCE, x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Byte>(ByteCodec.INSTANCE, x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Short>(ShortCodec.INSTANCE, x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Integer>(IntCodec.INSTANCE, x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Long>(LongCodec.INSTANCE, x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Float>(FloatCodec.INSTANCE, Float.valueOf(x)));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Double>(DoubleCodec.INSTANCE, x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<BigDecimal>(BigDecimalCodec.INSTANCE, x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<String>(StringCodec.INSTANCE, x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<byte[]>(ByteArrayCodec.INSTANCE, x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Date>(DateCodec.INSTANCE, x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Time>(TimeCodec.INSTANCE, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Timestamp>(TimestampCodec.INSTANCE, x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<InputStream>(StreamCodec.INSTANCE, x, Long.valueOf(length)));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<InputStream>(StreamCodec.INSTANCE, x, Long.valueOf(length)));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<InputStream>(StreamCodec.INSTANCE, x, Long.valueOf(length)));
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
        this.parameters = new ParameterList();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, x, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setInternalObject(parameterIndex, x, null);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Reader>(ReaderCodec.INSTANCE, reader, Long.valueOf(length)));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw this.exceptionFactory().notSupported("REF parameter are not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Blob>(BlobCodec.INSTANCE, x));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Clob>(ClobCodec.INSTANCE, x));
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw this.exceptionFactory().notSupported("Array parameter are not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCal<Date>(DateCodec.INSTANCE, x, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCal<Time>(TimeCodec.INSTANCE, x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCal<Timestamp>(TimestampCodec.INSTANCE, x, cal));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, Parameter.NULL_PARAMETER);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<String>(StringCodec.INSTANCE, x.toString()));
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw this.exceptionFactory().notSupported("RowId parameter are not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<String>(StringCodec.INSTANCE, value));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Reader>(ReaderCodec.INSTANCE, value, length));
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<NClob>(ClobCodec.INSTANCE, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Reader>(ReaderCodec.INSTANCE, reader, length));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<InputStream>(StreamCodec.INSTANCE, inputStream, length));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Reader>(ReaderCodec.INSTANCE, reader, length));
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw this.exceptionFactory().notSupported("SQLXML parameter are not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, x, Long.valueOf(scaleOrLength));
    }

    private void setInternalObject(int parameterIndex, Object x, Long scaleOrLength) throws SQLException {
        this.checkIndex(parameterIndex);
        if (x == null) {
            this.parameters.set(parameterIndex - 1, Parameter.NULL_PARAMETER);
            return;
        }
        for (Codec<?> codec : this.con.getContext().getConf().codecs()) {
            if (!codec.canEncode(x)) continue;
            Parameter<Object> p = new Parameter<Object>(codec, x, scaleOrLength);
            this.parameters.set(parameterIndex - 1, p);
            return;
        }
        throw new SQLException(String.format("Type %s not supported type", x.getClass().getName()));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<InputStream>(StreamCodec.INSTANCE, x, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<InputStream>(StreamCodec.INSTANCE, x, length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Reader>(ReaderCodec.INSTANCE, reader, length));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<InputStream>(StreamCodec.INSTANCE, x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<InputStream>(StreamCodec.INSTANCE, x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Reader>(ReaderCodec.INSTANCE, reader));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Reader>(ReaderCodec.INSTANCE, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Reader>(ReaderCodec.INSTANCE, reader));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<InputStream>(StreamCodec.INSTANCE, inputStream));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Reader>(ReaderCodec.INSTANCE, reader));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, x, Long.valueOf(scaleOrLength));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, x, null);
    }
}

