/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.oauth;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.jdbc.common.OAuthSettings;
import com.databricks.client.jdbc.common.SSLSettings;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.oauth.OAuthFactory;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpPost;
import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSAlgorithm;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSHeader;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSSigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.ECDSASigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.RSASSASigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.BaseJWSProvider;
import com.databricks.client.jdbc42.internal.nimbusjwt.JWTClaimsSet;
import com.databricks.client.jdbc42.internal.nimbusjwt.SignedJWT;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.FileReader;
import java.io.Reader;
import java.net.URI;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.UUID;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public class SparkOAuthFactory
extends OAuthFactory {
    private static final String RS256_KEY = "RS256";
    private static final String RS384_KEY = "RS384";
    private static final String RS512_KEY = "RS512 ";
    private static final String PS256_KEY = "PS256";
    private static final String PS384_KEY = "PS384";
    private static final String PS512_KEY = "PS512";
    private static final String ES256_KEY = "ES256";
    private static final String ES384_KEY = "ES384";
    private static final String ES512_KEY = "ES512";
    private static final String RSA_KEY = "RSA";
    private static final String DSA_KEY = "ECDSA";
    private static final String RSA_SEGMENT_KEY = "SunRsaSign";
    private static final String DSA_SEGMENT_KEY = "SunEC";

    public static String JWTCredentialOAuth(HiveJDBCSettings hiveJDBCSettings, SSLSettings sSLSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, sSLSettings, iLogger);
        PrivateKey privateKey = SparkOAuthFactory.getPrivateKey(hiveJDBCSettings.m_oAuthSettings);
        SignedJWT signedJWT = SparkOAuthFactory.fetchAccessToken(privateKey, hiveJDBCSettings.m_oAuthSettings);
        hiveJDBCSettings.m_oAuthSettings.m_OAuthClientAssertion = signedJWT.serialize();
        URI uRI = SparkOAuthFactory.getServerURI(hiveJDBCSettings.m_oAuthSettings.m_authorizationUrl, hiveJDBCSettings.m_oAuthSettings.m_OAuth2EnableAuthURLIPRange);
        String string = null;
        HttpPost httpPost = new HttpPost(uRI);
        httpPost = SparkOAuthFactory.setRequestParams(hiveJDBCSettings.m_oAuthSettings, httpPost);
        httpPost.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        string = SparkOAuthFactory.executeRequestWithRetry(hiveJDBCSettings, uRI, httpPost, iLogger);
        String string2 = SparkOAuthFactory.parseJsonResponse(string.toString(), "access_token");
        SparkOAuthFactory.setExpiryTime(string, hiveJDBCSettings.m_oAuthSettings, iLogger);
        if (null == string2) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
            throw errorException;
        }
        return string2;
    }

    private static PrivateKey getPrivateKey(OAuthSettings oAuthSettings) throws ErrorException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            Object object;
            PEMParser pEMParser = new PEMParser((Reader)new FileReader(oAuthSettings.m_OAuth2KeyFilePath));
            while ((object = pEMParser.readObject()) != null) {
                try {
                    return SparkOAuthFactory.parseSegment(oAuthSettings, object);
                }
                catch (Exception exception) {
                }
            }
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage()});
            throw errorException;
        }
    }

    private static PrivateKey parseSegment(OAuthSettings oAuthSettings, Object object) throws ErrorException {
        try {
            try {
                oAuthSettings.m_OAuthJWTKeyType = DSA_KEY;
                return SparkOAuthFactory.checkSegment(oAuthSettings, object, DSA_SEGMENT_KEY);
            }
            catch (PEMException pEMException) {
                oAuthSettings.m_OAuthJWTKeyType = RSA_KEY;
                return SparkOAuthFactory.checkSegment(oAuthSettings, object, RSA_SEGMENT_KEY);
            }
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage()});
            throw errorException;
        }
    }

    private static PrivateKey checkSegment(OAuthSettings oAuthSettings, Object object, String string) throws OperatorCreationException, PKCSException, PEMException {
        PrivateKeyInfo privateKeyInfo;
        Object object2;
        if (oAuthSettings.m_OAuth2KeyPassphrase != null) {
            object2 = (PKCS8EncryptedPrivateKeyInfo)object;
            JceOpenSSLPKCS8DecryptorProviderBuilder jceOpenSSLPKCS8DecryptorProviderBuilder = new JceOpenSSLPKCS8DecryptorProviderBuilder();
            jceOpenSSLPKCS8DecryptorProviderBuilder.setProvider("BC");
            InputDecryptorProvider inputDecryptorProvider = jceOpenSSLPKCS8DecryptorProviderBuilder.build(oAuthSettings.m_OAuth2KeyPassphrase.toCharArray());
            privateKeyInfo = object2.decryptPrivateKeyInfo(inputDecryptorProvider);
        } else {
            try {
                privateKeyInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
            }
            catch (ClassCastException classCastException) {
                privateKeyInfo = (PrivateKeyInfo)object;
            }
        }
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter().setProvider(string);
        object2 = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
        return object2;
    }

    private static SignedJWT fetchAccessToken(PrivateKey privateKey, OAuthSettings oAuthSettings) throws ErrorException {
        JWSHeader jWSHeader;
        BaseJWSProvider baseJWSProvider;
        if (oAuthSettings.m_OAuthJWTKeyType.equals(RSA_KEY)) {
            baseJWSProvider = new RSASSASigner(privateKey);
            jWSHeader = SparkOAuthFactory.buildRSAHeader(oAuthSettings);
        } else if (oAuthSettings.m_OAuthJWTKeyType.equals(DSA_KEY)) {
            try {
                baseJWSProvider = new ECDSASigner((ECPrivateKey)privateKey);
                jWSHeader = SparkOAuthFactory.buildECHeader(oAuthSettings);
            }
            catch (JOSEException jOSEException) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{jOSEException.getMessage()});
                throw errorException;
            }
        } else {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
            throw errorException;
        }
        String string = oAuthSettings.m_authClientID;
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        UUID uUID = UUID.randomUUID();
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        JWTClaimsSet jWTClaimsSet = builder.issuer(string).subject(string).issueTime(timestamp).expirationTime(timestamp).audience(oAuthSettings.m_authorizationUrl).jwtID(uUID.toString()).build();
        SignedJWT signedJWT = new SignedJWT(jWSHeader, jWTClaimsSet);
        try {
            signedJWT.sign((JWSSigner)((Object)baseJWSProvider));
            return signedJWT;
        }
        catch (JOSEException jOSEException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{jOSEException.getMessage()});
            throw errorException;
        }
    }

    private static JWSHeader buildECHeader(OAuthSettings oAuthSettings) throws ErrorException {
        JWSHeader jWSHeader;
        if (oAuthSettings.m_OAuthJWTAssertionAlgorithm == null) {
            oAuthSettings.m_OAuthJWTAssertionAlgorithm = ES256_KEY;
        }
        if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals(ES256_KEY)) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.ES256).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals(ES384_KEY)) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.ES384).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals(ES512_KEY)) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.ES512).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.INVALID_ASSERTION_ALGORITHM_ERROR.name());
            throw errorException;
        }
        return jWSHeader;
    }

    private static JWSHeader buildRSAHeader(OAuthSettings oAuthSettings) throws ErrorException {
        JWSHeader jWSHeader;
        if (oAuthSettings.m_OAuthJWTAssertionAlgorithm == null) {
            oAuthSettings.m_OAuthJWTAssertionAlgorithm = RS256_KEY;
        }
        if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals(RS256_KEY)) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals(RS384_KEY)) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.RS384).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals(RS512_KEY)) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.RS512).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals(PS256_KEY)) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.PS256).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals(PS384_KEY)) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.PS384).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals(PS512_KEY)) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.PS512).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.INVALID_ASSERTION_ALGORITHM_ERROR.name(), oAuthSettings.m_OAuthJWTAssertionAlgorithm);
            throw errorException;
        }
        return jWSHeader;
    }
}

