/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl;

import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableTimeNanoHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.TimeNanoHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.Types;

public class NullableTimeNanoHolderReaderImpl
extends AbstractFieldReader {
    private NullableTimeNanoHolder holder;

    public NullableTimeNanoHolderReaderImpl(NullableTimeNanoHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMENANO;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(TimeNanoHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeNanoHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Long readLong() {
        if (!this.isSet()) {
            return null;
        }
        Long value = new Long(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readLong();
    }
}

