/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.filesystem.impl;

import com.terracottatech.offheapstore.filesystem.File;
import com.terracottatech.offheapstore.filesystem.SeekableInputStream;
import com.terracottatech.offheapstore.filesystem.SeekableOutputStream;
import com.terracottatech.offheapstore.filesystem.impl.OffheapDirectory;
import com.terracottatech.offheapstore.filesystem.impl.OffheapInputStream;
import com.terracottatech.offheapstore.filesystem.impl.OffheapOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.ehcache.shadow.org.terracotta.offheapstore.concurrent.ConcurrentOffHeapHashMap;
import org.ehcache.shadow.org.terracotta.offheapstore.paging.PageSource;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.IntegerStorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.OffHeapBufferHalfStorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.SplitStorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.Portability;
import org.ehcache.shadow.org.terracotta.offheapstore.util.Factory;
import org.ehcache.shadow.org.terracotta.offheapstore.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffheapFile
implements File {
    private static final boolean VALIDATING = Validation.shouldValidate(OffheapFile.class);
    private final PageSource source;
    private final String name;
    private final Map<Integer, ByteBuffer> blockMap;
    private final AtomicInteger blockCount = new AtomicInteger(0);
    private volatile long length;
    private volatile long lastModified = System.currentTimeMillis();
    private final int blockSize;
    private final int maxDataPageSize;
    private static final int TABLE_SIZE = 128;
    private final int concurrency;
    private OffheapOutputStream outputStream;
    private final AtomicInteger inputStreamCount = new AtomicInteger(0);
    private volatile boolean pendingDelete = false;
    private final ByteBuffer outBuffer;
    private static final Logger LOGGER = LoggerFactory.getLogger(OffheapFile.class);
    private final boolean debug = LOGGER.isDebugEnabled();

    OffheapFile(OffheapDirectory dir, String fileName, PageSource source, int blockSize, int maxDataPageSize, int concurrency) {
        this.name = fileName;
        this.source = source;
        this.blockSize = blockSize;
        this.maxDataPageSize = maxDataPageSize;
        this.concurrency = concurrency;
        this.blockMap = this.createOffHeapMap();
        this.outBuffer = this.newBlock(blockSize);
        if (this.debug) {
            LOGGER.debug("Creating Offheap File: " + this);
        }
    }

    private ConcurrentMap<Integer, ByteBuffer> createOffHeapMap() {
        Factory storageEngineFactory = SplitStorageEngine.createFactory(IntegerStorageEngine.createFactory(), OffHeapBufferHalfStorageEngine.createFactory(this.source, this.maxDataPageSize, this.maxDataPageSize, new ValuePortability(), false, false));
        return new ConcurrentOffHeapHashMap<Integer, ByteBuffer>(this.source, true, storageEngineFactory, 128L, this.concurrency);
    }

    @Override
    public long length() throws IOException {
        return this.length;
    }

    @Override
    public long lastModifiedTime() throws IOException {
        return this.lastModified;
    }

    @Override
    public void setLastModifiedTime(long time) throws IOException {
        this.lastModified = time;
    }

    @Override
    public SeekableInputStream getInputStream() throws IOException {
        this.inputStreamCount.incrementAndGet();
        OffheapInputStream stream = new OffheapInputStream(this, this.blockSize);
        return stream;
    }

    @Override
    public synchronized SeekableOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new OffheapOutputStream(this, this.blockSize);
            return this.outputStream;
        }
        return this.outputStream;
    }

    synchronized void streamClosed(boolean isOut) throws IOException {
        if (isOut) {
            this.outputStream = null;
        } else {
            this.inputStreamCount.decrementAndGet();
        }
        if (this.pendingDelete && this.okToDelete()) {
            this.doDelete();
        }
    }

    public String toString() {
        return "Name: " + this.name + "\nBlock Size: " + this.blockSize + "\nMax Data Page Size: " + this.maxDataPageSize + "\nConcurrency: " + this.concurrency + "\n\n";
    }

    @Override
    public String getName() {
        return this.name;
    }

    synchronized void setLength(long newLength) {
        this.validateLength(newLength);
        this.length = newLength;
        for (int i = this.blockCount.get(); i > (int)(newLength / (long)this.blockSize); --i) {
            this.blockMap.remove(i);
            this.blockCount.decrementAndGet();
        }
    }

    private void validateLength(long newLength) {
        if (newLength < 0L) {
            throw new AssertionError((Object)("Length cant be negative : current : " + this.length + " new : " + newLength));
        }
        if (newLength / (long)this.blockSize > Integer.MAX_VALUE) {
            throw new AssertionError((Object)("File Length too large : Block size : " + this.blockSize + " file size : " + newLength));
        }
    }

    private void setLengthOnFlush(long newLength) {
        this.validateLength(newLength);
        if (this.length < newLength) {
            this.length = newLength;
        }
    }

    int numBlocks() {
        return this.blockMap.size();
    }

    private ByteBuffer newBlock(int size) {
        return ByteBuffer.allocate(size);
    }

    private final ByteBuffer addBlock(int size) {
        this.blockCount.getAndIncrement();
        this.outBuffer.clear();
        return this.outBuffer;
    }

    private final ByteBuffer getBlock(int index) {
        ByteBuffer ret = null;
        while (index >= this.blockCount.get()) {
            ret = this.addBlock(this.blockSize);
        }
        if (ret != null) {
            return ret;
        }
        ret = this.blockMap.get(index);
        return ret;
    }

    final ByteBuffer getBlockToWrite(int index) {
        ByteBuffer buf = this.getBlock(index);
        ByteBuffer copy = this.newBlock(buf.capacity());
        copy.put(buf);
        copy.flip();
        return copy;
    }

    final ByteBuffer getBlockToRead(int index) throws IOException {
        if (this.blockMap.size() == 0) {
            throw new IOException("File is either empty or it has been deleted");
        }
        int lastIndex = this.blockMap.size() - 1;
        if (lastIndex < index) {
            throw new EOFException("Attempt to read past end : lastIndex= " + lastIndex + " index = " + index);
        }
        ByteBuffer buf = this.getBlock(index).asReadOnlyBuffer();
        buf.position(0);
        int bufEnd = (int)(this.length() % (long)this.blockSize);
        if (index == lastIndex && bufEnd != 0) {
            buf.limit(bufEnd);
        } else {
            buf.limit(this.blockSize);
        }
        return buf;
    }

    @Override
    public long getSizeInBytes() {
        return this.blockCount.get() * this.blockSize;
    }

    void flush(int index, ByteBuffer buffer, int bufferEnd) throws IOException {
        if (index + 1 == this.blockCount.get()) {
            long newLength = (long)index * (long)this.blockSize + (long)bufferEnd;
            this.setLengthOnFlush(newLength);
        }
        this.blockMap.put(index, buffer);
        this.setLastModifiedTime(System.currentTimeMillis());
    }

    synchronized void delete() throws IOException {
        if (!this.okToDelete()) {
            this.pendingDelete = true;
        } else {
            this.doDelete();
        }
    }

    private void doDelete() {
        Validation.validate(!VALIDATING || Thread.holdsLock(this));
        this.blockMap.clear();
        this.blockCount.set(0);
        this.pendingDelete = false;
    }

    private synchronized boolean okToDelete() {
        return !this.anyInputStreamsAreOpen() && !this.outputStreamIsOpen();
    }

    boolean anyInputStreamsAreOpen() {
        Validation.validate(!VALIDATING || Thread.holdsLock(this));
        return this.inputStreamCount.get() != 0;
    }

    boolean outputStreamIsOpen() {
        return this.outputStream != null;
    }

    @Override
    public synchronized void truncate() throws IOException {
        if (this.length == 0L) {
            return;
        }
        if (this.outputStream != null) {
            this.outputStream.reset();
            this.blockCount.set(0);
            this.blockMap.clear();
        } else {
            this.blockCount.set(0);
            this.blockMap.clear();
        }
    }

    public static class ValuePortability
    implements Portability<ByteBuffer> {
        @Override
        public ByteBuffer decode(ByteBuffer src) {
            return src;
        }

        @Override
        public ByteBuffer encode(ByteBuffer buf) {
            ByteBuffer buffer = buf.asReadOnlyBuffer();
            buffer.position(0);
            buffer.limit(buffer.capacity());
            return buffer;
        }

        @Override
        public boolean equals(Object value, ByteBuffer buf) {
            return value.equals(buf);
        }
    }
}

