/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.nio.NIOConstants;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NIOSegmentList
implements Iterable<File> {
    private final List<File> segments;
    private final File directory;
    private File readHead;
    private int position;
    private int segmentId;
    private long cachedTotalSize;
    private static final Logger LOGGER = LoggerFactory.getLogger(NIOSegmentList.class);

    NIOSegmentList(File directory) throws IOException {
        this.directory = directory;
        File[] list = directory.listFiles(NIOConstants.SEGMENT_FILENAME_FILTER);
        if (list == null) {
            list = new File[]{};
        }
        this.segments = new LinkedList<File>(Arrays.asList(list));
        Collections.sort(this.segments, NIOConstants.SEGMENT_FILE_COMPARATOR);
        this.segmentId = this.segments.isEmpty() ? 0 : NIOConstants.convertSegmentNumber(this.segments.get(0));
        this.position = -1;
        for (int x = 0; x < this.segments.size() - 1; ++x) {
            this.cachedTotalSize += this.segments.get(x).length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getTotalSize() {
        long size = this.cachedTotalSize;
        NIOSegmentList nIOSegmentList = this;
        synchronized (nIOSegmentList) {
            if (!this.segments.isEmpty()) {
                size += this.segments.get(this.segments.size() - 1).length();
            }
        }
        return size;
    }

    synchronized File appendFile() throws IOException {
        int seg = this.segmentId + this.segments.size();
        File writeHead = new File(this.directory, NIOConstants.convertToSegmentFileName(seg));
        if (!this.segments.isEmpty()) {
            this.cachedTotalSize += this.segments.get(this.segments.size() - 1).length();
        }
        this.segments.add(writeHead);
        return writeHead;
    }

    public synchronized boolean isEmpty() {
        return this.segments.isEmpty();
    }

    synchronized void setReadPosition(int pos) {
        this.position = this.segments.isEmpty() || pos == 0 ? -1 : (pos < 0 || pos >= this.segmentId + this.segments.size() ? this.segments.size() : pos - this.segmentId);
    }

    synchronized File nextReadFile(Direction dir) throws IOException {
        this.readHead = null;
        this.position = dir == Direction.REVERSE ? --this.position : ++this.position;
        this.readHead = this.position < 0 || this.position >= this.segments.size() ? null : this.segments.get(this.position);
        return this.readHead;
    }

    int getSegmentPosition() {
        return this.segmentId + this.position;
    }

    int getBeginningSegmentId() {
        return this.segmentId;
    }

    synchronized long removeFilesFromTail() throws IOException {
        int count;
        long size = 0L;
        for (count = 0; count < this.position; ++count) {
            File f = this.segments.remove(0);
            size += f.length();
            if (f.delete()) continue;
            size -= f.length();
            this.segments.add(0, f);
            break;
        }
        this.segmentId += count;
        this.position -= count;
        if (this.readHead != null && !this.segments.get(0).equals(this.readHead) || this.segmentId != NIOConstants.convertSegmentNumber(this.segments.get(0))) {
            LOGGER.warn("unable to delete some files during compaction");
        }
        this.cachedTotalSize -= size;
        return size;
    }

    synchronized long removeFilesFromHead() throws IOException {
        long size = 0L;
        while (this.position + 1 < this.segments.size()) {
            File f = this.segments.remove(this.segments.size() - 1);
            size += f.length();
            if (f.delete()) continue;
            size -= f.length();
            this.segments.add(f);
            break;
        }
        if (this.readHead != null && !this.segments.get(this.position).equals(this.readHead)) {
            LOGGER.warn("unable to delete some files during compaction");
        }
        this.cachedTotalSize -= size;
        return size;
    }

    synchronized File getCurrentReadFile() {
        if (this.position < 0 || this.position >= this.segments.size()) {
            return null;
        }
        if (this.readHead == null) {
            this.readHead = this.segments.get(this.position);
        }
        return this.readHead;
    }

    synchronized File getEndFile() throws IOException {
        if (this.segments.isEmpty()) {
            return null;
        }
        return this.segments.get(this.segments.size() - 1);
    }

    synchronized File getFile(int segmentId) {
        int spot = segmentId - this.segmentId;
        if (spot < 0 || spot >= this.segments.size()) {
            return null;
        }
        return this.segments.get(segmentId - this.segmentId);
    }

    synchronized boolean currentIsHead() throws IOException {
        if (this.readHead == null && this.segments.isEmpty()) {
            return true;
        }
        if (this.readHead != null && this.segments.isEmpty()) {
            throw new AssertionError((Object)"segment list is inconsistent");
        }
        return this.segments.get(this.segments.size() - 1).equals(this.readHead);
    }

    synchronized boolean currentIsTail() throws IOException {
        if (this.readHead == null && this.segments.isEmpty()) {
            return true;
        }
        if (this.readHead != null && this.segments.isEmpty()) {
            throw new AssertionError((Object)"segment list is inconsistent");
        }
        return this.segments.get(0).equals(this.readHead);
    }

    synchronized File getBeginningFile() throws IOException {
        if (this.segments.isEmpty()) {
            return null;
        }
        return this.segments.get(0);
    }

    synchronized int getCount() {
        return this.segments.size();
    }

    public synchronized File get(int i) {
        if (i >= this.segments.size()) {
            return null;
        }
        return this.segments.get(i);
    }

    public synchronized int size() {
        return this.segments.size();
    }

    public synchronized File remove(int i) {
        if (i >= this.segments.size()) {
            return null;
        }
        File f = this.segments.remove(i);
        this.cachedTotalSize -= f.length();
        f.delete();
        return f;
    }

    @Override
    public Iterator<File> iterator() {
        return this.listIterator(0);
    }

    public ListIterator<File> listIterator(final int start) {
        return new ListIterator<File>(){
            int position;
            {
                this.position = start;
            }

            @Override
            public boolean hasNext() {
                return this.position < NIOSegmentList.this.size();
            }

            @Override
            public File next() {
                if (this.position >= NIOSegmentList.this.size()) {
                    throw new NoSuchElementException();
                }
                return NIOSegmentList.this.get(this.position++);
            }

            @Override
            public void remove() {
                NIOSegmentList.this.remove(this.position);
            }

            @Override
            public boolean hasPrevious() {
                return this.position > 0;
            }

            @Override
            public File previous() {
                return NIOSegmentList.this.get(--this.position);
            }

            @Override
            public int nextIndex() {
                return this.position + 1;
            }

            @Override
            public int previousIndex() {
                return this.position - 1;
            }

            @Override
            public void set(File e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(File e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List<File> copyList() {
        return new ArrayList<File>(this.segments);
    }

    public String toString() {
        return "NIOSegmentList{segments=" + this.segments + ", position=" + this.position + ", segmentId=" + this.segmentId + '}';
    }
}

