# Contributing to sig

We welcome contributions to "sig" and greatly appreciate your help in making
this project even better. Here's a quick guide to get you started.

## How to Contribute

1. **Fork the Repository**: Click the "Fork" button at the top right of the
[sig repository](https://github.com/ynqa/sig) to create a copy of the
project in your GitHub account.

2. **Clone the Repository**: On your local machine, open a terminal and run the
following command, replacing `<your_username>` with your GitHub username:

```bash
git clone https://github.com/<your_username>/sig.git
```

3. **Create a Branch**: Before making any changes, create a new branch for your
work:

```bash
git checkout -b your-branch-name
```

4. **Make Changes**: Make your desired code changes, bug fixes, or feature
additions.

5. **Commit Your Changes**: Commit your changes with a clear and concise message
explaining the purpose of your contribution:

```bash
git commit -m "Your commit message here"
```

6. **Push to Your Fork**: Push your changes to your forked repository on GitHub:

```bash
git push origin your-branch-name
```

7. **Create a Pull Request (PR)**: Open the
[sig Pull Request page](https://github.com/ynqa/sig/pulls) and click the
"New Pull Request" button. Compare and create your PR by following the prompts.

8. **Review and Discuss**: Your PR will be reviewed by project maintainers, who
may provide feedback or request further changes. Be prepared for discussion and
updates.

9. **Merging**: Once your PR is approved and passes any necessary tests, a
project maintainer will merge it into the main repository.

## Code of Conduct

Please adhere to our [Code of Conduct](CODE_OF_CONDUCT.md) when participating in
this project. We aim to create a respectful and inclusive community for all
contributors.

Thank you for considering contributing to "sig"!
