/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SourceVersion;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This code can be simplified to use a pattern-matching instanceof.")
public final class PatternMatchingInstanceof
extends BugChecker
implements BugChecker.IfTreeMatcher {
    public Description matchIf(IfTree tree, VisitorState state) {
        if (!SourceVersion.supportsPatternMatchingInstanceof((Context)state.context)) {
            return Description.NO_MATCH;
        }
        ImmutableSet<InstanceOfTree> instanceofChecks = this.scanForInstanceOf(tree.getCondition());
        if (instanceofChecks.isEmpty()) {
            return Description.NO_MATCH;
        }
        StatementTree body = tree.getThenStatement();
        if (!(body instanceof BlockTree)) {
            return Description.NO_MATCH;
        }
        BlockTree block = (BlockTree)body;
        if (block.getStatements().isEmpty()) {
            return Description.NO_MATCH;
        }
        StatementTree firstStatement = block.getStatements().get(0);
        if (!(firstStatement instanceof VariableTree)) {
            return Description.NO_MATCH;
        }
        VariableTree variableTree = (VariableTree)firstStatement;
        if (!(variableTree.getInitializer() instanceof TypeCastTree)) {
            return Description.NO_MATCH;
        }
        TypeCastTree typeCast = (TypeCastTree)variableTree.getInitializer();
        InstanceOfTree matchingInstanceof = instanceofChecks.stream().filter(i -> state.getTypes().isSameType(ASTHelpers.getType((Tree)i.getType()), ASTHelpers.getType((Tree)typeCast.getType())) && ASTHelpers.getSymbol((Tree)i.getExpression()) instanceof Symbol.VarSymbol && ASTHelpers.getSymbol((Tree)i.getExpression()).equals(ASTHelpers.getSymbol((Tree)typeCast.getExpression()))).findFirst().orElse(null);
        if (matchingInstanceof == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(firstStatement, (Fix)SuggestedFix.builder().delete((Tree)variableTree).postfixWith((Tree)matchingInstanceof, " " + variableTree.getName().toString()).build());
    }

    private ImmutableSet<InstanceOfTree> scanForInstanceOf(ExpressionTree condition) {
        final ImmutableSet.Builder instanceOfs = ImmutableSet.builder();
        new SimpleTreeVisitor<Void, Void>(this){
            final /* synthetic */ PatternMatchingInstanceof this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (Void)this.visit(tree.getExpression(), null);
            }

            @Override
            public Void visitBinary(BinaryTree tree, Void unused) {
                if (tree.getKind() != Tree.Kind.CONDITIONAL_AND) {
                    return null;
                }
                this.visit(tree.getLeftOperand(), null);
                this.visit(tree.getRightOperand(), null);
                return null;
            }

            @Override
            public Void visitInstanceOf(InstanceOfTree tree, Void unused) {
                instanceOfs.add((Object)tree);
                return null;
            }
        }.visit(condition, null);
        return instanceOfs.build();
    }
}

