/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.instrument;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class JarFinder {
    private static final Logger logger = Logger.getLogger(JarFinder.class.getName());
    private static final Splitter CLASS_PATH_ATTRIBUTE_SEPARATOR = Splitter.on((char)' ').omitEmptyStrings();

    JarFinder() {
    }

    public static ImmutableSet<File> findJarFiles(ClassLoader first, ClassLoader ... rest) throws IOException {
        Scanner scanner = new Scanner();
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (ClassLoader classLoader : Lists.asList((Object)first, (Object[])rest)) {
            map.putAll(JarFinder.getClassPathEntries(classLoader));
        }
        for (Map.Entry entry : map.entrySet()) {
            scanner.scan((File)entry.getKey(), (ClassLoader)entry.getValue());
        }
        return scanner.jarFiles();
    }

    @VisibleForTesting
    static ImmutableMap<File, ClassLoader> getClassPathEntries(ClassLoader classloader) {
        LinkedHashMap entries = Maps.newLinkedHashMap();
        ClassLoader parent = classloader.getParent();
        if (parent != null) {
            entries.putAll(JarFinder.getClassPathEntries(parent));
        }
        for (URL url : JarFinder.getClassLoaderUrls(classloader)) {
            File file;
            if (!url.getProtocol().equals("file") || entries.containsKey(file = JarFinder.toFile(url))) continue;
            entries.put(file, classloader);
        }
        return ImmutableMap.copyOf((Map)entries);
    }

    private static ImmutableList<URL> getClassLoaderUrls(ClassLoader classloader) {
        if (classloader instanceof URLClassLoader) {
            return ImmutableList.copyOf((Object[])((URLClassLoader)classloader).getURLs());
        }
        if (classloader.equals(ClassLoader.getSystemClassLoader())) {
            return JarFinder.parseJavaClassPath();
        }
        return ImmutableList.of();
    }

    private static ImmutableList<URL> parseJavaClassPath() {
        ImmutableList.Builder urls = ImmutableList.builder();
        for (String entry : Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value())) {
            try {
                try {
                    urls.add((Object)new File(entry).toURI().toURL());
                }
                catch (SecurityException e) {
                    urls.add((Object)new URL("file", null, new File(entry).getAbsolutePath()));
                }
            }
            catch (MalformedURLException e) {
                String string = String.valueOf(entry);
                logger.log(Level.WARNING, string.length() != 0 ? "malformed classpath entry: ".concat(string) : new String("malformed classpath entry: "), e);
            }
        }
        return urls.build();
    }

    private static File toFile(URL url) {
        Preconditions.checkArgument((boolean)url.getProtocol().equals("file"));
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    @VisibleForTesting
    static final class Scanner {
        private final ImmutableSet.Builder<File> jarFiles = new ImmutableSet.Builder();
        private final Set<File> scannedFiles = Sets.newHashSet();

        Scanner() {
        }

        ImmutableSet<File> jarFiles() {
            return this.jarFiles.build();
        }

        void scan(File file, ClassLoader classloader) throws IOException {
            if (this.scannedFiles.add(file)) {
                this.scanFrom(file, classloader);
            }
        }

        @VisibleForTesting
        void scanFrom(File file, ClassLoader classloader) throws IOException {
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory()) {
                this.scanDirectory(file, classloader);
            } else {
                this.scanJar(file, classloader);
            }
        }

        private void scanDirectory(File directory, ClassLoader classloader) {
            this.scanDirectory(directory, classloader, "");
        }

        private void scanDirectory(File directory, ClassLoader classloader, String packagePrefix) {
            for (File file : directory.listFiles()) {
                String name = file.getName();
                if (!file.isDirectory()) continue;
                this.scanDirectory(file, classloader, new StringBuilder(1 + String.valueOf(packagePrefix).length() + String.valueOf(name).length()).append(packagePrefix).append(name).append("/").toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanJar(File file, ClassLoader classloader) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return;
            }
            this.jarFiles.add((Object)file);
            try {
                for (File path : Scanner.getClassPathFromManifest(file, jarFile.getManifest())) {
                    this.scan(path, classloader);
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }

        @VisibleForTesting
        static ImmutableSet<File> getClassPathFromManifest(File jarFile, @Nullable Manifest manifest) {
            if (manifest == null) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
            if (classpathAttribute != null) {
                for (String path : CLASS_PATH_ATTRIBUTE_SEPARATOR.split((CharSequence)classpathAttribute)) {
                    URL url;
                    try {
                        url = Scanner.getClassPathEntry(jarFile, path);
                    }
                    catch (MalformedURLException e) {
                        String string = String.valueOf(path);
                        logger.warning(string.length() != 0 ? "Invalid Class-Path entry: ".concat(string) : new String("Invalid Class-Path entry: "));
                        continue;
                    }
                    if (!url.getProtocol().equals("file")) continue;
                    builder.add((Object)JarFinder.toFile(url));
                }
            }
            return builder.build();
        }

        @VisibleForTesting
        static URL getClassPathEntry(File jarFile, String path) throws MalformedURLException {
            return new URL(jarFile.toURI().toURL(), path);
        }
    }
}

