/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.target.Device;
import com.google.caliper.runner.target.Target;
import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;

@Module
public abstract class TargetModule {
    private TargetModule() {
    }

    @Singleton
    @Provides
    static ImmutableSet<Target> provideTargets(Device device, CaliperOptions options, CaliperConfig config) {
        ImmutableSet<String> vmNames = options.vmNames();
        if (vmNames.isEmpty()) {
            return ImmutableSet.of((Object)device.createDefaultTarget());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String vmName : vmNames) {
            builder.add((Object)device.createTarget(config.getVmConfig(vmName)));
        }
        return builder.build();
    }

    @Provides
    static ImmutableSet<VmType> vmTypes(ImmutableSet<Target> targets) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Target target : targets) {
            builder.add((Object)target.vm().type());
        }
        return builder.build();
    }
}

