/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.instrument;

import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Modifier;

final class BenchmarkMethods {
    private static final ImmutableList<String> MACROBENCHMARK_PARAMS = ImmutableList.of();
    private static final ImmutableList<String> MICROBENCHMARK_PARAMS = ImmutableList.of((Object)"int");
    private static final ImmutableList<String> PICOBENCHMARK_PARAMS = ImmutableList.of((Object)"long");

    private BenchmarkMethods() {
    }

    static boolean isTimeMethod(BenchmarkClassModel.MethodModel method) {
        return method.name().startsWith("time") && Modifier.isPublic(method.modifiers());
    }

    static BenchmarkClassModel.MethodModel checkTimeMethod(BenchmarkClassModel.MethodModel timeMethod) throws InvalidBenchmarkException {
        Preconditions.checkArgument((boolean)BenchmarkMethods.isTimeMethod(timeMethod));
        ImmutableList parameterTypes = timeMethod.parameterTypes();
        if (!parameterTypes.equals(MICROBENCHMARK_PARAMS) && !parameterTypes.equals(PICOBENCHMARK_PARAMS)) {
            String string = String.valueOf(timeMethod.name());
            throw new InvalidBenchmarkException(string.length() != 0 ? "Microbenchmark methods must accept a single int parameter: ".concat(string) : new String("Microbenchmark methods must accept a single int parameter: "), new Object[0]);
        }
        if (Modifier.isStatic(timeMethod.modifiers())) {
            String string = String.valueOf(timeMethod.name());
            throw new InvalidBenchmarkException(string.length() != 0 ? "Microbenchmark methods must not be static: ".concat(string) : new String("Microbenchmark methods must not be static: "), new Object[0]);
        }
        return timeMethod;
    }

    static enum Type {
        MACRO,
        MICRO,
        PICO;


        static Type of(BenchmarkClassModel.MethodModel benchmarkMethod) {
            ImmutableList parameterTypes = benchmarkMethod.parameterTypes();
            if (parameterTypes.equals((Object)MACROBENCHMARK_PARAMS)) {
                return MACRO;
            }
            if (parameterTypes.equals((Object)MICROBENCHMARK_PARAMS)) {
                return MICRO;
            }
            if (parameterTypes.equals((Object)PICOBENCHMARK_PARAMS)) {
                return PICO;
            }
            String string = String.valueOf(benchmarkMethod);
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length()).append("invalid method parameters: ").append(string).toString());
        }
    }
}

