/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.jobs.Job;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;

public final class DblSeq
extends NativeSeq {
    private final double[] values;

    private DblSeq(double[] values) {
        super(values.length, (Type)AtomType.DOUBLE);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException, QueryException {
        int size = in.readNum();
        double[] values = new double[size];
        for (int s = 0; s < size; ++s) {
            values[s] = Dbl.parse(in.readToken(), null);
        }
        return DblSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (double v : this.values) {
            out.writeToken(Token.token(v));
        }
    }

    @Override
    public Dbl itemAt(long index) {
        return Dbl.get(this.values[(int)index]);
    }

    @Override
    public Value reverse(Job job) {
        int sz = (int)this.size;
        double[] tmp = new double[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return DblSeq.get(tmp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof DblSeq) {
            DblSeq seq = (DblSeq)obj;
            if (!Arrays.equals(this.values, seq.values)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    public double[] toJava() {
        return this.values;
    }

    public static Value get(double[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Dbl.get(values[0]) : new DblSeq(values));
    }
}

