/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.core.jobs.Job;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQHashMap;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.Type;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;

public final class XQRecordMap
extends XQHashMap {
    private final Value[] values;

    public XQRecordMap(Value[] values, Type type) {
        super(type);
        this.values = values;
    }

    @Override
    public boolean refineType() throws QueryException {
        return true;
    }

    @Override
    public long structSize() {
        return this.values.length;
    }

    @Override
    public XQMap put(Item key, Value value) throws QueryException {
        int i;
        if (key.type.isStringOrUntyped() && (i = this.fields().index(key.string(null))) != 0) {
            return this.putAt(i - 1, value);
        }
        return super.put(key, value);
    }

    @Override
    public XQMap putAt(int index, Value value) throws QueryException {
        if (value == this.values[index]) {
            return this;
        }
        if (value.seqType().instanceOf(this.fields().value(index + 1).seqType())) {
            Value[] copy = (Value[])this.values.clone();
            copy[index] = value;
            return new XQRecordMap(copy, this.type);
        }
        return super.putAt(index, value);
    }

    @Override
    public Value getOrNull(Item key) throws QueryException {
        int i;
        if (key.type.isStringOrUntyped() && (i = this.fields().index(key.string(null))) != 0) {
            return this.valueAt(i - 1);
        }
        return null;
    }

    @Override
    public Value keys() {
        return StrSeq.get(this.fields().keys());
    }

    @Override
    public Item keyAt(int index) {
        return Str.get(this.fields().key(index + 1));
    }

    private TokenObjectMap<RecordField> fields() {
        return ((RecordType)this.type).fields();
    }

    @Override
    public Value valueAt(int index) {
        return this.values[index];
    }

    @Override
    void valueAt(int index, Value value) {
        this.values[index] = value;
    }

    @Override
    XQHashMap build(Item key, Value value) {
        throw Util.notExpected();
    }

    @Override
    public Item shrink(Job job) throws QueryException {
        this.shrinkValues(job);
        return this;
    }
}

