/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.RecordSet;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.map.MapCompilation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class MapPut
extends StandardFunc {
    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        XQMap map = this.toMap(this.arg(0), qc);
        Item key = this.toAtomItem(this.arg(1), qc);
        Value value = this.arg(2).value(qc);
        return map.put(key, value);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        AtomType akt;
        Expr map = this.arg(0);
        Expr key = this.arg(1);
        Expr value = this.arg(2);
        if (map == XQMap.empty()) {
            return cc.function(Function._MAP_ENTRY, this.info, key, value);
        }
        MapType tp = null;
        MapCompilation mc = MapCompilation.get(map).key(key);
        if (mc.field != null) {
            SeqType ft;
            if (!mc.record.hasOptional()) {
                return new RecordSet(this.info, map, mc.index, value).optimize(cc);
            }
            SeqType vt = value.seqType();
            if (vt.instanceOf(ft = mc.field.seqType())) {
                tp = mc.record;
            } else if (mc.record.fields().size() < 32) {
                tp = mc.record.copy(null, mc.key, vt.union(ft), cc);
            }
        } else if (mc.validKey) {
            if (mc.record.isExtensible()) {
                tp = mc.record;
            } else if (mc.key != null && mc.record.fields().size() < 32) {
                tp = mc.record.copy(null, mc.key, value.seqType(), cc);
            }
        }
        if (tp == null && mc.mapType != null && (akt = key.seqType().type.atomic()) != null) {
            tp = mc.mapType.union(akt, value.seqType());
        }
        if (tp != null) {
            this.exprType.assign(tp);
        }
        return this;
    }
}

