/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.hof;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.MinHeap;

public final class HofTopKBy
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Iter input = this.arg(0).iter(qc);
        FItem key = this.toFunction(this.arg(1), 1, qc);
        long k = Math.min(this.toLong(this.arg(2), qc), Integer.MAX_VALUE);
        if (k < 1L) {
            return Empty.VALUE;
        }
        MinHeap<Item, Item> heap = new MinHeap<Item, Item>((item1, item2) -> {
            try {
                if (!item1.comparable((Item)item2)) {
                    throw QueryError.compareError(item1, item2, this.info);
                }
                return item1.compare((Item)item2, null, true, this.info);
            }
            catch (QueryException ex) {
                throw new QueryRTException(ex);
            }
        });
        try {
            Item item;
            while ((item = input.next()) != null) {
                Item ky = key.invoke(qc, this.info, item).item(qc, this.info);
                heap.insert(ky.isEmpty() ? item : ky, item);
                if ((long)heap.size() <= k) continue;
                heap.removeMin();
            }
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        ValueBuilder vb = new ValueBuilder(qc);
        while (!heap.isEmpty()) {
            vb.add((Value)heap.removeMin());
        }
        return vb.value(this).reverse(qc);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr input = this.arg(0);
        return input.seqType().zero() ? input : this.adoptType(input);
    }
}

