/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.convert;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class ConvertFn
extends StandardFunc {
    final byte[] stringToBinary(QueryContext qc) throws QueryException {
        byte[] value = this.toToken(this.arg(0), qc);
        String encoding = this.toEncodingOrNull(this.arg(1), QueryError.CONVERT_ENCODING_X, qc);
        try {
            return ConvertFn.toBinary(value, encoding);
        }
        catch (CharacterCodingException ex) {
            Util.debug(ex);
            throw QueryError.CONVERT_BINARY_X_X.get(this.info, value, encoding);
        }
    }

    public static byte[] toBinary(byte[] in, String encoding) throws CharacterCodingException {
        if (encoding == null || encoding == "UTF-8") {
            return in;
        }
        Charset cs = Charset.forName(encoding == "UTF-16" ? "UTF-16BE" : encoding);
        ByteBuffer bb = cs.newEncoder().encode(CharBuffer.wrap(Token.string(in)));
        return Arrays.copyOfRange(bb.array(), bb.position(), bb.limit());
    }

    public static byte[] toString(InputStream is, String encoding, boolean validate) throws IOException {
        try (TextInput ti = new TextInput(is, encoding);){
            byte[] byArray = ti.validate(validate).content();
            return byArray;
        }
    }
}

