/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.EnumSet;
import java.util.function.Supplier;
import org.basex.core.users.Perm;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Flag;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class FuncDefinition {
    public final SeqType seqType;
    public final QNm name;
    public final QNm[] params;
    public final SeqType[] types;
    final Supplier<? extends StandardFunc> supplier;
    final int[] minMax;
    final Perm perm;
    private final String paramString;
    private final EnumSet<Flag> flags;

    FuncDefinition(Supplier<? extends StandardFunc> supplier, String string, SeqType[] types, SeqType seqType, EnumSet<Flag> flags, byte[] uri, Perm perm) {
        this.supplier = supplier;
        this.seqType = seqType;
        this.types = types;
        this.flags = flags;
        this.perm = perm;
        int s = string.indexOf(40);
        this.name = new QNm(NSGlobal.prefix(uri), Token.token(string.substring(0, s)), uri);
        this.paramString = string.substring(s + 1).replace(")", "");
        this.minMax = FuncDefinition.minMax(this.paramString);
        String[] prms = Strings.split(this.paramString.replaceAll("[.\\[\\]]", ""), ',');
        int pl = prms.length == 1 && prms[0].isEmpty() ? 0 : prms.length;
        this.params = new QNm[pl];
        for (int p = 0; p < pl; ++p) {
            this.params[p] = new QNm(prms[p]);
        }
        if (flags.contains((Object)Flag.UPD)) {
            flags.add(Flag.NDT);
        }
    }

    public static int[] minMax(String paramString) {
        boolean optional = false;
        int min = 0;
        int max = -1;
        for (int d = 0; d < paramString.length(); ++d) {
            char ch = paramString.charAt(d);
            if (ch == ',') {
                if (optional) {
                    ++max;
                } else {
                    ++min;
                }
                ++d;
                continue;
            }
            if (ch == '[') {
                optional = true;
                max = min;
                continue;
            }
            if (ch == '.') {
                if (!optional) {
                    --min;
                }
                max = Integer.MAX_VALUE;
                break;
            }
            if (optional) {
                if (max != min) continue;
                ++max;
                continue;
            }
            if (min != 0) continue;
            min = 1;
        }
        if (max == -1) {
            max = min;
        }
        return new int[]{min, max};
    }

    public boolean has(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    FuncType type(int arity, AnnList anns) {
        SeqType[] st = new SeqType[arity];
        if (arity != 0 && this.variadic()) {
            int tl = this.types.length;
            Array.copy(this.types, tl, st);
            SeqType var = this.types[tl - 1];
            for (int t = tl; t < arity; ++t) {
                st[t] = var;
            }
        } else {
            Array.copy(this.types, arity, st);
        }
        return FuncType.get(anns, this.seqType, st);
    }

    QNm[] paramNames(int arity) {
        QNm[] qnames = new QNm[arity];
        int nl = this.params.length;
        int n = Math.min(arity, nl);
        while (--n >= 0) {
            qnames[n] = this.params[n];
        }
        if (arity > nl) {
            String nm = Token.string(this.params[nl - 1].local());
            boolean start = true;
            for (int n2 = nl; n2 < arity; ++n2) {
                qnames[n2] = new QNm(nm + (1 + n2 - nl), "");
            }
        }
        return qnames;
    }

    public boolean variadic() {
        return this.minMax[1] == Integer.MAX_VALUE;
    }

    public StandardFunc get(InputInfo info, Expr ... args) {
        StandardFunc sf = this.supplier.get();
        sf.init(info, this, args);
        return sf;
    }

    public String args(boolean error, Object ... args) {
        TokenBuilder tb = new TokenBuilder().add(32).add(this.name.string()).add(40);
        int c = 0;
        for (Object arg : args) {
            String str;
            if (c++ > 0) {
                tb.add(", ");
            }
            if (arg instanceof ExprInfo) {
                ExprInfo ei = (ExprInfo)arg;
                tb.add(error ? ei.toErrorString() : ei.toString());
                continue;
            }
            if (arg instanceof Number) {
                tb.add(arg);
                continue;
            }
            if (arg instanceof Boolean) {
                tb.add(String.valueOf(arg) + "()");
                continue;
            }
            if (arg instanceof byte[]) {
                byte[] token = (byte[])arg;
                v0 = Token.string(token);
            } else {
                v0 = str = arg.toString();
            }
            if (Strings.startsWith(str, ' ')) {
                tb.add(str.substring(1));
                continue;
            }
            tb.add("\"" + str.replace("\"", "\"\"") + "\"");
        }
        return tb.add(41).toString();
    }

    public String toString() {
        return Strings.concat(this.name.string(), Character.valueOf('('), this.paramString, Character.valueOf(')'));
    }
}

