/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.util;

import java.io.PrintWriter;
import java.util.TimeZone;
import net.xqj.core.TextContainer;
import net.xqj.core.XQToolkit;

public final class Logger {
    public static final int FATAL = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int TRACE = 5;
    private static final char[][] LEXICAL_VALUES = new char[][]{{'F', 'A', 'T', 'A', 'L'}, {'E', 'R', 'R', 'O', 'R'}, {' ', 'W', 'A', 'R', 'N'}, {' ', 'I', 'N', 'F', 'O'}, {'D', 'E', 'B', 'U', 'G'}, {'T', 'R', 'A', 'C', 'E'}};
    private static final char[][] LEXICAL_NUMBERS = new char[][]{{'0', '0'}, {'0', '1'}, {'0', '2'}, {'0', '3'}, {'0', '4'}, {'0', '5'}, {'0', '6'}, {'0', '7'}, {'0', '8'}, {'0', '9'}, {'1', '0'}, {'1', '1'}, {'1', '2'}, {'1', '3'}, {'1', '4'}, {'1', '5'}, {'1', '6'}, {'1', '7'}, {'1', '8'}, {'1', '9'}, {'2', '0'}, {'2', '1'}, {'2', '2'}, {'2', '3'}, {'2', '4'}, {'2', '5'}, {'2', '6'}, {'2', '7'}, {'2', '8'}, {'2', '9'}, {'3', '0'}, {'3', '1'}, {'3', '2'}, {'3', '3'}, {'3', '4'}, {'3', '5'}, {'3', '6'}, {'3', '7'}, {'3', '8'}, {'3', '9'}, {'4', '0'}, {'4', '1'}, {'4', '2'}, {'4', '3'}, {'4', '4'}, {'4', '5'}, {'4', '6'}, {'4', '7'}, {'4', '8'}, {'4', '9'}, {'5', '0'}, {'5', '1'}, {'5', '2'}, {'5', '3'}, {'5', '4'}, {'5', '5'}, {'5', '6'}, {'5', '7'}, {'5', '8'}, {'5', '9'}};
    private boolean fatal = true;
    private boolean error = true;
    private boolean warn = true;
    private boolean info = false;
    private boolean debug = false;
    private boolean trace = false;
    private int logLevel = 3;
    private final TextContainer buffer;
    private PrintWriter out;

    private Logger(PrintWriter out) {
        this.out = out;
        this.buffer = new TextContainer();
        char[] raw = this.buffer.getRawCharArray();
        for (int i = 0; i < 22; ++i) {
            raw[i] = 32;
        }
        raw[0] = 91;
        raw[13] = 93;
        raw[20] = 58;
    }

    public static Logger newInstance(PrintWriter out) {
        return new Logger(out);
    }

    public final void setLogLevel(int level) {
        this.trace = level == 5;
        this.debug = level >= 4;
        this.info = level >= 3;
        this.warn = level >= 2;
        this.error = level >= 1;
        this.fatal = level >= 0;
        this.logLevel = level;
    }

    public final int getLogLevel() {
        return this.logLevel;
    }

    public final boolean isFatalLoggable() {
        return this.fatal;
    }

    public final boolean isErrorLoggable() {
        return this.error;
    }

    public final boolean isWarnLoggable() {
        return this.warn;
    }

    public final boolean isInfoLoggable() {
        return this.info;
    }

    public final boolean isDebugLoggable() {
        return this.debug;
    }

    public final boolean isTraceLoggable() {
        return this.trace;
    }

    public synchronized void log(int level, String msg) {
        this.buffer.setRawPosition(1);
        this.buffer.append(Logger.getTimeStamp());
        this.buffer.setRawPosition(15);
        this.buffer.append(LEXICAL_VALUES[level], 0, 5);
        this.buffer.setRawPosition(22);
        this.buffer.append(msg.toCharArray());
        this.out.println(this.buffer.toCharArray());
    }

    private static char[] getTimeStamp() {
        TimeZone tz = TimeZone.getDefault();
        long shiftMs = tz.getDSTSavings() + tz.getRawOffset();
        long time = System.currentTimeMillis() + shiftMs;
        long days = time / 86400000L;
        long start = days * 86400000L;
        long soFarMs = time - start;
        long hours = soFarMs / 3600000L;
        long minutes = soFarMs / 60000L - hours * 60L;
        long secondsSoFar = soFarMs / 1000L;
        long seconds = secondsSoFar - (hours * 3600L + minutes * 60L);
        long milliseconds = soFarMs - (hours * 3600000L + minutes * 60000L + seconds * 1000L);
        char[] value = new char[12];
        System.arraycopy(Logger.intToCharArray(hours), 0, value, 0, 2);
        value[2] = 58;
        System.arraycopy(Logger.intToCharArray(minutes), 0, value, 3, 2);
        value[5] = 58;
        System.arraycopy(Logger.intToCharArray(seconds), 0, value, 6, 2);
        value[8] = 46;
        value[11] = 48;
        value[10] = 48;
        value[9] = 48;
        char[] msecs = Long.toString(milliseconds).toCharArray();
        int msecsStrStart = milliseconds > 99L ? 9 : (milliseconds > 9L ? 10 : 11);
        System.arraycopy(msecs, 0, value, msecsStrStart, Math.min(msecs.length, 3));
        return value;
    }

    private static final char[] intToCharArray(long value) {
        return LEXICAL_NUMBERS[(int)value];
    }

    public PrintWriter getPrintWriter() {
        return this.out;
    }

    public synchronized void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void fatal(int id, Object ... arguments) {
        if (this.isFatalLoggable()) {
            this.log(0, XQToolkit.formatMessage(id, arguments));
        }
    }

    public void error(int id, Object ... arguments) {
        if (this.isErrorLoggable()) {
            this.log(1, XQToolkit.formatMessage(id, arguments));
        }
    }

    public void warn(int id, Object ... arguments) {
        if (this.isWarnLoggable()) {
            this.log(2, XQToolkit.formatMessage(id, arguments));
        }
    }

    public void info(int id, Object ... arguments) {
        if (this.isInfoLoggable()) {
            this.log(3, XQToolkit.formatMessage(id, arguments));
        }
    }

    public void debug(int id, Object ... arguments) {
        if (this.isDebugLoggable()) {
            this.log(4, XQToolkit.formatMessage(id, arguments));
        }
    }

    public void trace(int id, Object ... arguments) {
        if (this.isTraceLoggable()) {
            this.log(5, XQToolkit.formatMessage(id, arguments));
        }
    }
}

