// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// The [tracking (trak)](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM06/Chap6trak.html) table.
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct TrakMarker {}

impl TrakMarker {
    pub fn version_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + MajorMinor::RAW_BYTE_LEN
    }

    pub fn format_byte_range(&self) -> Range<usize> {
        let start = self.version_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn horiz_offset_byte_range(&self) -> Range<usize> {
        let start = self.format_byte_range().end;
        start..start + Offset16::RAW_BYTE_LEN
    }

    pub fn vert_offset_byte_range(&self) -> Range<usize> {
        let start = self.horiz_offset_byte_range().end;
        start..start + Offset16::RAW_BYTE_LEN
    }

    pub fn reserved_byte_range(&self) -> Range<usize> {
        let start = self.vert_offset_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }
}

impl MinByteRange for TrakMarker {
    fn min_byte_range(&self) -> Range<usize> {
        0..self.reserved_byte_range().end
    }
}

impl TopLevelTable for Trak<'_> {
    /// `trak`
    const TAG: Tag = Tag::new(b"trak");
}

impl<'a> FontRead<'a> for Trak<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<MajorMinor>();
        cursor.advance::<u16>();
        cursor.advance::<Offset16>();
        cursor.advance::<Offset16>();
        cursor.advance::<u16>();
        cursor.finish(TrakMarker {})
    }
}

/// The [tracking (trak)](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM06/Chap6trak.html) table.
pub type Trak<'a> = TableRef<'a, TrakMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> Trak<'a> {
    /// Version number of the tracking table (0x00010000 for the current version).
    pub fn version(&self) -> MajorMinor {
        let range = self.shape.version_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Format of the tracking table (set to 0).
    pub fn format(&self) -> u16 {
        let range = self.shape.format_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Offset from start of tracking table to TrackData for horizontal text (or 0 if none).
    pub fn horiz_offset(&self) -> Nullable<Offset16> {
        let range = self.shape.horiz_offset_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Attempt to resolve [`horiz_offset`][Self::horiz_offset].
    pub fn horiz(&self) -> Option<Result<TrackData<'a>, ReadError>> {
        let data = self.data;
        self.horiz_offset().resolve(data)
    }

    /// Offset from start of tracking table to TrackData for vertical text (or 0 if none).
    pub fn vert_offset(&self) -> Nullable<Offset16> {
        let range = self.shape.vert_offset_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Attempt to resolve [`vert_offset`][Self::vert_offset].
    pub fn vert(&self) -> Option<Result<TrackData<'a>, ReadError>> {
        let data = self.data;
        self.vert_offset().resolve(data)
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Trak<'a> {
    fn type_name(&self) -> &str {
        "Trak"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("version", self.version())),
            1usize => Some(Field::new("format", self.format())),
            2usize => Some(Field::new(
                "horiz_offset",
                FieldType::offset(self.horiz_offset(), self.horiz()),
            )),
            3usize => Some(Field::new(
                "vert_offset",
                FieldType::offset(self.vert_offset(), self.vert()),
            )),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for Trak<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

/// The tracking data table.
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct TrackDataMarker {
    track_table_byte_len: usize,
}

impl TrackDataMarker {
    pub fn n_tracks_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn n_sizes_byte_range(&self) -> Range<usize> {
        let start = self.n_tracks_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn size_table_offset_byte_range(&self) -> Range<usize> {
        let start = self.n_sizes_byte_range().end;
        start..start + u32::RAW_BYTE_LEN
    }

    pub fn track_table_byte_range(&self) -> Range<usize> {
        let start = self.size_table_offset_byte_range().end;
        start..start + self.track_table_byte_len
    }
}

impl MinByteRange for TrackDataMarker {
    fn min_byte_range(&self) -> Range<usize> {
        0..self.track_table_byte_range().end
    }
}

impl<'a> FontRead<'a> for TrackData<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        let n_tracks: u16 = cursor.read()?;
        cursor.advance::<u16>();
        cursor.advance::<u32>();
        let track_table_byte_len = (n_tracks as usize)
            .checked_mul(TrackTableEntry::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        cursor.advance_by(track_table_byte_len);
        cursor.finish(TrackDataMarker {
            track_table_byte_len,
        })
    }
}

/// The tracking data table.
pub type TrackData<'a> = TableRef<'a, TrackDataMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> TrackData<'a> {
    /// Number of separate tracks included in this table.
    pub fn n_tracks(&self) -> u16 {
        let range = self.shape.n_tracks_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Number of point sizes included in this table.
    pub fn n_sizes(&self) -> u16 {
        let range = self.shape.n_sizes_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Offset from the start of the tracking table to the start of the size subtable.
    pub fn size_table_offset(&self) -> u32 {
        let range = self.shape.size_table_offset_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Array of TrackTableEntry records.
    pub fn track_table(&self) -> &'a [TrackTableEntry] {
        let range = self.shape.track_table_byte_range();
        self.data.read_array(range).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for TrackData<'a> {
    fn type_name(&self) -> &str {
        "TrackData"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("n_tracks", self.n_tracks())),
            1usize => Some(Field::new("n_sizes", self.n_sizes())),
            2usize => Some(Field::new("size_table_offset", self.size_table_offset())),
            3usize => Some(Field::new(
                "track_table",
                traversal::FieldType::array_of_records(
                    stringify!(TrackTableEntry),
                    self.track_table(),
                    self.offset_data(),
                ),
            )),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for TrackData<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

/// Single entry in a tracking table.
#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Copy, bytemuck :: AnyBitPattern)]
#[repr(C)]
#[repr(packed)]
pub struct TrackTableEntry {
    /// Track value for this record.
    pub track: BigEndian<Fixed>,
    /// The 'name' table index for this track (a short word or phrase like \"loose\" or \"very tight\"). NameIndex has a value greater than 255 and less than 32768.
    pub name_index: BigEndian<NameId>,
    /// Offset from the start of the tracking table to per-size tracking values for this track.
    pub offset: BigEndian<u16>,
}

impl TrackTableEntry {
    /// Track value for this record.
    pub fn track(&self) -> Fixed {
        self.track.get()
    }

    /// The 'name' table index for this track (a short word or phrase like \"loose\" or \"very tight\"). NameIndex has a value greater than 255 and less than 32768.
    pub fn name_index(&self) -> NameId {
        self.name_index.get()
    }

    /// Offset from the start of the tracking table to per-size tracking values for this track.
    pub fn offset(&self) -> u16 {
        self.offset.get()
    }
}

impl FixedSize for TrackTableEntry {
    const RAW_BYTE_LEN: usize = Fixed::RAW_BYTE_LEN + NameId::RAW_BYTE_LEN + u16::RAW_BYTE_LEN;
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeRecord<'a> for TrackTableEntry {
    fn traverse(self, data: FontData<'a>) -> RecordResolver<'a> {
        RecordResolver {
            name: "TrackTableEntry",
            get_field: Box::new(move |idx, _data| match idx {
                0usize => Some(Field::new("track", self.track())),
                1usize => Some(Field::new("name_index", self.name_index())),
                2usize => Some(Field::new("offset", self.offset())),
                _ => None,
            }),
            data,
        }
    }
}
